/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.Arrays;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZ;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class PolygonZShape
extends PolygonShape {
    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.POLYGON_Z;
    }

    public double[] getZArray() {
        double[] zArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            zArray[i] = ((PointZ)this.getPoints().get((int)i)).Z;
        }
        return zArray;
    }

    public double[] getZRange() {
        return MIMath.arrayMinMax((double[])this.getZArray());
    }

    public double[] getMArray() {
        double[] mArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            mArray[i] = ((PointZ)this.getPoints().get((int)i)).M;
        }
        return mArray;
    }

    public double[] getMRange() {
        return MIMath.arrayMinMax((double[])this.getMArray());
    }

    @Override
    protected void updatePolygons() {
        this._polygons = new ArrayList();
        if (this._numParts == 1) {
            PolygonZ aPolygon = new PolygonZ();
            aPolygon.setOutLine(this._points);
            this._polygons.add(aPolygon);
        } else {
            PolygonZ aPolygon = null;
            int numPoints = this.getPointNum();
            for (int p = 0; p < this._numParts; ++p) {
                int pp;
                PointD[] Pointps;
                if (p == this._numParts - 1) {
                    Pointps = new PointZ[numPoints - this.parts[p]];
                    for (pp = this.parts[p]; pp < numPoints; ++pp) {
                        Pointps[pp - this.parts[p]] = (PointZ)this._points.get(pp);
                    }
                } else {
                    Pointps = new PointZ[this.parts[p + 1] - this.parts[p]];
                    for (pp = this.parts[p]; pp < this.parts[p + 1]; ++pp) {
                        Pointps[pp - this.parts[p]] = (PointZ)this._points.get(pp);
                    }
                }
                if (GeoComputation.isClockwise(Pointps)) {
                    if (p > 0) {
                        this._polygons.add(aPolygon);
                    }
                    aPolygon = new PolygonZ();
                    aPolygon.setOutLine(Arrays.asList(Pointps));
                    continue;
                }
                if (aPolygon == null) {
                    MIMath.arrayReverse((PointD[])Pointps);
                    aPolygon = new PolygonZ();
                    aPolygon.setOutLine(Arrays.asList(Pointps));
                    continue;
                }
                aPolygon.addHole(Arrays.asList(Pointps));
            }
            this._polygons.add(aPolygon);
        }
    }

    @Override
    public PolygonShape valueClone() {
        PolygonZShape aPGS = new PolygonZShape();
        aPGS.highValue = this.highValue;
        aPGS.lowValue = this.lowValue;
        aPGS.setVisible(this.isVisible());
        aPGS.setSelected(this.isSelected());
        aPGS.setLegendIndex(this.getLegendIndex());
        return aPGS;
    }
}

