/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.graphic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LabelBreak;
import org.meteoinfo.geometry.legend.LabelSet;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class GraphicCollection
extends Graphic
implements Iterator {
    protected List<? extends Graphic> graphics = new ArrayList<Graphic>();
    protected Extent extent = new Extent();
    protected boolean singleLegend = true;
    protected int index = 0;
    protected LabelSet labelSet = new LabelSet();
    protected List<Graphic> labelPoints = new ArrayList<Graphic>();
    protected LegendScheme legendScheme;
    protected ColorBreak legendBreak;
    protected boolean avoidCollision = false;

    @Override
    public Shape getShape() {
        if (this.graphics.isEmpty()) {
            return null;
        }
        return this.graphics.get(0).getShape();
    }

    public Shape getShape(int index) {
        if (this.graphics.isEmpty()) {
            return null;
        }
        return this.graphics.get(index).getShape();
    }

    public List<? extends Graphic> getGraphics() {
        return this.graphics;
    }

    public void setGraphics(List<Graphic> value) {
        this.graphics = value;
        this.updateExtent();
    }

    @Override
    public Extent getExtent() {
        return this.extent;
    }

    @Override
    public void setExtent(Extent value) {
        this.extent = value;
    }

    @Override
    public boolean isSingleLegend() {
        return this.singleLegend;
    }

    public void setSingleLegend(boolean value) {
        this.singleLegend = value;
    }

    public LabelSet getLabelSet() {
        return this.labelSet;
    }

    public void setLabelSet(LabelSet ls) {
        this.labelSet = ls;
    }

    public List<Graphic> getLabelPoints() {
        return this.labelPoints;
    }

    public void setLabelPoints(List<Graphic> lps) {
        this.labelPoints = lps;
    }

    public LegendScheme getLegendScheme() {
        return this.legendScheme;
    }

    public void setLegendScheme(LegendScheme value) {
        this.legendScheme = value;
    }

    public ColorBreak getLegendBreak() {
        return this.legendBreak;
    }

    public void setLegendBreak(ColorBreak value) {
        this.legendBreak = value;
    }

    public boolean is3D() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public boolean isAvoidCollision() {
        return this.avoidCollision;
    }

    public void setAvoidCollision(boolean value) {
        this.avoidCollision = value;
    }

    public void updateExtent() {
        int i = 0;
        for (Graphic graphic : this.graphics) {
            Extent extent = graphic.getExtent();
            this.extent = i == 0 ? extent : MIMath.getLagerExtent((Extent)this.extent, (Extent)extent);
            ++i;
        }
    }

    public boolean add(Graphic aGraphic) {
        boolean istrue = this.graphics.add(aGraphic);
        this.extent = this.graphics.size() == 1 ? aGraphic.getExtent() : MIMath.getLagerExtent((Extent)this.extent, (Extent)aGraphic.getExtent());
        return istrue;
    }

    public void add(int index, Graphic aGraphic) {
        this.graphics.add(index, aGraphic);
        this.extent = this.graphics.size() == 1 ? aGraphic.getExtent() : MIMath.getLagerExtent((Extent)this.extent, (Extent)aGraphic.getExtent());
    }

    public Graphic get(int idx) {
        return this.graphics.get(idx);
    }

    public int indexOf(Graphic g) {
        return this.graphics.indexOf(g);
    }

    public boolean contains(Graphic g) {
        return this.graphics.contains(g);
    }

    public int size() {
        return this.graphics.size();
    }

    public boolean isEmpty() {
        return this.graphics.isEmpty();
    }

    @Override
    public int getNumGraphics() {
        return this.size();
    }

    @Override
    public Graphic getGraphicN(int idx) {
        return this.get(idx);
    }

    public void setGraphicN(int idx, Graphic graphic) {
        this.graphics.set(idx, graphic);
    }

    public boolean remove(Graphic aGraphic) {
        boolean istrue = this.graphics.remove(aGraphic);
        this.updateExtent();
        return istrue;
    }

    public Graphic remove(int index) {
        Graphic ag = this.graphics.remove(index);
        this.updateExtent();
        return ag;
    }

    public void clear() {
        this.graphics.clear();
    }

    public void addAll(List<Graphic> gs) {
        this.graphics.addAll(gs);
        int i = 0;
        for (Graphic g : gs) {
            Extent extent = g.getExtent();
            this.extent = i == 0 ? extent : MIMath.getLagerExtent((Extent)this.extent, (Extent)extent);
            ++i;
        }
    }

    public void join(Graphic graphic) {
        if (graphic.isCollection()) {
            this.extent = this.isEmpty() ? graphic.getExtent() : MIMath.getLagerExtent((Extent)this.extent, (Extent)graphic.getExtent());
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                this.graphics.add(graphic.getGraphicN(i));
            }
        } else {
            this.add(graphic);
        }
    }

    public void removeAll(List<Graphic> gs) {
        this.graphics.removeAll(gs);
    }

    @Override
    public ColorBreak getLegend() {
        if (this.legendBreak != null) {
            return this.legendBreak;
        }
        return this.graphics.get(0).getLegend();
    }

    public GraphicCollection selectGraphics(Extent aExtent) {
        GraphicCollection selectedGraphics = new GraphicCollection();
        PointD aPoint = new PointD();
        aPoint.X = (aExtent.minX + aExtent.maxX) / 2.0;
        aPoint.Y = (aExtent.minY + aExtent.maxY) / 2.0;
        for (Graphic graphic : this.graphics) {
            block0 : switch (graphic.getShape().getShapeType()) {
                case POINT: {
                    PointShape aPS = (PointShape)graphic.getShape();
                    if (!MIMath.pointInExtent((PointD)aPS.getPoint(), (Extent)aExtent)) break;
                    selectedGraphics.add(graphic);
                    break;
                }
                case POLYLINE: 
                case POLYLINE_Z: {
                    PolylineShape aPLS = (PolylineShape)graphic.getShape();
                    if (!MIMath.isExtentCross((Extent)aExtent, (Extent)aPLS.getExtent()).booleanValue()) break;
                    for (int j = 0; j < aPLS.getPoints().size(); ++j) {
                        aPoint = aPLS.getPoints().get(j);
                        if (!MIMath.pointInExtent((PointD)aPoint, (Extent)aExtent)) continue;
                        selectedGraphics.add(graphic);
                        break block0;
                    }
                    break;
                }
                case POLYGON: 
                case RECTANGLE: {
                    PolygonShape aPGS = (PolygonShape)graphic.getShape();
                    if (aPGS.getPartNum() <= 1) {
                        if (!GeoComputation.pointInPolygon(aPGS.getPoints(), aPoint)) break;
                        selectedGraphics.add(graphic);
                        break;
                    }
                    for (int p = 0; p < aPGS.getPartNum(); ++p) {
                        int pp;
                        ArrayList<PointD> pList = new ArrayList<PointD>();
                        if (p == aPGS.getPartNum() - 1) {
                            for (pp = aPGS.parts[p]; pp < aPGS.getPointNum(); ++pp) {
                                pList.add(aPGS.getPoints().get(pp));
                            }
                        } else {
                            for (pp = aPGS.parts[p]; pp < aPGS.parts[p + 1]; ++pp) {
                                pList.add(aPGS.getPoints().get(pp));
                            }
                        }
                        if (!GeoComputation.pointInPolygon(pList, aPoint)) continue;
                        selectedGraphics.add(graphic);
                        break block0;
                    }
                    break;
                }
            }
        }
        return selectedGraphics;
    }

    @Override
    public boolean hasNext() {
        return this.index <= this.size() - 1;
    }

    public Object next() {
        if (this.index >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.get(this.index++);
    }

    public void addLabels() {
        this.addLabelsByColor();
        this.labelSet.setDrawLabels(true);
    }

    public List<? extends Shape> getShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (Graphic graphic : this.graphics) {
            shapes.add(graphic.getShape());
        }
        return shapes;
    }

    @Override
    public ShapeTypes getShapeType() {
        if (this.graphics.isEmpty()) {
            return null;
        }
        return this.graphics.get(0).getShape().getShapeType();
    }

    private double getMinValue() {
        double min = Double.MAX_VALUE;
        for (Graphic graphic : this.graphics) {
            Shape shape = graphic.getShape();
            if (!(min > shape.getValue())) continue;
            min = shape.getValue();
        }
        return min;
    }

    protected void addLabelsByColor() {
        if (this.labelSet.isAutoDecimal()) {
            double min = this.getMinValue();
            this.labelSet.setDecimalDigits(MIMath.getDecimalNum((double)min));
        }
        String dFormat = "%1$." + String.valueOf(this.labelSet.getDecimalDigits()) + "f";
        for (Graphic graphic : this.graphics) {
            ColorBreak cb = graphic.getLegend();
            Shape shape = graphic.getShape();
            PointShape aPS = new PointShape();
            switch (shape.getShapeType()) {
                case POINT: 
                case POINT_M: 
                case POINT_Z: {
                    aPS.setPoint((PointD)((PointShape)shape).getPoint().clone());
                    break;
                }
                case POLYLINE: 
                case POLYLINE_Z: 
                case POLYLINE_M: {
                    int pIdx = ((PolylineShape)shape).getPoints().size() / 2;
                    aPS.setPoint((PointD)((PolylineShape)shape).getPoints().get(pIdx - 1).clone());
                    break;
                }
                case POLYGON: 
                case POLYGON_M: {
                    Extent aExtent = shape.getExtent();
                    PointD aPoint = new PointD();
                    aPoint.X = (aExtent.minX + aExtent.maxX) / 2.0;
                    aPoint.Y = (aExtent.minY + aExtent.maxY) / 2.0;
                    aPS.setPoint(aPoint);
                }
            }
            LabelBreak aLP = new LabelBreak();
            aLP.setText(String.format(dFormat, shape.getValue()));
            if (this.labelSet.isColorByLegend()) {
                aLP.setColor(cb.getColor());
            } else {
                aLP.setColor(this.labelSet.getLabelColor());
            }
            aLP.setFont(this.labelSet.getLabelFont());
            aLP.setAlignType(this.labelSet.getLabelAlignType());
            aLP.setYShift(this.labelSet.getYOffset());
            aLP.setXShift(this.labelSet.getXOffset());
            Graphic aGraphic = new Graphic(aPS, aLP);
            this.addLabel(aGraphic);
        }
    }

    public void addLabel(Graphic aLP) {
        this.labelPoints.add(aLP);
    }

    public void addLabelsContourDynamic(Extent sExtent) {
        if (this.labelSet.isAutoDecimal()) {
            double min = this.getMinValue();
            this.labelSet.setDecimalDigits(MIMath.getDecimalNum((double)min));
        }
        String dFormat = "%1$." + String.valueOf(this.labelSet.getDecimalDigits()) + "f";
        for (Graphic graphic : this.graphics) {
            Shape shape = graphic.getShape();
            ColorBreak cb = graphic.getLegend();
            PolylineShape aPLS = (PolylineShape)shape;
            Extent IExtent = aPLS.getExtent();
            if (!(IExtent.maxX - IExtent.minX > (sExtent.maxX - sExtent.minX) / 10.0) && !(IExtent.maxY - IExtent.minY > (sExtent.maxY - sExtent.minY) / 10.0)) continue;
            LabelBreak aLP = new LabelBreak();
            int pIdx = aPLS.getPoints().size() / 2;
            PointShape aPS = new PointShape();
            aPS.setPoint(aPLS.getPoints().get(pIdx - 1));
            String text = String.format(dFormat, aPLS.getValue());
            aLP.setText(text);
            aLP.setFont(this.labelSet.getLabelFont());
            aLP.setAlignType(this.labelSet.getLabelAlignType());
            aLP.setXShift(this.labelSet.getXOffset());
            aLP.setYShift(this.labelSet.getYOffset());
            if (this.labelSet.isColorByLegend()) {
                aLP.setColor(cb.getColor());
            } else {
                aLP.setColor(this.labelSet.getLabelColor());
            }
            Graphic aGraphic = new Graphic(aPS, aLP);
            this.addLabel(aGraphic);
        }
        this.labelSet.setDrawLabels(true);
    }

    public Graphic getLabel(String text) {
        for (Graphic lb : this.labelPoints) {
            if (!((LabelBreak)lb.getLegend()).getText().equals(text)) continue;
            return lb;
        }
        return null;
    }

    public void moveLabel(String text, float x, float y) {
        Graphic lb = this.getLabel(text);
        if (lb != null) {
            this.moveLabel(lb, x, y);
        }
    }

    public void moveLabel(Graphic lb, float x, float y) {
        LabelBreak lbb = (LabelBreak)lb.getLegend();
        lbb.setXShift(lbb.getXShift() + x);
        lbb.setYShift(lbb.getYShift() + y);
    }

    public void removeLabels() {
        this.labelPoints.clear();
        this.labelSet.setDrawLabels(false);
    }

    public float getArrowZoom() {
        if (this.getLegend().getBreakType() == BreakTypes.POINT_BREAK) {
            float size = ((PointBreak)this.getLegend()).getSize();
            return size / 10.0f;
        }
        return 1.0f;
    }

    public GraphicCollection clip(List<PolygonShape> clipPolys) {
        GraphicCollection cgraphics = new GraphicCollection();
        for (PolygonShape aPGS : clipPolys) {
            for (int i = 0; i < this.graphics.size(); ++i) {
                Shape bShape = this.graphics.get(i).getShape();
                Shape clipShape = bShape.intersection(aPGS);
                if (clipShape == null) continue;
                cgraphics.add(new Graphic(clipShape, this.graphics.get(i).getLegend()));
            }
        }
        cgraphics.setSingleLegend(this.singleLegend);
        cgraphics.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        return cgraphics;
    }

    public GraphicCollection xShift(double xs) {
        for (Graphic graphic : this.graphics) {
            for (PointD pointD : graphic.getShape().getPoints()) {
                pointD.X += xs;
            }
            graphic.setExtent(graphic.getExtent().shift(xs, 0.0));
        }
        this.extent.shift(xs, 0.0);
        return this;
    }

    public GraphicCollection xShiftCopy(double xs) {
        GraphicCollection graphicCollection = new GraphicCollection();
        for (Graphic graphic : this.graphics) {
            Shape shape = (Shape)graphic.getShape().clone();
            for (PointD pointD : shape.getPoints()) {
                pointD.X += xs;
            }
            Graphic graphic2 = new Graphic(shape, graphic.legend);
            graphic2.setExtent(graphic2.getExtent().shift(xs, 0.0));
            graphicCollection.add(graphic2);
        }
        return graphicCollection;
    }
}

