/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.graphic;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.Point2DGraphic;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class Point2DGraphicCollection
extends GraphicCollection {
    private Array xData;
    private Array yData;
    private Array cData;

    public Point2DGraphicCollection() {
        this.graphics = new ArrayList();
        this.legend = new PointBreak();
    }

    public Point2DGraphicCollection(List<Point2DGraphic> graphics) {
        this();
        this.graphics = graphics;
    }

    public Point2DGraphicCollection(Array xData, Array yData, PointBreak pointBreak) {
        this();
        this.xData = xData;
        this.yData = yData;
        this.updateGraphics(pointBreak);
    }

    public Point2DGraphicCollection(Array xData, Array yData, List<ColorBreak> cbs) {
        this();
        this.xData = xData;
        this.yData = yData;
        this.updateGraphics(cbs);
    }

    public Point2DGraphicCollection(Array xData, Array yData, Array cData, LegendScheme ls) {
        this();
        this.xData = xData;
        this.yData = yData;
        this.cData = cData;
        this.updateGraphics(ls);
    }

    public boolean hasColorData() {
        return this.cData != null;
    }

    public Array getXData() {
        return this.xData;
    }

    public void setXData(Array xData) {
        this.xData = xData;
        this.updateShape();
    }

    public Array getYData() {
        return this.yData;
    }

    public void setYData(Array yData) {
        this.yData = yData;
        this.updateShape();
    }

    public Array getColorData() {
        return this.cData;
    }

    protected void updateShape() {
        if (this.hasColorData()) {
            this.updateGraphics(this.legendScheme);
        } else {
            this.updateGraphics((PointBreak)this.legend);
        }
    }

    protected void updateGraphics() {
        this.updateGraphics((PointBreak)this.legend);
    }

    protected void updateGraphics(PointBreak pointBreak) {
        this.legend = pointBreak;
        this.graphics = new ArrayList();
        ArrayList points = new ArrayList();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            PointShape shape = new PointShape(new PointD(x, y));
            this.add(new Point2DGraphic(shape, pointBreak));
        }
    }

    protected void updateGraphics(List<ColorBreak> cbs) {
        this.graphics = new ArrayList();
        ArrayList points = new ArrayList();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        if ((long)cbs.size() == this.xData.getSize()) {
            int i = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                PointShape shape = new PointShape(new PointD(x, y));
                this.add(new Point2DGraphic(shape, (PointBreak)cbs.get(i)));
                ++i;
            }
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UNIQUE_VALUE);
            ls.setShapeType(ShapeTypes.POINT);
            this.singleLegend = false;
            this.legendScheme = ls;
        } else {
            this.updateGraphics((PointBreak)cbs.get(0));
        }
    }

    protected void updateGraphics(LegendScheme ls) {
        this.graphics = new ArrayList();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        IndexIterator zIter = this.cData.getIndexIterator();
        if (ls.getLegendType() == LegendType.UNIQUE_VALUE && this.xData.getSize() == (long)ls.getBreakNum()) {
            int i = 0;
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                double z = zIter.getDoubleNext();
                ps.setValue(z);
                ColorBreak cb = ls.getLegendBreak(i);
                this.add(new Graphic(ps, cb));
                ++i;
            }
        } else {
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                double z = zIter.getDoubleNext();
                ps.setValue(z);
                ColorBreak cb = ls.findLegendBreak(z);
                if (cb == null) continue;
                this.add(new Graphic(ps, cb));
            }
        }
        this.singleLegend = false;
        this.legendScheme = ls;
    }

    public void setData(Array xData, Array yData) {
        this.xData = xData;
        this.yData = yData;
        this.updateShape();
    }
}

