/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.legend;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.geometry.legend.AlignType;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.ui.event.ISizeChangedListener;
import org.meteoinfo.ui.event.SizeChangedEvent;

public class LabelBreak
extends ColorBreak {
    private EventListenerList listeners = new EventListenerList();
    private List<String> text;
    private float angle;
    private Font font;
    private AlignType alignType;
    private float xShift;
    private float yShift;
    private int lineSpace;

    public LabelBreak() {
        this.setBreakType(BreakTypes.LABEL_BREAK);
        this.text = new ArrayList<String>();
        this.angle = 0.0f;
        this.setColor(Color.black);
        this.font = new Font(GlobalUtil.getDefaultFontName(), 0, 7);
        this.alignType = AlignType.LEFT;
        this.xShift = 0.0f;
        this.yShift = 0.0f;
        this.lineSpace = 5;
    }

    public String getText() {
        return String.join((CharSequence)"\n", this.text);
    }

    public List<String> getTexts() {
        return this.text;
    }

    public void setText(String text) {
        this.text = Arrays.asList(text.split("\n"));
        this.fireSizeChangedEvent(new SizeChangedEvent((Object)this));
    }

    public void setTexts(List<String> value) {
        this.text = value;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public AlignType getAlignType() {
        return this.alignType;
    }

    public void setAlignType(AlignType at) {
        this.alignType = at;
    }

    public float getYShift() {
        return this.yShift;
    }

    public void setYShift(float value) {
        this.yShift = value;
    }

    public float getXShift() {
        return this.xShift;
    }

    public void setXShift(float value) {
        this.xShift = value;
    }

    public int getLineSpace() {
        return this.lineSpace;
    }

    public void setLineSpace(int value) {
        this.lineSpace = value;
    }

    @Override
    public Object getPropertyObject() {
        HashMap<String, String> objAttr = new HashMap<String, String>();
        objAttr.put("Text", "Text");
        objAttr.put("Angle", "Angle");
        objAttr.put("Color", "Color");
        objAttr.put("Font", "Font");
        return objAttr;
    }

    @Override
    public Object clone() {
        LabelBreak aCB = new LabelBreak();
        aCB.setCaption(this.getCaption());
        aCB.setColor(this.getColor());
        aCB.setDrawShape(this.isDrawShape());
        aCB.setEndValue(this.getEndValue());
        aCB.setNoData(this.isNoData());
        aCB.setStartValue(this.getStartValue());
        aCB.setAngle(this.angle);
        aCB.setTexts(this.text);
        aCB.setFont(this.font);
        aCB.setAlignType(this.alignType);
        aCB.setYShift(this.yShift);
        aCB.setXShift(this.xShift);
        aCB.setLineSpace(this.lineSpace);
        return aCB;
    }

    public void addSizeChangedListener(ISizeChangedListener scl) {
        this.listeners.add(ISizeChangedListener.class, scl);
    }

    public void removeSizeChangedListener(ISizeChangedListener scl) {
        this.listeners.remove(ISizeChangedListener.class, scl);
    }

    public void fireSizeChangedEvent(SizeChangedEvent event) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = 0; i < ls.length; i += 2) {
            if (ls[i] != ISizeChangedListener.class) continue;
            ((ISizeChangedListener)ls[i + 1]).sizeChangedEvent(event);
        }
    }
}

