/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.legend;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geometry.colors.BoundaryNorm;
import org.meteoinfo.geometry.colors.ExtendType;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.colors.TransferFunction;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.MarkerType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.ndarray.util.BigDecimalUtil;

public class LegendManage {
    public static LegendScheme createSingleSymbolLegendScheme(ShapeTypes shapeType) {
        if (shapeType.isPoint()) {
            return LegendManage.createSingleSymbolLegendScheme(shapeType, Color.green, 8.0f);
        }
        if (shapeType.isLine()) {
            return LegendManage.createSingleSymbolLegendScheme(shapeType, Color.blue, 1.0f);
        }
        return LegendManage.createSingleSymbolLegendScheme(shapeType, Color.cyan, 1.0f);
    }

    public static LegendScheme createSingleSymbolLegendScheme(ShapeTypes aST, Color aColor, float size) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.SINGLE_SYMBOL);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(0.0);
        legendScheme.setMaxValue(0.0);
        legendScheme.setUndefValue(-9999.0);
        legendScheme.setLegendBreaks(new ArrayList<ColorBreak>());
        if (aST.isPoint()) {
            PointBreak aPB = new PointBreak();
            aPB.setColor(aColor);
            aPB.setOutlineColor(Color.black);
            aPB.setSize(size);
            aPB.setNoData(false);
            aPB.setDrawFill(true);
            aPB.setDrawOutline(true);
            aPB.setDrawShape(true);
            aPB.setStyle(PointStyle.CIRCLE);
            aPB.setStartValue(0);
            aPB.setEndValue(0);
            aPB.setCaption("");
            legendScheme.getLegendBreaks().add(aPB);
        } else if (aST.isLine()) {
            PolylineBreak aPLB = new PolylineBreak();
            aPLB.setColor(aColor);
            aPLB.setDrawPolyline(true);
            aPLB.setWidth(size);
            aPLB.setStyle(LineStyles.SOLID);
            aPLB.setStartValue(0);
            aPLB.setEndValue(0);
            aPLB.setCaption("");
            aPLB.setSymbolColor(aColor);
            legendScheme.getLegendBreaks().add(aPLB);
        } else if (aST.isPolygon()) {
            PolygonBreak aPGB = new PolygonBreak();
            aPGB.setColor(aColor);
            aPGB.setDrawFill(true);
            aPGB.setDrawOutline(true);
            aPGB.setDrawShape(true);
            aPGB.setOutlineColor(Color.gray);
            aPGB.setOutlineSize(size);
            aPGB.setStartValue(0);
            aPGB.setEndValue(0);
            aPGB.setCaption("");
            legendScheme.getLegendBreaks().add(aPGB);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<String> CValues, List<String> captions, Color[] colors, ShapeTypes aST, double min, double max, boolean hasNodata, double unDef) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        legendScheme.setUndefValue(unDef);
        if (aST.isPoint()) {
            for (int i = 1; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue(CValues.get(i - 1));
                aPB.setEndValue(aPB.getStartValue());
                if (colors.length <= 13) {
                    aPB.setSize((float)i / 2.0f + 2.0f);
                } else {
                    aPB.setSize(5.0f);
                }
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            for (int i = 1; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue(CValues.get(i - 1));
                aPLB.setEndValue(aPLB.getStartValue());
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(captions.get(i - 1));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.CIRCLE);
                legendScheme.getLegendBreaks().add(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 1; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue(CValues.get(i - 1));
                aPGB.setEndValue(aPGB.getStartValue());
                aPGB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<String> CValues, List<String> captions, Color[] colors, ShapeTypes aST, double min, double max) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        if (aST.isPoint()) {
            for (int i = 1; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue(CValues.get(i - 1));
                aPB.setEndValue(aPB.getStartValue());
                if (colors.length <= 13) {
                    aPB.setSize((float)i / 2.0f + 2.0f);
                } else {
                    aPB.setSize(5.0f);
                }
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            for (int i = 1; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue(CValues.get(i - 1));
                aPLB.setEndValue(aPLB.getStartValue());
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(captions.get(i - 1));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.CIRCLE);
                legendScheme.getLegendBreaks().add(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 1; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue(CValues.get(i - 1));
                aPGB.setEndValue(aPGB.getStartValue());
                aPGB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(int n, ShapeTypes aST) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        Color[] colors = n <= 13 ? LegendManage.createRainBowColors(n) : LegendManage.createRandomColors(n);
        if (aST.isPoint()) {
            for (int i = 0; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue(i);
                aPB.setEndValue(i);
                aPB.setSize(6.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(String.valueOf(i));
                legendScheme.getLegendBreaks().add(aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            int ii = 0;
            for (int i = 0; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue(i);
                aPLB.setEndValue(i);
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(String.valueOf(i));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.values()[ii]);
                if (++ii == PointStyle.values().length) {
                    ii = 0;
                }
                legendScheme.getLegendBreaks().add(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 0; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue(i);
                aPGB.setEndValue(i);
                aPGB.setCaption(String.valueOf(i));
                legendScheme.getLegendBreaks().add(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, ShapeTypes aST) {
        int n = values.size();
        Color[] colors = n <= 13 ? LegendManage.createRainBowColors(n) : LegendManage.createRandomColors(n);
        return LegendManage.createUniqValueLegendScheme(values, colors, aST);
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, ColorMap cmap, ShapeTypes aST) {
        int n = values.size();
        Color[] colors = cmap.getColors(n);
        return LegendManage.createUniqValueLegendScheme(values, colors, aST);
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, Color[] colors, ShapeTypes aST) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        if (aST.isPoint()) {
            for (int i = 0; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue(values.get(i));
                aPB.setEndValue(values.get(i));
                aPB.setSize(6.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(String.valueOf(values.get(i)));
                legendScheme.addLegendBreak(aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            int ii = 0;
            for (int i = 0; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue(values.get(i));
                aPLB.setEndValue(values.get(i));
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(String.valueOf(values.get(i)));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.values()[ii]);
                if (++ii == PointStyle.values().length) {
                    ii = 0;
                }
                legendScheme.addLegendBreak(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 0; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue(values.get(i));
                aPGB.setEndValue(values.get(i));
                aPGB.setCaption(String.valueOf(values.get(i)));
                legendScheme.addLegendBreak(aPGB);
            }
            legendScheme.setHasNoData(false);
        } else {
            for (int i = 0; i < colors.length; ++i) {
                ColorBreak aPGB = new ColorBreak();
                aPGB.setColor(colors[i]);
                aPGB.setDrawShape(true);
                aPGB.setStartValue(values.get(i));
                aPGB.setEndValue(values.get(i));
                aPGB.setCaption(String.valueOf(values.get(i)));
                legendScheme.addLegendBreak(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, List<Color> colors, ShapeTypes aST) {
        Color[] cols = colors.toArray(new Color[0]);
        return LegendManage.createUniqValueLegendScheme(values, cols, aST);
    }

    public static LegendScheme createUniqValueLegendScheme(List<String> CValues, Color[] colors, ShapeTypes aST, double min, double max, boolean hasNodata, double unDef) {
        return LegendManage.createUniqValueLegendScheme(CValues, CValues, colors, aST, min, max, hasNodata, unDef);
    }

    public static LegendScheme createUniqValueLegendScheme(double[] CValues, Color[] colors, ShapeTypes aST, double min, double max, Boolean hasNodata, double unDef) {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> captions = new ArrayList<String>();
        String dFormat = "%1$." + String.valueOf(MIMath.getDecimalNum((double)CValues[0])) + "f";
        for (double v : CValues) {
            captions.add(String.format(dFormat, v));
            values.add(String.valueOf(v));
        }
        return LegendManage.createUniqValueLegendScheme(values, captions, colors, aST, min, max, hasNodata, unDef);
    }

    public static LegendScheme createUniqValueLegendScheme(double[] CValues, Color[] colors, ShapeTypes aST, double min, double max) {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> captions = new ArrayList<String>();
        String dFormat = "%1$." + String.valueOf(MIMath.getDecimalNum((double)CValues[0])) + "f";
        for (double v : CValues) {
            captions.add(String.format(dFormat, v));
            values.add(String.valueOf(v));
        }
        return LegendManage.createUniqValueLegendScheme(values, captions, colors, aST, min, max);
    }

    public static LegendScheme createGraduatedLegendScheme(double[] CValues, Color[] colors, ShapeTypes aST, double min, double max, Boolean hasNodata, double unDef) {
        if (CValues.length > 1) {
            if (min >= CValues[0]) {
                min = CValues[0] - (CValues[1] - CValues[0]);
            }
            if (max <= CValues[CValues.length - 1]) {
                max = CValues[CValues.length - 1] + (CValues[CValues.length - 1] - CValues[CValues.length - 2]);
            }
        }
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.GRADUATED_COLOR);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        legendScheme.setUndefValue(unDef);
        if (aST.isPoint()) {
            PointBreak aPB;
            for (int i = 0; i < colors.length; ++i) {
                aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                if (i == 0) {
                    aPB.setStartValue(min);
                } else {
                    aPB.setStartValue(CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aPB.setEndValue(max);
                } else {
                    aPB.setEndValue(CValues[i]);
                }
                aPB.setSize(8.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                if (aPB.getStartValue() == aPB.getEndValue()) {
                    aPB.setCaption(DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()));
                } else if (i == 0) {
                    aPB.setCaption("< " + DataConvert.removeTailingZeros((String)aPB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPB.setCaption("> " + DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()));
                } else {
                    aPB.setCaption(DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak(aPB);
            }
            legendScheme.setHasNoData(false);
            if (hasNodata.booleanValue()) {
                aPB = new PointBreak();
                aPB.setColor(Color.gray);
                aPB.setOutlineColor(Color.black);
                aPB.setStartValue(unDef);
                aPB.setEndValue(aPB.getStartValue());
                aPB.setSize(1.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setCaption("NoData");
                aPB.setNoData(true);
                aPB.setDrawShape(true);
                aPB.setDrawOutline(true);
                legendScheme.addLegendBreak(aPB);
                legendScheme.setHasNoData(true);
            }
        } else if (aST.isLine()) {
            for (int i = 0; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                if (i == 0) {
                    aPLB.setStartValue(min);
                } else {
                    aPLB.setStartValue(CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aPLB.setEndValue(max);
                } else {
                    aPLB.setEndValue(CValues[i]);
                }
                if (aPLB.getStartValue() == aPLB.getEndValue()) {
                    aPLB.setCaption(DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()));
                } else if (i == 0) {
                    aPLB.setCaption("< " + DataConvert.removeTailingZeros((String)aPLB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPLB.setCaption("> " + DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()));
                } else {
                    aPLB.setCaption(DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPLB.getEndValue().toString()));
                }
                aPLB.setSymbolColor(aPLB.getColor());
                if (i < PointStyle.values().length) {
                    aPLB.setSymbolStyle(PointStyle.values()[i]);
                }
                legendScheme.addLegendBreak(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 0; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(false);
                aPGB.setDrawShape(true);
                if (i == 0) {
                    aPGB.setStartValue(min);
                } else {
                    aPGB.setStartValue(CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aPGB.setEndValue(max);
                } else {
                    aPGB.setEndValue(CValues[i]);
                }
                if (aPGB.getStartValue() == aPGB.getEndValue()) {
                    aPGB.setCaption(DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()));
                } else if (i == 0) {
                    aPGB.setCaption("< " + DataConvert.removeTailingZeros((String)aPGB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPGB.setCaption("> " + DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()));
                } else {
                    aPGB.setCaption(DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPGB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak(aPGB);
            }
            legendScheme.setHasNoData(false);
        } else {
            ColorBreak aCB;
            for (int i = 0; i < colors.length; ++i) {
                aCB = new ColorBreak();
                aCB.setColor(colors[i]);
                if (i == 0) {
                    aCB.setStartValue(min);
                } else {
                    aCB.setStartValue(CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aCB.setEndValue(max);
                } else {
                    aCB.setEndValue(CValues[i]);
                }
                if (aCB.getStartValue() == aCB.getEndValue()) {
                    aCB.setCaption(DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()));
                } else if (i == 0) {
                    aCB.setCaption("< " + DataConvert.removeTailingZeros((String)aCB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aCB.setCaption("> " + DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()));
                } else {
                    aCB.setCaption(DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aCB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak(aCB);
            }
            legendScheme.setHasNoData(false);
            if (hasNodata.booleanValue()) {
                aCB = new ColorBreak();
                aCB.setColor(new Color(230, 230, 230, 0));
                aCB.setStartValue(unDef);
                aCB.setEndValue(aCB.getStartValue());
                aCB.setCaption("NoData");
                aCB.setNoData(true);
                legendScheme.addLegendBreak(aCB);
                legendScheme.setHasNoData(true);
            }
        }
        return legendScheme;
    }

    public static LegendScheme createGraduatedLegendScheme(double[] values, Color[] colors, ShapeTypes shapeType) {
        int nv = values.length;
        double min = values[0];
        double max = values[nv - 1];
        LegendScheme legendScheme = new LegendScheme(shapeType);
        legendScheme.setLegendType(LegendType.GRADUATED_COLOR);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        if (shapeType.isPoint()) {
            for (int i = 0; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setStartValue(values[i]);
                aPB.setEndValue(values[i + 1]);
                aPB.setSize(8.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                if (aPB.getStartValue() == aPB.getEndValue()) {
                    aPB.setCaption(DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()));
                } else if (i == 0) {
                    aPB.setCaption("< " + DataConvert.removeTailingZeros((String)aPB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPB.setCaption("> " + DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()));
                } else {
                    aPB.setCaption(DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak(aPB);
            }
        } else if (shapeType.isLine()) {
            for (int i = 0; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setStartValue(values[i]);
                aPLB.setEndValue(values[i + 1]);
                if (aPLB.getStartValue() == aPLB.getEndValue()) {
                    aPLB.setCaption(DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()));
                } else if (i == 0) {
                    aPLB.setCaption("< " + DataConvert.removeTailingZeros((String)aPLB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPLB.setCaption("> " + DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()));
                } else {
                    aPLB.setCaption(DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPLB.getEndValue().toString()));
                }
                aPLB.setSymbolColor(aPLB.getColor());
                if (i < PointStyle.values().length) {
                    aPLB.setSymbolStyle(PointStyle.values()[i]);
                }
                legendScheme.addLegendBreak(aPLB);
            }
        } else if (shapeType.isPolygon()) {
            for (int i = 0; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(false);
                aPGB.setDrawShape(true);
                aPGB.setStartValue(values[i]);
                aPGB.setEndValue(values[i + 1]);
                if (aPGB.getStartValue() == aPGB.getEndValue()) {
                    aPGB.setCaption(DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()));
                } else if (i == 0) {
                    aPGB.setCaption("< " + DataConvert.removeTailingZeros((String)aPGB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPGB.setCaption("> " + DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()));
                } else {
                    aPGB.setCaption(DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPGB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak(aPGB);
            }
        } else {
            for (int i = 0; i < colors.length; ++i) {
                ColorBreak aCB = new ColorBreak();
                aCB.setColor(colors[i]);
                aCB.setStartValue(values[i]);
                aCB.setEndValue(values[i + 1]);
                if (aCB.getStartValue() == aCB.getEndValue()) {
                    aCB.setCaption(DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()));
                } else if (i == 0) {
                    aCB.setCaption("< " + DataConvert.removeTailingZeros((String)aCB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aCB.setCaption("> " + DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()));
                } else {
                    aCB.setCaption(DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aCB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak(aCB);
            }
        }
        return legendScheme;
    }

    public static LegendScheme createGraduatedLegendScheme(BoundaryNorm norm, ColorMap colorMap) {
        Array values = norm.getBoundaries();
        int nv = (int)values.getSize();
        double min = values.getDouble(0);
        double max = values.getDouble(nv - 1);
        LegendScheme legendScheme = new LegendScheme(ShapeTypes.IMAGE);
        legendScheme.setLegendType(LegendType.GRADUATED_COLOR);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        Color[] colors = colorMap.getColors(norm.getNRegions());
        ExtendType extendType = norm.getExtendType();
        legendScheme.setExtendType(extendType);
        int offset = norm.getOffset();
        for (int i = 0; i < nv - 1; ++i) {
            ColorBreak cb = new ColorBreak();
            cb.setColor(colors[i + offset]);
            cb.setStartValue(values.getDouble(i));
            cb.setEndValue(values.getDouble(i + 1));
            cb.setCaption(DataConvert.removeTailingZeros((String)cb.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)cb.getEndValue().toString()));
            legendScheme.addLegendBreak(cb);
        }
        if (extendType.isExtendMin()) {
            ColorBreak cb = new ColorBreak();
            cb.setColor(colors[0]);
            cb.setStartValue(-1.7976931348623157E308);
            cb.setEndValue(values.getDouble(0));
            cb.setCaption("< " + DataConvert.removeTailingZeros((String)cb.getEndValue().toString()));
            legendScheme.addLegendBreak(0, cb);
        }
        if (extendType.isExtendMax()) {
            ColorBreak cb = new ColorBreak();
            cb.setColor(colors[colors.length - 1]);
            cb.setStartValue(values.getDouble(nv - 1));
            cb.setEndValue(Double.MAX_VALUE);
            cb.setCaption("> " + DataConvert.removeTailingZeros((String)cb.getStartValue().toString()));
            legendScheme.addLegendBreak(cb);
        }
        return legendScheme;
    }

    public static LegendScheme createLegendScheme(List<Number> values, List<Color> colors) {
        if (values.size() == colors.size()) {
            return LegendManage.createUniqValueLegendScheme(values, colors, ShapeTypes.IMAGE);
        }
        double[] vs = new double[values.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = values.get(i).doubleValue();
        }
        Color[] cs = new Color[values.size()];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = colors.get(i);
        }
        return LegendManage.createGraduatedLegendScheme(vs, cs, ShapeTypes.IMAGE, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static LegendScheme createGraduatedLegendScheme(double[] values, Color[] colors, ShapeTypes aST, double min, double max) {
        double unDef = -9999.0;
        boolean hasNodata = false;
        return LegendManage.createGraduatedLegendScheme(values, colors, aST, min, max, hasNodata, unDef);
    }

    public static Color[] createColors(Color sColor, Color eColor, int cNum) {
        Color[] colors = new Color[cNum];
        int sR = sColor.getRed();
        int sG = sColor.getGreen();
        int sB = sColor.getBlue();
        int eR = eColor.getRed();
        int eG = eColor.getGreen();
        int eB = eColor.getBlue();
        int rStep = (eR - sR) / cNum;
        int gStep = (eG - sG) / cNum;
        int bStep = (eB - sB) / cNum;
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(sR + i * rStep, sG + i * gStep, sB + i * bStep);
        }
        return colors;
    }

    public static double[] createContourValuesInterval(double min, double max, double interval) {
        int cNum = (int)((max - min) / interval) + 1;
        double[] cValues = new double[cNum];
        for (int i = 0; i < cNum; ++i) {
            cValues[i] = BigDecimalUtil.add((double)min, (double)BigDecimalUtil.mul((double)i, (double)interval));
        }
        return cValues;
    }

    public static LegendScheme createLegendScheme(ShapeTypes shapeType, List<Number> values, List<Color> colors) {
        LegendScheme ls;
        Color[] cols = new Color[colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            cols[i] = colors.get(i);
        }
        if (values.size() == colors.size()) {
            ls = LegendManage.createUniqValueLegendScheme(values, cols, shapeType);
        } else {
            int n = values.size();
            double[] vals = new double[n];
            for (int i = 0; i < n; ++i) {
                vals[i] = values.get(i).doubleValue();
            }
            double min = values.get(0).doubleValue() - (values.get(1).doubleValue() - values.get(0).doubleValue());
            double max = values.get(n - 1).doubleValue() + (values.get(n - 1).doubleValue() - values.get(n - 2).doubleValue());
            ls = LegendManage.createGraduatedLegendScheme(vals, cols, shapeType, min, max);
        }
        return ls;
    }

    public static LegendScheme createLegendScheme(double min, double max) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max);
        Color[] colors = LegendManage.createRainBowColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, ColorMap ct) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, ColorMap ct, ExtendType extendType) {
        double[] values = (double[])MIMath.getIntervalValues((double)min, (double)max, (boolean)true).get(0);
        Color[] colors = ct.getColors(values.length - 1);
        LegendScheme ls = LegendManage.createLegendScheme(values, colors);
        ls.setExtendType(extendType);
        return ls;
    }

    public static LegendScheme createLegendScheme(double min, double max, ColorMap ct, double missingValue) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, missingValue);
    }

    public static LegendScheme createLegendScheme(double min, double max, double interval, LegendType legendType, ShapeTypes shapeType) {
        return LegendManage.createLegendScheme(min, max, interval, legendType, shapeType, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, double interval, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (double)interval);
        Color[] colors = LegendManage.createRainBowColors(values.length + 1);
        LegendScheme ls = legendType == LegendType.UNIQUE_VALUE ? LegendManage.createUniqValueLegendScheme(values, colors, shapeType, min, max, (Boolean)hasNodata, unDef) : LegendManage.createGraduatedLegendScheme(values, colors, shapeType, min, max, hasNodata, unDef);
        return ls;
    }

    public static LegendScheme createLegendScheme(double min, double max, int n) {
        return LegendManage.createLegendScheme(min, max, n, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, LegendType legendType, ShapeTypes shapeType) {
        return LegendManage.createLegendScheme(min, max, n, legendType, shapeType, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, double[] values, Color[] colors, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        LegendScheme ls = legendType == LegendType.UNIQUE_VALUE ? LegendManage.createUniqValueLegendScheme(values, colors, shapeType, min, max, (Boolean)hasNodata, unDef) : LegendManage.createGraduatedLegendScheme(values, colors, shapeType, min, max, hasNodata, unDef);
        return ls;
    }

    public static LegendScheme createLegendScheme(double[] values, Color[] colors) {
        if (values.length == colors.length) {
            List<Number> vList = Arrays.stream(values).boxed().collect(Collectors.toList());
            return LegendManage.createUniqValueLegendScheme(vList, colors, ShapeTypes.IMAGE);
        }
        if (values.length > colors.length) {
            return LegendManage.createGraduatedLegendScheme(values, colors, ShapeTypes.IMAGE);
        }
        return LegendManage.createGraduatedLegendScheme(values, colors, ShapeTypes.IMAGE, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = LegendManage.createRainBowColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, legendType, shapeType, hasNodata, unDef);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, ColorMap ct, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, legendType, shapeType, hasNodata, unDef);
    }

    public static LegendScheme createLegendScheme(double min, double max, List<Number> levs, ColorMap ct, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = new double[levs.size()];
        for (int i = 0; i < levs.size(); ++i) {
            values[i] = levs.get(i).doubleValue();
        }
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, legendType, shapeType, hasNodata, unDef);
    }

    public static LegendScheme createLegendScheme(double min, double max, List<Number> levs, ColorMap ct) {
        if (levs.size() == ct.getColorCount()) {
            return LegendManage.createUniqValueLegendScheme(levs, ct.getColors(), ShapeTypes.IMAGE);
        }
        double[] values = new double[levs.size()];
        for (int i = 0; i < levs.size(); ++i) {
            values[i] = levs.get(i).doubleValue();
        }
        Color[] colors = ct.getColors(levs.size() + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, List<Number> levels, ColorMap ct, boolean extend) {
        if (levels.size() == ct.getColorCount()) {
            return LegendManage.createUniqValueLegendScheme(levels, ct.getColors(), ShapeTypes.IMAGE);
        }
        double[] values = new double[levels.size()];
        for (int i = 0; i < levels.size(); ++i) {
            values[i] = levels.get(i).doubleValue();
        }
        if (extend) {
            Color[] colors = ct.getColors(values.length - 1);
            return LegendManage.createLegendScheme(values, colors);
        }
        Color[] colors = ct.getColors(levels.size() + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(List<Number> levels, ColorMap colorMap, ExtendType extendType) {
        Array boundaries = ArrayUtil.array(levels);
        BoundaryNorm norm = new BoundaryNorm(boundaries, extendType);
        return LegendManage.createGraduatedLegendScheme(norm, colorMap);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, ColorMap ct) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, ColorMap ct, ExtendType extendType) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n, (boolean)true);
        Color[] colors = ct.getColors(values.length - 1);
        LegendScheme ls = LegendManage.createLegendScheme(values, colors);
        ls.setExtendType(extendType);
        return ls;
    }

    public static LegendScheme createLegendScheme(TransferFunction transferFunction) {
        ColorMap colorMap = transferFunction.getColorMap();
        Color[] colors = colorMap.getColors();
        int n = colors.length;
        Normalize norm = transferFunction.getNormalize();
        double[] values = MIMath.getIntervalValues((double)norm.getMinValue(), (double)norm.getMaxValue(), (int)(n - 1));
        LegendScheme ls = LegendManage.createGraduatedLegendScheme(values, colors, ShapeTypes.POLYGON, norm.getMinValue(), norm.getMaxValue());
        ls.setColorMap(colorMap);
        ls.setNormalize(norm);
        return ls;
    }

    public static LegendScheme createImageLegend(Array array, ColorMap colorMap) {
        LegendScheme ls;
        boolean isUnique = ArrayUtil.isUnique((Array)array, (int)20);
        if (isUnique) {
            try {
                Array ua = ArrayUtil.unique((Array)array, null);
                ArrayList<Number> values = new ArrayList<Number>();
                IndexIterator iter = ua.getIndexIterator();
                while (iter.hasNext()) {
                    values.add((Number)iter.getObjectNext());
                }
                ls = LegendManage.createUniqValueLegendScheme(values, colorMap, ShapeTypes.IMAGE);
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        } else {
            ls = ArrayMath.containsNaN((Array)array) ? LegendManage.createLegendScheme(ArrayMath.min((Array)array).doubleValue(), ArrayMath.max((Array)array).doubleValue(), colorMap, Double.NaN) : LegendManage.createLegendScheme(ArrayMath.min((Array)array).doubleValue(), ArrayMath.max((Array)array).doubleValue(), colorMap);
        }
        return ls;
    }

    public static LegendScheme createImageLegend(Array array, int n, ColorMap colorMap) {
        double min = ArrayMath.min((Array)array).doubleValue();
        double max = ArrayMath.max((Array)array).doubleValue();
        LegendScheme ls = ArrayMath.containsNaN((Array)array) ? LegendManage.createLegendScheme(min, max, n, colorMap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, Double.NaN) : LegendManage.createLegendScheme(min, max, n, colorMap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, Double.NaN);
        return ls;
    }

    public static LegendScheme createImageLegend(Array array, List<Number> levels, ColorMap colorMap) {
        LegendScheme ls;
        if (colorMap.getColorCount() == levels.size()) {
            ls = LegendManage.createUniqValueLegendScheme(levels, colorMap, ShapeTypes.IMAGE);
        } else {
            double min = ArrayMath.min((Array)array).doubleValue();
            double max = ArrayMath.max((Array)array).doubleValue();
            ls = ArrayMath.containsNaN((Array)array) ? LegendManage.createLegendScheme(min, max, levels, colorMap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, Double.NaN) : LegendManage.createLegendScheme(min, max, levels, colorMap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, Double.NaN);
        }
        return ls;
    }

    public static LegendScheme createWeatherLegendScheme(List<Integer> wList, int size, Color color) {
        LegendScheme aLS = new LegendScheme(ShapeTypes.POINT);
        aLS.setLegendType(LegendType.UNIQUE_VALUE);
        for (int w : wList) {
            PointBreak aPB = new PointBreak();
            aPB.setMarkerType(MarkerType.CHARACTER);
            aPB.setSize(size);
            aPB.setColor(color);
            aPB.setFontName("Weather");
            aPB.setStartValue(w);
            aPB.setEndValue(w);
            int charIdx = w + 28;
            if (w == 99) {
                charIdx = w + 97;
            }
            aPB.setCharIndex(charIdx);
            aPB.setCaption(String.valueOf(w));
            aLS.getLegendBreaks().add(aPB);
        }
        return aLS;
    }

    public static Color[] createRandomColors(int cNum) {
        Color[] colors = new Color[cNum];
        Random randomColor = new Random();
        for (int i = 0; i < cNum; ++i) {
            colors[i] = new Color(randomColor.nextInt(256), randomColor.nextInt(256), randomColor.nextInt(256));
        }
        return colors;
    }

    public static Color[] createRainBowColors(int cNum) {
        if (cNum > 13) {
            return LegendManage.getRainBowColors_HSV(cNum);
        }
        ArrayList<Color> colorList = new ArrayList<Color>();
        colorList.add(new Color(160, 0, 200));
        colorList.add(new Color(110, 0, 220));
        colorList.add(new Color(30, 60, 255));
        colorList.add(new Color(0, 160, 255));
        colorList.add(new Color(0, 200, 200));
        colorList.add(new Color(0, 210, 140));
        colorList.add(new Color(0, 220, 0));
        colorList.add(new Color(160, 230, 50));
        colorList.add(new Color(230, 220, 50));
        colorList.add(new Color(230, 175, 45));
        colorList.add(new Color(240, 130, 40));
        colorList.add(new Color(250, 60, 60));
        colorList.add(new Color(240, 0, 130));
        switch (cNum) {
            case 12: {
                colorList.remove(new Color(0, 210, 140));
                break;
            }
            case 11: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                break;
            }
            case 10: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                break;
            }
            case 9: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                break;
            }
            case 8: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                break;
            }
            case 7: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                break;
            }
            case 6: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                break;
            }
            case 5: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                colorList.remove(new Color(160, 0, 200));
            }
        }
        Color[] colors = new Color[cNum];
        for (int i = 0; i < cNum; ++i) {
            colors[i] = (Color)colorList.get(i);
        }
        return colors;
    }

    public static Color[] getRainBowColors_HSV(int cNum) {
        double p = 360.0 / (double)cNum;
        Color[] colors = new Color[cNum];
        for (int i = 0; i < cNum; ++i) {
            colors[cNum - i - 1] = Color.getHSBColor((float)((double)i * p), 1.0f, 1.0f);
        }
        return colors;
    }

    public static Object[] getContoursAndColors(LegendScheme aLS) {
        Color[] colors;
        double[] cValues;
        block9: {
            ShapeTypes st;
            block10: {
                block8: {
                    if (aLS.getHasNoData()) {
                        cValues = new double[aLS.getBreakNum() - 2];
                        colors = new Color[aLS.getBreakNum() - 1];
                    } else {
                        cValues = new double[aLS.getBreakNum() - 1];
                        colors = new Color[aLS.getBreakNum()];
                    }
                    st = aLS.getShapeType();
                    if (!st.isPoint()) break block8;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(i);
                        if (aPB.isNoData()) continue;
                        colors[i] = aPB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPB.getStartValue().toString());
                    }
                    break block9;
                }
                if (!st.isLine()) break block10;
                if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                    cValues = new double[aLS.getBreakNum()];
                    colors = new Color[aLS.getBreakNum() + 1];
                    colors[0] = Color.white;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i + 1] = aPLB.getColor();
                        cValues[i] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                } else {
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i] = aPLB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                }
                break block9;
            }
            if (!st.isPolygon()) break block9;
            for (int i = 0; i < aLS.getBreakNum(); ++i) {
                PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i);
                colors[i] = aPGB.getColor();
                if (i <= 0) continue;
                cValues[i - 1] = Double.parseDouble(aPGB.getStartValue().toString());
            }
        }
        return new Object[]{cValues, colors};
    }

    public static void setContoursAndColors(LegendScheme aLS, double[] cValues, Color[] colors) {
        block9: {
            ShapeTypes st;
            block10: {
                block8: {
                    if (aLS.getHasNoData()) {
                        cValues = new double[aLS.getBreakNum() - 2];
                        colors = new Color[aLS.getBreakNum() - 1];
                    } else {
                        cValues = new double[aLS.getBreakNum() - 1];
                        colors = new Color[aLS.getBreakNum()];
                    }
                    st = aLS.getShapeType();
                    if (!st.isPoint()) break block8;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(i);
                        if (aPB.isNoData()) continue;
                        colors[i] = aPB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPB.getStartValue().toString());
                    }
                    break block9;
                }
                if (!st.isLine()) break block10;
                if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                    cValues = new double[aLS.getBreakNum()];
                    colors = new Color[aLS.getBreakNum() + 1];
                    colors[0] = Color.white;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i + 1] = aPLB.getColor();
                        cValues[i] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                } else {
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i] = aPLB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                }
                break block9;
            }
            if (!st.isPolygon()) break block9;
            for (int i = 0; i < aLS.getBreakNum(); ++i) {
                PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i);
                colors[i] = aPGB.getColor();
                if (i <= 0) continue;
                cValues[i - 1] = Double.parseDouble(aPGB.getStartValue().toString());
            }
        }
    }

    public static List<Integer> getWeatherTypes(String weatherType) {
        int[] weathers;
        ArrayList<Integer> weatherList = new ArrayList<Integer>();
        switch (weatherType.toLowerCase()) {
            default: {
                int i;
                weathers = new int[96];
                for (i = 4; i < 100; ++i) {
                    weathers[i - 4] = i;
                }
                break;
            }
            case "sds": 
            case "dust": {
                weathers = new int[]{6, 7, 8, 9, 30, 31, 32, 33, 34, 35};
                break;
            }
            case "sds, haze": {
                weathers = new int[]{5, 6, 7, 8, 9, 30, 31, 32, 33, 34, 35};
                break;
            }
            case "smoke, haze, mist": {
                weathers = new int[]{4, 5, 10};
                break;
            }
            case "smoke": {
                weathers = new int[]{4};
                break;
            }
            case "haze": {
                weathers = new int[]{5};
                break;
            }
            case "mist": {
                weathers = new int[]{10};
                break;
            }
            case "Fog": {
                int i;
                weathers = new int[10];
                for (i = 40; i < 50; ++i) {
                    weathers[i - 40] = i;
                }
            }
        }
        for (Object w : (String)weathers) {
            weatherList.add((int)w);
        }
        return weatherList;
    }

    public static LegendScheme createCloudLegendScheme(int size, Color color) {
        int[] clouds;
        LegendScheme aLS = new LegendScheme(ShapeTypes.POINT);
        aLS.setLegendType(LegendType.UNIQUE_VALUE);
        for (int w : clouds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}) {
            PointBreak aPB = new PointBreak();
            aPB.setMarkerType(MarkerType.CHARACTER);
            aPB.setSize(size);
            aPB.setColor(color);
            aPB.setFontName("Weather");
            aPB.setStartValue(w);
            aPB.setEndValue(w);
            int charIdx = w + 197;
            aPB.setCharIndex(charIdx);
            aPB.setCaption(String.valueOf(w));
            aLS.getLegendBreaks().add(aPB);
        }
        return aLS;
    }
}

