/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.lab.gui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.jogl.GLChartPanel;
import org.meteoinfo.console.ConsoleColors;
import org.meteoinfo.console.JConsole;
import org.meteoinfo.console.NameCompletion;
import org.meteoinfo.console.jython.JIntrospect;
import org.meteoinfo.console.jython.PythonInteractiveInterpreter;
import org.meteoinfo.lab.gui.EncodingUtil;
import org.meteoinfo.lab.gui.FrmMain;
import org.python.core.Py;
import org.python.util.PythonInterpreter;

public class ConsoleDockable
extends DefaultSingleCDockable {
    private String startupPath;
    private FrmMain parent;
    private PythonInteractiveInterpreter interp;
    private JConsole console;
    private SwingWorker myWorker;
    private ConsoleColors consoleColors;

    public ConsoleDockable(FrmMain parent, String startupPath, String id, String title, CAction ... actions) {
        super(id, title, actions);
        this.parent = parent;
        this.startupPath = startupPath;
        this.consoleColors = new ConsoleColors(this.parent.getOptions().getLookFeel());
        this.console = new JConsole();
        this.console.setCommandColor(this.consoleColors.getCommandColor());
        this.console.setLocale(Locale.getDefault());
        this.console.setPreferredSize(new Dimension(600, 400));
        this.console.println((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/jython_small_c.png")));
        System.out.println("Initialize console...");
        this.initializeConsole(this.console, parent.getCurrentFolder());
        JIntrospect nameComplete = new JIntrospect((PythonInterpreter)this.interp);
        this.console.setNameCompletion((NameCompletion)nameComplete);
        System.out.println("Set title icon...");
        this.setTitleIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/console.svg"));
        this.getContentPane().add((Component)this.console, "Center");
        this.console.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent ke) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                switch (ke.getKeyCode()) {
                    case 67: {
                        if (!ke.isControlDown() || ConsoleDockable.this.myWorker == null || ConsoleDockable.this.myWorker.isCancelled() || ConsoleDockable.this.myWorker.isDone()) break;
                        ConsoleDockable.this.myWorker.cancel(true);
                        ConsoleDockable.this.myWorker = null;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
            }
        });
    }

    public void setLookFeel(String laf) {
        this.consoleColors = new ConsoleColors(laf);
        this.console.setCommandColor(this.consoleColors.getCommandColor());
        this.console.setStyle(this.consoleColors.getCommandColor());
        this.console.repaint();
    }

    private void initializeConsole(JConsole console, String currentPath) {
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        try {
            Py.getSystemState().setdefaultencoding("utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.interp = new PythonInteractiveInterpreter(console);
        this.interp.setConsoleColors(this.consoleColors);
        String path = this.startupPath + File.separator + "pylib";
        String toolboxPath = this.startupPath + "/toolbox";
        String miPath = this.startupPath;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows") && miPath.substring(0, 1).equals("/")) {
            miPath = miPath.substring(1);
        }
        new Thread((Runnable)this.interp).start();
        try {
            this.interp.set("milapp", (Object)this.parent);
            this.interp.exec("import sys");
            this.interp.exec("import os");
            this.interp.exec("import datetime");
            System.out.println("Append path: " + path);
            this.interp.exec("sys.path.append('" + path + "')");
            System.out.println("Run milab.py ...");
            this.interp.execfile_(path + "/milab.py");
            this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
            this.interp.exec("mipylib.migl.milapp = milapp");
            System.out.println("Set mifolder: " + miPath);
            this.interp.exec("mipylib.migl.mifolder = u'" + miPath + "'");
            currentPath = currentPath.replace("\\", "/");
            System.out.println("Set currentfolder: " + currentPath);
            this.interp.exec("mipylib.migl.currentfolder = u'" + currentPath + "'");
            System.out.println("Append path: " + toolboxPath);
            this.interp.exec("sys.path.append(u'" + toolboxPath + "')");
            if (isDebug) {
                System.out.println("Run milab_debug.py ...");
                this.interp.execfile_(path + "/milab_debug.py");
            }
            System.out.println("Interpreter done...");
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public PythonInteractiveInterpreter getInterpreter() {
        return this.interp;
    }

    public JConsole getConsole() {
        return this.interp.console;
    }

    public void setStartupPath(String path) {
        this.startupPath = path;
    }

    public void setParent(FrmMain parent) {
        this.parent = parent;
    }

    public void run(final String command) {
        this.myWorker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setStyle(ConsoleDockable.this.consoleColors.getCommandColor());
                ((ConsoleDockable)ConsoleDockable.this).interp.console.println((Object)"evaluate selection...");
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setStyle(ConsoleDockable.this.consoleColors.getCodeLinesColor());
                ((ConsoleDockable)ConsoleDockable.this).interp.console.println((Object)command);
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setStyle(ConsoleDockable.this.consoleColors.getCommandColor());
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setFocusable(true);
                ((ConsoleDockable)ConsoleDockable.this).interp.console.requestFocusInWindow();
                try {
                    ConsoleDockable.this.interp.exec(command);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ConsoleDockable.this.interp.fireConsoleExecEvent();
                }
                return "";
            }

            @Override
            protected void done() {
                ((ConsoleDockable)ConsoleDockable.this).interp.console.print((Object)">>> ", ConsoleDockable.this.consoleColors.getPromptColor());
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setStyle(ConsoleDockable.this.consoleColors.getCommandColor());
                ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
            }
        };
        this.myWorker.execute();
    }

    public void enter() {
        this.interp.console.print((Object)">>> ", this.consoleColors.getPromptColor());
        this.interp.console.setStyle(this.consoleColors.getCommandColor());
        this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
    }

    public void exec(String command) {
        this.interp.console.setStyle(this.consoleColors.getCommandColor());
        this.interp.console.println((Object)"run script...");
        this.interp.exec(command);
        this.interp.console.print((Object)">>> ", this.consoleColors.getPromptColor());
        this.interp.console.setStyle(this.consoleColors.getCommandColor());
        this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
    }

    public void execfile(final String fn) {
        this.myWorker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setStyle(ConsoleDockable.this.consoleColors.getCommandColor());
                ((ConsoleDockable)ConsoleDockable.this).interp.console.println((Object)"run script...");
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setFocusable(true);
                ((ConsoleDockable)ConsoleDockable.this).interp.console.requestFocusInWindow();
                try {
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.isinteractive = False");
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.clf()");
                    ConsoleDockable.this.interp.execfile(fn);
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PythonInteractiveInterpreter.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    ((ConsoleDockable)ConsoleDockable.this).interp.console.print((Object)">>> ", ConsoleDockable.this.consoleColors.getPromptColor());
                    ((ConsoleDockable)ConsoleDockable.this).interp.console.setStyle(ConsoleDockable.this.consoleColors.getCommandColor());
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
                }
                return "";
            }

            @Override
            protected void done() {
                IChartPanel cp = ConsoleDockable.this.parent.getFigureDock().getCurrentFigure();
                if (cp != null) {
                    cp.paintGraphics();
                    if (cp instanceof GLChartPanel) {
                        ((GLChartPanel)cp).display();
                    }
                }
            }
        };
        this.myWorker.execute();
    }

    public void runfile(String code) {
        try {
            this.interp.console.setStyle(this.consoleColors.getCommandColor());
            this.interp.console.println((Object)"run script...");
            this.interp.setOut((OutputStream)this.interp.console.getOut());
            this.interp.setErr((OutputStream)this.interp.console.getErr());
            System.setOut(this.interp.console.getOut());
            System.setErr(this.interp.console.getErr());
            String encoding = EncodingUtil.findEncoding(code);
            if (encoding != null) {
                try {
                    this.interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes(encoding)));
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.interp.console.print((Object)">>> ", this.consoleColors.getPromptColor());
            this.interp.console.setStyle(this.consoleColors.getCommandColor());
        }
        catch (IOException ex) {
            Logger.getLogger(ConsoleDockable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void runPythonScript(final String code) throws InterruptedException {
        this.myWorker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setStyle(ConsoleDockable.this.consoleColors.getCommandColor());
                ((ConsoleDockable)ConsoleDockable.this).interp.console.println((Object)"run script...");
                ((ConsoleDockable)ConsoleDockable.this).interp.console.setFocusable(true);
                ((ConsoleDockable)ConsoleDockable.this).interp.console.requestFocusInWindow();
                String encoding = "utf-8";
                try {
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.isinteractive = False");
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.clf()");
                    ConsoleDockable.this.interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes(encoding)));
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ConsoleDockable.this.interp.exec("mipylib.plotlib.miplot.isinteractive = True");
                    ConsoleDockable.this.interp.fireConsoleExecEvent();
                }
                return "";
            }

            @Override
            protected void done() {
                IChartPanel cp = ConsoleDockable.this.parent.getFigureDock().getCurrentFigure();
                if (cp != null) {
                    cp.paintGraphics();
                }
            }
        };
        this.myWorker.execute();
    }

    class SmallWorker
    extends SwingWorker<String, String> {
        SmallWorker() {
        }

        @Override
        protected String doInBackground() throws Exception {
            ConsoleDockable.this.interp.exec("print('Thread cancled!')");
            return "";
        }
    }
}

