/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.lab.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.console.jython.PythonInteractiveInterpreter;
import org.meteoinfo.lab.application.AppCollection;
import org.meteoinfo.lab.application.Application;
import org.meteoinfo.lab.gui.FrmMain;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteoinfo.ui.JCheckBoxList;
import org.meteoinfo.ui.plugin.IPlugin;
import org.python.core.PyObject;

public class FrmAppsManager
extends JDialog {
    private final FrmMain parent;
    private AppCollection apps = new AppCollection();
    private JCheckBoxList checkBoxList_Plugin;
    private JButton jButton_UpdateList;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea_PluginDetails;

    public FrmAppsManager(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.parent = (FrmMain)parent;
        this.initialize();
    }

    private void initialize() {
        this.apps = this.parent.getApplications();
        this.updatePluginCheckList();
    }

    private void updatePluginCheckList() {
        DefaultListModel<CheckBoxListEntry> listModel = new DefaultListModel<CheckBoxListEntry>();
        for (Application plugin : this.apps) {
            listModel.addElement(new CheckBoxListEntry((Object)plugin, plugin.isLoad()));
        }
        this.checkBoxList_Plugin.setModel(listModel);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.checkBoxList_Plugin = new JCheckBoxList();
        this.jButton_UpdateList = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea_PluginDetails = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Application Manager");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                FrmAppsManager.this.formWindowClosed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Applications"));
        this.checkBoxList_Plugin.setModel((ListModel)new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.checkBoxList_Plugin.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmAppsManager.this.checkBoxList_PluginMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.checkBoxList_Plugin);
        this.jButton_UpdateList.setText("Update List");
        this.jButton_UpdateList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAppsManager.this.jButton_UpdateListActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 391, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(126, 126, 126).addComponent(this.jButton_UpdateList))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_UpdateList)));
        this.jLabel1.setText("Application:");
        this.jTextArea_PluginDetails.setColumns(20);
        this.jTextArea_PluginDetails.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea_PluginDetails);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jScrollPane2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 156, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void checkBoxList_PluginMouseClicked(MouseEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Plugin.getModel();
        int idx = this.checkBoxList_Plugin.getSelectedIndex();
        CheckBoxListEntry item = (CheckBoxListEntry)listModel.getElementAt(idx);
        Application plugin = (Application)((Object)item.getValue());
        if (item.isSelected()) {
            this.parent.loadApplication(plugin);
            this.parent.validate();
        } else {
            this.parent.unloadApplication(plugin);
            this.parent.validate();
        }
        String detailStr = "Name: " + plugin.getName() + System.getProperty("line.separator") + "Author: " + plugin.getAuthor() + System.getProperty("line.separator") + "Version: " + plugin.getVersion() + System.getProperty("line.separator") + "Description: " + plugin.getDescription() + System.getProperty("line.separator") + "Jar Path: " + plugin.getJarPath() + System.getProperty("line.separator") + "Class Name: " + plugin.getClassName();
        this.jTextArea_PluginDetails.setText(detailStr);
    }

    private void jButton_UpdateListActionPerformed(ActionEvent evt) {
        ArrayList<Application> plugins = new ArrayList<Application>();
        String pluginPath = this.parent.getApplications().getPluginPath();
        if (new File(pluginPath).isDirectory()) {
            File f = new File(pluginPath);
            if (f.isDirectory()) {
                File[] fs = f.listFiles();
                for (File ff : fs) {
                    Application plugin;
                    if (!ff.isDirectory() || (plugin = this.readPyApp(ff.getName(), "loadApp.py")) == null) continue;
                    plugins.add(plugin);
                }
            }
            if (plugins.size() > 0) {
                ArrayList<String> pluginNames = new ArrayList<String>();
                for (Application plugin : this.apps) {
                    pluginNames.add(plugin.getName());
                }
                ArrayList<String> newPluginNames = new ArrayList<String>();
                for (Application plugin : plugins) {
                    newPluginNames.add(plugin.getName());
                }
                for (int i = 0; i < this.apps.size(); ++i) {
                    if (newPluginNames.contains(((Application)((Object)this.apps.get(i))).getName())) continue;
                    this.apps.remove(i);
                    --i;
                }
                for (Application plugin : plugins) {
                    if (pluginNames.contains(plugin.getName())) continue;
                    this.apps.add(plugin);
                }
                this.updatePluginCheckList();
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.parent.getApplications().saveConfigFile();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(FrmAppsManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Application readPyApp(String path, String fileName) {
        try {
            Application plugin = new Application();
            plugin.setPath(path);
            plugin.setClassName("LoadApp");
            PythonInteractiveInterpreter interp = this.parent.getConsoleDockable().getInterpreter();
            interp.exec("import " + path);
            interp.exec("from " + path + ".loadApp import LoadApp");
            PyObject loadClass = interp.get("LoadApp");
            PyObject loadObj = loadClass.__call__();
            IPlugin instance = (IPlugin)loadObj.__tojava__(IPlugin.class);
            plugin.setPluginObject(instance);
            return plugin;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Application readApplication(String jarFileName) {
        try {
            Application plugin = new Application();
            plugin.setPath(jarFileName);
            String className = GlobalUtil.getPluginClassName((String)jarFileName);
            if (className == null) {
                return null;
            }
            plugin.setClassName(className);
            URL url = new URL("file:" + plugin.getPath());
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url});
            Class<?> clazz = urlClassLoader.loadClass(plugin.getClassName());
            IPlugin instance = (IPlugin)clazz.newInstance();
            plugin.setPluginObject(instance);
            return plugin;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmAppsManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmAppsManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmAppsManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmAppsManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmAppsManager dialog = new FrmAppsManager(new FrmMain(null, null), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

