/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.meteoinfo.lab.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.meteoinfo.console.editor.TextEditor;

/**
 *
 * @author yaqiang
 */
public class FrmFindReplace extends javax.swing.JDialog {
    
    private TextEditor textEditor;
    private List<String> findStrs = new ArrayList<>();
    private List<String> replaceStrs = new ArrayList<>();

    /**
     * Creates new form FrmFindReplace
     */
    public FrmFindReplace(java.awt.Frame parent, boolean modal, TextEditor textEditor) {
        super(parent, modal);
        this.textEditor = textEditor;
        
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup_Direction = new javax.swing.ButtonGroup();
        buttonGroup_Find = new javax.swing.ButtonGroup();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel_Find = new javax.swing.JPanel();
        jLabel_Find = new javax.swing.JLabel();
        jComboBox_Find = new javax.swing.JComboBox<>();
        jButton_Find = new javax.swing.JButton();
        jCheckBox_MatchCase = new javax.swing.JCheckBox();
        jButton_Cancel = new javax.swing.JButton();
        jCheckBox_WholeWord = new javax.swing.JCheckBox();
        jCheckBox_Regular = new javax.swing.JCheckBox();
        jCheckBox_MarkAll = new javax.swing.JCheckBox();
        jPanel_Direction = new javax.swing.JPanel();
        jRadioButton_Down = new javax.swing.JRadioButton();
        jRadioButton_Up = new javax.swing.JRadioButton();
        jPanel_Replace = new javax.swing.JPanel();
        jLabel_Find1 = new javax.swing.JLabel();
        jComboBox_Find1 = new javax.swing.JComboBox<>();
        jButton_Find1 = new javax.swing.JButton();
        jButton_Cancel1 = new javax.swing.JButton();
        jPanel_Direction1 = new javax.swing.JPanel();
        jRadioButton_Down1 = new javax.swing.JRadioButton();
        jRadioButton_Up1 = new javax.swing.JRadioButton();
        jCheckBox_MatchCase1 = new javax.swing.JCheckBox();
        jCheckBox_Regular1 = new javax.swing.JCheckBox();
        jCheckBox_WholeWord1 = new javax.swing.JCheckBox();
        jCheckBox_MarkAll1 = new javax.swing.JCheckBox();
        jButton_Replace = new javax.swing.JButton();
        jButton_ReplaceAll = new javax.swing.JButton();
        jLabel_ReplaceWith = new javax.swing.JLabel();
        jComboBox_ReplaceWith = new javax.swing.JComboBox<>();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Find & Replace");

        jLabel_Find.setText("Find what");

        jComboBox_Find.setEditable(true);

        jButton_Find.setText("Find");
        jButton_Find.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_FindActionPerformed(evt);
            }
        });

        jCheckBox_MatchCase.setText("Match case");

        jButton_Cancel.setText("Cancel");
        jButton_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_CancelActionPerformed(evt);
            }
        });

        jCheckBox_WholeWord.setText("Whole word");

        jCheckBox_Regular.setText("Regular");

        jCheckBox_MarkAll.setText("Mark all");

        jPanel_Direction.setBorder(javax.swing.BorderFactory.createTitledBorder("Direction"));

        buttonGroup_Find.add(jRadioButton_Down);
        jRadioButton_Down.setSelected(true);
        jRadioButton_Down.setText("Down");

        buttonGroup_Find.add(jRadioButton_Up);
        jRadioButton_Up.setText("Up");

        javax.swing.GroupLayout jPanel_DirectionLayout = new javax.swing.GroupLayout(jPanel_Direction);
        jPanel_Direction.setLayout(jPanel_DirectionLayout);
        jPanel_DirectionLayout.setHorizontalGroup(
            jPanel_DirectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel_DirectionLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jRadioButton_Up)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButton_Down)
                .addGap(18, 18, 18))
        );
        jPanel_DirectionLayout.setVerticalGroup(
            jPanel_DirectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_DirectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jRadioButton_Down)
                .addComponent(jRadioButton_Up))
        );

        javax.swing.GroupLayout jPanel_FindLayout = new javax.swing.GroupLayout(jPanel_Find);
        jPanel_Find.setLayout(jPanel_FindLayout);
        jPanel_FindLayout.setHorizontalGroup(
            jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_FindLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(jPanel_FindLayout.createSequentialGroup()
                        .addGroup(jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(jPanel_FindLayout.createSequentialGroup()
                                .addComponent(jCheckBox_WholeWord, javax.swing.GroupLayout.PREFERRED_SIZE, 98, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jCheckBox_MarkAll, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(jPanel_FindLayout.createSequentialGroup()
                                .addComponent(jCheckBox_MatchCase, javax.swing.GroupLayout.PREFERRED_SIZE, 98, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jCheckBox_Regular)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanel_Direction, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel_FindLayout.createSequentialGroup()
                        .addGap(11, 11, 11)
                        .addComponent(jLabel_Find, javax.swing.GroupLayout.PREFERRED_SIZE, 72, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox_Find, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButton_Find, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButton_Cancel, javax.swing.GroupLayout.DEFAULT_SIZE, 93, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel_FindLayout.setVerticalGroup(
            jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_FindLayout.createSequentialGroup()
                .addGap(16, 16, 16)
                .addGroup(jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox_Find, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton_Find)
                    .addComponent(jLabel_Find))
                .addGap(40, 40, 40)
                .addGroup(jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel_Direction, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel_FindLayout.createSequentialGroup()
                        .addGroup(jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBox_MatchCase)
                            .addComponent(jCheckBox_Regular))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel_FindLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBox_WholeWord)
                            .addComponent(jCheckBox_MarkAll)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel_FindLayout.createSequentialGroup()
                        .addComponent(jButton_Cancel)
                        .addGap(11, 11, 11)))
                .addContainerGap(24, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Find", jPanel_Find);

        jLabel_Find1.setText("Find what");

        jComboBox_Find1.setEditable(true);

        jButton_Find1.setText("Find");
        jButton_Find1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_Find1ActionPerformed(evt);
            }
        });

        jButton_Cancel1.setText("Cancel");
        jButton_Cancel1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_Cancel1ActionPerformed(evt);
            }
        });

        jPanel_Direction1.setBorder(javax.swing.BorderFactory.createTitledBorder("Direction"));

        buttonGroup_Direction.add(jRadioButton_Down1);
        jRadioButton_Down1.setSelected(true);
        jRadioButton_Down1.setText("Down");

        buttonGroup_Direction.add(jRadioButton_Up1);
        jRadioButton_Up1.setText("Up");

        javax.swing.GroupLayout jPanel_Direction1Layout = new javax.swing.GroupLayout(jPanel_Direction1);
        jPanel_Direction1.setLayout(jPanel_Direction1Layout);
        jPanel_Direction1Layout.setHorizontalGroup(
            jPanel_Direction1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel_Direction1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jRadioButton_Up1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButton_Down1)
                .addGap(18, 18, 18))
        );
        jPanel_Direction1Layout.setVerticalGroup(
            jPanel_Direction1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_Direction1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jRadioButton_Down1)
                .addComponent(jRadioButton_Up1))
        );

        jCheckBox_MatchCase1.setText("Match case");

        jCheckBox_Regular1.setText("Regular");

        jCheckBox_WholeWord1.setText("Whole word");

        jCheckBox_MarkAll1.setText("Mark all");

        jButton_Replace.setText("Replace");
        jButton_Replace.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ReplaceActionPerformed(evt);
            }
        });

        jButton_ReplaceAll.setText("Replace all");
        jButton_ReplaceAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ReplaceAllActionPerformed(evt);
            }
        });

        jLabel_ReplaceWith.setText("Replace with");

        jComboBox_ReplaceWith.setEditable(true);

        javax.swing.GroupLayout jPanel_ReplaceLayout = new javax.swing.GroupLayout(jPanel_Replace);
        jPanel_Replace.setLayout(jPanel_ReplaceLayout);
        jPanel_ReplaceLayout.setHorizontalGroup(
            jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                        .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                                .addComponent(jCheckBox_WholeWord1, javax.swing.GroupLayout.PREFERRED_SIZE, 98, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jCheckBox_MarkAll1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                                .addComponent(jCheckBox_MatchCase1, javax.swing.GroupLayout.PREFERRED_SIZE, 98, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jCheckBox_Regular1)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanel_Direction1, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                        .addGap(11, 11, 11)
                        .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel_Find1, javax.swing.GroupLayout.PREFERRED_SIZE, 72, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel_ReplaceWith, javax.swing.GroupLayout.PREFERRED_SIZE, 78, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jComboBox_ReplaceWith, 0, 218, Short.MAX_VALUE)
                            .addComponent(jComboBox_Find1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jButton_Find1, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton_ReplaceAll)
                    .addComponent(jButton_Replace, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButton_Cancel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(112, 112, 112))
        );
        jPanel_ReplaceLayout.setVerticalGroup(
            jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                        .addGap(19, 19, 19)
                        .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jComboBox_Find1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel_Find1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jComboBox_ReplaceWith, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel_ReplaceWith)))
                    .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jButton_Find1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton_Replace, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel_ReplaceLayout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addComponent(jPanel_Direction1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                        .addComponent(jButton_ReplaceAll, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton_Cancel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel_ReplaceLayout.createSequentialGroup()
                        .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBox_MatchCase1)
                            .addComponent(jCheckBox_Regular1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel_ReplaceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBox_WholeWord1)
                            .addComponent(jCheckBox_MarkAll1))))
                .addGap(7, 7, 7))
        );

        jTabbedPane1.addTab("Replace", jPanel_Replace);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 438, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.TRAILING)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton_FindActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_FindActionPerformed
        // TODO add your handling code here:
        // Create an object defining our search parameters.
        SearchContext context = new SearchContext();
        String text = (String)this.jComboBox_Find.getSelectedItem();
        if (text.length() == 0) {
            return;
        }
        context.setSearchFor(text);
        context.setMatchCase(this.jCheckBox_MatchCase.isSelected());
        context.setRegularExpression(this.jCheckBox_Regular.isSelected());
        context.setSearchForward(this.jRadioButton_Down.isSelected());
        context.setWholeWord(this.jCheckBox_WholeWord.isSelected());
        context.setMarkAll(this.jCheckBox_MarkAll.isSelected());

        boolean found = SearchEngine.find(this.textEditor.getTextArea(), context).wasFound();
        if (!found) {
            JOptionPane.showMessageDialog(this, "Text not found");
        } else {
            if (!this.findStrs.contains(text)) {
                this.findStrs.add(text);
                this.jComboBox_Find.addItem(text);
                this.jComboBox_Find1.addItem(text);
            }
        }
    }//GEN-LAST:event_jButton_FindActionPerformed

    private void jButton_Find1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_Find1ActionPerformed
        // TODO add your handling code here:
        SearchContext context = new SearchContext();
        String text = (String)this.jComboBox_Find1.getSelectedItem();
        if (text.length() == 0) {
            return;
        }
        context.setSearchFor(text);
        context.setMatchCase(this.jCheckBox_MatchCase1.isSelected());
        context.setRegularExpression(this.jCheckBox_Regular1.isSelected());
        context.setSearchForward(this.jRadioButton_Down1.isSelected());
        context.setWholeWord(this.jCheckBox_WholeWord1.isSelected());
        context.setMarkAll(this.jCheckBox_MarkAll1.isSelected());

        boolean found = SearchEngine.find(this.textEditor.getTextArea(), context).wasFound();
        if (!found) {
            JOptionPane.showMessageDialog(this, "Text not found");
        } else {
            if (!this.findStrs.contains(text)) {
                this.findStrs.add(text);
                this.jComboBox_Find.addItem(text);
                this.jComboBox_Find1.addItem(text);
            }
        }
    }//GEN-LAST:event_jButton_Find1ActionPerformed

    private void jButton_ReplaceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ReplaceActionPerformed
        // TODO add your handling code here:
        SearchContext context = new SearchContext();
        String text = (String)this.jComboBox_Find1.getSelectedItem();
        if (text.length() == 0) {
            return;
        }
        String rText = (String)this.jComboBox_ReplaceWith.getSelectedItem();
        context.setSearchFor(text);
        context.setReplaceWith(rText);
        context.setMatchCase(this.jCheckBox_MatchCase1.isSelected());
        context.setRegularExpression(this.jCheckBox_Regular1.isSelected());
        context.setSearchForward(this.jRadioButton_Down1.isSelected());
        context.setWholeWord(this.jCheckBox_WholeWord1.isSelected());
        context.setMarkAll(this.jCheckBox_MarkAll1.isSelected());

        boolean found = SearchEngine.replace(this.textEditor.getTextArea(), context).wasFound();
        if (!found) {
            JOptionPane.showMessageDialog(this, "Text not found");
        } else {
            if (!this.findStrs.contains(text)) {
                this.findStrs.add(text);
                this.jComboBox_Find.addItem(text);
                this.jComboBox_Find1.addItem(text);
            }
            if (!this.replaceStrs.contains(rText)) {
                this.replaceStrs.add(rText);
                this.jComboBox_ReplaceWith.addItem(rText);
            }
        }
    }//GEN-LAST:event_jButton_ReplaceActionPerformed

    private void jButton_ReplaceAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ReplaceAllActionPerformed
        // TODO add your handling code here:
        SearchContext context = new SearchContext();
        String text = (String)this.jComboBox_Find1.getSelectedItem();
        if (text.length() == 0) {
            return;
        }
        String rText = (String)this.jComboBox_ReplaceWith.getSelectedItem();
        context.setSearchFor(text);
        context.setReplaceWith(rText);
        context.setMatchCase(this.jCheckBox_MatchCase1.isSelected());
        context.setRegularExpression(this.jCheckBox_Regular1.isSelected());
        context.setSearchForward(this.jRadioButton_Down1.isSelected());
        context.setWholeWord(this.jCheckBox_WholeWord1.isSelected());
        context.setMarkAll(this.jCheckBox_MarkAll1.isSelected());

        boolean found = SearchEngine.replaceAll(this.textEditor.getTextArea(), context).wasFound();
        if (!found) {
            JOptionPane.showMessageDialog(this, "Text not found");
        }
    }//GEN-LAST:event_jButton_ReplaceAllActionPerformed

    private void jButton_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_CancelActionPerformed
        // TODO add your handling code here:
        this.dispose();
    }//GEN-LAST:event_jButton_CancelActionPerformed

    private void jButton_Cancel1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_Cancel1ActionPerformed
        // TODO add your handling code here:
        this.dispose();
    }//GEN-LAST:event_jButton_Cancel1ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FrmFindReplace.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FrmFindReplace.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FrmFindReplace.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrmFindReplace.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                FrmFindReplace dialog = new FrmFindReplace(new javax.swing.JFrame(), true, null);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup_Direction;
    private javax.swing.ButtonGroup buttonGroup_Find;
    private javax.swing.JButton jButton_Cancel;
    private javax.swing.JButton jButton_Cancel1;
    private javax.swing.JButton jButton_Find;
    private javax.swing.JButton jButton_Find1;
    private javax.swing.JButton jButton_Replace;
    private javax.swing.JButton jButton_ReplaceAll;
    private javax.swing.JCheckBox jCheckBox_MarkAll;
    private javax.swing.JCheckBox jCheckBox_MarkAll1;
    private javax.swing.JCheckBox jCheckBox_MatchCase;
    private javax.swing.JCheckBox jCheckBox_MatchCase1;
    private javax.swing.JCheckBox jCheckBox_Regular;
    private javax.swing.JCheckBox jCheckBox_Regular1;
    private javax.swing.JCheckBox jCheckBox_WholeWord;
    private javax.swing.JCheckBox jCheckBox_WholeWord1;
    private javax.swing.JComboBox<String> jComboBox_Find;
    private javax.swing.JComboBox<String> jComboBox_Find1;
    private javax.swing.JComboBox<String> jComboBox_ReplaceWith;
    private javax.swing.JLabel jLabel_Find;
    private javax.swing.JLabel jLabel_Find1;
    private javax.swing.JLabel jLabel_ReplaceWith;
    private javax.swing.JPanel jPanel_Direction;
    private javax.swing.JPanel jPanel_Direction1;
    private javax.swing.JPanel jPanel_Find;
    private javax.swing.JPanel jPanel_Replace;
    private javax.swing.JRadioButton jRadioButton_Down;
    private javax.swing.JRadioButton jRadioButton_Down1;
    private javax.swing.JRadioButton jRadioButton_Up;
    private javax.swing.JRadioButton jRadioButton_Up1;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables
}
