/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.lab.gui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Font;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.console.NameCompletion;
import org.meteoinfo.console.editor.JTextAreaPrintStream;
import org.meteoinfo.console.editor.JTextAreaWriter;
import org.meteoinfo.console.editor.MITextEditorPane;
import org.meteoinfo.console.editor.TextEditor;
import org.meteoinfo.console.jython.JIntrospect;
import org.meteoinfo.lab.gui.EncodingUtil;
import org.meteoinfo.lab.gui.FrmMain;
import org.meteoinfo.ui.ButtonTabComponent;
import org.python.util.PythonInterpreter;

public class EditorDockable
extends DefaultSingleCDockable {
    private final FrmMain parent;
    private final JTabbedPane tabbedPanel;
    private Font textFont;
    private PythonInterpreter interp;
    private Theme theme;

    public EditorDockable(FrmMain parent, String id, String title, CAction ... actions) {
        super(id, title, actions);
        this.parent = parent;
        this.setTitleIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/editor.svg"));
        String lfName = this.parent.getOptions().getLookFeel();
        String themeName = "default";
        switch (lfName) {
            case "FlatDarculaLaf": 
            case "FlatDarkLaf": 
            case "FlatMacDarkLaf": {
                themeName = "dark";
            }
        }
        try {
            this.theme = Theme.load((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + themeName + ".xml"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.addChangeListener(e -> {
            JTabbedPane sourceTabbedPane = (JTabbedPane)e.getSource();
            TextEditor te = (TextEditor)sourceTabbedPane.getSelectedComponent();
            if (te != null) {
                this.setTitleText("Editor - " + te.getFileName());
            }
        });
        this.getContentPane().add(this.tabbedPanel);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPanel;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
        for (Component tab : this.tabbedPanel.getComponents()) {
            if (!(tab instanceof TextEditor)) continue;
            ((TextEditor)tab).setTextFont(this.textFont);
        }
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme value) {
        this.theme = value;
    }

    public void setInterp(PythonInterpreter value) {
        this.interp = value;
    }

    public final TextEditor addNewTextEditor(String title) {
        final TextEditor tab = new TextEditor(this.tabbedPanel, title);
        this.tabbedPanel.add((Component)tab, title);
        this.tabbedPanel.setSelectedComponent((Component)tab);
        final MITextEditorPane textArea = (MITextEditorPane)tab.getTextArea();
        textArea.setSyntaxEditingStyle("text/python");
        textArea.discardAllEdits();
        this.theme.apply((RSyntaxTextArea)textArea);
        tab.setTextFont(this.textFont);
        JPopupMenu popup = textArea.getPopupMenu();
        JMenuItem evaluate = new JMenuItem("Evaluate Selection");
        evaluate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditorDockable.this.runCodeLines(textArea);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        popup.insert(evaluate, 0);
        popup.insert(new JPopupMenu.Separator(), 1);
        JMenuItem comment = new JMenuItem("Comment or Uncomment");
        comment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditorDockable.this.comment(textArea);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        popup.insert(comment, 2);
        JMenuItem insertTab = new JMenuItem("Insert Tab");
        insertTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditorDockable.this.insertTab(textArea);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (AWTException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        popup.insert(insertTab, 3);
        JMenuItem delTab = new JMenuItem("Delete Tab");
        delTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditorDockable.this.delTab(textArea);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        popup.insert(delTab, 4);
        tab.getTextArea().setDirty(false);
        tab.setTitle(title);
        JIntrospect nameComplete = new JIntrospect(this.interp);
        textArea.setNameCompletion((NameCompletion)nameComplete);
        ButtonTabComponent btc = new ButtonTabComponent(this.tabbedPanel);
        ButtonTabComponent.TabButton button = btc.getTabButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorDockable.this.closeFile(tab);
            }
        });
        this.tabbedPanel.setTabComponentAt(this.tabbedPanel.indexOfComponent((Component)tab), (Component)btc);
        return tab;
    }

    public TextEditor getActiveTextEditor() {
        if (this.tabbedPanel.getTabCount() == 0) {
            return null;
        }
        return (TextEditor)this.tabbedPanel.getSelectedComponent();
    }

    public List<TextEditor> getAllTextEditor() {
        ArrayList<TextEditor> tes = new ArrayList<TextEditor>();
        for (int i = 0; i < this.tabbedPanel.getComponentCount(); ++i) {
            Component comp = this.tabbedPanel.getComponent(i);
            if (!(comp instanceof TextEditor)) continue;
            tes.add((TextEditor)comp);
        }
        return tes;
    }

    public void setActiveTextEditor(TextEditor te) {
        this.tabbedPanel.setSelectedComponent((Component)te);
        this.setTitleText("Editor - " + te.getFileName());
    }

    private TextEditorPane getActiveTextArea() {
        TextEditor textEditor = this.getActiveTextEditor();
        if (textEditor != null) {
            return textEditor.getTextArea();
        }
        return null;
    }

    public void closeFile() {
        this.closeFile(this.getActiveTextEditor());
    }

    private void closeFile(TextEditor textEditor) {
        if (textEditor != null) {
            boolean ifClose = true;
            if (textEditor.getTextArea().isDirty()) {
                int result;
                String fName = textEditor.getFileName();
                if (fName.isEmpty()) {
                    fName = "New file";
                }
                if ((result = JOptionPane.showConfirmDialog(null, MessageFormat.format("Save changes to \"{0}\"", fName), "Save?", 1)) == 0) {
                    if (!this.doSave(textEditor)) {
                        ifClose = false;
                    }
                } else if (result == 2) {
                    ifClose = false;
                }
            }
            if (ifClose) {
                this.removeTextEditor(textEditor);
            }
        }
    }

    public void closeAllFiles() {
        while (this.tabbedPanel.getTabCount() > 0) {
            this.closeFile();
        }
    }

    public boolean doSave(TextEditor editor) {
        if (editor.getFileName().isEmpty()) {
            return this.doSaveAs_Jython(editor);
        }
        editor.saveFile(editor.getFile());
        return true;
    }

    public boolean doSaveAs_Jython(TextEditor editor) {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"py"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Python File (*.py)");
        aDlg.setFileFilter((FileFilter)mapFileFilter);
        if (editor.getFile() != null) {
            aDlg.setSelectedFile(editor.getFile());
        } else {
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
        }
        if (aDlg.showSaveDialog(this.parent) == 0) {
            int overwrite;
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            if ((file = new File(fileName)).exists() && (overwrite = JOptionPane.showConfirmDialog(null, "File exists! Overwrite it?", "Confirm", 0)) == 1) {
                return false;
            }
            editor.saveFile(file);
            this.setTitleText(editor.getFileName());
            return true;
        }
        return false;
    }

    private void removeTextEditor(TextEditor editor) {
        this.tabbedPanel.remove((Component)editor);
    }

    public void doOpen_Jython() {
        JFileChooser aDlg = new JFileChooser();
        aDlg.setMultiSelectionEnabled(true);
        aDlg.setAcceptAllFileFilterUsed(false);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        String[] fileExts = new String[]{"py"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Jython File (*.py)");
        aDlg.setFileFilter((FileFilter)mapFileFilter);
        if (0 == aDlg.showOpenDialog(this.parent)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            this.openFiles(files);
        }
    }

    public void openFiles(List<String> fileNames) {
        ArrayList<File> files = new ArrayList<File>();
        for (String fn : fileNames) {
            File file = new File(fn);
            if (!file.exists()) continue;
            files.add(file);
        }
        if (files.size() > 0) {
            File[] fs = new File[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                fs[i] = (File)files.get(i);
            }
            this.openFiles(fs);
        }
    }

    public void openFiles(File[] files) {
        TextEditor textEditor;
        if (this.tabbedPanel.getTabCount() == 1 && (textEditor = this.getActiveTextEditor()).getTextArea().getDocument().getLength() == 0 && textEditor.getFileName().isEmpty()) {
            this.removeTextEditor(textEditor);
        }
        for (File file : files) {
            boolean isExist = false;
            for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
                TextEditor te = (TextEditor)this.tabbedPanel.getComponentAt(i);
                if (!file.getAbsolutePath().equals(te.getFileName())) continue;
                isExist = true;
                this.setActiveTextEditor(te);
                break;
            }
            if (isExist) continue;
            TextEditor editor = this.addNewTextEditor(file.getName());
            editor.openFile(file);
            this.setTitleText(editor.getFileName());
        }
    }

    public void openFile(File file) {
        TextEditor textEditor;
        if (this.tabbedPanel.getTabCount() == 1 && (textEditor = this.getActiveTextEditor()).getTextArea().getDocument().getLength() == 0 && textEditor.getFileName().isEmpty()) {
            this.removeTextEditor(textEditor);
        }
        boolean isExist = false;
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            TextEditor te = (TextEditor)this.tabbedPanel.getComponentAt(i);
            if (!file.getAbsolutePath().equals(te.getFileName())) continue;
            isExist = true;
            this.setActiveTextEditor(te);
            break;
        }
        if (!isExist) {
            TextEditor editor = this.addNewTextEditor(file.getName());
            editor.openFile(file);
            this.parent.getOptions().addRecentFile(file.getAbsolutePath());
            this.setTitleText(editor.getFileName());
        }
    }

    public List<String> getOpenedFiles() {
        ArrayList<String> fns = new ArrayList<String>();
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            TextEditor te = (TextEditor)this.tabbedPanel.getComponentAt(i);
            fns.add(te.getFileName());
        }
        return fns;
    }

    private void runCodeLines(MITextEditorPane textArea) throws InterruptedException, BadLocationException {
        int sLine = textArea.getLineOfOffset(textArea.getSelectionStart());
        int sIdx = textArea.getLineStartOffset(sLine);
        int eLine = textArea.getLineOfOffset(textArea.getSelectionEnd());
        int eIdx = textArea.getLineEndOffset(eLine);
        textArea.setSelectionStart(sIdx);
        textArea.setSelectionEnd(eIdx);
        String code = textArea.getSelectedText();
        this.parent.getConsoleDockable().run(code);
    }

    public void Comment() {
        try {
            this.comment((MITextEditorPane)this.getActiveTextArea());
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void comment(MITextEditorPane textArea) throws InterruptedException, BadLocationException {
        int sLine = textArea.getLineOfOffset(textArea.getSelectionStart());
        int sIdx = textArea.getLineStartOffset(sLine);
        int eLine = textArea.getLineOfOffset(textArea.getSelectionEnd());
        int eIdx = textArea.getLineEndOffset(eLine);
        textArea.setSelectionStart(sIdx);
        textArea.setSelectionEnd(eIdx);
        String text = textArea.getSelectedText();
        String[] lines = text.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            String nLine = line.trim();
            if (nLine.startsWith("#")) {
                sb.append(line.replaceFirst("#", ""));
            } else {
                sb.append("#" + line);
            }
            sb.append("\n");
        }
        text = sb.toString();
        textArea.replaceSelection(text);
    }

    public void delTab() {
        try {
            this.delTab((MITextEditorPane)this.getActiveTextArea());
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void delTab(MITextEditorPane textArea) throws InterruptedException, BadLocationException {
        int sLine = textArea.getLineOfOffset(textArea.getSelectionStart());
        int sIdx = textArea.getLineStartOffset(sLine);
        int eLine = textArea.getLineOfOffset(textArea.getSelectionEnd());
        int eIdx = textArea.getLineEndOffset(eLine);
        textArea.setSelectionStart(sIdx);
        textArea.setSelectionEnd(eIdx);
        String text = textArea.getSelectedText();
        String[] lines = text.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith("    ")) {
                sb.append(line.substring(4));
            } else if (line.startsWith("   ")) {
                sb.append(line.substring(3));
            } else if (line.startsWith("  ")) {
                sb.append(line.substring(2));
            } else if (line.startsWith(" ")) {
                sb.append(line.substring(1));
            } else {
                sb.append(line);
            }
            sb.append("\n");
        }
        text = sb.toString();
        textArea.replaceSelection(text);
    }

    public void insertTab() {
        try {
            this.insertTab((MITextEditorPane)this.getActiveTextArea());
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (AWTException ex) {
            Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void insertTab(MITextEditorPane textArea) throws InterruptedException, AWTException {
        Robot robot = new Robot();
        robot.keyPress(9);
    }

    public void runPythonScript(final JTextArea jTextArea_Output) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){
            PrintStream oout = System.out;
            PrintStream oerr = System.err;

            @Override
            protected String doInBackground() throws Exception {
                JTextAreaWriter writer = new JTextAreaWriter(jTextArea_Output);
                JTextAreaPrintStream printStream = new JTextAreaPrintStream((OutputStream)System.out, jTextArea_Output);
                jTextArea_Output.setText("");
                PythonInterpreter interp = new PythonInterpreter();
                interp.setOut((Writer)writer);
                interp.setErr((Writer)writer);
                System.setOut((PrintStream)printStream);
                System.setErr((PrintStream)printStream);
                try {
                    interp.exec("import sys");
                    interp.set("milapp", (Object)EditorDockable.this.parent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TextEditorPane textArea = EditorDockable.this.getActiveTextArea();
                String code = textArea.getText();
                String encoding = EncodingUtil.findEncoding(code);
                if (encoding != null) {
                    try {
                        interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes(encoding)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return "";
            }

            @Override
            protected void done() {
                System.setOut(this.oout);
                System.setErr(this.oerr);
            }
        };
        worker.execute();
    }
}

