/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.extras.FlatSVGUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.GridDataSetting;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.DrawType2D;
import org.meteoinfo.data.meteodata.ITrajDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.MeteoUVSet;
import org.meteoinfo.data.meteodata.PlotDimension;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.grads.GrADSDataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS7DataInfo;
import org.meteoinfo.data.meteodata.netcdf.NetCDFDataInfo;
import org.meteoinfo.geo.analysis.InterpolationMethods;
import org.meteoinfo.geo.analysis.InterpolationSetting;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.RasterLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.FrmLegendSet;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geo.meteodata.DrawMeteoData;
import org.meteoinfo.geo.util.GeoMathUtil;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.StreamlineBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.image.AnimatedGifEncoder;
import org.meteoinfo.map.config.GenericFileFilter;
import org.meteoinfo.map.forms.FrmDataInfo;
import org.meteoinfo.map.forms.FrmInterpolate;
import org.meteoinfo.map.forms.FrmMain;
import org.meteoinfo.map.forms.FrmOneDim;
import org.meteoinfo.map.forms.FrmOpenData;
import org.meteoinfo.map.forms.FrmSectionPlot;
import org.meteoinfo.map.forms.FrmUVSet;
import org.meteoinfo.map.forms.FrmViewData;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.ui.JSplitButton;

public class FrmMeteoData
extends JDialog {
    private final FrmMain _parent;
    private final List<MeteoDataInfo> _dataInfoList;
    private MeteoDataInfo _meteoDataInfo = new MeteoDataInfo();
    private MeteoUVSet meteoUVSet = new MeteoUVSet();
    private GridData _gridData;
    private StationData _stationData = new StationData();
    boolean _useSameLegendScheme = false;
    boolean _useSameGridInterSet = false;
    private LegendScheme _legendScheme = null;
    double[] _cValues;
    Color[] _cColors;
    int _lastAddedLayerHandle = -1;
    private int _selectedIndex = -1;
    private int _strmDensity = 4;
    private int _skipY = 1;
    private int _skipX = 1;
    private boolean _hasUndefData;
    private boolean _isLoading = false;
    private InterpolationSetting _interpolationSetting = new InterpolationSetting();
    private boolean _enableAnimation = true;
    private boolean _isRunning = false;
    private boolean windColor = false;
    private boolean smooth = true;
    private String weatherString = "All Weather";
    private JButton jButton_1DPlot;
    private JButton jButton_Animator;
    private JButton jButton_ClearDraw;
    private JButton jButton_CreateAnimatorFile;
    private JButton jButton_DataInfo;
    private JButton jButton_Draw;
    private JButton jButton_DrawSetting;
    private JButton jButton_NexTime;
    private JSplitButton jSplitButton_OpenData;
    private JPopupMenu jPopupMenu_OpenData;
    private JMenuBar jMenuBar_Main;
    private JMenu jMenu_OpenData;
    private JMenuItem jMenuItem_NetCDF;
    private JMenuItem jMenuItem_GrADS;
    private JMenuItem jMenuItem_ARL;
    private JMenu jMenu_HYSPLIT;
    private JMenuItem jMenuItem_HYSPLIT_Traj;
    private JMenuItem jMenuItem_HYSPLIT_Conc;
    private JMenuItem jMenuItem_HYSPLIT_Particle;
    private JMenu jMenu_ASCII;
    private JMenuItem jMenuItem_ASCII_LonLat;
    private JMenuItem jMenuItem_ASCII_SYNOP;
    private JMenuItem jMenuItem_ASCII_METAR;
    private JMenuItem jMenuItem_ASCII_EsriGrid;
    private JMenuItem jMenuItem_ASCII_SurferGrid;
    private JMenuItem jMenuItem_MICAPS;
    private JMenu jMenu_MM5;
    private JMenuItem jMenuItem_MM5_Output;
    private JMenuItem jMenuItem_MM5_Inter;
    private JMenuItem jMenuItem_AWX;
    private JButton jButton_PreTime;
    private JButton jButton_RemoveAllData;
    private JButton jButton_SectionPlot;
    private JButton jButton_Setting;
    private JButton jButton_ViewData;
    private JCheckBox jCheckBox_Big_Endian;
    private JCheckBox jCheckBox_ColorVar;
    private JComboBox jComboBox_DrawType;
    private JComboBox jComboBox_Level;
    private JComboBox jComboBox_Time;
    private JComboBox jComboBox_Variable;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel_Variable;
    private JList jList_DataFiles;
    private JPanel jPanel1;
    private JPanel jPanel_DataSet;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JSplitButton jSplitButton_Stat;
    private JPopupMenu jPopupMenu_Stat;
    private JMenuItem jMenuItem_ArrivalTime;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;

    public FrmMeteoData(Frame parent, boolean modal) {
        super(parent, modal);
        this._parent = (FrmMain)parent;
        this.setIconImages(FlatSVGUtils.createWindowIconImages((String)"/org/meteoinfo/map/icons/meteo-data.svg"));
        this.initComponents();
        this._dataInfoList = new ArrayList<MeteoDataInfo>();
        int height = this.jToolBar1.getHeight() + this.jComboBox_DrawType.getY() + this.jComboBox_DrawType.getHeight() + 90;
        this.setSize(500, height);
        this.jComboBox_Variable.setEditable(true);
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Meteo Data");
        this.jList_DataFiles.setModel(new DefaultListModel());
        this.jComboBox_Variable.removeAllItems();
        this.jComboBox_Time.removeAllItems();
        this.jComboBox_Level.removeAllItems();
        this.jComboBox_DrawType.removeAllItems();
        for (Component aItem : this.jToolBar1.getComponents()) {
            aItem.setEnabled(false);
        }
        this.jSplitButton_OpenData.setEnabled(true);
        this.jPanel_DataSet.setEnabled(false);
        this.jCheckBox_ColorVar.setVisible(false);
        this.jCheckBox_Big_Endian.setVisible(false);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel_DataSet = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBox_Time = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBox_Level = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jComboBox_DrawType = new JComboBox();
        this.jCheckBox_ColorVar = new JCheckBox();
        this.jLabel_Variable = new JLabel();
        this.jComboBox_Variable = new JComboBox();
        this.jCheckBox_Big_Endian = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jButton_RemoveAllData = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList_DataFiles = new JList();
        this.jToolBar1 = new JToolBar();
        this.jSplitButton_OpenData = new JSplitButton();
        this.jMenuBar_Main = new JMenuBar();
        this.jMenu_OpenData = new JMenu();
        this.jPopupMenu_OpenData = new JPopupMenu();
        this.jMenuItem_NetCDF = new JMenuItem();
        this.jMenuItem_GrADS = new JMenuItem();
        this.jMenuItem_ARL = new JMenuItem();
        this.jMenu_HYSPLIT = new JMenu();
        this.jMenuItem_HYSPLIT_Traj = new JMenuItem();
        this.jMenuItem_HYSPLIT_Conc = new JMenuItem();
        this.jMenuItem_HYSPLIT_Particle = new JMenuItem();
        this.jMenu_ASCII = new JMenu();
        this.jMenuItem_ASCII_LonLat = new JMenuItem();
        this.jMenuItem_ASCII_SYNOP = new JMenuItem();
        this.jMenuItem_ASCII_METAR = new JMenuItem();
        this.jMenuItem_ASCII_EsriGrid = new JMenuItem();
        this.jMenuItem_ASCII_SurferGrid = new JMenuItem();
        this.jMenuItem_MICAPS = new JMenuItem();
        this.jMenu_MM5 = new JMenu();
        this.jMenuItem_MM5_Output = new JMenuItem();
        this.jMenuItem_MM5_Inter = new JMenuItem();
        this.jMenuItem_AWX = new JMenuItem();
        this.jButton_DataInfo = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_Draw = new JButton();
        this.jButton_ViewData = new JButton();
        this.jButton_ClearDraw = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_PreTime = new JButton();
        this.jButton_NexTime = new JButton();
        this.jButton_Animator = new JButton();
        this.jButton_CreateAnimatorFile = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_DrawSetting = new JButton();
        this.jButton_Setting = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButton_SectionPlot = new JButton();
        this.jButton_1DPlot = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.jSplitButton_Stat = new JSplitButton();
        this.jPopupMenu_Stat = new JPopupMenu();
        this.jMenuItem_ArrivalTime = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setDividerSize(4);
        this.jPanel_DataSet.setBorder(BorderFactory.createEtchedBorder());
        ResourceBundle bundle = ResourceBundle.getBundle("bundle/Bundle_FrmMeteoData");
        this.jLabel2.setText(bundle.getString("FrmMeteoData.jLabel2.text"));
        this.jComboBox_Time.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Time.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jComboBox_TimeActionPerformed(evt);
            }
        });
        this.jLabel3.setText(bundle.getString("FrmMeteoData.jLabel3.text"));
        this.jComboBox_Level.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Level.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jComboBox_LevelActionPerformed(evt);
            }
        });
        this.jLabel4.setText(bundle.getString("FrmMeteoData.jLabel4.text"));
        this.jComboBox_DrawType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DrawType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jComboBox_DrawTypeActionPerformed(evt);
            }
        });
        this.jCheckBox_ColorVar.setText(bundle.getString("FrmMeteoData.jCheckBox_ColorVar.text"));
        this.jCheckBox_ColorVar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jCheckBox_ColorVarActionPerformed(evt);
            }
        });
        this.jLabel_Variable.setText(bundle.getString("FrmMeteoData.jLabel_Variable.text"));
        this.jComboBox_Variable.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Variable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jComboBox_VariableActionPerformed(evt);
            }
        });
        this.jCheckBox_Big_Endian.setText(bundle.getString("FrmMeteoData.jCheckBox_Big_Endian.text"));
        this.jCheckBox_Big_Endian.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jCheckBox_Big_EndianActionPerformed(evt);
            }
        });
        GroupLayout jPanel_DataSetLayout = new GroupLayout(this.jPanel_DataSet);
        this.jPanel_DataSet.setLayout(jPanel_DataSetLayout);
        jPanel_DataSetLayout.setHorizontalGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DataSetLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_Variable).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Level, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Time, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_DrawType, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Variable, 0, -1, Short.MAX_VALUE).addGroup(jPanel_DataSetLayout.createSequentialGroup().addComponent(this.jCheckBox_ColorVar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBox_Big_Endian))).addContainerGap()));
        jPanel_DataSetLayout.setVerticalGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DataSetLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Variable).addComponent(this.jComboBox_Variable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox_Time, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox_Level, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBox_DrawType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addGroup(jPanel_DataSetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_ColorVar).addComponent(this.jCheckBox_Big_Endian)).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel_DataSet);
        this.jButton_RemoveAllData.setText(bundle.getString("FrmMeteoData.jButton_RemoveAllData.text"));
        this.jButton_RemoveAllData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_RemoveAllDataActionPerformed(evt);
            }
        });
        this.jList_DataFiles.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_DataFiles.setSelectionMode(0);
        this.jList_DataFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmMeteoData.this.jList_DataFilesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList_DataFiles);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.jButton_RemoveAllData).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_RemoveAllData).addGap(10, 10, 10)));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jToolBar1.setRollover(true);
        this.jSplitButton_OpenData.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jSplitButton_OpenData.setText("  ");
        this.jSplitButton_OpenData.setToolTipText(bundle.getString("FrmMeteoData.jButton_OpenData.toolTipText"));
        this.jSplitButton_OpenData.setFocusable(false);
        this.jSplitButton_OpenData.setArrowColor(ColorUtil.parseToColor((String)"#6E6E6E"));
        this.jMenuItem_NetCDF.setText("NetCDF, GRIB, HDF...");
        this.jMenuItem_NetCDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onNetCDFDataClick(e);
            }
        });
        this.jPopupMenu_OpenData.add(this.jMenuItem_NetCDF);
        this.jMenuItem_GrADS.setText("GrADS Data");
        this.jMenuItem_GrADS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onGrADSDataClick(e);
            }
        });
        this.jPopupMenu_OpenData.add(this.jMenuItem_GrADS);
        this.jMenuItem_ARL.setText("ARL Data");
        this.jMenuItem_ARL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onARLDataClick(e);
            }
        });
        this.jPopupMenu_OpenData.add(this.jMenuItem_ARL);
        this.jMenu_HYSPLIT.setText("HYSPLIT Data");
        this.jMenuItem_HYSPLIT_Traj.setText("Trajectory Data");
        this.jMenuItem_HYSPLIT_Traj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onHYSPLITTrajDataClick(e);
            }
        });
        this.jMenu_HYSPLIT.add(this.jMenuItem_HYSPLIT_Traj);
        this.jMenuItem_HYSPLIT_Conc.setText("Concentration Data");
        this.jMenuItem_HYSPLIT_Conc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onHYSPLITConcDataClick(e);
            }
        });
        this.jMenu_HYSPLIT.add(this.jMenuItem_HYSPLIT_Conc);
        this.jMenuItem_HYSPLIT_Particle.setText("Particle Data");
        this.jMenuItem_HYSPLIT_Particle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onHYSPLITPartDataClick(e);
            }
        });
        this.jMenu_HYSPLIT.add(this.jMenuItem_HYSPLIT_Particle);
        this.jPopupMenu_OpenData.add(this.jMenu_HYSPLIT);
        this.jMenu_ASCII.setText("ASCII Data");
        this.jMenuItem_ASCII_LonLat.setText("Lon/Lat Station Data");
        this.jMenuItem_ASCII_LonLat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onLonLatStationsClick(e);
            }
        });
        this.jMenu_ASCII.add(this.jMenuItem_ASCII_LonLat);
        this.jMenuItem_ASCII_SYNOP.setText("SYNOP Data");
        this.jMenuItem_ASCII_SYNOP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onSYNOPClick(e);
            }
        });
        this.jMenu_ASCII.add(this.jMenuItem_ASCII_SYNOP);
        this.jMenuItem_ASCII_METAR.setText("METAR Data");
        this.jMenuItem_ASCII_METAR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onMETARClick(e);
            }
        });
        this.jMenu_ASCII.add(this.jMenuItem_ASCII_METAR);
        this.jMenu_ASCII.add(new JSeparator());
        this.jMenuItem_ASCII_EsriGrid.setText("Esri ASCII Grid Data");
        this.jMenuItem_ASCII_EsriGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onASCIIGridDataClick(e);
            }
        });
        this.jMenu_ASCII.add(this.jMenuItem_ASCII_EsriGrid);
        this.jMenuItem_ASCII_SurferGrid.setText("Surfer ASCII Grid Data");
        this.jMenuItem_ASCII_SurferGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onSurferGridDataClick(e);
            }
        });
        this.jMenu_ASCII.add(this.jMenuItem_ASCII_SurferGrid);
        this.jPopupMenu_OpenData.add(this.jMenu_ASCII);
        this.jMenuItem_MICAPS.setText("MICAPS Data");
        this.jMenuItem_MICAPS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onMICAPSDataClick(e);
            }
        });
        this.jPopupMenu_OpenData.add(this.jMenuItem_MICAPS);
        this.jMenu_MM5.setText("MM5 Data");
        this.jMenuItem_MM5_Output.setText("MM5 Output Data");
        this.jMenuItem_MM5_Output.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onMM5DataClick(e);
            }
        });
        this.jMenu_MM5.add(this.jMenuItem_MM5_Output);
        this.jMenuItem_MM5_Inter.setText("MM5 Intermediate Data");
        this.jMenuItem_MM5_Inter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onMM5IMDataClick(e);
            }
        });
        this.jMenu_MM5.add(this.jMenuItem_MM5_Inter);
        this.jPopupMenu_OpenData.add(this.jMenu_MM5);
        this.jMenuItem_AWX.setText("AWX Data");
        this.jMenuItem_AWX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onAWXDataClick(e);
            }
        });
        this.jPopupMenu_OpenData.add(this.jMenuItem_AWX);
        this.jSplitButton_OpenData.setPopupMenu(this.jPopupMenu_OpenData);
        this.jToolBar1.add((Component)this.jSplitButton_OpenData);
        this.jButton_DataInfo.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/information.svg"));
        this.jButton_DataInfo.setToolTipText(bundle.getString("FrmMeteoData.jButton_DataInfo.toolTipText"));
        this.jButton_DataInfo.setFocusable(false);
        this.jButton_DataInfo.setHorizontalTextPosition(0);
        this.jButton_DataInfo.setVerticalTextPosition(3);
        this.jButton_DataInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_DataInfoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_DataInfo);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_Draw.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/draw-layer.svg"));
        this.jButton_Draw.setToolTipText(bundle.getString("FrmMeteoData.jButton_Draw.toolTipText"));
        this.jButton_Draw.setFocusable(false);
        this.jButton_Draw.setHorizontalTextPosition(0);
        this.jButton_Draw.setVerticalTextPosition(3);
        this.jButton_Draw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_DrawActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Draw);
        this.jButton_ViewData.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/table.svg"));
        this.jButton_ViewData.setToolTipText(bundle.getString("FrmMeteoData.jButton_ViewData.toolTipText"));
        this.jButton_ViewData.setFocusable(false);
        this.jButton_ViewData.setHorizontalTextPosition(0);
        this.jButton_ViewData.setVerticalTextPosition(3);
        this.jButton_ViewData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_ViewDataActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ViewData);
        this.jButton_ClearDraw.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/delete.svg"));
        this.jButton_ClearDraw.setToolTipText(bundle.getString("FrmMeteoData.jButton_ClearDraw.toolTipText"));
        this.jButton_ClearDraw.setFocusable(false);
        this.jButton_ClearDraw.setHorizontalTextPosition(0);
        this.jButton_ClearDraw.setVerticalTextPosition(3);
        this.jButton_ClearDraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_ClearDrawActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ClearDraw);
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_PreTime.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/left-arrow.svg"));
        this.jButton_PreTime.setToolTipText(bundle.getString("FrmMeteoData.jButton_PreTime.toolTipText"));
        this.jButton_PreTime.setFocusable(false);
        this.jButton_PreTime.setHorizontalTextPosition(0);
        this.jButton_PreTime.setVerticalTextPosition(3);
        this.jButton_PreTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_PreTimeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_PreTime);
        this.jButton_NexTime.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/right-arrow.svg"));
        this.jButton_NexTime.setToolTipText(bundle.getString("FrmMeteoData.jButton_NexTime.toolTipText"));
        this.jButton_NexTime.setFocusable(false);
        this.jButton_NexTime.setHorizontalTextPosition(0);
        this.jButton_NexTime.setVerticalTextPosition(3);
        this.jButton_NexTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_NexTimeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_NexTime);
        this.jButton_Animator.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/animator.svg"));
        this.jButton_Animator.setToolTipText(bundle.getString("FrmMeteoData.jButton_Animator.toolTipText"));
        this.jButton_Animator.setFocusable(false);
        this.jButton_Animator.setHorizontalTextPosition(0);
        this.jButton_Animator.setVerticalTextPosition(3);
        this.jButton_Animator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_AnimatorActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Animator);
        this.jButton_CreateAnimatorFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/animator-file.svg"));
        this.jButton_CreateAnimatorFile.setToolTipText(bundle.getString("FrmMeteoData.jButton_CreateAnimatorFile.toolTipText"));
        this.jButton_CreateAnimatorFile.setFocusable(false);
        this.jButton_CreateAnimatorFile.setHorizontalTextPosition(0);
        this.jButton_CreateAnimatorFile.setVerticalTextPosition(3);
        this.jButton_CreateAnimatorFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_CreateAnimatorFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_CreateAnimatorFile);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton_DrawSetting.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/legend-setting.svg"));
        this.jButton_DrawSetting.setToolTipText(bundle.getString("FrmMeteoData.jButton_DrawSetting.toolTipText"));
        this.jButton_DrawSetting.setFocusable(false);
        this.jButton_DrawSetting.setHorizontalTextPosition(0);
        this.jButton_DrawSetting.setVerticalTextPosition(3);
        this.jButton_DrawSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_DrawSettingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_DrawSetting);
        this.jButton_Setting.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/tools.svg"));
        this.jButton_Setting.setToolTipText(bundle.getString("FrmMeteoData.jButton_Setting.toolTipText"));
        this.jButton_Setting.setFocusable(false);
        this.jButton_Setting.setHorizontalTextPosition(0);
        this.jButton_Setting.setVerticalTextPosition(3);
        this.jButton_Setting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_SettingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Setting);
        this.jToolBar1.add(this.jSeparator4);
        this.jButton_SectionPlot.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/section-chart.svg"));
        this.jButton_SectionPlot.setToolTipText(bundle.getString("FrmMeteoData.jButton_SectionPlot.toolTipText"));
        this.jButton_SectionPlot.setFocusable(false);
        this.jButton_SectionPlot.setHorizontalTextPosition(0);
        this.jButton_SectionPlot.setVerticalTextPosition(3);
        this.jButton_SectionPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_SectionPlotActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SectionPlot);
        this.jButton_1DPlot.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/chart-line-bar.svg"));
        this.jButton_1DPlot.setToolTipText(bundle.getString("FrmMeteoData.jButton_1DPlot.toolTipText"));
        this.jButton_1DPlot.setFocusable(false);
        this.jButton_1DPlot.setHorizontalTextPosition(0);
        this.jButton_1DPlot.setVerticalTextPosition(3);
        this.jButton_1DPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeteoData.this.jButton_1DPlotActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_1DPlot);
        this.getContentPane().add((Component)this.jToolBar1, "First");
        this.pack();
    }

    private void jButton_OpenDataMouseClicked(MouseEvent evt) {
        JPopupMenu menu_OpenData = new JPopupMenu();
        JMenuItem dataMI = new JMenuItem("NetCDF, GRIB, HDF...");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onNetCDFDataClick(e);
            }
        });
        menu_OpenData.add(dataMI);
        dataMI = new JMenuItem("GrADS Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onGrADSDataClick(e);
            }
        });
        menu_OpenData.add(dataMI);
        JMenuItem arlDataMI = new JMenuItem("ARL Data");
        arlDataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onARLDataClick(e);
            }
        });
        menu_OpenData.add(arlDataMI);
        JMenu hysplitM = new JMenu("HYSPLIT Data");
        menu_OpenData.add(hysplitM);
        dataMI = new JMenuItem("Trajectory Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onHYSPLITTrajDataClick(e);
            }
        });
        hysplitM.add(dataMI);
        dataMI = new JMenuItem("Concentration Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onHYSPLITConcDataClick(e);
            }
        });
        hysplitM.add(dataMI);
        dataMI = new JMenuItem("Particle Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onHYSPLITPartDataClick(e);
            }
        });
        hysplitM.add(dataMI);
        JMenu asciiM = new JMenu("ASCII Data");
        menu_OpenData.add(asciiM);
        dataMI = new JMenuItem("Lon/Lat Station Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onLonLatStationsClick(e);
            }
        });
        asciiM.add(dataMI);
        dataMI = new JMenuItem("SYNOP Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onSYNOPClick(e);
            }
        });
        asciiM.add(dataMI);
        asciiM.add(new JSeparator());
        dataMI = new JMenuItem("ASCII Grid Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onASCIIGridDataClick(e);
            }
        });
        asciiM.add(dataMI);
        dataMI = new JMenuItem("Surfer ASCII Grid Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onSurferGridDataClick(e);
            }
        });
        asciiM.add(dataMI);
        dataMI = new JMenuItem("MICAPS Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onMICAPSDataClick(e);
            }
        });
        menu_OpenData.add(dataMI);
        JMenu mm5M = new JMenu("MM5 Data");
        menu_OpenData.add(mm5M);
        dataMI = new JMenuItem("MM5 Output Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onMM5DataClick(e);
            }
        });
        mm5M.add(dataMI);
        dataMI = new JMenuItem("MM5 Intermediate Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onMM5IMDataClick(e);
            }
        });
        mm5M.add(dataMI);
        dataMI = new JMenuItem("AWX Data");
        dataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMeteoData.this.onAWXDataClick(e);
            }
        });
        menu_OpenData.add(dataMI);
        menu_OpenData.show(this, evt.getX(), evt.getY());
    }

    private void jList_DataFilesMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            if (this.jList_DataFiles.getSelectedIndex() < 0 || this.jList_DataFiles.getSelectedIndex() == this._selectedIndex) {
                return;
            }
            this._meteoDataInfo = this._dataInfoList.get(this.jList_DataFiles.getSelectedIndex());
            this.updateParameters();
            this._selectedIndex = this.jList_DataFiles.getSelectedIndex();
        } else if (evt.getButton() == 3) {
            JPopupMenu mnuLayer = new JPopupMenu();
            JMenuItem removeLayerMI = new JMenuItem("Remove Data File");
            removeLayerMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrmMeteoData.this.onRemoveDataClick(e);
                }
            });
            mnuLayer.add(removeLayerMI);
            mnuLayer.show(this.jList_DataFiles, evt.getX(), evt.getY());
        }
    }

    private void jComboBox_VariableActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        if (this.jComboBox_Variable.getItemCount() > 0) {
            int i;
            DataInfo aDataInfo = this._meteoDataInfo.getDataInfo();
            Variable var = aDataInfo.getVariable(this.jComboBox_Variable.getSelectedItem().toString());
            if (var == null) {
                return;
            }
            if (var.getTDimension() != null) {
                DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                List times = var.getTimes();
                DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
                for (i = 0; i < times.size(); ++i) {
                    comboBoxModel.addElement(sdf.format((TemporalAccessor)times.get(i)));
                }
                this.jComboBox_Time.setModel(comboBoxModel);
                if (this.jComboBox_Time.getItemCount() > this._meteoDataInfo.getTimeIndex()) {
                    this.jComboBox_Time.setSelectedIndex(this._meteoDataInfo.getTimeIndex());
                }
            }
            if (var.getZDimension() == null) {
                this.jComboBox_Level.removeAllItems();
                if (this._meteoDataInfo.isSWATHData()) {
                    Variable lonvar = this._meteoDataInfo.getDataInfo().getVariable("longitude");
                    org.meteoinfo.ndarray.Dimension ldim = var.getLevelDimension(lonvar);
                    if (ldim == null) {
                        this.jComboBox_Level.addItem("Surface");
                        this.jComboBox_Level.setSelectedIndex(0);
                    } else {
                        for (i = 0; i < ldim.getLength(); ++i) {
                            this.jComboBox_Level.addItem(String.valueOf(ldim.getDimValue().get(i)));
                        }
                        if (this.jComboBox_Level.getItemCount() > this._meteoDataInfo.getLevelIndex()) {
                            this.jComboBox_Level.setSelectedIndex(this._meteoDataInfo.getLevelIndex());
                        }
                    }
                } else {
                    this.jComboBox_Level.addItem("Surface");
                    this.jComboBox_Level.setSelectedIndex(0);
                }
            } else {
                DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
                for (i = 0; i < var.getZDimension().getLength(); ++i) {
                    comboBoxModel.addElement(String.valueOf(var.getZDimension().getDimValue().get(i)));
                }
                this.jComboBox_Level.setModel(comboBoxModel);
                if (this.jComboBox_Level.getItemCount() > this._meteoDataInfo.getLevelIndex()) {
                    this.jComboBox_Level.setSelectedIndex(this._meteoDataInfo.getLevelIndex());
                }
            }
        }
    }

    private void jButton_OpenDataActionPerformed(ActionEvent evt) {
        FrmOpenData frm = new FrmOpenData(this, false);
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
    }

    private void jButton_DataInfoActionPerformed(ActionEvent evt) {
        FrmDataInfo frmDI = new FrmDataInfo();
        frmDI.setLocationRelativeTo(this);
        frmDI.setText(this._meteoDataInfo.getInfoText());
        frmDI.setVisible(true);
    }

    private void jButton_DrawActionPerformed(ActionEvent evt) {
        this.display();
    }

    private void jComboBox_DrawTypeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_DrawType.getItemCount() > 0) {
            this._meteoDataInfo.setDrawType2D((DrawType2D)this.jComboBox_DrawType.getSelectedItem());
            this.jButton_Draw.setEnabled(true);
            this._useSameLegendScheme = false;
            this.jButton_Animator.setEnabled(false);
            this.jButton_CreateAnimatorFile.setEnabled(false);
            this.jButton_PreTime.setEnabled(false);
            this.jButton_NexTime.setEnabled(false);
            switch (this._meteoDataInfo.getDataType()) {
                case MICAPS_7: 
                case HYSPLIT_TRAJ: {
                    this.jButton_Animator.setEnabled(true);
                    this.jButton_CreateAnimatorFile.setEnabled(true);
                }
            }
            ResourceBundle bundle = ResourceBundle.getBundle("bundle/Bundle_FrmMeteoData");
            switch (this._meteoDataInfo.getDrawType2D()) {
                case VECTOR: 
                case BARB: {
                    this.jCheckBox_ColorVar.setText(bundle.getString("FrmMeteoData.jCheckBox_ColorVar.text"));
                    this.jCheckBox_ColorVar.setVisible(true);
                    this.jCheckBox_ColorVar.setSelected(this.windColor);
                    break;
                }
                case CONTOUR: 
                case SHADED: {
                    this.jCheckBox_ColorVar.setText(bundle.getString("FrmMeteoData.jCheckBox_Smooth.text"));
                    this.jCheckBox_ColorVar.setVisible(true);
                    this.jCheckBox_ColorVar.setSelected(this.smooth);
                    break;
                }
                default: {
                    this.jCheckBox_ColorVar.setVisible(false);
                }
            }
        }
    }

    private void jButton_ViewDataActionPerformed(ActionEvent evt) {
        if (this._meteoDataInfo.isGridData()) {
            this.viewGridData();
        } else if (this._meteoDataInfo.isStationData()) {
            this.viewStationData();
            if (this._gridData.getXArray() != null && this._gridData.getYArray() != null && this._gridData.getXNum() > 0 && this._gridData.getYNum() > 0) {
                this.viewGridData();
            }
        }
    }

    private void viewGridData() {
        if (this._gridData == null) {
            return;
        }
        if (this._gridData.getData() == null) {
            return;
        }
        if (this._gridData.getYNum() == 0) {
            return;
        }
        FrmViewData frmData = new FrmViewData();
        frmData.setGridData(this._gridData);
        frmData.setLocationRelativeTo(this);
        frmData.setVisible(true);
    }

    private void viewStationData() {
        if (this._stationData == null) {
            return;
        }
        if (this._stationData.data.length == 0) {
            return;
        }
        String[] colNames = new String[]{"Stid", "Longitude", "Latitude", this.jComboBox_Variable.getSelectedItem().toString()};
        FrmViewData frmData = new FrmViewData(colNames);
        frmData.setStationData(this._stationData);
        frmData.setLocationRelativeTo(this._parent);
        frmData.setVisible(true);
    }

    private void jButton_ClearDrawActionPerformed(ActionEvent evt) {
        this._parent.getMapDocument().getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
    }

    private void jButton_PreTimeActionPerformed(ActionEvent evt) {
        this._useSameLegendScheme = true;
        this._useSameGridInterSet = true;
        switch (this._meteoDataInfo.getDataType()) {
            case MICAPS_7: 
            case MICAPS_2: 
            case MICAPS_3: 
            case MICAPS_4: 
            case MICAPS_11: 
            case MICAPS_13: {
                LocalDateTime tt = (LocalDateTime)this._meteoDataInfo.getDataInfo().getTimes().get(0);
                tt = tt.minusHours(3L);
                String aFile = this._meteoDataInfo.getFileName();
                String path = new File(aFile).getParent();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyMMddHH");
                for (int i = 0; i < 100 && !new File(aFile = path + File.separator + format.format(tt) + ".000").exists(); ++i) {
                    tt = tt.minusHours(3L);
                }
                if (!new File(aFile).exists()) break;
                this._meteoDataInfo.openMICAPSData(aFile);
                DefaultListModel listModel = (DefaultListModel)this.jList_DataFiles.getModel();
                listModel.set(this.jList_DataFiles.getSelectedIndex(), new File(aFile).getName());
                format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                this.jComboBox_Time.removeAllItems();
                this.jComboBox_Time.addItem(format.format(tt));
                break;
            }
            case MICAPS_120: 
            case MICAPS_1: {
                DateTimeFormatter format;
                LocalDateTime tt = (LocalDateTime)this._meteoDataInfo.getDataInfo().getTimes().get(0);
                tt = tt.minusHours(1L);
                String aFile = this._meteoDataInfo.getFileName();
                String path = new File(aFile).getParent();
                switch (this._meteoDataInfo.getDataType()) {
                    case MICAPS_120: {
                        format = DateTimeFormatter.ofPattern("yyyyMMddHH");
                        break;
                    }
                    default: {
                        format = DateTimeFormatter.ofPattern("yyMMddHH");
                    }
                }
                for (int i = 0; i < 100 && !new File(aFile = path + File.separator + format.format(tt) + ".000").exists(); ++i) {
                    tt = tt.minusHours(1L);
                }
                if (!new File(aFile).exists()) break;
                this._meteoDataInfo.openMICAPSData(aFile);
                DefaultListModel listModel = (DefaultListModel)this.jList_DataFiles.getModel();
                listModel.set(this.jList_DataFiles.getSelectedIndex(), new File(aFile).getName());
                format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                this.jComboBox_Time.removeAllItems();
                this.jComboBox_Time.addItem(format.format(tt));
                break;
            }
            case ISH: {
                break;
            }
            default: {
                if (this.jComboBox_Time.getSelectedIndex() > 0) {
                    this.jComboBox_Time.setSelectedIndex(this.jComboBox_Time.getSelectedIndex() - 1);
                    break;
                }
                this.jComboBox_Time.setSelectedIndex(this.jComboBox_Time.getItemCount() - 1);
            }
        }
        this._parent.getMapDocument().getActiveMapFrame().getMapView().setLockViewUpdate(true);
        this._parent.getMapDocument().getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
        this._parent.getMapDocument().getActiveMapFrame().getMapView().setLockViewUpdate(false);
        this.jButton_Draw.doClick();
    }

    private void jButton_NexTimeActionPerformed(ActionEvent evt) {
        this._useSameLegendScheme = true;
        this._useSameGridInterSet = true;
        switch (this._meteoDataInfo.getDataType()) {
            case MICAPS_7: 
            case MICAPS_2: 
            case MICAPS_3: 
            case MICAPS_4: 
            case MICAPS_11: 
            case MICAPS_13: {
                LocalDateTime tt = (LocalDateTime)this._meteoDataInfo.getDataInfo().getTimes().get(0);
                tt = tt.plusHours(3L);
                String aFile = this._meteoDataInfo.getFileName();
                String path = new File(aFile).getParent();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyMMddHH");
                for (int i = 0; i < 100 && !new File(aFile = path + File.separator + format.format(tt) + ".000").exists(); ++i) {
                    tt = tt.plusHours(3L);
                }
                if (!new File(aFile).exists()) break;
                this._meteoDataInfo.openMICAPSData(aFile);
                DefaultListModel listModel = (DefaultListModel)this.jList_DataFiles.getModel();
                listModel.set(this.jList_DataFiles.getSelectedIndex(), new File(aFile).getName());
                format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                this.jComboBox_Time.removeAllItems();
                this.jComboBox_Time.addItem(format.format(tt));
                break;
            }
            case MICAPS_120: 
            case MICAPS_1: {
                DateTimeFormatter format;
                LocalDateTime tt = (LocalDateTime)this._meteoDataInfo.getDataInfo().getTimes().get(0);
                tt = tt.plusHours(1L);
                String aFile = this._meteoDataInfo.getFileName();
                String path = new File(aFile).getParent();
                switch (this._meteoDataInfo.getDataType()) {
                    case MICAPS_120: {
                        format = DateTimeFormatter.ofPattern("yyyyMMddHH");
                        break;
                    }
                    default: {
                        format = DateTimeFormatter.ofPattern("yyMMddHH");
                    }
                }
                for (int i = 0; i < 100 && !new File(aFile = path + File.separator + format.format(tt) + ".000").exists(); ++i) {
                    tt = tt.plusHours(1L);
                }
                if (!new File(aFile).exists()) break;
                this._meteoDataInfo.openMICAPSData(aFile);
                DefaultListModel listModel = (DefaultListModel)this.jList_DataFiles.getModel();
                listModel.set(this.jList_DataFiles.getSelectedIndex(), new File(aFile).getName());
                format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                this.jComboBox_Time.removeAllItems();
                this.jComboBox_Time.addItem(format.format(tt));
                break;
            }
            case ISH: {
                break;
            }
            default: {
                if (this.jComboBox_Time.getSelectedIndex() < this.jComboBox_Time.getItemCount() - 1) {
                    this.jComboBox_Time.setSelectedIndex(this.jComboBox_Time.getSelectedIndex() + 1);
                    break;
                }
                this.jComboBox_Time.setSelectedIndex(0);
            }
        }
        this._parent.getMapDocument().getActiveMapFrame().getMapView().setLockViewUpdate(true);
        this._parent.getMapDocument().getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
        this._parent.getMapDocument().getActiveMapFrame().getMapView().setLockViewUpdate(false);
        this.jButton_Draw.doClick();
    }

    private void jButton_AnimatorActionPerformed(ActionEvent evt) {
        if (this._isRunning) {
            this._enableAnimation = false;
        } else {
            this.run_Animation(false);
        }
    }

    private void run_Animation(final boolean isCreateFile) {
        final AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        if (isCreateFile) {
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"gif"};
            GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif File (*.gif)");
            aDlg.setFileFilter(mapFileFilter);
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
            aDlg.setAcceptAllFileFilterUsed(false);
            if (aDlg.showSaveDialog(this) == 0) {
                File file = aDlg.getSelectedFile();
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                String fileName = file.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                encoder.setRepeat(0);
                encoder.setDelay(1000);
                encoder.start(fileName);
            }
        }
        switch (this._meteoDataInfo.getDataType()) {
            case MICAPS_7: 
            case HYSPLIT_TRAJ: {
                MICAPS7DataInfo aM7DataInfo = (MICAPS7DataInfo)this._meteoDataInfo.getDataInfo();
                List trajPoints = aM7DataInfo.getATrajData(this.jComboBox_Time.getSelectedIndex());
                Graphics2D g = (Graphics2D)this._parent.getMapDocument().getActiveMapFrame().getMapView().getGraphics();
                PointF prePoint = new PointF();
                for (int i = 0; i < trajPoints.size(); ++i) {
                    List pList = (List)trajPoints.get(i);
                    PointBreak aPB = new PointBreak();
                    aPB.setStyle(PointStyle.CIRCLE);
                    aPB.setColor(Color.red);
                    aPB.setOutlineColor(Color.black);
                    aPB.setSize(10.0f);
                    aPB.setDrawOutline(true);
                    aPB.setDrawFill(true);
                    PointF aPoint = new PointF();
                    PointD aPD = (PointD)pList.get(0);
                    double[] sxy = this._parent.getMapDocument().getActiveMapFrame().getMapView().lonLatToScreen(aPD.X, aPD.Y);
                    aPoint.X = (float)sxy[0];
                    aPoint.Y = (float)sxy[1];
                    g.setColor(Color.blue);
                    Font wFont = new Font("Weather", 0, 12);
                    String text = String.valueOf('\u00ba');
                    FontMetrics metrics = g.getFontMetrics(wFont);
                    Dimension sf = new Dimension(metrics.stringWidth(text), metrics.getHeight());
                    PointF sPoint = aPoint;
                    sPoint.X = aPoint.X - (float)sf.getWidth() / 2.0f;
                    sPoint.Y = aPoint.Y - (float)sf.getHeight() / 2.0f;
                    g.setFont(wFont);
                    g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
                    if (i > 0) {
                        g.setColor(Color.red);
                        BasicStroke stroke = new BasicStroke(2.0f);
                        g.setStroke(stroke);
                        g.draw(new Line2D.Float(prePoint.X, prePoint.Y, aPoint.X, aPoint.Y));
                    }
                    prePoint = aPoint;
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FrmMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                break;
            }
            default: {
                if (this.jComboBox_Time.getItemCount() <= 1) break;
                SwingWorker<String, String> worker = new SwingWorker<String, String>(){

                    @Override
                    protected String doInBackground() throws Exception {
                        FrmMeteoData.this.jButton_Animator.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/stop.svg"));
                        FrmMeteoData.this._isRunning = true;
                        FrmMeteoData.this._useSameLegendScheme = true;
                        FrmMeteoData.this._useSameGridInterSet = true;
                        for (int i = 0; i < FrmMeteoData.this.jComboBox_Time.getItemCount(); ++i) {
                            if (!FrmMeteoData.this._enableAnimation) {
                                FrmMeteoData.this._enableAnimation = true;
                                FrmMeteoData.this._isRunning = false;
                                FrmMeteoData.this.jButton_Animator.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/animator.svg"));
                                return "";
                            }
                            FrmMeteoData.this.jComboBox_Time.setSelectedIndex(i);
                            FrmMeteoData.this._parent.getMapDocument().getActiveMapFrame().getMapView().setLockViewUpdate(true);
                            FrmMeteoData.this._parent.getMapDocument().getActiveMapFrame().removeLayerByHandle(FrmMeteoData.this._lastAddedLayerHandle);
                            FrmMeteoData.this._parent.getMapDocument().getActiveMapFrame().getMapView().setLockViewUpdate(false);
                            FrmMeteoData.this.display();
                            if (isCreateFile) {
                                if (FrmMeteoData.this._parent.getMainTab().getSelectedIndex() == 0) {
                                    encoder.addFrame(FrmMeteoData.this._parent.getMapDocument().getActiveMapFrame().getMapView().getViewImage());
                                    continue;
                                }
                                encoder.addFrame(FrmMeteoData.this._parent.getMapDocument().getMapLayout().getViewImage());
                                continue;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(FrmMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        FrmMeteoData.this._enableAnimation = true;
                        FrmMeteoData.this._isRunning = false;
                        FrmMeteoData.this.jButton_Animator.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/animator.svg"));
                        encoder.finish();
                        return "";
                    }
                };
                worker.execute();
            }
        }
    }

    private void jButton_CreateAnimatorFileActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.run_Animation(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_DrawSettingActionPerformed(ActionEvent evt) {
        switch (this._meteoDataInfo.getDataType()) {
            default: 
        }
        FrmLegendSet aFrmLS = new FrmLegendSet((Dialog)this, true);
        aFrmLS.setLegendScheme(this._legendScheme);
        String fieldName = this.jComboBox_Variable.getSelectedItem().toString();
        aFrmLS.setLocationRelativeTo((Component)this);
        aFrmLS.setVisible(true);
        if (aFrmLS.isOK()) {
            this._parent.getMapDocument().getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
            this._legendScheme = aFrmLS.getLegendScheme();
            this.drawMeteoMap(false, this._legendScheme, fieldName);
            this._parent.getMapDocument().getActiveMapFrame().getMapView().paintLayers();
        }
    }

    private void jButton_SettingActionPerformed(ActionEvent evt) {
        if (this._meteoDataInfo.isStationData() || this._meteoDataInfo.isSWATHData()) {
            switch (this._meteoDataInfo.getDrawType2D()) {
                case CONTOUR: 
                case SHADED: 
                case GRID_POINT: 
                case RASTER: {
                    JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
                    FrmInterpolate frmInter = new FrmInterpolate((Frame)frame, true);
                    frmInter.setParameters(this._interpolationSetting);
                    frmInter.setLocationRelativeTo(this);
                    frmInter.setVisible(true);
                    if (!frmInter.isOK()) break;
                    this._interpolationSetting = frmInter.getParameters();
                    this.jButton_Draw.setEnabled(true);
                    this._useSameGridInterSet = true;
                    break;
                }
                case WEATHER_SYMBOL: {
                    Object[] possibleValues = new Object[]{"All Weather", "SDS", "SDS, Haze", "Smoke", "Haze", "Mist", "Smoke, Haze, Mist", "Fog"};
                    Object selectedValue = JOptionPane.showInputDialog(null, "Choose one", "Input", 1, null, possibleValues, this.weatherString);
                    if (selectedValue == null) break;
                    this.weatherString = selectedValue.toString();
                    VectorLayer layer = DrawMeteoData.createWeatherSymbolLayer((StationData)this._stationData, (String)this.weatherString, (String)"Weather");
                    layer.setProjInfo(this._meteoDataInfo.getProjectionInfo());
                    this._parent.getMapDocument().getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
                    this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().addLayer((MapLayer)layer);
                    break;
                }
                case VECTOR: 
                case BARB: 
                case STREAMLINE: {
                    this.meteoUVSet.setUV(false);
                    this.setMeteoUV();
                }
            }
        } else if (this._meteoDataInfo.isGridData()) {
            switch (this._meteoDataInfo.getDrawType2D()) {
                case CONTOUR: 
                case SHADED: 
                case GRID_POINT: 
                case RASTER: 
                case GRID_FILL: {
                    break;
                }
                case STREAMLINE: {
                    String strmDen = JOptionPane.showInputDialog("Streamline density", (Object)4);
                    int den = Integer.parseInt(strmDen);
                    if (den < 1 || den > 10) {
                        JOptionPane.showMessageDialog(null, "The streamline density must be set between 1 - 10");
                        break;
                    }
                    this._strmDensity = den;
                    break;
                }
                case VECTOR: 
                case BARB: {
                    this.setMeteoUV();
                }
            }
        }
    }

    private void setMeteoUV() {
        if (this.meteoUVSet.getUDataInfo() == null || !this._dataInfoList.contains(this.meteoUVSet.getUDataInfo())) {
            this.meteoUVSet.setUDataInfo(this._meteoDataInfo);
            this.meteoUVSet.setVDataInfo(this._meteoDataInfo);
            this.meteoUVSet.setFixUVStr(this._meteoDataInfo.getMeteoUVSet().isFixUVStr());
            this.meteoUVSet.setUV(this._meteoDataInfo.getMeteoUVSet().isUV());
            this.meteoUVSet.setUStr(this._meteoDataInfo.getMeteoUVSet().getUStr());
            this.meteoUVSet.setVStr(this._meteoDataInfo.getMeteoUVSet().getVStr());
        }
        FrmUVSet aFrmUVSet = new FrmUVSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), true);
        if (this.meteoUVSet.isUV()) {
            aFrmUVSet.setUV(true);
        } else {
            aFrmUVSet.setUV(false);
        }
        aFrmUVSet.setUVData(this._dataInfoList);
        aFrmUVSet.setUData(this.meteoUVSet.getUDataInfo());
        aFrmUVSet.setVData(this.meteoUVSet.getVDataInfo());
        aFrmUVSet.setUStr(this.meteoUVSet.getUStr());
        aFrmUVSet.setVStr(this.meteoUVSet.getVStr());
        aFrmUVSet.setXSkip(this._skipX);
        aFrmUVSet.setYSkip(this._skipY);
        aFrmUVSet.setLocationRelativeTo(this);
        aFrmUVSet.setVisible(true);
        if (aFrmUVSet.isOK()) {
            String[] uvStr = aFrmUVSet.getUVItems();
            String uStr = uvStr[0];
            String vStr = uvStr[1];
            this.meteoUVSet.setUV(aFrmUVSet.isUV());
            this.meteoUVSet.setUDataInfo(aFrmUVSet.getUData());
            this.meteoUVSet.setUStr(uStr);
            this.meteoUVSet.setVDataInfo(aFrmUVSet.getVData());
            this.meteoUVSet.setVStr(vStr);
            this.meteoUVSet.setFixUVStr(true);
            this._skipX = aFrmUVSet.getXSkip();
            this._skipY = aFrmUVSet.getYSkip();
        }
    }

    private void jButton_SectionPlotActionPerformed(ActionEvent evt) {
        FrmSectionPlot afrm = new FrmSectionPlot(this._meteoDataInfo);
        afrm.setLocationRelativeTo(this._parent);
        afrm.setVisible(true);
    }

    private void jButton_1DPlotActionPerformed(ActionEvent evt) {
        FrmOneDim afrm = new FrmOneDim(this._parent, this._meteoDataInfo);
        afrm.setLocationRelativeTo(this._parent);
        afrm.setVisible(true);
    }

    private void jButton_RemoveAllDataActionPerformed(ActionEvent evt) {
        this.removeAllMeteoData();
    }

    private void jMenuTime_ArrivalTimeActionPerformed(ActionEvent evt) {
        String threshold = JOptionPane.showInputDialog(this, "Threshold value:", 0.0);
        if (threshold != null) {
            double th = Double.parseDouble(threshold);
            String varName = this.jComboBox_Variable.getEditor().getItem().toString();
            GridData gData = this._meteoDataInfo.getArrivalTimeData(varName, th);
            this.display(gData);
        }
    }

    private void jComboBox_TimeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Time.getItemCount() > 0) {
            this._meteoDataInfo.setTimeIndex(this.jComboBox_Time.getSelectedIndex());
        }
    }

    private void jComboBox_LevelActionPerformed(ActionEvent evt) {
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
        this._useSameLegendScheme = false;
        this._meteoDataInfo.setLevelIndex(this.jComboBox_Level.getSelectedIndex());
    }

    private void jCheckBox_ColorVarActionPerformed(ActionEvent evt) {
        switch (this._meteoDataInfo.getDrawType2D()) {
            case VECTOR: 
            case BARB: {
                this.windColor = this.jCheckBox_ColorVar.isSelected();
                this._useSameLegendScheme = false;
                break;
            }
            case CONTOUR: 
            case SHADED: {
                this.smooth = this.jCheckBox_ColorVar.isSelected();
            }
        }
    }

    private void jCheckBox_Big_EndianActionPerformed(ActionEvent evt) {
        switch (this._meteoDataInfo.getDataType()) {
            case GRADS_GRID: 
            case GRADS_STATION: {
                GrADSDataInfo aDataInfo = (GrADSDataInfo)this._meteoDataInfo.getDataInfo();
                aDataInfo.setBigEndian(this.jCheckBox_Big_Endian.isSelected());
            }
        }
    }

    private String getStartupPath() {
        return System.getProperty("user.dir");
    }

    public MeteoDataInfo openGrADSData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openGrADSData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openARLData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openARLData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openASCIIGridData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openASCIIGridData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openSurferGridData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openSurferGridData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openHYSPLITConcData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openHYSPLITConcData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openHYSPITPartData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openHYSPLITPartData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openHYSPLITTrajData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openHYSPLITTrajData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openNetCDFData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openNetCDFData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openLonLatData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openLonLatData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openMICAPSData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openMICAPSData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openMM5Data(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openMM5Data(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openMM5IMData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openMM5IMData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    private void onGrADSDataClick(ActionEvent e) {
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"ctl"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "GrADS Data (*.ctl)");
        aDlg.setFileFilter(mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openGrADSData(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
    }

    private void onRemoveDataClick(ActionEvent e) {
        int selIdx = this.jList_DataFiles.getSelectedIndex();
        this.removeMeteoData(selIdx);
    }

    private void onARLDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openARLData(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onASCIIGridDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openASCIIGridData(file.getAbsolutePath());
            aDataInfo.getDataInfo().setProjectionInfo(this._parent.getMapDocument().getActiveMapFrame().getMapView().getProjection().getProjInfo());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onSurferGridDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openSurferGridData(file.getAbsolutePath());
            aDataInfo.getDataInfo().setProjectionInfo(this._parent.getMapDocument().getActiveMapFrame().getMapView().getProjection().getProjInfo());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onHYSPLITConcDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openHYSPLITConcData(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onHYSPLITPartDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openHYSPLITPartData(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onHYSPLITTrajDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setMultiSelectionEnabled(true);
        if (0 == aDlg.showOpenDialog(this)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            for (File file : files) {
                MeteoDataInfo aDataInfo = new MeteoDataInfo();
                aDataInfo.openHYSPLITTrajData(file.getAbsolutePath());
                this.addMeteoData(aDataInfo);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onNetCDFDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setMultiSelectionEnabled(true);
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            for (File file : files) {
                MeteoDataInfo aDataInfo = new MeteoDataInfo();
                aDataInfo.openNetCDFData(file.getAbsolutePath());
                this.addMeteoData(aDataInfo);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onLonLatStationsClick(ActionEvent e) {
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setAcceptAllFileFilterUsed(false);
        String[] fileExts = new String[]{"csv"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "CSV File (*.csv)");
        aDlg.setFileFilter(mapFileFilter);
        fileExts = new String[]{"txt"};
        mapFileFilter = new GenericFileFilter(fileExts, "Text File (*.txt)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openLonLatData(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
    }

    private void onSYNOPClick(ActionEvent e) {
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            String stFile = this._parent.getStartupPath() + "\\station\\SYNOP_Stations.csv";
            aDataInfo.openSYNOPData(file.getAbsolutePath(), stFile);
            this.addMeteoData(aDataInfo);
        }
    }

    private void onMETARClick(ActionEvent e) {
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            String stFile = this._parent.getStartupPath() + "\\station\\METAR_Stations.csv";
            aDataInfo.openMETARData(file.getAbsolutePath(), stFile);
            this.addMeteoData(aDataInfo);
        }
    }

    private void onMICAPSDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openMICAPSData(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onMM5DataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openMM5Data(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onMM5IMDataClick(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            MeteoDataInfo aDataInfo = new MeteoDataInfo();
            aDataInfo.openMM5IMData(file.getAbsolutePath());
            this.addMeteoData(aDataInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onAWXDataClick(ActionEvent e) {
        String path = this.getStartupPath();
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setAcceptAllFileFilterUsed(false);
        String[] fileExts = new String[]{"awx"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "AWX Data (*.awx)");
        aDlg.setFileFilter(mapFileFilter);
        aDlg.setMultiSelectionEnabled(true);
        if (0 == aDlg.showOpenDialog(this)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            for (File file : files) {
                MeteoDataInfo aDataInfo = new MeteoDataInfo();
                aDataInfo.openAWXData(file.getAbsolutePath());
                this.addMeteoData(aDataInfo);
            }
        }
    }

    public MapLayer getLastAddLayer() {
        MapLayer layer = null;
        if (this._lastAddedLayerHandle >= 0) {
            layer = this._parent.getMapView().getLayerByHandle(this._lastAddedLayerHandle);
        }
        return layer;
    }

    public void addMeteoData(MeteoDataInfo aDataInfo) {
        this._dataInfoList.add(aDataInfo);
        DefaultListModel listModel = (DefaultListModel)this.jList_DataFiles.getModel();
        listModel.addElement(new File(aDataInfo.getFileName()).getName());
        this.jList_DataFiles.setModel(listModel);
        this.jList_DataFiles.setSelectedIndex(listModel.size() - 1);
        this._meteoDataInfo = this._dataInfoList.get(this.jList_DataFiles.getSelectedIndex());
        this.updateParameters();
    }

    private void updateParameters() {
        DataInfo aDataInfo = this._meteoDataInfo.getDataInfo();
        switch (this._meteoDataInfo.getDataType()) {
            case GRADS_GRID: 
            case GRADS_STATION: {
                this.jCheckBox_Big_Endian.setVisible(true);
                this.jCheckBox_Big_Endian.setSelected(((GrADSDataInfo)aDataInfo).isBigEndian());
                break;
            }
            default: {
                this.jCheckBox_Big_Endian.setVisible(false);
            }
        }
        String dataType = this._meteoDataInfo.getDataType().toString();
        if (this._meteoDataInfo.getDataType() == MeteoDataType.NETCDF) {
            dataType = ((NetCDFDataInfo)this._meteoDataInfo.getDataInfo()).getFileTypeId();
        }
        this.setTitle(this.getTitle().split("-")[0].trim() + " - " + dataType);
        this.jPanel_DataSet.setEnabled(true);
        for (Component aItem : this.jToolBar1.getComponents()) {
            aItem.setEnabled(true);
        }
        this.jButton_DrawSetting.setEnabled(false);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
        this.jButton_Setting.setEnabled(true);
        switch (this._meteoDataInfo.getDataType()) {
            case HYSPLIT_TRAJ: {
                this.jButton_SectionPlot.setEnabled(false);
            }
        }
        this.updateProjection();
        DefaultComboBoxModel<DrawType2D> comboBoxModel = new DefaultComboBoxModel<DrawType2D>();
        if (this._meteoDataInfo.isGridData()) {
            comboBoxModel.addElement(DrawType2D.RASTER);
            comboBoxModel.addElement(DrawType2D.CONTOUR);
            comboBoxModel.addElement(DrawType2D.SHADED);
            comboBoxModel.addElement(DrawType2D.GRID_FILL);
            comboBoxModel.addElement(DrawType2D.GRID_POINT);
            comboBoxModel.addElement(DrawType2D.VECTOR);
            comboBoxModel.addElement(DrawType2D.BARB);
            comboBoxModel.addElement(DrawType2D.STREAMLINE);
        } else if (this._meteoDataInfo.isStationData()) {
            switch (this._meteoDataInfo.getDataType()) {
                case HYSPLIT_PARTICLE: {
                    comboBoxModel.addElement(DrawType2D.STATION_POINT);
                    break;
                }
                default: {
                    comboBoxModel.addElement(DrawType2D.STATION_POINT);
                    comboBoxModel.addElement(DrawType2D.STATION_INFO);
                    comboBoxModel.addElement(DrawType2D.WEATHER_SYMBOL);
                    comboBoxModel.addElement(DrawType2D.STATION_MODEL);
                    comboBoxModel.addElement(DrawType2D.VECTOR);
                    comboBoxModel.addElement(DrawType2D.BARB);
                    comboBoxModel.addElement(DrawType2D.CONTOUR);
                    comboBoxModel.addElement(DrawType2D.SHADED);
                    comboBoxModel.addElement(DrawType2D.STREAMLINE);
                    break;
                }
            }
        } else if (this._meteoDataInfo.isSWATHData()) {
            comboBoxModel.addElement(DrawType2D.RASTER);
            comboBoxModel.addElement(DrawType2D.STATION_POINT);
        } else {
            comboBoxModel.addElement(DrawType2D.TRAJECTORY_LINE);
            comboBoxModel.addElement(DrawType2D.TRAJECTORY_POINT);
            comboBoxModel.addElement(DrawType2D.TRAJECTORY_START_POINT);
        }
        this.jComboBox_DrawType.setModel(comboBoxModel);
        if (this._meteoDataInfo.getDrawType2D() == null) {
            this._meteoDataInfo.setDrawType2D((DrawType2D)this.jComboBox_DrawType.getItemAt(0));
        }
        this.jComboBox_DrawType.setSelectedItem(this._meteoDataInfo.getDrawType2D());
        this._isLoading = true;
        this.jComboBox_Variable.setEnabled(true);
        this.jComboBox_Variable.removeAllItems();
        ArrayList<String> varNames = new ArrayList<String>();
        for (int i = 0; i < aDataInfo.getVariables().size(); ++i) {
            Variable var = (Variable)aDataInfo.getVariables().get(i);
            if (this._meteoDataInfo.isSWATHData()) {
                Variable lonvar = this._meteoDataInfo.getDataInfo().getVariable("longitude");
                if (lonvar == null || !var.dimensionContains(lonvar)) continue;
                this.jComboBox_Variable.addItem(var.getName());
                varNames.add(var.getName());
                continue;
            }
            if (!var.isPlottable()) continue;
            this.jComboBox_Variable.addItem(var.getName());
            varNames.add(var.getName());
        }
        this._isLoading = false;
        if (this._meteoDataInfo.getVariableName() == null) {
            this.jComboBox_Variable.setSelectedIndex(0);
        } else if (varNames.contains(this._meteoDataInfo.getVariableName())) {
            this.jComboBox_Variable.setSelectedItem(this._meteoDataInfo.getVariableName());
        } else {
            this.jComboBox_Variable.setSelectedIndex(0);
        }
    }

    private void updateProjection() {
        ProjectionInfo mapViewProj;
        ProjectionInfo dataProj = this._meteoDataInfo.getProjectionInfo();
        if (!dataProj.equals(mapViewProj = this._parent.getMapDocument().getActiveMapFrame().getMapView().getProjection().getProjInfo()) && JOptionPane.showConfirmDialog(null, "Different projection! If project?", "Conform", 0) == 0) {
            this._parent.getMapDocument().getActiveMapFrame().getMapView().projectLayers(this._meteoDataInfo.getProjectionInfo());
        }
    }

    public void removeMeteoData(int idx) {
        this._dataInfoList.remove(idx);
        if (this.jList_DataFiles.getModel().getSize() > 1) {
            if (idx >= 1) {
                this.jList_DataFiles.setSelectedIndex(idx - 1);
            } else {
                this.jList_DataFiles.setSelectedIndex(0);
            }
        }
        ((DefaultListModel)this.jList_DataFiles.getModel()).remove(idx);
        if (this._dataInfoList.isEmpty()) {
            this.initialize();
        }
    }

    public void removeMeteoData(MeteoDataInfo aDataInfo) {
        this._dataInfoList.remove(aDataInfo);
        if (this._dataInfoList.isEmpty()) {
            this.initialize();
        }
    }

    public void removeAllMeteoData() {
        this._dataInfoList.clear();
        ((DefaultListModel)this.jList_DataFiles.getModel()).removeAllElements();
        this.initialize();
    }

    public MapLayer display() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jButton_ViewData.setEnabled(true);
        this.jButton_DrawSetting.setEnabled(true);
        if (this.jComboBox_Time.getItemCount() > 1) {
            this.jButton_NexTime.setEnabled(true);
            this.jButton_PreTime.setEnabled(true);
            this.jButton_Animator.setEnabled(true);
            this.jButton_CreateAnimatorFile.setEnabled(true);
        }
        this.jButton_Setting.setEnabled(true);
        this._meteoDataInfo.setDimensionSet(PlotDimension.Lat_Lon);
        MapLayer aLayer = null;
        String fieldName = "";
        if (this.jComboBox_Variable.getSelectedItem() != null) {
            fieldName = this.jComboBox_Variable.getEditor().getItem().toString();
        }
        if (this._meteoDataInfo.isGridData()) {
            aLayer = this.drawGrid(fieldName);
        } else if (this._meteoDataInfo.isStationData()) {
            aLayer = this.drawStation(fieldName);
            this._useSameLegendScheme = true;
        } else if (this._meteoDataInfo.isTrajData()) {
            aLayer = this.drawTraj(fieldName);
            this.jButton_DrawSetting.setEnabled(false);
            this.jButton_NexTime.setEnabled(false);
            this.jButton_PreTime.setEnabled(false);
        } else if (this._meteoDataInfo.isSWATHData()) {
            aLayer = this.drawStation(fieldName);
        }
        switch (this._meteoDataInfo.getDataType()) {
            case MICAPS_7: 
            case MICAPS_120: 
            case MICAPS_2: 
            case MICAPS_3: 
            case MICAPS_4: 
            case MICAPS_11: 
            case MICAPS_13: 
            case MICAPS_1: {
                this.jButton_NexTime.setEnabled(true);
                this.jButton_PreTime.setEnabled(true);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        return aLayer;
    }

    private MapLayer display(GridData gData) {
        this._gridData = gData;
        if (this._gridData == null) {
            return null;
        }
        if (this._useSameLegendScheme) {
            if (this._legendScheme.getLegendType() == LegendType.GRADUATED_COLOR) {
                double[] maxmin = new double[2];
                boolean hasUndef = this._gridData.getMaxMinValue(maxmin);
                double minValue = maxmin[1];
                double maxValue = maxmin[0];
                if (Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getStartValue().toString()) < Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getEndValue().toString())) {
                    if (minValue < Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getStartValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).setStartValue((Object)minValue);
                    }
                    if (maxValue > Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).getEndValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).setEndValue((Object)maxValue);
                    }
                } else {
                    if (maxValue > Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getEndValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).setEndValue((Object)maxValue);
                    }
                    if (minValue < Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).getStartValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).setStartValue((Object)minValue);
                    }
                }
            }
        } else {
            this.createLegendScheme_Grid();
        }
        return this.drawMeteoMap_Grid(true, this._legendScheme, "Data");
    }

    private MapLayer drawGrid(String fieldName) {
        String vName = fieldName;
        this._gridData = this._meteoDataInfo.getGridData(vName);
        if (this._gridData == null) {
            return null;
        }
        if (this._useSameLegendScheme) {
            if (this._legendScheme.getLegendType() == LegendType.GRADUATED_COLOR) {
                double[] maxmin = new double[2];
                boolean hasUndef = this._gridData.getMaxMinValue(maxmin);
                double minValue = maxmin[1];
                double maxValue = maxmin[0];
                if (Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getStartValue().toString()) < Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getEndValue().toString())) {
                    if (minValue < Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getStartValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).setStartValue((Object)minValue);
                    }
                    if (maxValue > Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).getEndValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).setEndValue((Object)maxValue);
                    }
                } else {
                    if (maxValue > Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).getEndValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(0)).setEndValue((Object)maxValue);
                    }
                    if (minValue < Double.parseDouble(((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).getStartValue().toString())) {
                        ((ColorBreak)this._legendScheme.getLegendBreaks().get(this._legendScheme.getBreakNum() - 1)).setStartValue((Object)minValue);
                    }
                }
            }
        } else {
            this.createLegendScheme_Grid();
        }
        return this.drawMeteoMap_Grid(true, this._legendScheme, fieldName);
    }

    private MapLayer drawStation(String fieldName) {
        String vName = fieldName;
        this._stationData = this._meteoDataInfo.getStationData(vName);
        Extent aExtent = this._stationData.dataExtent;
        if (this._stationData.getStNum() > 5 && aExtent.getWidth() > 0.0 && aExtent.getHeight() > 0.0 && !this._useSameGridInterSet) {
            GridDataSetting aGDP = this._interpolationSetting.getGridDataSetting();
            aGDP.dataExtent = aExtent;
            this._interpolationSetting.setRadius((double)((float)((aGDP.dataExtent.maxX - aGDP.dataExtent.minX) / (double)aGDP.xNum * 2.0)));
            this._useSameGridInterSet = true;
            if (this._meteoDataInfo.isSWATHData()) {
                this._interpolationSetting.setInterpolationMethod(InterpolationMethods.ASSIGN_POINT_GRID);
                aGDP.xNum = 1000;
                aGDP.yNum = 1000;
            }
        }
        switch (this._meteoDataInfo.getDrawType2D()) {
            case VECTOR: 
            case BARB: 
            case WEATHER_SYMBOL: 
            case STATION_POINT: 
            case STATION_MODEL: 
            case STATION_INFO: {
                if (!this._useSameLegendScheme) {
                    this.createLegendScheme_Station();
                }
                return this.drawMeteoMap_Station(true, this._legendScheme, fieldName);
            }
        }
        this._gridData = GeoMathUtil.interpolateData((StationData)this._stationData, (InterpolationSetting)this._interpolationSetting);
        if (!this._useSameLegendScheme) {
            this.createLegendScheme_Station();
        }
        return this.drawMeteoMap_Station(true, this._legendScheme, fieldName);
    }

    private MapLayer drawTraj(String varName) {
        DataInfo aDataInfo = this._meteoDataInfo.getDataInfo();
        VectorLayer aLayer = null;
        switch (this._meteoDataInfo.getDrawType2D()) {
            case TRAJECTORY_LINE: {
                aLayer = DrawMeteoData.createTrajLineLayer((ITrajDataInfo)((ITrajDataInfo)aDataInfo), (String)varName);
                this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().insertPolylineLayer(aLayer);
                break;
            }
            case TRAJECTORY_START_POINT: {
                aLayer = DrawMeteoData.createTrajStartPointLayer((ITrajDataInfo)((ITrajDataInfo)aDataInfo));
                PointBreak aPB = (PointBreak)aLayer.getLegendScheme().getLegendBreaks().get(0);
                aPB.setStyle(PointStyle.UP_TRIANGLE);
                this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().insertPolylineLayer(aLayer);
                break;
            }
            case TRAJECTORY_POINT: {
                aLayer = DrawMeteoData.createTrajPointLayer((ITrajDataInfo)((ITrajDataInfo)aDataInfo));
                this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().insertPolylineLayer(aLayer);
            }
        }
        return aLayer;
    }

    private void createLegendScheme_Grid() {
        switch (this._meteoDataInfo.getDrawType2D()) {
            case CONTOUR: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.UNIQUE_VALUE, (ShapeTypes)ShapeTypes.POLYLINE);
                break;
            }
            case SHADED: 
            case GRID_FILL: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POLYGON);
                break;
            }
            case GRID_POINT: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                break;
            }
            case VECTOR: 
            case BARB: {
                if (this.jCheckBox_ColorVar.isSelected()) {
                    this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                    for (int i = 0; i < this._legendScheme.getBreakNum(); ++i) {
                        PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(i);
                        aPB.setSize(10.0f);
                    }
                    break;
                }
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.blue, (float)10.0f);
                break;
            }
            case STREAMLINE: {
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYLINE, (Color)Color.blue, (float)1.0f);
                this._legendScheme.setLegendBreak(0, (ColorBreak)new StreamlineBreak((PolylineBreak)this._legendScheme.getLegendBreak(0)));
                break;
            }
            case RASTER: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.IMAGE);
            }
        }
    }

    private LegendScheme createLegendScheme_Station() {
        switch (this._meteoDataInfo.getDrawType2D()) {
            case STATION_POINT: {
                this._legendScheme = LegendManage.createLegendSchemeFromStationData((StationData)this._stationData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                if (this._meteoDataInfo.getDataType() != MeteoDataType.HDF) break;
                for (int i = 0; i < this._legendScheme.getBreakNum(); ++i) {
                    ((PointBreak)this._legendScheme.getLegendBreaks().get(i)).setDrawOutline(false);
                }
                break;
            }
            case GRID_POINT: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                break;
            }
            case CONTOUR: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.UNIQUE_VALUE, (ShapeTypes)ShapeTypes.POLYLINE);
                break;
            }
            case SHADED: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POLYGON);
                break;
            }
            case RASTER: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.IMAGE);
                break;
            }
            case VECTOR: 
            case BARB: {
                if (this.jCheckBox_ColorVar.isSelected()) {
                    this._legendScheme = LegendManage.createLegendSchemeFromStationData((StationData)this._stationData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                    for (int i = 0; i < this._legendScheme.getLegendBreaks().size(); ++i) {
                        PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(i);
                        aPB.setSize(10.0f);
                    }
                    break;
                }
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.blue, (float)10.0f);
                break;
            }
            case STREAMLINE: {
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYLINE, (Color)Color.blue, (float)1.0f);
                this._legendScheme.setLegendBreak(0, (ColorBreak)new StreamlineBreak((PolylineBreak)this._legendScheme.getLegendBreak(0)));
                break;
            }
            case WEATHER_SYMBOL: {
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.blue, (float)12.0f);
                break;
            }
            case STATION_MODEL: {
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.blue, (float)12.0f);
                break;
            }
            case STATION_INFO: {
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.red, (float)8.0f);
            }
        }
        return this._legendScheme;
    }

    public MapLayer drawMeteoMap(boolean isNew, LegendScheme aLS, String fieldName) {
        if (this._meteoDataInfo.isGridData()) {
            return this.drawMeteoMap_Grid(isNew, aLS, fieldName);
        }
        if (this._meteoDataInfo.isStationData() || this._meteoDataInfo.isSWATHData()) {
            return this.drawMeteoMap_Station(isNew, aLS, fieldName);
        }
        return null;
    }

    private MapLayer drawMeteoMap_Grid(boolean isNew, LegendScheme aLS, String fieldName) {
        RasterLayer aLayer = null;
        String varName = this.jComboBox_Variable.getSelectedItem().toString();
        String lName = "";
        if (this.jComboBox_Level.getItemCount() > 0) {
            lName = this.jComboBox_Level.getSelectedItem().toString();
        }
        if (this.jComboBox_Time.getItemCount() > 0) {
            if (!lName.isEmpty()) {
                lName = lName + "_";
            }
            lName = lName + this.jComboBox_Time.getSelectedItem().toString();
        }
        lName = lName.isEmpty() ? varName : varName + "_" + lName;
        boolean ifAddLayer = true;
        if (this._gridData.isGlobal()) {
            this._gridData.extendToGlobal();
        }
        switch (this._meteoDataInfo.getDrawType2D()) {
            case CONTOUR: {
                lName = "Contour_" + lName;
                aLayer = DrawMeteoData.createContourLayer((GridData)this._gridData, (LegendScheme)aLS, (String)lName, (String)fieldName, (boolean)this.smooth);
                if (aLayer == null) break;
                ((VectorLayer)aLayer).getLabelSet().setShadowColor(this._parent.getMapDocument().getActiveMapFrame().getMapView().getBackground());
                ((VectorLayer)aLayer).addLabelsContourDynamic(this._parent.getMapDocument().getActiveMapFrame().getMapView().getViewExtent());
                break;
            }
            case SHADED: {
                lName = "Shaded_" + lName;
                aLayer = DrawMeteoData.createShadedLayer((GridData)this._gridData, (LegendScheme)aLS, (String)lName, (String)fieldName, (boolean)this.smooth);
                break;
            }
            case GRID_FILL: {
                lName = "GridFill_" + lName;
                aLayer = DrawMeteoData.createGridFillLayer((GridData)this._gridData, (LegendScheme)aLS, (String)lName, (String)fieldName);
                break;
            }
            case GRID_POINT: {
                lName = "GridPoint_" + lName;
                aLayer = DrawMeteoData.createGridPointLayer((GridData)this._gridData, (LegendScheme)aLS, (String)lName, (String)fieldName);
                break;
            }
            case VECTOR: {
                GridData[] uvData = this.getUVGridData();
                if (uvData != null) {
                    GridData uData = uvData[0];
                    GridData vData = uvData[1];
                    lName = "Vector_" + lName;
                    if (this.windColor && (this._skipX != 1 || this._skipY != 1)) {
                        this._gridData = this._gridData.skip(this._skipY, this._skipX);
                    }
                    aLayer = DrawMeteoData.createGridVectorLayer((GridData)uData, (GridData)vData, (GridData)this._gridData, (LegendScheme)aLS, (boolean)this.windColor, (String)lName, (boolean)this.meteoUVSet.isUV());
                    break;
                }
                ifAddLayer = false;
                break;
            }
            case STREAMLINE: {
                GridData[] uvData = this.getUVGridData();
                if (uvData != null) {
                    GridData uData = uvData[0];
                    GridData vData = uvData[1];
                    if (uData.isGlobal()) {
                        uData.extendToGlobal();
                        vData.extendToGlobal();
                    }
                    lName = "Streamline_" + lName;
                    aLayer = DrawMeteoData.createStreamlineLayer((GridData)uData, (GridData)vData, (int)this._strmDensity, (LegendScheme)aLS, (String)lName, (boolean)this.meteoUVSet.isUV());
                    break;
                }
                ifAddLayer = false;
                break;
            }
            case BARB: {
                GridData[] uvData = this.getUVGridData();
                if (uvData != null) {
                    GridData uData = uvData[0];
                    GridData vData = uvData[1];
                    lName = "Barb_" + lName;
                    if (this.windColor && (this._skipX != 1 || this._skipY != 1)) {
                        this._gridData = this._gridData.skip(this._skipY, this._skipX);
                    }
                    aLayer = DrawMeteoData.createGridBarbLayer((GridData)uData, (GridData)vData, (GridData)this._gridData, (LegendScheme)aLS, (boolean)this.windColor, (String)lName, (boolean)this.meteoUVSet.isUV());
                    break;
                }
                ifAddLayer = false;
                break;
            }
            case RASTER: {
                lName = "Raster_" + lName;
                aLayer = DrawMeteoData.createRasterLayer((GridData)this._gridData, (String)lName, (LegendScheme)aLS);
            }
        }
        if (!ifAddLayer || aLayer == null) {
            return null;
        }
        aLayer.setProjInfo(this._meteoDataInfo.getProjectionInfo());
        if (aLayer.getLayerType() == LayerTypes.VECTOR_LAYER) {
            VectorLayer aVLayer = (VectorLayer)aLayer;
            aVLayer.setMaskout(true);
            if (aVLayer.getShapeType() == ShapeTypes.POLYGON) {
                this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().insertPolygonLayer((MapLayer)aVLayer);
            } else {
                switch (this._meteoDataInfo.getDrawType2D()) {
                    case VECTOR: 
                    case BARB: {
                        this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().addWindLayer(aVLayer, this._meteoDataInfo.EarthWind);
                        break;
                    }
                    default: {
                        this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().insertPolylineLayer(aVLayer);
                    }
                }
            }
        } else {
            RasterLayer aILayer = aLayer;
            this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().insertImageLayer((MapLayer)aILayer);
        }
        return aLayer;
    }

    public MapLayer drawMeteoMap_Station(boolean isNew, LegendScheme aLS, String fieldName) {
        String LNameM;
        boolean hasNoData = this._hasUndefData;
        RasterLayer aLayer = null;
        String LName = LNameM = this.jComboBox_Variable.getSelectedItem().toString() + "_";
        if (this._interpolationSetting.getInterpolationMethod() == InterpolationMethods.IDW_NEIGHBORS) {
            hasNoData = false;
        }
        boolean ifAddLayer = true;
        switch (this._meteoDataInfo.getDrawType2D()) {
            case STATION_POINT: {
                LegendManage.setContoursAndColors((LegendScheme)aLS, (double[])this._cValues, (Color[])this._cColors);
                LName = "StationPoint_" + LName;
                aLayer = DrawMeteoData.createSTPointLayer((StationData)this._stationData, (LegendScheme)aLS, (String)LName, (String)fieldName);
                switch (this._meteoDataInfo.getDataType()) {
                    case HYSPLIT_PARTICLE: 
                    case NETCDF: {
                        for (ColorBreak cb : aLayer.getLegendScheme().getLegendBreaks()) {
                            ((PointBreak)cb).setDrawOutline(false);
                        }
                        break;
                    }
                }
                break;
            }
            case GRID_POINT: {
                LegendManage.setContoursAndColors((LegendScheme)aLS, (double[])this._cValues, (Color[])this._cColors);
                LName = "GridPoint_" + LName;
                aLayer = DrawMeteoData.createGridPointLayer((GridData)this._gridData, (LegendScheme)aLS, (String)LName, (String)fieldName);
                break;
            }
            case CONTOUR: {
                LegendManage.setContoursAndColors((LegendScheme)aLS, (double[])this._cValues, (Color[])this._cColors);
                LName = "Contour_" + LName;
                aLayer = DrawMeteoData.createContourLayer((GridData)this._gridData, (LegendScheme)aLS, (String)LName, (String)fieldName, (boolean)this.smooth);
                break;
            }
            case SHADED: {
                LegendManage.setContoursAndColors((LegendScheme)aLS, (double[])this._cValues, (Color[])this._cColors);
                LName = "Shaded_" + LName;
                aLayer = DrawMeteoData.createShadedLayer((GridData)this._gridData, (LegendScheme)aLS, (String)LName, (String)fieldName, (boolean)this.smooth);
                break;
            }
            case RASTER: {
                LName = "Raster_" + LName;
                aLayer = DrawMeteoData.createRasterLayer((GridData)this._gridData, (String)LName, (LegendScheme)aLS);
                break;
            }
            case VECTOR: 
            case BARB: 
            case STREAMLINE: {
                StationData[] stUVData = this.getUVStationData();
                if (stUVData != null) {
                    StationData stUData = stUVData[0];
                    StationData stVData = stUVData[1];
                    switch (this._meteoDataInfo.getDrawType2D()) {
                        case VECTOR: 
                        case BARB: {
                            if (this.windColor) {
                                LegendManage.setContoursAndColors((LegendScheme)aLS, (double[])this._cValues, (Color[])this._cColors);
                            }
                            if (this._meteoDataInfo.getDrawType2D() == DrawType2D.VECTOR) {
                                LName = "Vector_" + LName;
                                if (this.windColor) {
                                    aLayer = DrawMeteoData.createSTVectorLayer((StationData)stUData, (StationData)stVData, (StationData)this._stationData, (LegendScheme)aLS, (String)LName, (boolean)this.meteoUVSet.isUV());
                                    break;
                                }
                                aLayer = DrawMeteoData.createSTVectorLayer((StationData)stUData, (StationData)stVData, (LegendScheme)aLS, (String)LName, (boolean)this.meteoUVSet.isUV());
                                break;
                            }
                            LName = "Barb_" + LName;
                            if (this.windColor) {
                                aLayer = DrawMeteoData.createSTBarbLayer((StationData)stUData, (StationData)stVData, (StationData)this._stationData, (LegendScheme)aLS, (String)LName, (boolean)this.meteoUVSet.isUV());
                                break;
                            }
                            aLayer = DrawMeteoData.createSTBarbLayer((StationData)stUData, (StationData)stVData, (LegendScheme)aLS, (String)LName, (boolean)this.meteoUVSet.isUV());
                            break;
                        }
                        case STREAMLINE: {
                            StationData nstVData;
                            StationData nstUData;
                            if (this._meteoDataInfo.getMeteoUVSet().isUV()) {
                                nstUData = stUData;
                                nstVData = stVData;
                            } else {
                                StationData[] uvData = DataMath.getUVFromDS((StationData)stUData, (StationData)stVData);
                                nstUData = uvData[0];
                                nstVData = uvData[1];
                            }
                            GridData UData = GeoMathUtil.interpolateData((StationData)nstUData, (InterpolationSetting)this._interpolationSetting);
                            GridData VData = GeoMathUtil.interpolateData((StationData)nstVData, (InterpolationSetting)this._interpolationSetting);
                            LName = "Streamline_" + LName;
                            aLayer = DrawMeteoData.createStreamlineLayer((GridData)UData, (GridData)VData, (int)this._strmDensity, (LegendScheme)aLS, (String)LName, (boolean)true);
                        }
                    }
                    break;
                }
                ifAddLayer = false;
                break;
            }
            case WEATHER_SYMBOL: {
                LName = "Weather_" + LName;
                aLayer = DrawMeteoData.createWeatherSymbolLayer((StationData)this._stationData, (String)this.weatherString, (String)LName);
                break;
            }
            case STATION_MODEL: {
                StationModelData stationModelData = this._meteoDataInfo.getStationModelData();
                LName = "StationModel_" + LName;
                boolean isSurface = true;
                if (this._meteoDataInfo.getDataType() == MeteoDataType.MICAPS_2) {
                    isSurface = false;
                }
                aLayer = DrawMeteoData.createStationModelLayer((StationModelData)stationModelData, (LegendScheme)aLS, (String)LName, (boolean)isSurface);
                break;
            }
            case STATION_INFO: {
                StationInfoData stInfoData = this._meteoDataInfo.getDataType() == MeteoDataType.GRADS_STATION ? this._meteoDataInfo.getStationInfoData(this.jComboBox_Time.getSelectedIndex()) : this._meteoDataInfo.getStationInfoData();
                if (stInfoData != null) {
                    aLS.setUndefValue(this._meteoDataInfo.getMissingValue());
                    LName = "StationInfo_" + LName;
                    aLayer = DrawMeteoData.createSTInfoLayer((StationInfoData)stInfoData, (LegendScheme)aLS, (String)LName);
                    break;
                }
                ifAddLayer = false;
            }
        }
        if (aLayer == null) {
            return null;
        }
        aLayer.setMaskout(true);
        aLayer.setProjInfo(this._meteoDataInfo.getProjectionInfo());
        if (aLayer.getLayerType() == LayerTypes.VECTOR_LAYER) {
            if (ifAddLayer) {
                this._lastAddedLayerHandle = aLayer.getShapeType() == ShapeTypes.POLYGON ? this._parent.getMapDocument().getActiveMapFrame().insertPolygonLayer((MapLayer)aLayer) : this._parent.getMapDocument().getActiveMapFrame().insertPolylineLayer((VectorLayer)aLayer);
            }
        } else if (ifAddLayer) {
            RasterLayer aILayer = aLayer;
            this._lastAddedLayerHandle = this._parent.getMapDocument().getActiveMapFrame().insertImageLayer((MapLayer)aILayer);
        }
        return aLayer;
    }

    private GridData[] getUVGridData() {
        if (this.meteoUVSet.getUDataInfo() == null || !this._dataInfoList.contains(this.meteoUVSet.getUDataInfo())) {
            this.meteoUVSet.setUDataInfo(this._meteoDataInfo);
            this.meteoUVSet.setVDataInfo(this._meteoDataInfo);
            this.meteoUVSet.setFixUVStr(this._meteoDataInfo.getMeteoUVSet().isFixUVStr());
            this.meteoUVSet.setUV(this._meteoDataInfo.getMeteoUVSet().isUV());
            this.meteoUVSet.setUStr(this._meteoDataInfo.getMeteoUVSet().getUStr());
            this.meteoUVSet.setVStr(this._meteoDataInfo.getMeteoUVSet().getVStr());
        }
        if (!this.meteoUVSet.isFixUVStr()) {
            ArrayList<String> vList = new ArrayList<String>();
            for (int i = 0; i < this.jComboBox_Variable.getItemCount(); ++i) {
                vList.add(this.jComboBox_Variable.getItemAt(i).toString());
            }
            if (!this.meteoUVSet.autoSetUVStr(vList)) {
                this.setMeteoUV();
            }
        }
        GridData udata = this.meteoUVSet.getUDataInfo().getGridData(this.meteoUVSet.getUStr());
        GridData vdata = this.meteoUVSet.getVDataInfo().getGridData(this.meteoUVSet.getVStr());
        if (udata == null || vdata == null) {
            return null;
        }
        if (udata.isXStagger()) {
            udata = udata.unStagger_X();
        }
        if (vdata.isYStagger()) {
            vdata = vdata.unStagger_Y();
        }
        if (this._skipY != 1 || this._skipX != 1) {
            udata = udata.skip(this._skipY, this._skipX);
            vdata = vdata.skip(this._skipY, this._skipX);
        }
        return new GridData[]{udata, vdata};
    }

    private StationData[] getUVStationData() {
        if (this.meteoUVSet.getUDataInfo() == null || !this._dataInfoList.contains(this.meteoUVSet.getUDataInfo())) {
            this.meteoUVSet.setUDataInfo(this._meteoDataInfo);
            this.meteoUVSet.setVDataInfo(this._meteoDataInfo);
            this.meteoUVSet.setFixUVStr(this._meteoDataInfo.getMeteoUVSet().isFixUVStr());
            this.meteoUVSet.setUV(this._meteoDataInfo.getMeteoUVSet().isUV());
            this.meteoUVSet.setUStr(this._meteoDataInfo.getMeteoUVSet().getUStr());
            this.meteoUVSet.setVStr(this._meteoDataInfo.getMeteoUVSet().getVStr());
        }
        if (!this.meteoUVSet.isFixUVStr()) {
            ArrayList<String> vList = new ArrayList<String>();
            for (int i = 0; i < this.jComboBox_Variable.getItemCount(); ++i) {
                vList.add(this.jComboBox_Variable.getItemAt(i).toString());
            }
            if (!this.meteoUVSet.autoSetUVStr(vList)) {
                this.meteoUVSet.setUV(false);
                this.setMeteoUV();
            }
        }
        StationData uData = this.meteoUVSet.getUDataInfo().getStationData(this.meteoUVSet.getUStr());
        StationData vData = this.meteoUVSet.getVDataInfo().getStationData(this.meteoUVSet.getVStr());
        if (uData == null || vData == null) {
            return null;
        }
        return new StationData[]{uData, vData};
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmMeteoData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmMeteoData dialog = new FrmMeteoData((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

