/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.map.config.Plugin;
import org.meteoinfo.map.config.PluginCollection;
import org.meteoinfo.map.forms.FrmMain;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteoinfo.ui.JCheckBoxList;

public class FrmPluginManager
extends JDialog {
    private final FrmMain _parent;
    PluginCollection _plugins = new PluginCollection();
    private JCheckBoxList checkBoxList_Plugin;
    private JButton jButton_UpdateList;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea_PluginDetails;

    public FrmPluginManager(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this._parent = (FrmMain)parent;
        this.initialize();
    }

    private void initialize() {
        this._plugins = this._parent.getPlugins();
        this.updatePluginCheckList();
    }

    private void updatePluginCheckList() {
        DefaultListModel<CheckBoxListEntry> listModel = new DefaultListModel<CheckBoxListEntry>();
        for (Plugin plugin : this._plugins) {
            listModel.addElement(new CheckBoxListEntry((Object)plugin, plugin.isLoad()));
        }
        this.checkBoxList_Plugin.setModel(listModel);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.checkBoxList_Plugin = new JCheckBoxList();
        this.jButton_UpdateList = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea_PluginDetails = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Plugin Manager");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Plugins"));
        this.checkBoxList_Plugin.setModel((ListModel)new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.checkBoxList_Plugin.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPluginManager.this.checkBoxList_PluginMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.checkBoxList_Plugin);
        this.jButton_UpdateList.setText("Update List");
        this.jButton_UpdateList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPluginManager.this.jButton_UpdateListActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 391, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(126, 126, 126).addComponent(this.jButton_UpdateList))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_UpdateList)));
        this.jLabel1.setText("Plugin:");
        this.jTextArea_PluginDetails.setColumns(20);
        this.jTextArea_PluginDetails.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea_PluginDetails);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jScrollPane2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 156, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void checkBoxList_PluginMouseClicked(MouseEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Plugin.getModel();
        int idx = this.checkBoxList_Plugin.getSelectedIndex();
        CheckBoxListEntry item = (CheckBoxListEntry)listModel.getElementAt(idx);
        Plugin plugin = (Plugin)((Object)item.getValue());
        if (item.isSelected()) {
            if (!plugin.isLoad()) {
                this._parent.loadPlugin(plugin);
                this._parent.validate();
            }
        } else if (plugin.isLoad()) {
            this._parent.unloadPlugin(plugin);
            this._parent.validate();
        }
        String detailStr = "Name: " + plugin.getName() + System.getProperty("line.separator") + "Author: " + plugin.getAuthor() + System.getProperty("line.separator") + "Version: " + plugin.getVersion() + System.getProperty("line.separator") + "Description: " + plugin.getDescription() + System.getProperty("line.separator") + "Jar Path: " + plugin.getJarPath() + System.getProperty("line.separator") + "Class Name: " + plugin.getClassName();
        this.jTextArea_PluginDetails.setText(detailStr);
    }

    private void jButton_UpdateListActionPerformed(ActionEvent evt) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        String pluginPath = this._parent.getPlugins().getPluginPath();
        if (new File(pluginPath).isDirectory()) {
            List fileNames = GlobalUtil.getFiles((String)pluginPath, (String)".jar");
            for (Object fn : fileNames) {
                Object plugin = this._parent.readPlugin((String)fn);
                if (plugin == null) continue;
                plugins.add((Plugin)((Object)plugin));
            }
            ArrayList<String> pluginNames = new ArrayList<String>();
            for (Object plugin : this._plugins) {
                pluginNames.add(plugin.getName());
            }
            ArrayList<String> newPluginNames = new ArrayList<String>();
            for (Plugin plugin : plugins) {
                newPluginNames.add(plugin.getName());
            }
            for (int i = 0; i < this._plugins.size(); ++i) {
                if (newPluginNames.contains(((Plugin)((Object)this._plugins.get(i))).getName())) continue;
                this._parent.removePlugin((Plugin)((Object)this._plugins.get(i)));
                this._plugins.remove(i);
                --i;
            }
            for (Plugin plugin : plugins) {
                if (pluginNames.contains(plugin.getName())) continue;
                this._plugins.add(plugin);
                try {
                    this._parent.addPlugin(plugin);
                }
                catch (IOException ex) {
                    Logger.getLogger(FrmPluginManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.updatePluginCheckList();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmPluginManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmPluginManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmPluginManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmPluginManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmPluginManager dialog = new FrmPluginManager(new FrmMain(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

