/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.print.PrintException;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointF;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.DrawType2D;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.PlotDimension;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.grads.GrADSDataInfo;
import org.meteoinfo.geo.layer.FrmLabelSet;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.layout.FrmPageSet;
import org.meteoinfo.geo.layout.LayoutLegend;
import org.meteoinfo.geo.layout.LegendStyles;
import org.meteoinfo.geo.layout.MapLayout;
import org.meteoinfo.geo.layout.MouseMode;
import org.meteoinfo.geo.legend.FrmLegendSet;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.legend.LayersLegend;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geo.legend.MapFrame;
import org.meteoinfo.geo.legend.NodeTypes;
import org.meteoinfo.geo.meteodata.DrawMeteoData;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.image.AnimatedGifEncoder;
import org.meteoinfo.map.config.GenericFileFilter;
import org.meteoinfo.map.forms.FrmDataInfo;
import org.meteoinfo.map.forms.FrmMain;
import org.meteoinfo.map.forms.FrmMeteoData;
import org.meteoinfo.map.forms.FrmUVSet;
import org.meteoinfo.map.forms.FrmViewData;

public class FrmSectionPlot
extends JFrame {
    private JButton _currentTool = null;
    private MeteoDataInfo _meteoDataInfo = new MeteoDataInfo();
    private GridData _gridData = null;
    private int _lastAddedLayerHandle;
    private PlotDimension _plotDimension;
    private List<String> _XGridStrs = new ArrayList<String>();
    private List<String> _YGridStrs = new ArrayList<String>();
    private boolean _useSameLegendScheme = false;
    private LegendScheme _legendScheme = null;
    private boolean _isLoading = false;
    private DrawType2D _2DDrawType = DrawType2D.CONTOUR;
    private int _skipY = 1;
    private int _skipX = 1;
    private double[] _CValues;
    private double[] _X;
    private double[] _Y;
    private Color[] _colors;
    private int _strmDensity = 4;
    private boolean _isSamePlotDim = false;
    private boolean _enableAnimation = true;
    private boolean _isRunning = false;
    private JButton jButton_Animator;
    private JButton jButton_ClearDraw;
    private JButton jButton_CreateAnimatorFile;
    private JButton jButton_DataInfo;
    private JButton jButton_Draw;
    private JButton jButton_DrawSetting;
    private JButton jButton_FitToScreen;
    private JButton jButton_FullExtent;
    private JButton jButton_Identifer;
    private JButton jButton_LabelSet;
    private JButton jButton_NexTime;
    private JButton jButton_PageSet;
    private JButton jButton_PageZoomIn;
    private JButton jButton_PageZoomOut;
    private JButton jButton_Pan;
    private JButton jButton_PreTime;
    private JButton jButton_SavePicture;
    private JButton jButton_SelectElement;
    private JButton jButton_ViewData;
    private JButton jButton_ZoomIn;
    private JButton jButton_ZoomOut;
    private JButton jButton_ZoomToLayer;
    private JCheckBox jCheckBox_ColorVar;
    private JCheckBox jCheckBox_Lat;
    private JCheckBox jCheckBox_Level;
    private JCheckBox jCheckBox_Lon;
    private JCheckBox jCheckBox_Time;
    private JCheckBox jCheckBox_YReverse;
    private JComboBox jComboBox_DrawType;
    private JComboBox jComboBox_Lat1;
    private JComboBox jComboBox_Lat2;
    private JComboBox jComboBox_Level1;
    private JComboBox jComboBox_Level2;
    private JComboBox jComboBox_Lon1;
    private JComboBox jComboBox_Lon2;
    private JComboBox jComboBox_PageZoom;
    private JComboBox jComboBox_PlotDim;
    private JComboBox jComboBox_Time1;
    private JComboBox jComboBox_Time2;
    private JComboBox jComboBox_Variable;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel_Coordinate;
    private JLabel jLabel_Status;
    private JLabel jLabel_Variable;
    private JList jList_Stations;
    private JPanel jPanel1;
    private JPanel jPanel_Layers;
    private JPanel jPanel_Setting;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private LayersLegend layersLegend1;
    private MapLayout mapLayout1;

    public FrmSectionPlot(MeteoDataInfo aDataInfo) {
        this.initComponents();
        this.layersLegend1.setMapLayout(this.mapLayout1);
        this.mapLayout1.getActiveMapFrame().setLayoutBounds(new Rectangle(40, 36, 606, 420));
        this.mapLayout1.getActiveMapFrame().getMapView().setGeoMap(false);
        this.jComboBox_Variable.setEditable(true);
        this.setDefaultCloseOperation(2);
        this._meteoDataInfo = aDataInfo;
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoInfo_1_16x16x8.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setIconImage(image);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton_DataInfo = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_Draw = new JButton();
        this.jButton_ViewData = new JButton();
        this.jButton_ClearDraw = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_PreTime = new JButton();
        this.jButton_NexTime = new JButton();
        this.jButton_Animator = new JButton();
        this.jButton_CreateAnimatorFile = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_DrawSetting = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButton_SelectElement = new JButton();
        this.jButton_ZoomIn = new JButton();
        this.jButton_ZoomOut = new JButton();
        this.jButton_Pan = new JButton();
        this.jButton_FullExtent = new JButton();
        this.jButton_ZoomToLayer = new JButton();
        this.jButton_Identifer = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.jButton_LabelSet = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.jButton_PageSet = new JButton();
        this.jButton_PageZoomIn = new JButton();
        this.jButton_PageZoomOut = new JButton();
        this.jButton_FitToScreen = new JButton();
        this.jComboBox_PageZoom = new JComboBox();
        this.jSeparator7 = new JToolBar.Separator();
        this.jButton_SavePicture = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel_Setting = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel_Variable = new JLabel();
        this.jComboBox_DrawType = new JComboBox();
        this.jCheckBox_YReverse = new JCheckBox();
        this.jCheckBox_ColorVar = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jComboBox_PlotDim = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jCheckBox_Time = new JCheckBox();
        this.jComboBox_Time1 = new JComboBox();
        this.jCheckBox_Level = new JCheckBox();
        this.jComboBox_Time2 = new JComboBox();
        this.jComboBox_Level1 = new JComboBox();
        this.jComboBox_Level2 = new JComboBox();
        this.jCheckBox_Lat = new JCheckBox();
        this.jComboBox_Lat1 = new JComboBox();
        this.jComboBox_Lat2 = new JComboBox();
        this.jCheckBox_Lon = new JCheckBox();
        this.jComboBox_Lon1 = new JComboBox();
        this.jComboBox_Lon2 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jList_Stations = new JList();
        this.jComboBox_Variable = new JComboBox();
        this.jPanel_Layers = new JPanel();
        this.layersLegend1 = new LayersLegend();
        this.mapLayout1 = new MapLayout();
        this.jToolBar2 = new JToolBar();
        this.jLabel_Coordinate = new JLabel();
        this.jLabel_Status = new JLabel();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("bundle/Bundle_FrmSectionPlot");
        this.setTitle(bundle.getString("FrmSectionPlot.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                FrmSectionPlot.this.formWindowOpened(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_DataInfo.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/information.svg"));
        ResourceBundle bundle1 = ResourceBundle.getBundle("bundle/Bundle_FrmMeteoData");
        this.jButton_DataInfo.setToolTipText(bundle1.getString("FrmMeteoData.jButton_DataInfo.toolTipText"));
        this.jButton_DataInfo.setFocusable(false);
        this.jButton_DataInfo.setHorizontalTextPosition(0);
        this.jButton_DataInfo.setVerticalTextPosition(3);
        this.jButton_DataInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_DataInfoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_DataInfo);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_Draw.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/draw-layer.svg"));
        this.jButton_Draw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_Draw.toolTipText"));
        this.jButton_Draw.setFocusable(false);
        this.jButton_Draw.setHorizontalTextPosition(0);
        this.jButton_Draw.setVerticalTextPosition(3);
        this.jButton_Draw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_DrawActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Draw);
        this.jButton_ViewData.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/table.svg"));
        this.jButton_ViewData.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ViewData.toolTipText"));
        this.jButton_ViewData.setFocusable(false);
        this.jButton_ViewData.setHorizontalTextPosition(0);
        this.jButton_ViewData.setVerticalTextPosition(3);
        this.jButton_ViewData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_ViewDataActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ViewData);
        this.jButton_ClearDraw.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/delete.svg"));
        this.jButton_ClearDraw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ClearDraw.toolTipText"));
        this.jButton_ClearDraw.setFocusable(false);
        this.jButton_ClearDraw.setHorizontalTextPosition(0);
        this.jButton_ClearDraw.setVerticalTextPosition(3);
        this.jButton_ClearDraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_ClearDrawActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ClearDraw);
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_PreTime.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/left-arrow.svg"));
        this.jButton_PreTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_PreTime.toolTipText"));
        this.jButton_PreTime.setFocusable(false);
        this.jButton_PreTime.setHorizontalTextPosition(0);
        this.jButton_PreTime.setVerticalTextPosition(3);
        this.jButton_PreTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_PreTimeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_PreTime);
        this.jButton_NexTime.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/right-arrow.svg"));
        this.jButton_NexTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_NexTime.toolTipText"));
        this.jButton_NexTime.setFocusable(false);
        this.jButton_NexTime.setHorizontalTextPosition(0);
        this.jButton_NexTime.setVerticalTextPosition(3);
        this.jButton_NexTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_NexTimeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_NexTime);
        this.jButton_Animator.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/animator.svg"));
        this.jButton_Animator.setFocusable(false);
        this.jButton_Animator.setHorizontalTextPosition(0);
        this.jButton_Animator.setVerticalTextPosition(3);
        this.jButton_Animator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_AnimatorActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Animator);
        this.jButton_CreateAnimatorFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/animator-file.svg"));
        this.jButton_CreateAnimatorFile.setToolTipText(bundle1.getString("FrmMeteoData.jButton_CreateAnimatorFile.toolTipText"));
        this.jButton_CreateAnimatorFile.setFocusable(false);
        this.jButton_CreateAnimatorFile.setHorizontalTextPosition(0);
        this.jButton_CreateAnimatorFile.setVerticalTextPosition(3);
        this.jButton_CreateAnimatorFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_CreateAnimatorFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_CreateAnimatorFile);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton_DrawSetting.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/legend-setting.svg"));
        this.jButton_DrawSetting.setToolTipText(bundle1.getString("FrmMeteoData.jButton_DrawSetting.toolTipText"));
        this.jButton_DrawSetting.setFocusable(false);
        this.jButton_DrawSetting.setHorizontalTextPosition(0);
        this.jButton_DrawSetting.setVerticalTextPosition(3);
        this.jButton_DrawSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_DrawSettingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_DrawSetting);
        this.jToolBar1.add(this.jSeparator4);
        this.jButton_SelectElement.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/select.svg"));
        ResourceBundle bundle2 = ResourceBundle.getBundle("bundle/Bundle_FrmMain");
        this.jButton_SelectElement.setToolTipText(bundle2.getString("FrmMain.jButton_SelectElement.toolTipText"));
        this.jButton_SelectElement.setFocusable(false);
        this.jButton_SelectElement.setHorizontalTextPosition(0);
        this.jButton_SelectElement.setVerticalTextPosition(3);
        this.jButton_SelectElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_SelectElementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectElement);
        this.jButton_ZoomIn.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/zoom-in.svg"));
        this.jButton_ZoomIn.setToolTipText(bundle2.getString("FrmMain.jButton_ZoomIn.toolTipText"));
        this.jButton_ZoomIn.setFocusable(false);
        this.jButton_ZoomIn.setHorizontalTextPosition(0);
        this.jButton_ZoomIn.setVerticalTextPosition(3);
        this.jButton_ZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_ZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ZoomIn);
        this.jButton_ZoomOut.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/zoom-out.svg"));
        this.jButton_ZoomOut.setToolTipText(bundle2.getString("FrmMain.jButton_ZoomOut.toolTipText"));
        this.jButton_ZoomOut.setFocusable(false);
        this.jButton_ZoomOut.setHorizontalTextPosition(0);
        this.jButton_ZoomOut.setVerticalTextPosition(3);
        this.jButton_ZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_ZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ZoomOut);
        this.jButton_Pan.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/hand.svg"));
        this.jButton_Pan.setToolTipText(bundle2.getString("FrmMain.jButton_Pan.toolTipText"));
        this.jButton_Pan.setFocusable(false);
        this.jButton_Pan.setHorizontalTextPosition(0);
        this.jButton_Pan.setVerticalTextPosition(3);
        this.jButton_Pan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_PanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Pan);
        this.jButton_FullExtent.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/full-extent.svg"));
        this.jButton_FullExtent.setToolTipText(bundle2.getString("FrmMain.jButton_FullExtent.toolTipText"));
        this.jButton_FullExtent.setFocusable(false);
        this.jButton_FullExtent.setHorizontalTextPosition(0);
        this.jButton_FullExtent.setVerticalTextPosition(3);
        this.jButton_FullExtent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_FullExtentActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_FullExtent);
        this.jButton_ZoomToLayer.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/zoom-layer.svg"));
        this.jButton_ZoomToLayer.setToolTipText(bundle2.getString("FrmMain.jButton_ZoomToLayer.toolTipText"));
        this.jButton_ZoomToLayer.setFocusable(false);
        this.jButton_ZoomToLayer.setHorizontalTextPosition(0);
        this.jButton_ZoomToLayer.setVerticalTextPosition(3);
        this.jButton_ZoomToLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_ZoomToLayerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ZoomToLayer);
        this.jButton_Identifer.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/information.svg"));
        this.jButton_Identifer.setToolTipText(bundle2.getString("FrmMain.jButton_Identifer.toolTipText"));
        this.jButton_Identifer.setFocusable(false);
        this.jButton_Identifer.setHorizontalTextPosition(0);
        this.jButton_Identifer.setVerticalTextPosition(3);
        this.jButton_Identifer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_IdentiferActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Identifer);
        this.jToolBar1.add(this.jSeparator5);
        this.jButton_LabelSet.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/label.svg"));
        this.jButton_LabelSet.setToolTipText(bundle2.getString("FrmMain.jButton_LabelSet.toolTipText"));
        this.jButton_LabelSet.setFocusable(false);
        this.jButton_LabelSet.setHorizontalTextPosition(0);
        this.jButton_LabelSet.setVerticalTextPosition(3);
        this.jButton_LabelSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_LabelSetActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_LabelSet);
        this.jToolBar1.add(this.jSeparator6);
        this.jButton_PageSet.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/page-setting.svg"));
        this.jButton_PageSet.setToolTipText(bundle2.getString("FrmMain.jButton_PageSet.toolTipText"));
        this.jButton_PageSet.setFocusable(false);
        this.jButton_PageSet.setHorizontalTextPosition(0);
        this.jButton_PageSet.setVerticalTextPosition(3);
        this.jButton_PageSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_PageSetActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_PageSet);
        this.jButton_PageZoomIn.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/page-zoom-in.svg"));
        this.jButton_PageZoomIn.setToolTipText(bundle2.getString("FrmMain.jButton_PageZoomIn.toolTipText"));
        this.jButton_PageZoomIn.setFocusable(false);
        this.jButton_PageZoomIn.setHorizontalTextPosition(0);
        this.jButton_PageZoomIn.setVerticalTextPosition(3);
        this.jButton_PageZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_PageZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_PageZoomIn);
        this.jButton_PageZoomOut.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/page-zoom-out.svg"));
        this.jButton_PageZoomOut.setToolTipText(bundle2.getString("FrmMain.jButton_PageZoomOut.toolTipText"));
        this.jButton_PageZoomOut.setFocusable(false);
        this.jButton_PageZoomOut.setHorizontalTextPosition(0);
        this.jButton_PageZoomOut.setVerticalTextPosition(3);
        this.jButton_PageZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_PageZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_PageZoomOut);
        this.jButton_FitToScreen.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/page-zoom-window.svg"));
        this.jButton_FitToScreen.setToolTipText(bundle2.getString("FrmMain.jButton_FitToScreen.toolTipText"));
        this.jButton_FitToScreen.setFocusable(false);
        this.jButton_FitToScreen.setHorizontalTextPosition(0);
        this.jButton_FitToScreen.setVerticalTextPosition(3);
        this.jButton_FitToScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_FitToScreenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_FitToScreen);
        this.jComboBox_PageZoom.setEditable(true);
        this.jComboBox_PageZoom.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_PageZoom.setMinimumSize(new java.awt.Dimension(60, 24));
        this.jComboBox_PageZoom.setPreferredSize(new java.awt.Dimension(80, 24));
        this.jComboBox_PageZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jComboBox_PageZoomActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jComboBox_PageZoom);
        this.jToolBar1.add(this.jSeparator7);
        this.jButton_SavePicture.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/map/icons/figure-output.svg"));
        this.jButton_SavePicture.setToolTipText(bundle2.getString("FrmMain.jButton_SavePicture.toolTipText"));
        this.jButton_SavePicture.setFocusable(false);
        this.jButton_SavePicture.setHorizontalTextPosition(0);
        this.jButton_SavePicture.setVerticalTextPosition(3);
        this.jButton_SavePicture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jButton_SavePictureActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SavePicture);
        this.jSplitPane1.setDividerLocation(250);
        this.jLabel3.setText(bundle.getString("FrmSectionPlot.jLabel3.text"));
        this.jLabel_Variable.setText(bundle.getString("FrmSectionPlot.jLabel_Variable.text"));
        this.jComboBox_DrawType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DrawType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jComboBox_DrawTypeActionPerformed(evt);
            }
        });
        this.jCheckBox_YReverse.setText(bundle.getString("FrmSectionPlot.jCheckBox_YReverse.text"));
        this.jCheckBox_ColorVar.setText(bundle.getString("FrmSectionPlot.jCheckBox_ColorVar.text"));
        this.jLabel4.setText(bundle.getString("FrmSectionPlot.jLabel4.text"));
        this.jComboBox_PlotDim.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_PlotDim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jComboBox_PlotDimActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("FrmSectionPlot.jPanel1.border.title")));
        this.jCheckBox_Time.setText(bundle.getString("FrmSectionPlot.jCheckBox_Time.text"));
        this.jCheckBox_Time.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmSectionPlot.this.jCheckBox_TimeStateChanged(evt);
            }
        });
        this.jComboBox_Time1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox_Level.setText(bundle.getString("FrmSectionPlot.jCheckBox_Level.text"));
        this.jCheckBox_Level.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmSectionPlot.this.jCheckBox_LevelStateChanged(evt);
            }
        });
        this.jComboBox_Time2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Level1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Level2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox_Lat.setText(bundle.getString("FrmSectionPlot.jCheckBox_Lat.text"));
        this.jCheckBox_Lat.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmSectionPlot.this.jCheckBox_LatStateChanged(evt);
            }
        });
        this.jComboBox_Lat1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Lat2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox_Lon.setText(bundle.getString("FrmSectionPlot.jCheckBox_Lon.text"));
        this.jCheckBox_Lon.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmSectionPlot.this.jCheckBox_LonStateChanged(evt);
            }
        });
        this.jComboBox_Lon1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Lon2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jList_Stations.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList_Stations);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox_Lat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Lat2, 0, 213, Short.MAX_VALUE).addComponent(this.jComboBox_Lat1, 0, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox_Lon).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Lon1, 0, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jComboBox_Lon2, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_Level).addComponent(this.jCheckBox_Time)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Time1, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Time2, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Level1, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Level2, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Time).addComponent(this.jComboBox_Time1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Time2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Level).addComponent(this.jComboBox_Level1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Level2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Lat).addComponent(this.jComboBox_Lat1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Lat2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Lon).addComponent(this.jComboBox_Lon1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Lon2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 72, Short.MAX_VALUE)));
        this.jComboBox_Variable.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Variable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSectionPlot.this.jComboBox_VariableActionPerformed(evt);
            }
        });
        GroupLayout jPanel_SettingLayout = new GroupLayout(this.jPanel_Setting);
        this.jPanel_Setting.setLayout(jPanel_SettingLayout);
        jPanel_SettingLayout.setHorizontalGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SettingLayout.createSequentialGroup().addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel_SettingLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SettingLayout.createSequentialGroup().addComponent(this.jCheckBox_YReverse).addGap(18, 18, 18).addComponent(this.jCheckBox_ColorVar).addGap(0, 4, Short.MAX_VALUE)).addGroup(jPanel_SettingLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_PlotDim, 0, -1, Short.MAX_VALUE)).addGroup(jPanel_SettingLayout.createSequentialGroup().addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SettingLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(8, 8, 8)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_SettingLayout.createSequentialGroup().addComponent(this.jLabel_Variable).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_DrawType, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Variable, 0, -1, Short.MAX_VALUE)))))).addContainerGap()));
        jPanel_SettingLayout.setVerticalGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SettingLayout.createSequentialGroup().addGap(9, 9, 9).addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Variable).addComponent(this.jComboBox_Variable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox_DrawType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_YReverse).addComponent(this.jCheckBox_ColorVar)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_SettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBox_PlotDim, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("FrmSectionPlot.jPanel_Setting.TabConstraints.tabTitle"), this.jPanel_Setting);
        GroupLayout jPanel_LayersLayout = new GroupLayout(this.jPanel_Layers);
        this.jPanel_Layers.setLayout(jPanel_LayersLayout);
        jPanel_LayersLayout.setHorizontalGroup(jPanel_LayersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.layersLegend1, GroupLayout.Alignment.TRAILING, -1, 244, Short.MAX_VALUE));
        jPanel_LayersLayout.setVerticalGroup(jPanel_LayersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.layersLegend1, -1, 520, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(bundle.getString("FrmSectionPlot.jPanel_Layers.TabConstraints.tabTitle"), this.jPanel_Layers);
        this.jSplitPane1.setLeftComponent(this.jTabbedPane1);
        this.jSplitPane1.setRightComponent((Component)this.mapLayout1);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jLabel_Coordinate.setText(bundle2.getString("FrmMain.jLabel_Coordinate.text"));
        this.jLabel_Coordinate.setPreferredSize(new java.awt.Dimension(80, 15));
        this.jToolBar2.add(this.jLabel_Coordinate);
        this.jLabel_Status.setText(bundle2.getString("FrmMain.jLabel_Status.text"));
        this.jToolBar2.add(this.jLabel_Status);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1).addComponent(this.jToolBar2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 666, -2).addGap(0, 134, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar2, -2, 25, -2)));
        this.pack();
    }

    private void jButton_DataInfoActionPerformed(ActionEvent evt) {
        FrmDataInfo frmDI = new FrmDataInfo();
        frmDI.setLocationRelativeTo(this);
        frmDI.setText(this._meteoDataInfo.getInfoText());
        frmDI.setVisible(true);
    }

    private void jButton_DrawActionPerformed(ActionEvent evt) {
        MapLayer aLayer;
        if (this.jComboBox_PlotDim.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(null, "It's not a muti dimension variable: " + this.jComboBox_Variable.getSelectedItem().toString() + "!");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._plotDimension = PlotDimension.valueOf((String)this.jComboBox_PlotDim.getSelectedItem().toString());
        this._meteoDataInfo.setDimensionSet(this._plotDimension);
        this._meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());
        this._meteoDataInfo.setLevelIndex(this.jComboBox_Lat1.getSelectedIndex());
        this._meteoDataInfo.setLatIndex(this.jComboBox_Lat1.getSelectedIndex());
        this._meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());
        this.getXYGridStrs();
        this.mapLayout1.getActiveMapFrame().getMapView().setXGridStrs(new ArrayList<String>(this._XGridStrs));
        this.mapLayout1.getActiveMapFrame().getMapView().setYGridStrs(new ArrayList<String>(this._YGridStrs));
        switch (this._meteoDataInfo.getDataType()) {
            case GRADS_GRID: 
            case HYSPLIT_CONC: 
            case ARL_GRID: 
            case NETCDF: 
            case GRIB1: 
            case GRIB2: {
                this.getGridData();
                this.drawGrid();
                break;
            }
            case GRADS_STATION: {
                this._gridData = ((GrADSDataInfo)this._meteoDataInfo.getDataInfo()).getGridData_Station(this.jComboBox_Variable.getSelectedIndex(), this.jList_Stations.getSelectedValuesList().get(0).toString());
                this.drawGrid();
            }
        }
        if (!this._useSameLegendScheme && (aLayer = this.mapLayout1.getActiveMapFrame().getMapView().getLayerByHandle(this._lastAddedLayerHandle)) != null) {
            VectorLayer sLayer = (VectorLayer)aLayer;
            if (sLayer.getExtent().maxX > sLayer.getExtent().minX && sLayer.getExtent().maxY > sLayer.getExtent().minY) {
                this.zoomToExtent(sLayer.getExtent());
            }
        }
        this.jButton_DrawSetting.setEnabled(true);
        if (!this.jCheckBox_Time.isSelected() && this.jComboBox_Time1.getItemCount() > 1) {
            this.jButton_NexTime.setEnabled(true);
            this.jButton_PreTime.setEnabled(true);
            this.jButton_Animator.setEnabled(true);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void display() {
        MapLayer aLayer;
        this._plotDimension = PlotDimension.valueOf((String)this.jComboBox_PlotDim.getSelectedItem().toString());
        this._meteoDataInfo.setDimensionSet(this._plotDimension);
        this._meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());
        this._meteoDataInfo.setLevelIndex(this.jComboBox_Lat1.getSelectedIndex());
        this._meteoDataInfo.setLatIndex(this.jComboBox_Lat1.getSelectedIndex());
        this._meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());
        this.getXYGridStrs();
        this.mapLayout1.getActiveMapFrame().getMapView().setXGridStrs(new ArrayList<String>(this._XGridStrs));
        this.mapLayout1.getActiveMapFrame().getMapView().setYGridStrs(new ArrayList<String>(this._YGridStrs));
        switch (this._meteoDataInfo.getDataType()) {
            case GRADS_GRID: 
            case HYSPLIT_CONC: 
            case ARL_GRID: 
            case NETCDF: 
            case GRIB1: 
            case GRIB2: {
                this.getGridData();
                this.drawGrid();
                break;
            }
            case GRADS_STATION: {
                this._gridData = ((GrADSDataInfo)this._meteoDataInfo.getDataInfo()).getGridData_Station(this.jComboBox_Variable.getSelectedIndex(), this.jList_Stations.getSelectedValuesList().get(0).toString());
                this.drawGrid();
            }
        }
        if (!this._useSameLegendScheme && (aLayer = this.mapLayout1.getActiveMapFrame().getMapView().getLayerByHandle(this._lastAddedLayerHandle)) != null) {
            VectorLayer sLayer = (VectorLayer)aLayer;
            if (sLayer.getExtent().maxX > sLayer.getExtent().minX && sLayer.getExtent().maxY > sLayer.getExtent().minY) {
                this.zoomToExtent(sLayer.getExtent());
            }
        }
    }

    private void jButton_ViewDataActionPerformed(ActionEvent evt) {
        if (this._gridData == null) {
            return;
        }
        if (this._gridData.getData() == null) {
            return;
        }
        if (this._gridData.getData().length == 0) {
            return;
        }
        FrmViewData frmData = new FrmViewData();
        frmData.setGridData(this._gridData);
        frmData.setLocationRelativeTo(this);
        frmData.setVisible(true);
    }

    private void jButton_ClearDrawActionPerformed(ActionEvent evt) {
        this.layersLegend1.getActiveMapFrame().removeAllLayers();
    }

    private void jButton_PreTimeActionPerformed(ActionEvent evt) {
        this._useSameLegendScheme = true;
        if (this.jComboBox_Time1.getSelectedIndex() > 0) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() - 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getItemCount() - 1);
        }
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(true);
        this.layersLegend1.getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(false);
        this.jButton_Draw.doClick();
    }

    private void jButton_NexTimeActionPerformed(ActionEvent evt) {
        this._useSameLegendScheme = true;
        if (this.jComboBox_Time1.getSelectedIndex() < this.jComboBox_Time1.getItemCount() - 1) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() + 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(0);
        }
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(true);
        this.layersLegend1.getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(false);
        this.jButton_Draw.doClick();
    }

    private void jButton_AnimatorActionPerformed(ActionEvent evt) {
        if (this._isRunning) {
            this._enableAnimation = false;
        } else {
            this.run_Animation(false);
        }
    }

    private void run_Animation(final boolean isCreateFile) {
        final AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        if (isCreateFile) {
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"gif"};
            GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif File (*.gif)");
            aDlg.setFileFilter(mapFileFilter);
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
            aDlg.setAcceptAllFileFilterUsed(false);
            if (aDlg.showSaveDialog(this) == 0) {
                File file = aDlg.getSelectedFile();
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                String fileName = file.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                encoder.setRepeat(0);
                encoder.setDelay(1000);
                encoder.start(fileName);
            }
        }
        switch (this._meteoDataInfo.getDataType()) {
            default: 
        }
        if (this.jComboBox_Time1.getItemCount() > 1) {
            SwingWorker<String, String> worker = new SwingWorker<String, String>(){

                @Override
                protected String doInBackground() throws Exception {
                    FrmSectionPlot.this.jButton_Animator.setIcon(new ImageIcon(this.getClass().getResource("/images/stop.png")));
                    FrmSectionPlot.this._isRunning = true;
                    FrmSectionPlot.this._useSameLegendScheme = true;
                    for (int i = 0; i < FrmSectionPlot.this.jComboBox_Time1.getItemCount(); ++i) {
                        if (!FrmSectionPlot.this._enableAnimation) {
                            FrmSectionPlot.this._enableAnimation = true;
                            FrmSectionPlot.this._isRunning = false;
                            FrmSectionPlot.this.jButton_Animator.setIcon(new ImageIcon(this.getClass().getResource("/images/animation-1.png")));
                            return "";
                        }
                        FrmSectionPlot.this.jComboBox_Time1.setSelectedIndex(i);
                        FrmSectionPlot.this.layersLegend1.getActiveMapFrame().getMapView().setLockViewUpdate(true);
                        FrmSectionPlot.this.layersLegend1.getActiveMapFrame().removeLayerByHandle(FrmSectionPlot.this._lastAddedLayerHandle);
                        FrmSectionPlot.this.layersLegend1.getActiveMapFrame().getMapView().setLockViewUpdate(false);
                        FrmSectionPlot.this.display();
                        if (isCreateFile) {
                            encoder.addFrame(FrmSectionPlot.this.layersLegend1.getActiveMapFrame().getMapView().getViewImage());
                            continue;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FrmMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    FrmSectionPlot.this._enableAnimation = true;
                    FrmSectionPlot.this._isRunning = false;
                    FrmSectionPlot.this.jButton_Animator.setIcon(new ImageIcon(this.getClass().getResource("/images/animation-1.png")));
                    encoder.finish();
                    return "";
                }
            };
            worker.execute();
        }
    }

    private void jButton_CreateAnimatorFileActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.run_Animation(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_DrawSettingActionPerformed(ActionEvent evt) {
        MapLayer aLayer = this.layersLegend1.getActiveMapFrame().getMapView().getLayerByHandle(this._lastAddedLayerHandle);
        FrmLegendSet aFrmLS = new FrmLegendSet((Frame)this, true);
        aFrmLS.setLegendScheme(this._legendScheme);
        String fieldName = this.jComboBox_Variable.getSelectedItem().toString();
        aFrmLS.setLocationRelativeTo((Component)this);
        aFrmLS.setVisible(true);
        if (aFrmLS.isOK()) {
            this.layersLegend1.getActiveMapFrame().removeLayerByHandle(this._lastAddedLayerHandle);
            this._legendScheme = aFrmLS.getLegendScheme();
            this.drawMeteoMap(false, this._legendScheme);
            this.layersLegend1.getActiveMapFrame().getMapView().paintLayers();
        }
    }

    private void jButton_SelectElementActionPerformed(ActionEvent evt) {
        this.mapLayout1.setMouseMode(MouseMode.SELECT);
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_ZoomInActionPerformed(ActionEvent evt) {
        this.mapLayout1.setMouseMode(MouseMode.MAP_ZOOM_IN);
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_ZoomOutActionPerformed(ActionEvent evt) {
        this.mapLayout1.setMouseMode(MouseMode.MAP_ZOOM_OUT);
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_PanActionPerformed(ActionEvent evt) {
        this.mapLayout1.setMouseMode(MouseMode.MAP_PAN);
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_FullExtentActionPerformed(ActionEvent evt) {
        this.mapLayout1.getActiveMapFrame().getMapView().zoomToExtent(this.mapLayout1.getActiveMapFrame().getMapView().getExtent());
    }

    private void jButton_ZoomToLayerActionPerformed(ActionEvent evt) {
        if (this.layersLegend1.getSelectedNode() == null) {
            return;
        }
        if (this.layersLegend1.getSelectedNode().getNodeType() == NodeTypes.LAYER_NODE) {
            MapFrame aMF = this.layersLegend1.getCurrentMapFrame();
            MapLayer aLayer = ((LayerNode)this.layersLegend1.getSelectedNode()).getMapLayer();
            if (aLayer != null) {
                aMF.getMapView().zoomToExtent(aLayer.getExtent());
            }
        }
    }

    private void jButton_IdentiferActionPerformed(ActionEvent evt) {
        this.mapLayout1.setMouseMode(MouseMode.MAP_IDENTIFIER);
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_LabelSetActionPerformed(ActionEvent evt) {
        VectorLayer aLayer;
        LayerNode aLN;
        MapLayer aMLayer;
        if (this.layersLegend1.getSelectedNode() == null) {
            return;
        }
        if (this.layersLegend1.getSelectedNode().getNodeType() == NodeTypes.LAYER_NODE && (aMLayer = (aLN = (LayerNode)this.layersLegend1.getSelectedNode()).getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle())).getLayerType() == LayerTypes.VECTOR_LAYER && (aLayer = (VectorLayer)aMLayer).getShapeNum() > 0) {
            FrmLabelSet aFrmLabel = new FrmLabelSet((Frame)this, false, this.layersLegend1.getActiveMapFrame().getMapView());
            aFrmLabel.setLayer(aLayer);
            aFrmLabel.setLocationRelativeTo((Component)this);
            aFrmLabel.setVisible(true);
        }
    }

    private void jButton_PageSetActionPerformed(ActionEvent evt) {
        FrmPageSet aFrmPageSet = new FrmPageSet((Frame)this, true);
        aFrmPageSet.setMapLayout(this.mapLayout1);
        aFrmPageSet.setPaperSize(this.layersLegend1.getMapLayout().getPaperSize());
        aFrmPageSet.setLandscape(this.layersLegend1.getMapLayout().isLandscape());
        aFrmPageSet.setLocationRelativeTo((Component)this);
        aFrmPageSet.setVisible(true);
    }

    private void jButton_PageZoomInActionPerformed(ActionEvent evt) {
        this.mapLayout1.setZoom(this.mapLayout1.getZoom() * 1.2f);
        this.mapLayout1.paintGraphics();
    }

    private void jButton_PageZoomOutActionPerformed(ActionEvent evt) {
        this.mapLayout1.setZoom(this.mapLayout1.getZoom() * 0.8f);
        this.mapLayout1.paintGraphics();
    }

    private void jButton_FitToScreenActionPerformed(ActionEvent evt) {
        float zoomX = (float)this.layersLegend1.getMapLayout().getWidth() / (float)this.layersLegend1.getMapLayout().getPageBounds().width;
        float zoomY = (float)this.layersLegend1.getMapLayout().getHeight() / (float)this.layersLegend1.getMapLayout().getPageBounds().height;
        float zoom = Math.min(zoomX, zoomY);
        PointF aP = new PointF(0.0f, 0.0f);
        this.layersLegend1.getMapLayout().setPageLocation(aP);
        this.layersLegend1.getMapLayout().setZoom(zoom);
        this.layersLegend1.getMapLayout().paintGraphics();
    }

    private void jComboBox_PageZoomActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        String zoomStr = this.jComboBox_PageZoom.getSelectedItem().toString().trim();
        if (zoomStr.endsWith("%")) {
            zoomStr = zoomStr.substring(0, zoomStr.length() - 1);
        }
        try {
            float zoom = Float.parseFloat(zoomStr);
            this.layersLegend1.getMapLayout().setZoom(zoom / 100.0f);
            this.layersLegend1.getMapLayout().paintGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton_SavePictureActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"png"};
        GenericFileFilter pngFileFilter = new GenericFileFilter(fileExts, "Png Image (*.png)");
        aDlg.addChoosableFileFilter(pngFileFilter);
        fileExts = new String[]{"gif"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif Image (*.gif)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"jpg"};
        mapFileFilter = new GenericFileFilter(fileExts, "Jpeg Image (*.jpg)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"eps"};
        mapFileFilter = new GenericFileFilter(fileExts, "EPS file (*.eps)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"pdf"};
        mapFileFilter = new GenericFileFilter(fileExts, "PDF file (*.pdf)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"emf"};
        mapFileFilter = new GenericFileFilter(fileExts, "EMF file (*.emf)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"ps"};
        mapFileFilter = new GenericFileFilter(fileExts, "Postscript file (*.ps)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        aDlg.setFileFilter(pngFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        if (0 == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = aFile.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            try {
                this.layersLegend1.getMapLayout().exportToPicture(fileName);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (PrintException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        String[] zooms;
        this._isLoading = true;
        this.setSize(1020, 600);
        LayoutLegend legend = this.mapLayout1.addLegend(660, 100);
        legend.setLegendStyle(LegendStyles.BAR_VERTICAL);
        legend.setWidth(36);
        legend.setHeight(295);
        this.mapLayout1.addText("MeteoInfo: Meteorological Data Infomation System", 320, 20, "Arial", 16.0f);
        this.mapLayout1.paintGraphics();
        this.jComboBox_PageZoom.removeAllItems();
        for (String zoom : zooms = new String[]{"20%", "50%", "75%", "100%", "150%", "200%", "300%"}) {
            this.jComboBox_PageZoom.addItem(zoom);
        }
        this.jComboBox_PageZoom.setSelectedItem(String.valueOf((int)(this.mapLayout1.getZoom() * 100.0f)) + "%");
        this.jButton_SelectElement.doClick();
        this.jComboBox_Lat2.setVisible(false);
        this.jComboBox_Level2.setVisible(false);
        this.jComboBox_Lon2.setVisible(false);
        this.jComboBox_Time2.setVisible(false);
        this.jCheckBox_Time.setEnabled(false);
        this.jCheckBox_Level.setEnabled(false);
        this.jCheckBox_Lon.setEnabled(false);
        this.jCheckBox_Lat.setEnabled(false);
        this.jCheckBox_ColorVar.setVisible(false);
        this.updateDimensions();
        this._isLoading = true;
        this.jComboBox_DrawType.removeAllItems();
        switch (this._meteoDataInfo.getDataType()) {
            case HYSPLIT_PARTICLE: {
                this.jComboBox_DrawType.addItem(DrawType2D.STATION_POINT);
                break;
            }
            default: {
                this.jComboBox_DrawType.addItem(DrawType2D.CONTOUR);
                this.jComboBox_DrawType.addItem(DrawType2D.SHADED);
                this.jComboBox_DrawType.addItem(DrawType2D.GRID_FILL);
                this.jComboBox_DrawType.addItem(DrawType2D.GRID_POINT);
                this.jComboBox_DrawType.addItem(DrawType2D.VECTOR);
                this.jComboBox_DrawType.addItem(DrawType2D.BARB);
                this.jComboBox_DrawType.addItem(DrawType2D.STREAMLINE);
            }
        }
        this.jComboBox_DrawType.setSelectedIndex(0);
        if (this._meteoDataInfo.isGridData()) {
            this.jList_Stations.setVisible(false);
            this.jScrollPane1.setVisible(false);
        } else {
            this.jList_Stations.setVisible(true);
            this.jScrollPane1.setVisible(true);
            this.jCheckBox_Lat.setVisible(false);
            this.jCheckBox_Lon.setVisible(false);
            this.jComboBox_Lat1.setVisible(false);
            this.jComboBox_Lat2.setVisible(false);
            this.jComboBox_Lon1.setVisible(false);
            this.jComboBox_Lon2.setVisible(false);
        }
        this._isLoading = false;
    }

    private void jComboBox_VariableActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        this._useSameLegendScheme = false;
        Variable var = this._meteoDataInfo.getDataInfo().getVariable(this.jComboBox_Variable.getSelectedItem().toString());
        if (var == null) {
            return;
        }
        this._meteoDataInfo.setVariableName((String)this.jComboBox_Variable.getSelectedItem());
        this.setVariableParas(var);
        this.updateEndDimSetS(this.jComboBox_Level1, this.jComboBox_Level2);
        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
        this._isLoading = true;
        String pdStr = this.jComboBox_PlotDim.getSelectedItem().toString();
        this.jComboBox_PlotDim.removeAllItems();
        if (this._meteoDataInfo.isGridData()) {
            if (this.jComboBox_Level1.getItemCount() > 1) {
                this.jComboBox_PlotDim.addItem(PlotDimension.Level_Lat.toString());
                this.jComboBox_PlotDim.addItem(PlotDimension.Level_Lon.toString());
            }
            if (this.jComboBox_Time1.getItemCount() > 1) {
                this.jComboBox_PlotDim.addItem(PlotDimension.Time_Lat.toString());
                this.jComboBox_PlotDim.addItem(PlotDimension.Time_Lon.toString());
            }
        }
        if (this.jComboBox_Level1.getItemCount() > 1 && this.jComboBox_Time1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Level_Time.toString());
        }
        ArrayList<String> dimItems = new ArrayList<String>();
        for (int i = 0; i < this.jComboBox_PlotDim.getItemCount(); ++i) {
            dimItems.add(this.jComboBox_PlotDim.getItemAt(i).toString());
        }
        this._isLoading = false;
        if (!"".equals(pdStr) && dimItems.contains(pdStr)) {
            this._isSamePlotDim = true;
            this.jComboBox_PlotDim.setSelectedItem(pdStr);
        } else {
            this._isSamePlotDim = false;
            if (this.jComboBox_PlotDim.getItemCount() > 0) {
                this.jComboBox_PlotDim.setSelectedIndex(0);
            }
        }
    }

    private void jComboBox_PlotDimActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        this._plotDimension = PlotDimension.valueOf((String)this.jComboBox_PlotDim.getSelectedItem().toString());
        this._meteoDataInfo.setDimensionSet(this._plotDimension);
        switch (this._plotDimension) {
            case Level_Lat: 
            case Level_Lon: 
            case Level_Time: {
                this.jCheckBox_YReverse.setVisible(true);
                break;
            }
            default: {
                this.jCheckBox_YReverse.setVisible(false);
            }
        }
        this.setDimensions();
        if (!this._isSamePlotDim && this.mapLayout1.getActiveMapFrame().getMapView().getLayerNum() > 0) {
            this.layersLegend1.getActiveMapFrame().removeMeteoLayers();
        }
        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
    }

    private void jComboBox_DrawTypeActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        this._2DDrawType = DrawType2D.valueOf((String)this.jComboBox_DrawType.getSelectedItem().toString());
        this.jButton_Draw.setEnabled(true);
        this._useSameLegendScheme = false;
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
        switch (this._2DDrawType) {
            case VECTOR: 
            case BARB: {
                this.jCheckBox_ColorVar.setVisible(true);
                break;
            }
            default: {
                this.jCheckBox_ColorVar.setVisible(false);
            }
        }
    }

    private void jCheckBox_TimeStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Time2.setVisible(this.jCheckBox_Time.isSelected());
        if (this.jCheckBox_Time.isSelected()) {
            if (this.jComboBox_Time1.getItemCount() > 0) {
                this.jComboBox_Time1.setSelectedIndex(0);
                this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);
            }
            this.jComboBox_Time1.setEnabled(false);
            this.jComboBox_Time2.setEnabled(false);
        } else {
            this.jComboBox_Time1.setEnabled(true);
            this.jComboBox_Time2.setEnabled(true);
        }
    }

    private void jCheckBox_LevelStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Level2.setVisible(this.jCheckBox_Level.isSelected());
        if (this.jCheckBox_Level.isSelected()) {
            if (this.jComboBox_Level1.getItemCount() > 0) {
                this.jComboBox_Level1.setSelectedIndex(0);
                this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);
            }
            this.jComboBox_Level1.setEnabled(false);
            this.jComboBox_Level2.setEnabled(false);
        } else {
            this.jComboBox_Level1.setEnabled(true);
            this.jComboBox_Level2.setEnabled(true);
        }
    }

    private void jCheckBox_LatStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Lat2.setVisible(this.jCheckBox_Lat.isSelected());
        if (this.jCheckBox_Lat.isSelected()) {
            if (this.jComboBox_Lat1.getItemCount() > 0) {
                this.jComboBox_Lat1.setSelectedIndex(0);
                this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
            }
            this.jComboBox_Lat1.setEnabled(false);
            this.jComboBox_Lat2.setEnabled(false);
        } else {
            this.jComboBox_Lat1.setEnabled(true);
            this.jComboBox_Lat2.setEnabled(true);
        }
    }

    private void jCheckBox_LonStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Lon2.setVisible(this.jCheckBox_Lon.isSelected());
        if (this.jCheckBox_Lon.isSelected()) {
            if (this.jComboBox_Lon1.getItemCount() > 0) {
                this.jComboBox_Lon1.setSelectedIndex(0);
                this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);
            }
            this.jComboBox_Lon1.setEnabled(false);
            this.jComboBox_Lon2.setEnabled(false);
        } else {
            this.jComboBox_Lon1.setEnabled(true);
            this.jComboBox_Lon2.setEnabled(true);
        }
    }

    private void setVariableParas(Variable var) {
        int levelIdx = this.jComboBox_Level1.getSelectedIndex();
        this.jComboBox_Level1.removeAllItems();
        Dimension zDim = var.getZDimension();
        if (zDim == null) {
            this.jComboBox_Level1.addItem("Surface");
            this.jComboBox_Level1.setSelectedIndex(0);
        } else {
            for (int i = 0; i < var.getLevelNum(); ++i) {
                this.jComboBox_Level1.addItem(String.valueOf(zDim.getDimValue().getDouble(i)));
            }
            if (levelIdx > -1 && this.jComboBox_Level1.getItemCount() > levelIdx) {
                this.jComboBox_Level1.setSelectedIndex(levelIdx);
            } else {
                this.jComboBox_Level1.setSelectedIndex(0);
            }
        }
    }

    private void updateDimensions() {
        int i;
        this.jComboBox_Time1.removeAllItems();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getTimeNum(); ++i) {
            this.jComboBox_Time1.addItem(sdf.format((TemporalAccessor)this._meteoDataInfo.getDataInfo().getTimes().get(i)));
        }
        this.jComboBox_Time1.setSelectedIndex(0);
        this.jComboBox_Lon1.removeAllItems();
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getXDimension().getLength(); ++i) {
            this.jComboBox_Lon1.addItem(String.valueOf(this._meteoDataInfo.getDataInfo().getXDimension().getDimValue().getDouble(i)));
        }
        this.jComboBox_Lon1.setSelectedIndex(0);
        this.jComboBox_Lat1.removeAllItems();
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getYDimension().getLength(); ++i) {
            this.jComboBox_Lat1.addItem(String.valueOf(this._meteoDataInfo.getDataInfo().getYDimension().getDimValue().getDouble(i)));
        }
        this.jComboBox_Lat1.setSelectedIndex(0);
        this.updateEndDimSet();
        this.jComboBox_Variable.setEnabled(true);
        this.jComboBox_Variable.removeAllItems();
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getVariableNum(); ++i) {
            Variable var = (Variable)this._meteoDataInfo.getDataInfo().getVariables().get(i);
            if (!var.isPlottable() || var.getDimNumber() == 2 && var.getDimension(DimensionType.T) == null && var.getDimension(DimensionType.Z) == null) continue;
            this.jComboBox_Variable.addItem(var.getName());
        }
        this._isLoading = false;
        this.jComboBox_Variable.setSelectedIndex(0);
    }

    private void updateEndDimSet() {
        int i;
        this.jComboBox_Time2.removeAllItems();
        for (i = 0; i < this.jComboBox_Time1.getItemCount(); ++i) {
            this.jComboBox_Time2.addItem(this.jComboBox_Time1.getItemAt(i));
        }
        this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);
        this.jComboBox_Level2.removeAllItems();
        for (i = 0; i < this.jComboBox_Level1.getItemCount(); ++i) {
            this.jComboBox_Level2.addItem(this.jComboBox_Level1.getItemAt(i));
        }
        this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);
        this.jComboBox_Lon2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lon1.getItemCount(); ++i) {
            this.jComboBox_Lon2.addItem(this.jComboBox_Lon1.getItemAt(i));
        }
        this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);
        this.jComboBox_Lat2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lat1.getItemCount(); ++i) {
            this.jComboBox_Lat2.addItem(this.jComboBox_Lat1.getItemAt(i));
        }
        this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
    }

    private void updateEndDimSetS(JComboBox CB1, JComboBox CB2) {
        CB2.removeAllItems();
        for (int i = 0; i < CB1.getItemCount(); ++i) {
            CB2.addItem(CB1.getItemAt(i));
        }
        CB2.setSelectedIndex(CB2.getItemCount() - 1);
    }

    private void setDimensions() {
        switch (this._plotDimension) {
            case Time_Lon: {
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(true);
                break;
            }
            case Time_Lat: {
                this.jCheckBox_Lat.setSelected(true);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(false);
                break;
            }
            case Level_Time: {
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(false);
                break;
            }
            case Level_Lon: {
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(true);
                break;
            }
            case Level_Lat: {
                this.jCheckBox_Lat.setSelected(true);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(false);
            }
        }
    }

    private void setCurrentTool(JButton currentTool) {
        if (this._currentTool != null) {
            this._currentTool.setSelected(false);
        }
        this._currentTool = currentTool;
        this._currentTool.setSelected(true);
        this.jLabel_Status.setText(this._currentTool.getToolTipText());
    }

    public void drawMeteoMap(boolean isNew, LegendScheme aLS) {
        switch (this._meteoDataInfo.getDataType()) {
            case GRADS_GRID: 
            case HYSPLIT_CONC: 
            case ARL_GRID: 
            case NETCDF: 
            case GRIB1: 
            case GRIB2: 
            case GRADS_STATION: 
            case MICAPS_4: {
                this.drawMeteoMap_Grid(isNew, aLS);
            }
        }
    }

    private void drawMeteoMap_Grid(Boolean isNew, LegendScheme aLS) {
        VectorLayer aLayer = null;
        String LName = this.getLayerName(this._plotDimension);
        String fieldName = this.jComboBox_Variable.getSelectedItem().toString();
        switch (this._2DDrawType) {
            case CONTOUR: {
                aLayer = DrawMeteoData.createContourLayer((GridData)this._gridData, (LegendScheme)aLS, (String)LName, (String)fieldName, (boolean)true);
                aLayer.addLabelsContourDynamic(this.layersLegend1.getActiveMapFrame().getMapView().getViewExtent());
                break;
            }
            case SHADED: {
                aLayer = DrawMeteoData.createShadedLayer((GridData)this._gridData, (LegendScheme)aLS, (String)LName, (String)fieldName, (boolean)true);
                break;
            }
            case GRID_FILL: {
                aLayer = DrawMeteoData.createGridFillLayer((GridData)this._gridData, (LegendScheme)aLS, (String)LName, (String)fieldName);
                break;
            }
            case GRID_POINT: {
                aLayer = DrawMeteoData.createGridPointLayer((GridData)this._gridData, (LegendScheme)aLS, (String)LName, (String)fieldName);
                break;
            }
            case VECTOR: {
                GridData[] uvData = this.getUVGridData();
                if (uvData == null) break;
                GridData uData = uvData[0];
                GridData vData = uvData[1];
                aLayer = DrawMeteoData.createGridVectorLayer((GridData)uData, (GridData)vData, (GridData)this._gridData, (LegendScheme)aLS, (boolean)this.jCheckBox_ColorVar.isSelected(), (String)LName, (boolean)this._meteoDataInfo.getMeteoUVSet().isUV());
                break;
            }
            case BARB: {
                GridData[] uvData = this.getUVGridData();
                if (uvData == null) break;
                GridData uData = uvData[0];
                GridData vData = uvData[1];
                this.setXYCoords(uData);
                this.setXYCoords(vData);
                if (this.jCheckBox_ColorVar.isSelected()) {
                    Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)aLS);
                    this._CValues = (double[])ccs[0];
                    this._colors = (Color[])ccs[1];
                }
                aLayer = DrawMeteoData.createGridBarbLayer((GridData)uData, (GridData)vData, (GridData)this._gridData, (LegendScheme)aLS, (boolean)this.jCheckBox_ColorVar.isSelected(), (String)LName, (boolean)this._meteoDataInfo.getMeteoUVSet().isUV());
                break;
            }
            case STREAMLINE: {
                GridData[] uvData = this.getUVGridData();
                if (uvData == null) break;
                GridData uData = uvData[0];
                GridData vData = uvData[1];
                this.setXYCoords(uData);
                this.setXYCoords(vData);
                if (this.jCheckBox_ColorVar.isSelected()) {
                    Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)aLS);
                    this._CValues = (double[])ccs[0];
                    this._colors = (Color[])ccs[1];
                }
                aLayer = DrawMeteoData.createStreamlineLayer((GridData)uData, (GridData)vData, (int)this._strmDensity, (LegendScheme)aLS, (String)LName, (boolean)this._meteoDataInfo.getMeteoUVSet().isUV());
            }
        }
        if (aLayer != null) {
            this._lastAddedLayerHandle = aLayer.getShapeType() == ShapeTypes.POLYGON ? this.layersLegend1.getActiveMapFrame().insertPolygonLayer((MapLayer)aLayer) : this.layersLegend1.getActiveMapFrame().insertPolylineLayer(aLayer);
        } else {
            JOptionPane.showMessageDialog(null, "There is no layer created!");
        }
    }

    private String getLayerName(PlotDimension aPD) {
        String layerName = this.jComboBox_DrawType.getSelectedItem().toString() + "_" + this.jComboBox_Variable.getSelectedItem().toString();
        if (this.jComboBox_Level1.isEnabled()) {
            layerName = layerName + "_" + this.jComboBox_Level1.getSelectedItem().toString();
        }
        if (this.jComboBox_Lon1.isEnabled()) {
            layerName = layerName + "_" + this.jComboBox_Lon1.getSelectedItem().toString();
        }
        if (this.jComboBox_Lat1.isEnabled()) {
            layerName = layerName + "_" + this.jComboBox_Lat1.getSelectedItem().toString();
        }
        if (this.jComboBox_Time1.isEnabled()) {
            layerName = layerName + "_" + this.jComboBox_Time1.getSelectedItem().toString();
        }
        return layerName;
    }

    private GridData[] getUVGridData() {
        if (!this._meteoDataInfo.getMeteoUVSet().isFixUVStr()) {
            ArrayList<String> vList = new ArrayList<String>();
            for (int i = 0; i < this.jComboBox_Variable.getItemCount(); ++i) {
                vList.add(this.jComboBox_Variable.getItemAt(i).toString());
            }
            if (!this._meteoDataInfo.getMeteoUVSet().autoSetUVStr(vList)) {
                FrmUVSet aFrmUVSet = new FrmUVSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), true);
                aFrmUVSet.setUVItems(vList);
                aFrmUVSet.setUV(true);
                if (aFrmUVSet.isOK()) {
                    String[] uvStr = aFrmUVSet.getUVItems();
                    String uStr = uvStr[0];
                    String vStr = uvStr[1];
                    this._meteoDataInfo.getMeteoUVSet().setUV(aFrmUVSet.isUV());
                    this._meteoDataInfo.getMeteoUVSet().setUStr(uStr);
                    this._meteoDataInfo.getMeteoUVSet().setVStr(vStr);
                    this._meteoDataInfo.getMeteoUVSet().setFixUVStr(true);
                    this._skipX = aFrmUVSet.getXSkip();
                    this._skipY = aFrmUVSet.getYSkip();
                } else {
                    JOptionPane.showMessageDialog(null, "U/V variables were not set!");
                    return null;
                }
            }
        }
        GridData udata = this._meteoDataInfo.getGridData(this._meteoDataInfo.getMeteoUVSet().getUStr());
        GridData vdata = this._meteoDataInfo.getGridData(this._meteoDataInfo.getMeteoUVSet().getVStr());
        if (udata == null || vdata == null) {
            return null;
        }
        if (this._skipY != 1 || this._skipX != 1) {
            udata = udata.skip(this._skipY, this._skipX);
            vdata = vdata.skip(this._skipY, this._skipX);
        }
        return new GridData[]{udata, vdata};
    }

    private void getXYGridStrs() {
        this._XGridStrs.clear();
        this._YGridStrs.clear();
        switch (this._plotDimension) {
            case Time_Lat: {
                this._XGridStrs = this.getLatGridStr();
                this._YGridStrs = this.getTimeGridStr();
                break;
            }
            case Time_Lon: {
                this._XGridStrs = this.getLonGridStr();
                this._YGridStrs = this.getTimeGridStr();
                break;
            }
            case Level_Lat: {
                this._XGridStrs = this.getLatGridStr();
                for (int i = 0; i < this.jComboBox_Level1.getItemCount(); ++i) {
                    this._YGridStrs.add(this.jComboBox_Level1.getItemAt(i).toString());
                }
                break;
            }
            case Level_Lon: {
                this._XGridStrs = this.getLonGridStr();
                for (int i = 0; i < this.jComboBox_Level1.getItemCount(); ++i) {
                    this._YGridStrs.add(this.jComboBox_Level1.getItemAt(i).toString());
                }
                break;
            }
            case Level_Time: {
                this._XGridStrs = this.getTimeGridStr();
                for (int i = 0; i < this.jComboBox_Level1.getItemCount(); ++i) {
                    this._YGridStrs.add(this.jComboBox_Level1.getItemAt(i).toString());
                }
                break;
            }
        }
        if (this.jCheckBox_YReverse.isVisible() && this.jCheckBox_YReverse.isSelected()) {
            Collections.reverse(this._YGridStrs);
        }
    }

    private List<String> getLonGridStr() {
        ArrayList<String> GStrList = new ArrayList<String>();
        if (this._meteoDataInfo.IsLonLat) {
            for (int i = 0; i < this.jComboBox_Lon1.getItemCount(); ++i) {
                float lon = Float.parseFloat(this.jComboBox_Lon1.getItemAt(i).toString());
                if (lon < 0.0f) {
                    lon += 360.0f;
                }
                String drawStr = lon > 0.0f && lon <= 180.0f ? String.valueOf(lon) + "E" : (lon == 0.0f || lon == 360.0f ? "0" : (lon == 180.0f ? "180" : String.valueOf(360.0f - lon) + "W"));
                GStrList.add(drawStr);
            }
        } else {
            for (int i = 0; i < this.jComboBox_Lon1.getItemCount(); ++i) {
                String drawStr = this.jComboBox_Lon1.getItemAt(i).toString();
                GStrList.add(drawStr);
            }
        }
        return GStrList;
    }

    private List<String> getLatGridStr() {
        ArrayList<String> GStrList = new ArrayList<String>();
        if (this._meteoDataInfo.IsLonLat) {
            for (int i = 0; i < this.jComboBox_Lat1.getItemCount(); ++i) {
                float lat = Float.parseFloat(this.jComboBox_Lat1.getItemAt(i).toString());
                String drawStr = lat > 0.0f ? String.valueOf(lat) + "N" : (lat < 0.0f ? String.valueOf(-lat) + "S" : "EQ");
                GStrList.add(drawStr);
            }
        } else {
            for (int i = 0; i < this.jComboBox_Lat1.getItemCount(); ++i) {
                String drawStr = this.jComboBox_Lat1.getItemAt(i).toString();
                GStrList.add(drawStr);
            }
        }
        return GStrList;
    }

    private List<String> getTimeGridStr() {
        int i;
        ArrayList<String> GStrList = new ArrayList<String>();
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        ArrayList<LocalDateTime> DTList = new ArrayList<LocalDateTime>();
        for (i = 0; i < this.jComboBox_Time1.getItemCount(); ++i) {
            DTList.add(LocalDateTime.parse(this.jComboBox_Time1.getItemAt(i).toString(), dateFormat));
        }
        Duration duration = Duration.between((Temporal)DTList.get(0), (Temporal)DTList.get(1));
        String timeFormat = duration.getSeconds() < 3600L ? "yyyy-MM-dd HH:mm" : (duration.toHours() < 24L ? "yyyy-MM-dd HH" : "yyyy-MM-dd");
        LocalDateTime ldt = (LocalDateTime)DTList.get(0);
        int sYear = ldt.getYear();
        int sMonth = ldt.getDayOfMonth();
        ldt = (LocalDateTime)DTList.get(DTList.size() - 1);
        int eYear = ldt.getYear();
        int eMonth = ldt.getDayOfMonth();
        if (sYear == eYear) {
            timeFormat = timeFormat.substring(5);
            if (sMonth == eMonth) {
                timeFormat = timeFormat.substring(3);
            }
        }
        DateTimeFormatter dataFormat = DateTimeFormatter.ofPattern(timeFormat);
        for (i = 0; i < DTList.size(); ++i) {
            GStrList.add(dataFormat.format((TemporalAccessor)DTList.get(i)));
        }
        return GStrList;
    }

    private void getGridData() {
        this._gridData = this._meteoDataInfo.getGridData(this.jComboBox_Variable.getSelectedItem().toString());
    }

    private void drawGrid() {
        this.setXYCoords(this._gridData);
        if (this.jCheckBox_YReverse.isVisible() && this.jCheckBox_YReverse.isSelected()) {
            double[][] aGD = (double[][])this._gridData.getData().clone();
            int yn = this._gridData.getYNum();
            int xn = this._gridData.getXNum();
            for (int i = 0; i < yn; ++i) {
                for (int j = 0; j < xn; ++j) {
                    this._gridData.setValue(i, j, aGD[yn - i - 1][j]);
                }
            }
        }
        if (!this._useSameLegendScheme) {
            this.createLegendScheme();
        }
        this.drawMeteoMap(true, this._legendScheme);
    }

    private void createLegendScheme() {
        switch (this._2DDrawType) {
            case CONTOUR: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.UNIQUE_VALUE, (ShapeTypes)ShapeTypes.POLYLINE);
                break;
            }
            case SHADED: 
            case GRID_FILL: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POLYGON);
                break;
            }
            case GRID_POINT: {
                this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                break;
            }
            case VECTOR: {
                if (this.jCheckBox_ColorVar.isSelected()) {
                    this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                    for (int i = 0; i < this._legendScheme.getLegendBreaks().size(); ++i) {
                        PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(i);
                        aPB.setSize(10.0f);
                    }
                    break;
                }
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.blue, (float)10.0f);
                break;
            }
            case BARB: {
                if (this.jCheckBox_ColorVar.isSelected()) {
                    this._legendScheme = LegendManage.createLegendSchemeFromGridData((GridData)this._gridData, (LegendType)LegendType.GRADUATED_COLOR, (ShapeTypes)ShapeTypes.POINT);
                    for (int i = 0; i < this._legendScheme.getLegendBreaks().size(); ++i) {
                        PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(i);
                        aPB.setSize(10.0f);
                    }
                    break;
                }
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.blue, (float)10.0f);
                break;
            }
            case STREAMLINE: {
                this._legendScheme = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYLINE, (Color)Color.blue, (float)1.0f);
            }
        }
    }

    private void setXYCoords(GridData aGridData) {
        int i;
        int xNum = 0;
        int yNum = 0;
        switch (this._plotDimension) {
            case Time_Lon: {
                xNum = this.jComboBox_Lon1.getItemCount();
                yNum = this.jComboBox_Time1.getItemCount();
                break;
            }
            case Time_Lat: {
                xNum = this.jComboBox_Lat1.getItemCount();
                yNum = this.jComboBox_Time1.getItemCount();
                break;
            }
            case Level_Lat: {
                xNum = this.jComboBox_Lat1.getItemCount();
                yNum = this.jComboBox_Level1.getItemCount();
                break;
            }
            case Level_Lon: {
                xNum = this.jComboBox_Lon1.getItemCount();
                yNum = this.jComboBox_Level1.getItemCount();
                break;
            }
            case Level_Time: {
                xNum = this.jComboBox_Time1.getItemCount();
                yNum = this.jComboBox_Level1.getItemCount();
            }
        }
        double[] xArray = new double[xNum];
        double[] yArray = new double[yNum];
        for (i = 0; i < xNum; ++i) {
            xArray[i] = i;
        }
        for (i = 0; i < yNum; ++i) {
            yArray[i] = i;
        }
        aGridData.setXArray(xArray);
        aGridData.setYArray(yArray);
    }

    private void zoomToExtent(Extent aExtent) {
        this.mapLayout1.getActiveMapFrame().getMapView().zoomToExtent(aExtent);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmSectionPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmSectionPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmSectionPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmSectionPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FrmSectionPlot(null).setVisible(true);
            }
        });
    }
}

