/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geo.analysis.GeoComputation;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.geoprocess.SpatialQueryTypes;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.map.forms.FrmMain;

public class FrmSelectByLocation
extends JDialog {
    List<VectorLayer> _vLayers = new ArrayList<VectorLayer>();
    private final FrmMain _frmMain;
    private JButton jButton_Clear;
    private JButton jButton_Select;
    private JCheckBox jCheckBox_SelFeaturesOnly;
    private JComboBox jComboBox_FromLayer;
    private JComboBox jComboBox_RelatedLayer;
    private JComboBox jComboBox_SelType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public FrmSelectByLocation(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this._frmMain = (FrmMain)parent;
        for (MapLayer mapLayer : this._frmMain.getMapDocument().getActiveMapFrame().getMapView().getLayers()) {
            if (mapLayer.getLayerType() != LayerTypes.VECTOR_LAYER) continue;
            this._vLayers.add((VectorLayer)mapLayer);
        }
        this.jComboBox_FromLayer.removeAllItems();
        for (VectorLayer vectorLayer : this._vLayers) {
            this.jComboBox_FromLayer.addItem(vectorLayer.getLayerName());
        }
        this.jComboBox_FromLayer.setSelectedIndex(0);
        this.jComboBox_SelType.removeAllItems();
        for (SpatialQueryTypes type : SpatialQueryTypes.values()) {
            this.jComboBox_SelType.addItem(type.toString());
        }
        this.jComboBox_SelType.setSelectedIndex(0);
        this.jComboBox_RelatedLayer.removeAllItems();
        for (VectorLayer vectorLayer : this._vLayers) {
            this.jComboBox_RelatedLayer.addItem(vectorLayer.getLayerName());
        }
        this.jComboBox_RelatedLayer.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_FromLayer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_SelType = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBox_RelatedLayer = new JComboBox();
        this.jCheckBox_SelFeaturesOnly = new JCheckBox();
        this.jButton_Select = new JButton();
        this.jButton_Clear = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select By Location");
        this.jLabel1.setText("Select features from the layer:");
        this.jComboBox_FromLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("That:");
        this.jComboBox_SelType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("The features in this layer:");
        this.jComboBox_RelatedLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_RelatedLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByLocation.this.jComboBox_RelatedLayerActionPerformed(evt);
            }
        });
        this.jCheckBox_SelFeaturesOnly.setText("Selected features only");
        this.jButton_Select.setText("Select");
        this.jButton_Select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByLocation.this.jButton_SelectActionPerformed(evt);
            }
        });
        this.jButton_Clear.setText("Clear");
        this.jButton_Clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByLocation.this.jButton_ClearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jComboBox_FromLayer, -2, 358, -2).addComponent(this.jLabel2).addComponent(this.jComboBox_SelType, -2, 358, -2).addComponent(this.jLabel3).addComponent(this.jComboBox_RelatedLayer, -2, 358, -2).addComponent(this.jCheckBox_SelFeaturesOnly))).addGroup(layout.createSequentialGroup().addGap(85, 85, 85).addComponent(this.jButton_Select).addGap(69, 69, 69).addComponent(this.jButton_Clear))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_FromLayer, -2, -1, -2).addGap(28, 28, 28).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_SelType, -2, -1, -2).addGap(29, 29, 29).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_RelatedLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_SelFeaturesOnly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Select).addComponent(this.jButton_Clear)).addGap(22, 22, 22)));
        this.pack();
    }

    private void jComboBox_RelatedLayerActionPerformed(ActionEvent evt) {
        if (this.jComboBox_RelatedLayer.getItemCount() == 0) {
            return;
        }
        VectorLayer aLayer = this._vLayers.get(this.jComboBox_RelatedLayer.getSelectedIndex());
        List selIndexes = aLayer.getSelectedShapeIndexes();
        if (selIndexes.size() > 0) {
            this.jCheckBox_SelFeaturesOnly.setEnabled(true);
            this.jCheckBox_SelFeaturesOnly.setText("Selected features only (" + String.valueOf(selIndexes.size()) + " features selected)");
        } else {
            this.jCheckBox_SelFeaturesOnly.setEnabled(false);
            this.jCheckBox_SelFeaturesOnly.setSelected(false);
            this.jCheckBox_SelFeaturesOnly.setText("Selected features only");
        }
    }

    private void jButton_SelectActionPerformed(ActionEvent evt) {
        if (this.jComboBox_FromLayer.getSelectedItem().toString().equals(this.jComboBox_RelatedLayer.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(null, "The two layers are same!");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        VectorLayer fromLayer = this._vLayers.get(this.jComboBox_FromLayer.getSelectedIndex());
        VectorLayer relatedLayer = this._vLayers.get(this.jComboBox_RelatedLayer.getSelectedIndex());
        SpatialQueryTypes selType = SpatialQueryTypes.valueOf((String)this.jComboBox_SelType.getSelectedItem().toString());
        boolean onlySel = this.jCheckBox_SelFeaturesOnly.isSelected();
        switch (selType) {
            case Within: {
                if (!relatedLayer.getShapeType().isPolygon()) {
                    JOptionPane.showMessageDialog(null, "The second layer must be polygon layer for 'Within' case!");
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                for (Shape aShape : fromLayer.getShapes()) {
                    boolean isIn = true;
                    List points = aShape.getPoints();
                    for (PointD aPoint : points) {
                        if (GeoComputation.pointInPolygonLayer((VectorLayer)relatedLayer, (PointD)aPoint, (boolean)onlySel)) continue;
                        isIn = false;
                        break;
                    }
                    if (isIn) {
                        aShape.setSelected(true);
                        continue;
                    }
                    aShape.setSelected(false);
                }
                break;
            }
            case Contain: {
                if (fromLayer.getShapeType() != ShapeTypes.POLYGON) {
                    JOptionPane.showMessageDialog(null, "The first layer must be polygon layer for 'Within' case!");
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                List<Shape> shapes = new ArrayList();
                if (onlySel) {
                    for (Shape aShape : relatedLayer.getShapes()) {
                        if (!aShape.isSelected()) continue;
                        shapes.add(aShape);
                    }
                } else {
                    shapes = relatedLayer.getShapes();
                }
                block7: for (Shape aShape : fromLayer.getShapes()) {
                    aShape.setSelected(false);
                    PolygonShape aPolygon = (PolygonShape)aShape;
                    for (Shape bShape : shapes) {
                        boolean isIn = true;
                        List points = bShape.getPoints();
                        for (PointD aPoint : points) {
                            if (GeoComputation.pointInPolygon((PolygonShape)aPolygon, (PointD)aPoint)) continue;
                            isIn = false;
                            break;
                        }
                        if (!isIn) continue;
                        aShape.setSelected(true);
                        continue block7;
                    }
                }
                break;
            }
        }
        this._frmMain.refreshMap();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_ClearActionPerformed(ActionEvent evt) {
        VectorLayer fromLayer = this._vLayers.get(this.jComboBox_FromLayer.getSelectedIndex());
        fromLayer.clearSelectedShapes();
        this._frmMain.refreshMap();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmSelectByLocation.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmSelectByLocation.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmSelectByLocation.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmSelectByLocation.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmSelectByLocation dialog = new FrmSelectByLocation((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

