/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.meteoinfo.map.forms;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import org.meteoinfo.chart.Chart;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.plot.ChartPlotMethod;
import org.meteoinfo.chart.plot.PlotOrientation;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.common.PointD;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.XYDataset;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.PlotDimension;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.geometry.legend.*;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.meteodata.hysplit.HYSPLITTrajDataInfo;
import org.meteoinfo.map.config.GenericFileFilter;
import org.meteoinfo.image.AnimatedGifEncoder;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.chart.LayoutChart;
import org.meteoinfo.geo.layout.MapLayout;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geometry.shape.ShapeTypes;

/**
 *
 * @author yaqiang
 */
public class FrmOneDim extends javax.swing.JFrame {

    private FrmMain mainGUI;
    private MeteoDataInfo _meteoDataInfo = new MeteoDataInfo();
    private org.meteoinfo.chart.ChartPanel _chartPanel;
    private PlotDimension _plotDimension;
    private String _graphType;
    private List<PointD> _pointList = new ArrayList<>();
    private boolean _isLoading = false;
    private boolean isSamePlotDim = false;
    private boolean _enableAnimation = true;
    private boolean _isRunning = false;

    /**
     * Creates new form FrmOneDim
     *
     * @param frmMain FrmMain
     * @param aDataInfo The data info
     */
    public FrmOneDim(FrmMain frmMain, MeteoDataInfo aDataInfo) {
        initComponents();

        mainGUI = frmMain;
        this.jComboBox_Variable.setEditable(true);
        //_chartPanel = new ChartPanel(null);
        _chartPanel = new org.meteoinfo.chart.ChartPanel(null);
        this.jSplitPane1.setRightComponent(_chartPanel);
        JPopupMenu popupMenu = this._chartPanel.getPopupMenu();
        if (popupMenu != null) {
            JMenuItem addToLayoutMI = new JMenuItem("Add to Layout");
            addToLayoutMI.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    onAddToLayoutClick();
                }
            });
            popupMenu.add(addToLayoutMI);
        }

        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        _meteoDataInfo = aDataInfo;

        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoInfo_1_16x16x8.png"));
        } catch (Exception e) {
        }
        this.setIconImage(image);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jToolBar1 = new javax.swing.JToolBar();
        jButton_DataInfo = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jButton_Draw = new javax.swing.JButton();
        jButton_ViewData = new javax.swing.JButton();
        jButton_ClearDraw = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JToolBar.Separator();
        jButton_PreTime = new javax.swing.JButton();
        jButton_NexTime = new javax.swing.JButton();
        jButton_Animator = new javax.swing.JButton();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel_DrawType = new javax.swing.JLabel();
        jComboBox_DrawType = new javax.swing.JComboBox();
        jLabel_PlotDims = new javax.swing.JLabel();
        jComboBox_PlotDim = new javax.swing.JComboBox();
        jPanel_Dimensions = new javax.swing.JPanel();
        jCheckBox_Time = new javax.swing.JCheckBox();
        jComboBox_Time1 = new javax.swing.JComboBox();
        jCheckBox_Level = new javax.swing.JCheckBox();
        jComboBox_Time2 = new javax.swing.JComboBox();
        jComboBox_Level1 = new javax.swing.JComboBox();
        jComboBox_Level2 = new javax.swing.JComboBox();
        jCheckBox_Lat = new javax.swing.JCheckBox();
        jComboBox_Lat1 = new javax.swing.JComboBox();
        jComboBox_Lat2 = new javax.swing.JComboBox();
        jCheckBox_Lon = new javax.swing.JCheckBox();
        jComboBox_Lon1 = new javax.swing.JComboBox();
        jComboBox_Lon2 = new javax.swing.JComboBox();
        jLabel_Variable = new javax.swing.JLabel();
        jComboBox_Variable = new javax.swing.JComboBox();
        jCheckBox_YReverse = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("bundle/Bundle_FrmOneDim"); // NOI18N
        setTitle(bundle.getString("FrmOneDim.title")); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);

        //jButton_DataInfo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/information.png"))); // NOI18N
        jButton_DataInfo.setIcon(new FlatSVGIcon("org/meteoinfo/map/icons/information.svg"));
        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("bundle/Bundle_FrmMeteoData"); // NOI18N
        jButton_DataInfo.setToolTipText(bundle1.getString("FrmMeteoData.jButton_DataInfo.toolTipText")); // NOI18N
        jButton_DataInfo.setFocusable(false);
        jButton_DataInfo.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_DataInfo.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_DataInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_DataInfoActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_DataInfo);
        jToolBar1.add(jSeparator1);

        //jButton_Draw.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Draw.Image.png"))); // NOI18N
        jButton_Draw.setIcon(new FlatSVGIcon("org/meteoinfo/map/icons/draw-layer.svg"));
        jButton_Draw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_Draw.toolTipText")); // NOI18N
        jButton_Draw.setFocusable(false);
        jButton_Draw.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_Draw.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_Draw.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_DrawActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_Draw);

        //jButton_ViewData.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_ViewData.Image.png"))); // NOI18N
        jButton_ViewData.setIcon(new FlatSVGIcon("org/meteoinfo/icons/table.svg"));
        jButton_ViewData.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ViewData.toolTipText")); // NOI18N
        jButton_ViewData.setFocusable(false);
        jButton_ViewData.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ViewData.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ViewData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ViewDataActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ViewData);

        //jButton_ClearDraw.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_ClearDrawing.Image.png"))); // NOI18N
        jButton_ClearDraw.setIcon(new FlatSVGIcon("org/meteoinfo/icons/delete.svg"));
        jButton_ClearDraw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ClearDraw.toolTipText")); // NOI18N
        jButton_ClearDraw.setFocusable(false);
        jButton_ClearDraw.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ClearDraw.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ClearDraw.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ClearDrawActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ClearDraw);
        jToolBar1.add(jSeparator2);

        //jButton_PreTime.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_PreTime.Image.png"))); // NOI18N
        jButton_PreTime.setIcon(new FlatSVGIcon("org/meteoinfo/map/icons/left-arrow.svg"));
        jButton_PreTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_PreTime.toolTipText")); // NOI18N
        jButton_PreTime.setFocusable(false);
        jButton_PreTime.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_PreTime.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_PreTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_PreTimeActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_PreTime);

        //jButton_NexTime.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_NextTime.Image.png"))); // NOI18N
        jButton_NexTime.setIcon(new FlatSVGIcon("org/meteoinfo/map/icons/right-arrow.svg"));
        jButton_NexTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_NexTime.toolTipText")); // NOI18N
        jButton_NexTime.setFocusable(false);
        jButton_NexTime.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_NexTime.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_NexTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_NexTimeActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_NexTime);

        //jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/animation-1.png"))); // NOI18N
        jButton_Animator.setIcon(new FlatSVGIcon("org/meteoinfo/map/icons/animator.svg"));
        jButton_Animator.setToolTipText(bundle1.getString("FrmMeteoData.jButton_Animator.toolTipText")); // NOI18N
        jButton_Animator.setFocusable(false);
        jButton_Animator.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_Animator.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_Animator.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_AnimatorActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_Animator);

        jSplitPane1.setDividerLocation(250);
        jSplitPane1.setPreferredSize(new java.awt.Dimension(737, 465));

        jPanel1.setPreferredSize(new java.awt.Dimension(250, 463));

        jLabel_DrawType.setText(bundle.getString("FrmOneDim.jLabel_DrawType.text")); // NOI18N

        jComboBox_DrawType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_DrawType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_DrawTypeActionPerformed(evt);
            }
        });

        jLabel_PlotDims.setText(bundle.getString("FrmOneDim.jLabel_PlotDims.text")); // NOI18N

        jComboBox_PlotDim.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_PlotDim.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_PlotDimActionPerformed(evt);
            }
        });

        jPanel_Dimensions.setBorder(javax.swing.BorderFactory.createTitledBorder(""));

        jCheckBox_Time.setText(bundle.getString("FrmOneDim.jCheckBox_Time.text")); // NOI18N
        jCheckBox_Time.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_TimeStateChanged(evt);
            }
        });

        jComboBox_Time1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jCheckBox_Level.setText(bundle.getString("FrmOneDim.jCheckBox_Level.text")); // NOI18N
        jCheckBox_Level.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_LevelStateChanged(evt);
            }
        });

        jComboBox_Time2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Level1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Level2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jCheckBox_Lat.setText(bundle.getString("FrmOneDim.jCheckBox_Lat.text")); // NOI18N
        jCheckBox_Lat.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_LatStateChanged(evt);
            }
        });

        jComboBox_Lat1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Lat2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jCheckBox_Lon.setText(bundle.getString("FrmOneDim.jCheckBox_Lon.text")); // NOI18N
        jCheckBox_Lon.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_LonStateChanged(evt);
            }
        });

        jComboBox_Lon1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Lon2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        javax.swing.GroupLayout jPanel_DimensionsLayout = new javax.swing.GroupLayout(jPanel_Dimensions);
        jPanel_Dimensions.setLayout(jPanel_DimensionsLayout);
        jPanel_DimensionsLayout.setHorizontalGroup(
            jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_DimensionsLayout.createSequentialGroup()
                .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel_DimensionsLayout.createSequentialGroup()
                        .addComponent(jCheckBox_Lat)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox_Lat2, 0, 124, Short.MAX_VALUE)
                            .addComponent(jComboBox_Lat1, 0, 1, Short.MAX_VALUE)))
                    .addGroup(jPanel_DimensionsLayout.createSequentialGroup()
                        .addComponent(jCheckBox_Lon)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox_Lon1, 0, 1, Short.MAX_VALUE)
                            .addComponent(jComboBox_Lon2, javax.swing.GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel_DimensionsLayout.createSequentialGroup()
                        .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBox_Level)
                            .addComponent(jCheckBox_Time))
                        .addGap(6, 6, 6)
                        .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox_Time1, 0, 1, Short.MAX_VALUE)
                            .addComponent(jComboBox_Time2, 0, 0, Short.MAX_VALUE)
                            .addComponent(jComboBox_Level1, 0, 1, Short.MAX_VALUE)
                            .addComponent(jComboBox_Level2, javax.swing.GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel_DimensionsLayout.setVerticalGroup(
            jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_DimensionsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Time)
                    .addComponent(jComboBox_Time1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Time2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Level)
                    .addComponent(jComboBox_Level1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Level2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Lat)
                    .addComponent(jComboBox_Lat1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Lat2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel_DimensionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Lon)
                    .addComponent(jComboBox_Lon1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Lon2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel_Variable.setText(bundle.getString("FrmOneDim.jLabel_Variable.text")); // NOI18N

        jComboBox_Variable.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_Variable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_VariableActionPerformed(evt);
            }
        });

        jCheckBox_YReverse.setText(bundle.getString("FrmOneDim.jCheckBox_YReverse.text")); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel_PlotDims)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox_PlotDim, 0, 1, Short.MAX_VALUE))
                    .addComponent(jPanel_Dimensions, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel_DrawType)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox_DrawType, 0, 1, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBox_YReverse)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel_Variable)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox_Variable, 0, 1, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox_Variable, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel_Variable))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel_DrawType)
                    .addComponent(jComboBox_DrawType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel_PlotDims)
                    .addComponent(jComboBox_PlotDim, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(14, 14, 14)
                .addComponent(jCheckBox_YReverse)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel_Dimensions, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jSplitPane1.setLeftComponent(jPanel1);

        jPanel2.setLayout(new java.awt.BorderLayout());
        jSplitPane1.setRightComponent(jPanel2);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 764, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 476, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton_DataInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_DataInfoActionPerformed
        // TODO add your handling code here:
        FrmDataInfo frmDI = new FrmDataInfo();
        frmDI.setLocationRelativeTo(this);
        frmDI.setText(_meteoDataInfo.getInfoText());
        frmDI.setVisible(true);
    }//GEN-LAST:event_jButton_DataInfoActionPerformed

    private void jButton_DrawActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_DrawActionPerformed
        // TODO add your handling code here:
        if (this.jComboBox_PlotDim.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(null, "It's not a muti dimension variable: " + this.jComboBox_Variable.getSelectedItem().toString() + "!");
            return;
        }

        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

        String varName = this.jComboBox_Variable.getSelectedItem().toString();
        ChartPlotMethod method = (ChartPlotMethod) this.jComboBox_DrawType.getSelectedItem();
        switch (this._meteoDataInfo.getDataType()) {
            case HYSPLIT_TRAJ:
                int varIdx = 11;
                String yLabel = "Meters AGL";
                if (varName.equals("Pressure")) {
                    varIdx = 12;
                    yLabel = "hPa";
                }
                XYListDataset ldataset = ((HYSPLITTrajDataInfo) this._meteoDataInfo.getDataInfo()).getXYDataset(varIdx);
                LegendScheme ls = null;
                MapLayer layer = this.mainGUI.getMeteoDataset().getLastAddLayer();
                if (layer != null) {
                    if (layer.getLayerDrawType() == LayerDrawType.TRAJECTORY_LINE) {
                        ls = layer.getLegendScheme();
                    }
                }
                if (ls == null) {
                    ls = LegendManage.createUniqValueLegendScheme(ldataset.getSeriesCount(), ShapeTypes.POLYLINE);
                    for (ColorBreak cb : ls.getLegendBreaks()) {
                        PolylineBreak plb = (PolylineBreak) cb;
                        plb.setDrawSymbol(true);
                        plb.setSymbolInterval(6);
                        plb.setWidth(2);
                    }
                }
                boolean yInverse = varName.equals("Pressure");
                this.createChart(ldataset, ls.getLegendBreaks(), null, "Time", yLabel, method,
                        PlotOrientation.VERTICAL, yInverse, false, true, false);
                break;
            default:
                _plotDimension = PlotDimension.valueOf(this.jComboBox_PlotDim.getSelectedItem().toString());
                _meteoDataInfo.setDimensionSet(_plotDimension);
                String seriesKey = varName;
                switch (_plotDimension) {
                    case Level:
                        seriesKey = seriesKey + "_" + this.jComboBox_Lon1.getSelectedItem().toString()
                                + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_"
                                + this.jComboBox_Time1.getSelectedItem().toString();
                        break;
                    case Time:
                        seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString()
                                + "_" + this.jComboBox_Lon1.getSelectedItem().toString()
                                + "_" + this.jComboBox_Lat1.getSelectedItem().toString();
                        break;
                    case Lon:
                        seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString()
                                + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_"
                                + this.jComboBox_Time1.getSelectedItem().toString();
                        break;
                    case Lat:
                        seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString()
                                + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_"
                                + this.jComboBox_Time1.getSelectedItem().toString();
                        break;
                }

                //Get data
                _meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());
                double y = Double.parseDouble(this.jComboBox_Lat1.getSelectedItem().toString());
                Dimension ydim = _meteoDataInfo.getDataInfo().getYDimension();                
                _meteoDataInfo.setLatIndex(ydim.getValueIndex(y));
                _meteoDataInfo.setLevelIndex(this.jComboBox_Level1.getSelectedIndex());
                _meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());

                //this.jComboBox_Variable.actionPerformed(null);
                GridData gData = _meteoDataInfo.getGridData(varName);

                if (gData == null) {
                    return;
                }

                //Plot       
                int itemCount = gData.getXNum();
                double[] xvs = new double[itemCount];
                double[] yvs = new double[itemCount];
                for (int i = 0; i < itemCount; i++) {
                    xvs[i] = gData.getXArray()[i];
                    yvs[i] = gData.getData()[0][i];
                }
                if (this.isSamePlotDim && this._chartPanel.getChart() != null) {
                    XY1DPlot plot = (XY1DPlot) this._chartPanel.getChart().getPlot();
                    plot.addSeries(seriesKey, xvs, yvs);
                    int idx = plot.getDataset().getSeriesCount() - 1;
                    ColorBreak cb = plot.getLegendBreak(idx);
                    PolylineBreak plb = new PolylineBreak();
                    plb.setCaption(seriesKey);
                    plb.setColor(cb.getColor());
                    plb.setSymbolColor(cb.getColor());
                    switch (method) {
                        case LINE:
                            plb.setDrawSymbol(false);
                            plot.setLegendBreak(idx, plb);
                            break;
                        case LINE_POINT:
                            plb.setDrawSymbol(true);
                            plot.setLegendBreak(idx, plb);
                            break;
                        case POINT:
                            PointBreak pb = new PointBreak();
                            pb.setColor(cb.getColor());
                            pb.setSize(plb.getSymbolSize());
                            pb.setStyle(plb.getSymbolStyle());
                            pb.setCaption(seriesKey);
                            plot.setLegendBreak(idx, pb);
                            break;
                        case BAR:
                            PolygonBreak pgb = new PolygonBreak();
                            pgb.setColor(cb.getColor());
                            pgb.setCaption(seriesKey);
                            plot.setLegendBreak(idx, pgb);
                            break;
                    }
                    this._chartPanel.paintGraphics();
                } else {
                    XYListDataset dataset = new XYListDataset();
                    dataset.addSeries(seriesKey, xvs, yvs);
                    dataset.setMissingValue(gData.getDoubleMissingValue());

                    String title = varName + "_" + this.jComboBox_PlotDim.getSelectedItem().toString() + " Graph";
                    PlotOrientation po = PlotOrientation.VERTICAL;
                    yInverse = this.jCheckBox_YReverse.isSelected();
                    if (_plotDimension == PlotDimension.Level) {
                        po = PlotOrientation.HORIZONTAL;
                        //yInverse = true;
                    }
                    String xLabel = _plotDimension.toString();
                    boolean isTime = false;
                    if (_plotDimension == PlotDimension.Time) {
                        isTime = true;
                    }
                    ls = LegendManage.createUniqValueLegendScheme(dataset.getSeriesCount(), ShapeTypes.POLYLINE);
                    for (ColorBreak cb : ls.getLegendBreaks()) {
                        PolylineBreak plb = (PolylineBreak) cb;
                        plb.setDrawSymbol(true);
                    }

                    this.createChart(dataset, ls.getLegendBreaks(), title, xLabel, varName, method, po, yInverse, false, isTime, true);
                }
                //Enable time controls            
                if (!this.jCheckBox_Time.isSelected()) {
                    if (this.jComboBox_Time1.getItemCount() > 1) {
                        this.jButton_NexTime.setEnabled(true);
                        this.jButton_PreTime.setEnabled(true);
                        this.jButton_Animator.setEnabled(true);
                    }
                }
                break;
        }
        this.isSamePlotDim = true;
        this.setCursor(Cursor.getDefaultCursor());
    }//GEN-LAST:event_jButton_DrawActionPerformed

    private void display() {
        String varName = this.jComboBox_Variable.getSelectedItem().toString();
        ChartPlotMethod method = (ChartPlotMethod) this.jComboBox_DrawType.getSelectedItem();
        _plotDimension = PlotDimension.valueOf(this.jComboBox_PlotDim.getSelectedItem().toString());
        _meteoDataInfo.setDimensionSet(_plotDimension);
        String seriesKey = varName;
        switch (_plotDimension) {
            case Level:
                seriesKey = seriesKey + "_" + this.jComboBox_Lon1.getSelectedItem().toString()
                        + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_"
                        + this.jComboBox_Time1.getSelectedItem().toString();
                break;
            case Time:
                seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString()
                        + "_" + this.jComboBox_Lon1.getSelectedItem().toString()
                        + "_" + this.jComboBox_Lat1.getSelectedItem().toString();
                break;
            case Lon:
                seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString()
                        + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_"
                        + this.jComboBox_Time1.getSelectedItem().toString();
                break;
            case Lat:
                seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString()
                        + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_"
                        + this.jComboBox_Time1.getSelectedItem().toString();
                break;
        }

        //Get data
        _meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());
        _meteoDataInfo.setLatIndex(this.jComboBox_Lat1.getSelectedIndex());
        _meteoDataInfo.setLevelIndex(this.jComboBox_Level1.getSelectedIndex());
        _meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());

        //this.jComboBox_Variable.actionPerformed(null);
        GridData gData = _meteoDataInfo.getGridData(varName);

        if (gData == null) {
            return;
        }

        //Plot       
        int itemCount = gData.getXNum();
        double[] xvs = new double[itemCount];
        double[] yvs = new double[itemCount];
        for (int i = 0; i < itemCount; i++) {
            xvs[i] = gData.getXArray()[i];
            yvs[i] = gData.getDoubleValue(0, i);
        }
        XYListDataset dataset = new XYListDataset();
        dataset.addSeries(seriesKey, xvs, yvs);
        dataset.setMissingValue(gData.getDoubleMissingValue());

        String title = varName + "_" + this.jComboBox_PlotDim.getSelectedItem().toString() + " Graph";
        PlotOrientation po = PlotOrientation.VERTICAL;
        boolean yInverse = false;
        if (_plotDimension == PlotDimension.Level) {
            po = PlotOrientation.HORIZONTAL;
            yInverse = true;
        }
        String xLabel = _plotDimension.toString();
        boolean isTime = false;
        if (_plotDimension == PlotDimension.Time) {
            isTime = true;
        }
        LegendScheme ls = LegendManage.createUniqValueLegendScheme(dataset.getSeriesCount(), ShapeTypes.POLYLINE);
        for (ColorBreak cb : ls.getLegendBreaks()) {
            PolylineBreak plb = (PolylineBreak) cb;
            plb.setDrawSymbol(true);
        }

        this.createChart(dataset, ls.getLegendBreaks(), title, xLabel, varName, method, po, yInverse, false, isTime, true);
    }

    private void jButton_ViewDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ViewDataActionPerformed
        // TODO add your handling code here:
        if (this._chartPanel.getChart() == null) {
            return;
        }
        
        XYListDataset dataset = (XYListDataset)this._chartPanel.getChart().getPlot().getDataset();
       
        FrmViewData frmData = new FrmViewData();
        //frmData.setProjectionInfo(_meteoDataInfo.getProjectionInfo());
        frmData.setXYData(dataset);
        frmData.setLocationRelativeTo(this);
        frmData.setVisible(true);
    }//GEN-LAST:event_jButton_ViewDataActionPerformed

    private void jButton_ClearDrawActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ClearDrawActionPerformed
        // TODO add your handling code here:
        this.isSamePlotDim = false;
        this._chartPanel.setChart(null);
        this._chartPanel.paintGraphics();
    }//GEN-LAST:event_jButton_ClearDrawActionPerformed

    private void jButton_PreTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_PreTimeActionPerformed
        // TODO add your handling code here:        
        if (this.jComboBox_Time1.getSelectedIndex() > 0) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() - 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getItemCount() - 1);
        }
        this.isSamePlotDim = false;
        this.jButton_Draw.doClick();
    }//GEN-LAST:event_jButton_PreTimeActionPerformed

    private void jButton_NexTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_NexTimeActionPerformed
        // TODO add your handling code here:        
        if (this.jComboBox_Time1.getSelectedIndex() < this.jComboBox_Time1.getItemCount() - 1) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() + 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(0);
        }
        this.isSamePlotDim = false;
        this.jButton_Draw.doClick();
    }//GEN-LAST:event_jButton_NexTimeActionPerformed

    private void jButton_AnimatorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_AnimatorActionPerformed
        // TODO add your handling code here:
        if (this._isRunning) {
            this._enableAnimation = false;
        } else {
            run_Animation(false);
            //this._enableAnimation = true;
            //this._isRunning = false;
            //this.jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/animation-1.png")));
        }
    }//GEN-LAST:event_jButton_AnimatorActionPerformed

    private void run_Animation(final boolean isCreateFile) {
        File file;
        final AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        if (isCreateFile) {
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"gif"};
            GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif File (*.gif)");
            aDlg.setFileFilter(mapFileFilter);
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
            aDlg.setAcceptAllFileFilterUsed(false);
            if (aDlg.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
                file = aDlg.getSelectedFile();
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter) aDlg.getFileFilter()).getFileExtent();
                String fileName = file.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                encoder.setRepeat(0);
                encoder.setDelay(1000);
                encoder.start(fileName);
            }
        }

        switch (_meteoDataInfo.getDataType()) {
            default:
                if (this.jComboBox_Time1.getItemCount() > 1) {
                    SwingWorker worker = new SwingWorker<String, String>() {
                        @Override
                        protected String doInBackground() throws Exception {
                            jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/stop.png")));
                            _isRunning = true;
                            for (int i = 0; i < jComboBox_Time1.getItemCount(); i++) {
                                if (!_enableAnimation) {
                                    _enableAnimation = true;
                                    _isRunning = false;
                                    jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/animation-1.png")));
                                    return "";
                                }

                                jComboBox_Time1.setSelectedIndex(i);
                                display();

                                if (isCreateFile) {
                                    encoder.addFrame(FrmOneDim.this._chartPanel.getViewImage());
                                } else {
                                    try {
                                        Thread.sleep(500);
                                    } catch (InterruptedException ex) {
                                        Logger.getLogger(FrmMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }

                            _enableAnimation = true;
                            _isRunning = false;
                            jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/animation-1.png")));
                            encoder.finish();
                            return "";
                        }
                    };
                    worker.execute();
                }
                break;
        }
    }

    private void jComboBox_VariableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_VariableActionPerformed
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        Variable var = _meteoDataInfo.getDataInfo().getVariable(this.jComboBox_Variable.getSelectedItem().toString());
        if (var == null) {
            return;
        }

        _meteoDataInfo.setVariableName(this.jComboBox_Variable.getSelectedItem().toString());
        this.setVariableParas(var);
        updateEndDimSetS(this.jComboBox_Level1, this.jComboBox_Level2);

        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);

        //Set plot dimensions
        _isLoading = true;
        String pdStr = this.jComboBox_PlotDim.getSelectedItem().toString();
        this.jComboBox_PlotDim.removeAllItems();
        if (this.jComboBox_Level1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Level.toString());
        }
        if (this.jComboBox_Time1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Time.toString());
        }
        if (this.jComboBox_Lon1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Lon.toString());
        }
        if (this.jComboBox_Lat1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Lat.toString());
        }

        List<String> dimItems = new ArrayList<>();
        for (int i = 0; i < this.jComboBox_PlotDim.getItemCount(); i++) {
            dimItems.add(this.jComboBox_PlotDim.getItemAt(i).toString());
        }
        _isLoading = false;
        if (!"".equals(pdStr) && dimItems.contains(pdStr)) {
            isSamePlotDim = true;
            this.jComboBox_PlotDim.setSelectedItem(pdStr);
        } else {
            isSamePlotDim = false;
            if (this.jComboBox_PlotDim.getItemCount() > 0) {
                this.jComboBox_PlotDim.setSelectedIndex(0);
            }
        }
    }//GEN-LAST:event_jComboBox_VariableActionPerformed

    private void jComboBox_DrawTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_DrawTypeActionPerformed
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        if (this.jComboBox_DrawType.getItemCount() == 0) {
            return;
        }

        this._graphType = this.jComboBox_DrawType.getSelectedItem().toString();
    }//GEN-LAST:event_jComboBox_DrawTypeActionPerformed

    private void jComboBox_PlotDimActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_PlotDimActionPerformed
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        _plotDimension = PlotDimension.valueOf(this.jComboBox_PlotDim.getSelectedItem().toString());
        _meteoDataInfo.setDimensionSet(_plotDimension);
        setDimensions();
        this.isSamePlotDim = false;

        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
    }//GEN-LAST:event_jComboBox_PlotDimActionPerformed

    private void jCheckBox_TimeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_TimeStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Time2.setVisible(this.jCheckBox_Time.isSelected());
        if (this.jCheckBox_Time.isSelected()) {
            if (this.jComboBox_Time1.getItemCount() > 0) {
                this.jComboBox_Time1.setSelectedIndex(0);
                this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);
            }
            this.jComboBox_Time1.setEnabled(false);
            this.jComboBox_Time2.setEnabled(false);
        } else {
            this.jComboBox_Time1.setEnabled(true);
            this.jComboBox_Time2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_TimeStateChanged

    private void jCheckBox_LevelStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_LevelStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Level2.setVisible(this.jCheckBox_Level.isSelected());
        if (this.jCheckBox_Level.isSelected()) {
            if (this.jComboBox_Level1.getItemCount() > 0) {
                this.jComboBox_Level1.setSelectedIndex(0);
                this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);
            }
            this.jComboBox_Level1.setEnabled(false);
            this.jComboBox_Level2.setEnabled(false);
        } else {
            this.jComboBox_Level1.setEnabled(true);
            this.jComboBox_Level2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_LevelStateChanged

    private void jCheckBox_LatStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_LatStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Lat2.setVisible(this.jCheckBox_Lat.isSelected());
        if (this.jCheckBox_Lat.isSelected()) {
            if (this.jComboBox_Lat1.getItemCount() > 0) {
                this.jComboBox_Lat1.setSelectedIndex(0);
                this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
            }
            this.jComboBox_Lat1.setEnabled(false);
            this.jComboBox_Lat2.setEnabled(false);
        } else {
            this.jComboBox_Lat1.setEnabled(true);
            this.jComboBox_Lat2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_LatStateChanged

    private void jCheckBox_LonStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_LonStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Lon2.setVisible(this.jCheckBox_Lon.isSelected());
        if (this.jCheckBox_Lon.isSelected()) {
            if (this.jComboBox_Lon1.getItemCount() > 0) {
                this.jComboBox_Lon1.setSelectedIndex(0);
                this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);
            }
            this.jComboBox_Lon1.setEnabled(false);
            this.jComboBox_Lon2.setEnabled(false);
        } else {
            this.jComboBox_Lon1.setEnabled(true);
            this.jComboBox_Lon2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_LonStateChanged

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        // TODO add your handling code here:
        this._isLoading = true;

        switch (this._meteoDataInfo.getDataType()) {
            case HYSPLIT_TRAJ:
                this.jPanel_Dimensions.setVisible(false);
                //this.jComboBox_DrawType.setVisible(false);
                this.jComboBox_Lat1.setVisible(false);
                this.jComboBox_Lat2.setVisible(false);
                this.jComboBox_Level1.setVisible(false);
                this.jComboBox_Level2.setVisible(false);
                this.jComboBox_Lon1.setVisible(false);
                this.jComboBox_Lon2.setVisible(false);
                this.jComboBox_PlotDim.setVisible(false);
                this.jComboBox_Time1.setVisible(false);
                this.jComboBox_Time2.setVisible(false);
                this.jCheckBox_Lat.setVisible(false);
                this.jCheckBox_Level.setVisible(false);
                this.jCheckBox_Lon.setVisible(false);
                this.jCheckBox_Time.setVisible(false);
                //this.jLabel_DrawType.setVisible(false);
                this.jLabel_PlotDims.setVisible(false);

                this.jComboBox_Variable.setEditable(false);
                this.jComboBox_Variable.removeAllItems();
                this.jComboBox_Variable.addItem("Altitude");
                this.jComboBox_Variable.addItem("Pressure");
//                HYSPLITTrajDataInfo trajDataInfo = (HYSPLITTrajDataInfo) this._meteoDataInfo.getDataInfo();
//                if (trajDataInfo.varNames.get(0).size() > 0) {
//                    for (String varName : trajDataInfo.varNames.get(0)) {
//                        this.jComboBox_Variable.addItem(varName);
//                    }
//                }
                this.jComboBox_Variable.setSelectedIndex(0);
                break;
            default:
                //Set dimensions
                this.jComboBox_Lat2.setVisible(false);
                this.jComboBox_Level2.setVisible(false);
                this.jComboBox_Lon2.setVisible(false);
                this.jComboBox_Time2.setVisible(false);
                this.jCheckBox_Time.setEnabled(false);
                this.jCheckBox_Level.setEnabled(false);
                this.jCheckBox_Lon.setEnabled(false);
                this.jCheckBox_Lat.setEnabled(false);

                updateDimensions();
                break;
        }

        //Set draw type
        this.jComboBox_DrawType.removeAllItems();
        for (ChartPlotMethod method : ChartPlotMethod.values()) {
            this.jComboBox_DrawType.addItem(method);
        }
        this.jComboBox_DrawType.setSelectedItem(ChartPlotMethod.LINE_POINT);

        _isLoading = false;

    }//GEN-LAST:event_formWindowOpened

    private void onAddToLayoutClick() {
        MapLayout mapLayout = mainGUI.getMapDocument().getMapLayout();
        LayoutChart chart = new LayoutChart();
        chart.setLeft(100);
        chart.setTop(100);
        mapLayout.addElement(chart);
        chart.setChart(this._chartPanel.getChart());
        mapLayout.paintGraphics();
    }

    private void setVariableParas(Variable var) {
        int i;
        int levelIdx = this.jComboBox_Level1.getSelectedIndex();

        this.jComboBox_Level1.removeAllItems();
        Dimension zDim = var.getZDimension();
        if (zDim == null) {
            this.jComboBox_Level1.addItem("Surface");
            this.jComboBox_Level1.setSelectedIndex(0);
        } else {
            for (i = 0; i < var.getLevelNum(); i++) {
                this.jComboBox_Level1.addItem(String.valueOf(zDim.getDimValue().getDouble(i)));
            }
            if ((levelIdx > -1) && (this.jComboBox_Level1.getItemCount() > levelIdx)) {
                this.jComboBox_Level1.setSelectedIndex(levelIdx);
            } else {
                this.jComboBox_Level1.setSelectedIndex(0);
            }
        }
    }

    private void updateDimensions() {
        int i;

        //Set time
        this.jComboBox_Time1.removeAllItems();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        for (i = 0; i < _meteoDataInfo.getDataInfo().getTimeNum(); i++) {
            this.jComboBox_Time1.addItem(sdf.format(_meteoDataInfo.getDataInfo().getTimes().get(i)));
        }
        this.jComboBox_Time1.setSelectedIndex(0);

        //Set lon/lat
        this.jComboBox_Lon1.removeAllItems();
        for (i = 0; i < (_meteoDataInfo.getDataInfo()).getXDimension().getLength(); i++) {
            this.jComboBox_Lon1.addItem(String.valueOf((_meteoDataInfo.getDataInfo()).getXDimension().getDimValue().getDouble(i)));
        }
        this.jComboBox_Lon1.setSelectedIndex(0);

        this.jComboBox_Lat1.removeAllItems();
        for (i = 0; i < (_meteoDataInfo.getDataInfo()).getYDimension().getLength(); i++) {
            this.jComboBox_Lat1.addItem(String.valueOf((_meteoDataInfo.getDataInfo()).getYDimension().getDimValue().getDouble(i)));
        }
        this.jComboBox_Lat1.setSelectedIndex(0);

        updateEndDimSet();

        //Set vars
        this.jComboBox_Variable.setEnabled(true);
        this.jComboBox_Variable.removeAllItems();
        for (i = 0; i < _meteoDataInfo.getDataInfo().getVariableNum(); i++) {
            Variable var = _meteoDataInfo.getDataInfo().getVariables().get(i);
            if (var.isPlottable()) {                
                this.jComboBox_Variable.addItem(var.getName());
            }
        }
        _isLoading = false;
        this.jComboBox_Variable.setSelectedIndex(0);
    }

    private void updateEndDimSet() {
        int i;
        this.jComboBox_Time2.removeAllItems();
        for (i = 0; i < this.jComboBox_Time1.getItemCount(); i++) {
            this.jComboBox_Time2.addItem(this.jComboBox_Time1.getItemAt(i));
        }
        this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);

        this.jComboBox_Level2.removeAllItems();
        for (i = 0; i < this.jComboBox_Level1.getItemCount(); i++) {
            this.jComboBox_Level2.addItem(this.jComboBox_Level1.getItemAt(i));
        }
        this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);

        this.jComboBox_Lon2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lon1.getItemCount(); i++) {
            this.jComboBox_Lon2.addItem(this.jComboBox_Lon1.getItemAt(i));
        }
        this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);

        this.jComboBox_Lat2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lat1.getItemCount(); i++) {
            this.jComboBox_Lat2.addItem(this.jComboBox_Lat1.getItemAt(i));
        }
        this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
    }

    private void updateEndDimSetS(JComboBox CB1, JComboBox CB2) {
        CB2.removeAllItems();
        for (int i = 0; i < CB1.getItemCount(); i++) {
            CB2.addItem(CB1.getItemAt(i));
        }
        CB2.setSelectedIndex(CB2.getItemCount() - 1);
    }

    private void setDimensions() {
        switch (_plotDimension) {
            case Time:
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(false);
                break;
            case Level:
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(false);
                break;
            case Lat:
                this.jCheckBox_Lat.setSelected(true);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(false);
                break;
            case Lon:
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(true);
                break;
        }
    }

    private void createChart(XYDataset dataset, List<ColorBreak> legendBreaks, String title, String xLabel, String yLabel,
                             ChartPlotMethod method, PlotOrientation orientation, boolean yInverse, boolean xInverse, boolean isTime,
                             boolean drawLegend) {
        XY1DPlot plot = new XY1DPlot(isTime, orientation, dataset);
        if (title != null) {
            plot.setTitle(title);
        }
        //plot.setAutoPosition(true);
        plot.setChartPlotMethod(method);
        plot.getAxis(Location.TOP).setVisible(false);
        plot.getAxis(Location.RIGHT).setVisible(false);
        plot.setDrawLegend(drawLegend);
        plot.getGridLine().setDrawXLine(true);
        plot.getGridLine().setDrawYLine(true);
        plot.getXAxis().setInverse(xInverse);
        plot.getYAxis().setInverse(yInverse);
        plot.getXAxis().setInsideTick(false);
        plot.getYAxis().setInsideTick(false);
        plot.getXAxis().setDrawLabel(true);
        plot.getYAxis().setDrawLabel(true);
        if (orientation == PlotOrientation.VERTICAL) {
            plot.getXAxis().setLabel(xLabel);
            plot.getYAxis().setLabel(yLabel);
        } else {
            plot.getXAxis().setLabel(yLabel);
            plot.getYAxis().setLabel(xLabel);
        }
        if (legendBreaks != null) {
            for (int i = 0; i < dataset.getSeriesCount(); i++) {
                String caption = dataset.getSeriesKey(i);
                PolylineBreak plb = (PolylineBreak) legendBreaks.get(i);
                plb.setCaption(caption);
                switch (method) {
                    case LINE:
                        plb.setDrawSymbol(false);
                        plot.setLegendBreak(i, plb);
                        break;
                    case LINE_POINT:
                        plb.setDrawSymbol(true);
                        plot.setLegendBreak(i, plb);
                        break;
                    case POINT:
                        PointBreak pb = new PointBreak();
                        pb.setColor(plb.getSymbolColor());
                        pb.setSize(plb.getSymbolSize());
                        pb.setStyle(plb.getSymbolStyle());
                        pb.setCaption(caption);
                        plot.setLegendBreak(i, pb);
                        break;
                    case BAR:
                        PolygonBreak pgb = new PolygonBreak();
                        pgb.setColor(plb.getColor());
                        pgb.setCaption(caption);
                        plot.setLegendBreak(i, pgb);
                        break;
                }
            }
        }

        Chart chart = new Chart(plot);
        //chart.setAntiAlias(true);
        //chart.setDrawLegend(drawLegend);
        this._chartPanel.setChart(chart);
        this._chartPanel.paintGraphics();
    }

//    private void createChart_backup(List<List<PointD>> points, String title, String xLabel, String yLabel, List<String> serieNames, String chartType, 
//            PlotOrientation po, boolean yInverse, boolean xInverse) {                
//        if (chartType.equals("Line")) {
//            XYSeriesCollection xyseriescollection = new XYSeriesCollection();
//            int i = 0;
//            for (List<PointD> plist : points) {
//                XYSeries xySeries = new XYSeries(serieNames.get(i));
//                for (PointD p : plist) {
//                    xySeries.add(p.X, p.Y);
//                }
//                xyseriescollection.addSeries(xySeries);
//                i += 1;
//            }
//            JFreeChart chart = ChartFactory.createXYLineChart(title, xLabel, yLabel,
//                    xyseriescollection, PlotOrientation.VERTICAL, true, true, false);
//            XYPlot plot = chart.getXYPlot();
//            plot.setOrientation(po);
//            plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
//            plot.setDomainPannable(true);
//            plot.setRangePannable(true);
//            plot.setBackgroundPaint(null);
//            plot.setRangeGridlinePaint(Color.gray);
//            LegendTitle legend = (LegendTitle) chart.getSubtitle(0);
//            legend.setPosition(RectangleEdge.TOP);
//            NumberAxis yAxis = (NumberAxis) plot.getRangeAxis();
//            yAxis.setAutoRangeIncludesZero(false);
//            yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
//            yAxis.setInverted(yInverse);
//            ValueAxis xAxis = plot.getDomainAxis();
//            xAxis.setInverted(xInverse);
//            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer) plot.getRenderer();
//            renderer.setBaseShapesVisible(true);
//            renderer.setBaseShapesFilled(false);            
//            this._chartPanel.setChart(chart);
//            this._chartPanel.repaint();
//        } else if (chartType.equals("Bar")) {
//            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
//            int i = 0;
//            for (List<PointD> plist : points) {
//                String sName = serieNames.get(i);
//                for (PointD p : plist) {
//                    dataset.addValue(p.Y, sName, String.valueOf(p.X));
//                }
//                i += 1;
//            }
//            JFreeChart chart = ChartFactory.createBarChart(title, xLabel, yLabel, dataset, PlotOrientation.VERTICAL, true, true, true);
//            CategoryPlot plot = chart.getCategoryPlot();
//            plot.setOrientation(po);
//            plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
//            NumberAxis yAxis = (NumberAxis) plot.getRangeAxis();
//            yAxis.setAutoRangeIncludesZero(false);
//            yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
//            yAxis.setInverted(yInverse);
//            this._chartPanel.setChart(chart);
//            this._chartPanel.repaint();
//        }
//    }
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FrmOneDim.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FrmOneDim.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FrmOneDim.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrmOneDim.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new FrmOneDim(null, null).setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton_Animator;
    private javax.swing.JButton jButton_ClearDraw;
    private javax.swing.JButton jButton_DataInfo;
    private javax.swing.JButton jButton_Draw;
    private javax.swing.JButton jButton_NexTime;
    private javax.swing.JButton jButton_PreTime;
    private javax.swing.JButton jButton_ViewData;
    private javax.swing.JCheckBox jCheckBox_Lat;
    private javax.swing.JCheckBox jCheckBox_Level;
    private javax.swing.JCheckBox jCheckBox_Lon;
    private javax.swing.JCheckBox jCheckBox_Time;
    private javax.swing.JCheckBox jCheckBox_YReverse;
    private javax.swing.JComboBox jComboBox_DrawType;
    private javax.swing.JComboBox jComboBox_Lat1;
    private javax.swing.JComboBox jComboBox_Lat2;
    private javax.swing.JComboBox jComboBox_Level1;
    private javax.swing.JComboBox jComboBox_Level2;
    private javax.swing.JComboBox jComboBox_Lon1;
    private javax.swing.JComboBox jComboBox_Lon2;
    private javax.swing.JComboBox jComboBox_PlotDim;
    private javax.swing.JComboBox jComboBox_Time1;
    private javax.swing.JComboBox jComboBox_Time2;
    private javax.swing.JComboBox jComboBox_Variable;
    private javax.swing.JLabel jLabel_DrawType;
    private javax.swing.JLabel jLabel_PlotDims;
    private javax.swing.JLabel jLabel_Variable;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel_Dimensions;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JToolBar jToolBar1;
    // End of variables declaration//GEN-END:variables
}
