/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.meteoinfo.map.forms;

import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.Variable;

import java.util.List;
import javax.swing.DefaultComboBoxModel;

/**
 *
 * @author User
 */
public class FrmUVSet extends javax.swing.JDialog {

    private boolean _isOK = false;

    /**
     * Creates new form FrmUVSet
     *
     * @param parent
     * @param modal
     */
    public FrmUVSet(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jRadioButton_UV = new javax.swing.JRadioButton();
        jRadioButton_DirSpeed = new javax.swing.JRadioButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jSpinner_XSkip = new javax.swing.JSpinner();
        jSpinner_YSkip = new javax.swing.JSpinner();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jComboBox_UDir = new javax.swing.JComboBox();
        jComboBox_VSpeed = new javax.swing.JComboBox();
        jComboBox_UData = new javax.swing.JComboBox();
        jComboBox_VData = new javax.swing.JComboBox();
        jButton_OK = new javax.swing.JButton();
        jButton_Cancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        buttonGroup1.add(jRadioButton_UV);
        jRadioButton_UV.setText("U/V");
        jRadioButton_UV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton_UVActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton_DirSpeed);
        jRadioButton_DirSpeed.setText("Direction/Speed");
        jRadioButton_DirSpeed.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton_DirSpeedActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jRadioButton_UV)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jRadioButton_DirSpeed)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButton_UV)
                    .addComponent(jRadioButton_DirSpeed))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Skip Factors"));

        jSpinner_XSkip.setModel(new javax.swing.SpinnerNumberModel(1, null, null, 1));

        jSpinner_YSkip.setModel(new javax.swing.SpinnerNumberModel(1, null, null, 1));

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSpinner_XSkip, javax.swing.GroupLayout.PREFERRED_SIZE, 68, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSpinner_YSkip)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jSpinner_XSkip, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jSpinner_YSkip, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel3.setText("U/Direction:");

        jLabel4.setText("V/Speed:");

        jComboBox_UDir.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_UDir.setPreferredSize(new java.awt.Dimension(142, 24));

        jComboBox_VSpeed.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_VSpeed.setPreferredSize(new java.awt.Dimension(142, 24));

        jComboBox_UData.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_UData.setPreferredSize(new java.awt.Dimension(142, 24));
        jComboBox_UData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_UDataActionPerformed(evt);
            }
        });

        jComboBox_VData.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_VData.setPreferredSize(new java.awt.Dimension(142, 24));
        jComboBox_VData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_VDataActionPerformed(evt);
            }
        });

        jButton_OK.setText("OK");
        jButton_OK.setPreferredSize(new java.awt.Dimension(69, 23));
        jButton_OK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_OKActionPerformed(evt);
            }
        });

        jButton_Cancel.setText("Cancel");
        jButton_Cancel.setPreferredSize(new java.awt.Dimension(6, 23));
        jButton_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_CancelActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(34, 34, 34)
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox_VSpeed, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel3)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jComboBox_UDir, 0, 159, Short.MAX_VALUE))
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jComboBox_UData, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jComboBox_VData, 0, 235, Short.MAX_VALUE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jButton_OK, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton_Cancel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(35, 35, 35))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3)
                            .addComponent(jComboBox_UDir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox_UData, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(21, 21, 21)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox_VSpeed, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4)
                    .addComponent(jButton_OK, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox_VData, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton_Cancel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jRadioButton_UVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton_UVActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton_UVActionPerformed

    private void jRadioButton_DirSpeedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton_DirSpeedActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton_DirSpeedActionPerformed

    private void jButton_OKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_OKActionPerformed
        // TODO add your handling code here:
        this._isOK = true;
        this.dispose();
    }//GEN-LAST:event_jButton_OKActionPerformed

    private void jButton_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_CancelActionPerformed
        // TODO add your handling code here:
        this.dispose();
    }//GEN-LAST:event_jButton_CancelActionPerformed

    private void jComboBox_UDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_UDataActionPerformed
        // TODO add your handling code here:
        MeteoDataInfo mdi = (MeteoDataInfo) this.jComboBox_UData.getSelectedItem();
        this.updateUData(mdi);
    }//GEN-LAST:event_jComboBox_UDataActionPerformed

    private void updateUData(MeteoDataInfo mdi){
        DataInfo aDataInfo = mdi.getDataInfo();
        this.jComboBox_UDir.removeAllItems();
        for (int i = 0; i < aDataInfo.getVariables().size(); i++) {
            Variable var = aDataInfo.getVariables().get(i);
            if (mdi.isSWATHData()) {
                Variable lonvar = aDataInfo.getVariable("longitude");
                if (var.dimensionContains(lonvar)) {
                    this.jComboBox_UDir.addItem(var.getName());
                }
            } else {
                if (var.isPlottable()) {
                    this.jComboBox_UDir.addItem(var.getName());
                }
            }
        }
        this.jComboBox_UDir.setSelectedItem(mdi.getVariableName());
    }
    
    private void jComboBox_VDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_VDataActionPerformed
        // TODO add your handling code here:
        MeteoDataInfo mdi = (MeteoDataInfo) this.jComboBox_VData.getSelectedItem();
        this.updateVData(mdi);
    }//GEN-LAST:event_jComboBox_VDataActionPerformed

    private void updateVData(MeteoDataInfo mdi){
        DataInfo aDataInfo = mdi.getDataInfo();
        this.jComboBox_VSpeed.removeAllItems();
        for (int i = 0; i < aDataInfo.getVariables().size(); i++) {
            Variable var = aDataInfo.getVariables().get(i);
            if (mdi.isSWATHData()) {
                Variable lonvar = aDataInfo.getVariable("longitude");
                if (var.dimensionContains(lonvar)) {
                    this.jComboBox_VSpeed.addItem(var.getName());
                }
            } else {
                if (var.isPlottable()) {
                    this.jComboBox_VSpeed.addItem(var.getName());
                }
            }
        }
        this.jComboBox_VSpeed.setSelectedItem(mdi.getVariableName());
    }
    
    /**
     * Set U/V data info
     *
     * @param dfs Data info list
     */
    public void setUVData(List<MeteoDataInfo> dfs) {
        DefaultComboBoxModel umodel = new DefaultComboBoxModel();
        DefaultComboBoxModel vmodel = new DefaultComboBoxModel();
        for (int i = 0; i < dfs.size(); i++) {
            umodel.addElement(dfs.get(i));
            vmodel.addElement(dfs.get(i));
        }
        this.jComboBox_UData.setModel(umodel);
        this.jComboBox_VData.setModel(vmodel);
    }

    /**
     * Set U/V items
     *
     * @param vList Variable names
     */
    public void setUVItems(List<String> vList) {
        int i;
        this.jComboBox_UDir.removeAllItems();
        this.jComboBox_VSpeed.removeAllItems();
        for (i = 0; i < vList.size(); i++) {
            this.jComboBox_UDir.addItem(vList.get(i));
            this.jComboBox_VSpeed.addItem(vList.get(i));
        }
    }

    /**
     * Set if is U/V
     *
     * @param isTrue Boolean
     */
    public void setUV(boolean isTrue) {
        if (isTrue) {
            this.jRadioButton_UV.setSelected(true);
        } else {
            this.jRadioButton_DirSpeed.setSelected(true);
        }
    }

    /**
     * Set U/Wind directory variable name
     *
     * @param ustr U/Wind directory variable name
     */
    public void setUStr(String ustr) {
        this.jComboBox_UDir.setSelectedItem(ustr);
    }

    /**
     * Set V/Wind speed variable name
     *
     * @param vstr V/Wind speed variable name
     */
    public void setVStr(String vstr) {
        this.jComboBox_VSpeed.setSelectedItem(vstr);
    }

    /**
     * Set x skip value
     *
     * @param xskip X skip
     */
    public void setXSkip(int xskip) {
        this.jSpinner_XSkip.setValue(xskip);
    }

    /**
     * Set y skip value
     *
     * @param yskip Y skip
     */
    public void setYSkip(int yskip) {
        this.jSpinner_YSkip.setValue(yskip);
    }

    /**
     * Get U data info
     *
     * @return U data info
     */
    public MeteoDataInfo getUData() {
        return (MeteoDataInfo) this.jComboBox_UData.getSelectedItem();
    }
    
    /**
     * Set U data info
     * @param value U data info
     */
    public void setUData(MeteoDataInfo value){
        this.jComboBox_UData.setSelectedItem(value);
        this.updateUData(value);
    }

    /**
     * Get V data info
     *
     * @return V data info
     */
    public MeteoDataInfo getVData() {
        return (MeteoDataInfo) this.jComboBox_VData.getSelectedItem();
    }
    
    /**
     * Set V data info
     * @param value V data info
     */
    public void setVData(MeteoDataInfo value){
        this.jComboBox_VData.setSelectedItem(value);
        this.updateVData(value);
    }

    /**
     * Get U/V variable names
     *
     * @return Variable names
     */
    public String[] getUVItems() {
        String uStr = this.jComboBox_UDir.getSelectedItem().toString();
        String vStr = this.jComboBox_VSpeed.getSelectedItem().toString();

        return new String[]{uStr, vStr};
    }

    /**
     * Get if OK button is pressed
     *
     * @return Boolean
     */
    public boolean isOK() {
        return _isOK;
    }

    /**
     * Get if is U/V
     *
     * @return Boolean
     */
    public boolean isUV() {
        return this.jRadioButton_UV.isSelected();
    }

    /**
     * Get x skip
     *
     * @return X skip
     */
    public int getXSkip() {
        return Integer.parseInt(this.jSpinner_XSkip.getValue().toString());
    }

    /**
     * Get y skip
     *
     * @return Y skip
     */
    public int getYSkip() {
        return Integer.parseInt(this.jSpinner_YSkip.getValue().toString());
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrmUVSet.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                FrmUVSet dialog = new FrmUVSet(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton_Cancel;
    private javax.swing.JButton jButton_OK;
    private javax.swing.JComboBox jComboBox_UData;
    private javax.swing.JComboBox jComboBox_UDir;
    private javax.swing.JComboBox jComboBox_VData;
    private javax.swing.JComboBox jComboBox_VSpeed;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton jRadioButton_DirSpeed;
    private javax.swing.JRadioButton jRadioButton_UV;
    private javax.swing.JSpinner jSpinner_XSkip;
    private javax.swing.JSpinner jSpinner_YSkip;
    // End of variables declaration//GEN-END:variables
}
