/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.image.ImageUtil;
import org.meteoinfo.map.config.GenericFileFilter;

public class FrmGifAnimator
extends JDialog {
    private JButton jButton_AddFiles;
    private JButton jButton_Clear;
    private JButton jButton_Create;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList_ImageFiles;
    private JScrollPane jScrollPane1;
    private JTextField jTextField_Delay;
    private JTextField jTextField_Repeat;

    public FrmGifAnimator(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jList_ImageFiles.setModel(new DefaultListModel());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList_ImageFiles = new JList();
        this.jButton_AddFiles = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextField_Delay = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField_Repeat = new JTextField();
        this.jButton_Create = new JButton();
        this.jButton_Clear = new JButton();
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setViewportView(this.jList_ImageFiles);
        this.jButton_AddFiles.setText("Add Image Files");
        this.jButton_AddFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGifAnimator.this.jButton_AddFilesActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Delay (ms):");
        this.jTextField_Delay.setText("1000");
        this.jLabel2.setText("Repeat times:");
        this.jTextField_Repeat.setText("0");
        this.jButton_Create.setText("Create");
        this.jButton_Create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGifAnimator.this.jButton_CreateActionPerformed(evt);
            }
        });
        this.jButton_Clear.setText("Clear");
        this.jButton_Clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGifAnimator.this.jButton_ClearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jButton_AddFiles).addGap(37, 37, 37).addComponent(this.jButton_Clear).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Delay, -2, 69, -2).addGap(37, 37, 37).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Repeat, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 57, Short.MAX_VALUE).addComponent(this.jButton_Create, -2, 99, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_AddFiles).addComponent(this.jButton_Clear)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 354, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField_Delay, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jTextField_Repeat, -2, -1, -2).addComponent(this.jButton_Create)).addContainerGap()));
        this.pack();
    }

    private void jButton_AddFilesActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"gif", "jpg", "png"};
        GenericFileFilter allFileFilter = new GenericFileFilter(fileExts, "Supported Formats");
        aDlg.addChoosableFileFilter(allFileFilter);
        fileExts = new String[]{"gif"};
        GenericFileFilter gifFileFilter = new GenericFileFilter(fileExts, "Gif File (*.gif)");
        aDlg.addChoosableFileFilter(gifFileFilter);
        fileExts = new String[]{"png"};
        GenericFileFilter pngFileFilter = new GenericFileFilter(fileExts, "Png File (*.png)");
        aDlg.addChoosableFileFilter(pngFileFilter);
        fileExts = new String[]{"jpg"};
        GenericFileFilter jpgFileFilter = new GenericFileFilter(fileExts, "Jpeg File (*.jpg)");
        aDlg.addChoosableFileFilter(jpgFileFilter);
        aDlg.setFileFilter(allFileFilter);
        aDlg.setMultiSelectionEnabled(true);
        if (0 == aDlg.showOpenDialog(this)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            DefaultListModel<File> listModel = (DefaultListModel<File>)this.jList_ImageFiles.getModel();
            if (listModel == null) {
                listModel = new DefaultListModel<File>();
            }
            for (File f : files) {
                listModel.addElement(f.getAbsoluteFile());
            }
            this.jList_ImageFiles.setModel(listModel);
        }
    }

    private void jButton_ClearActionPerformed(ActionEvent evt) {
        this.jList_ImageFiles.setModel(new DefaultListModel());
    }

    private void jButton_CreateActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser saveDlg = new JFileChooser();
        saveDlg.setAcceptAllFileFilterUsed(false);
        saveDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"gif"};
        GenericFileFilter gifFileFilter = new GenericFileFilter(fileExts, "Gif File (*.gif)");
        saveDlg.setFileFilter(gifFileFilter);
        if (0 == saveDlg.showSaveDialog(this)) {
            File outfile = saveDlg.getSelectedFile();
            String extent = ((GenericFileFilter)saveDlg.getFileFilter()).getFileExtent();
            String fileName = outfile.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            DefaultListModel listModel = (DefaultListModel)this.jList_ImageFiles.getModel();
            ArrayList<String> fns = new ArrayList<String>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                fns.add(listModel.get(i).toString());
            }
            int delay = Integer.parseInt(this.jTextField_Delay.getText());
            int repeat = Integer.parseInt(this.jTextField_Repeat.getText());
            ImageUtil.createGifAnimator(fns, (String)fileName, (int)delay, (int)repeat);
            JOptionPane.showMessageDialog(null, "Gif animator file is created!");
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmGifAnimator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmGifAnimator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmGifAnimator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmGifAnimator.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmGifAnimator dialog = new FrmGifAnimator((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

