/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.data.GridDataSetting;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.grads.GrADSDataInfo;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.map.config.GenericFileFilter;
import org.meteoinfo.map.forms.FrmGridSet;
import org.meteoinfo.map.forms.FrmMain;

public class FrmOutputMapData
extends JDialog {
    private List<VectorLayer> _mapLayers = new ArrayList<VectorLayer>();
    private VectorLayer _currentLayer;
    private FrmMain _parent;
    private JButton jButton_Close;
    private JButton jButton_Output;
    private JComboBox jComboBox_MapLayer;
    private JComboBox jComboBox_OutputFormat;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JProgressBar jProgressBar1;

    public FrmOutputMapData(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this._parent = (FrmMain)parent;
        this.initialize();
    }

    private void initialize() {
        int i;
        this.jProgressBar1.setVisible(false);
        for (i = 0; i < this._parent.getMapDocument().getActiveMapFrame().getMapView().getLayerNum(); ++i) {
            if (((MapLayer)this._parent.getMapDocument().getActiveMapFrame().getMapView().getLayers().get(i)).getLayerType() != LayerTypes.VECTOR_LAYER) continue;
            VectorLayer aLayer = (VectorLayer)this._parent.getMapDocument().getActiveMapFrame().getMapView().getLayers().get(i);
            this._mapLayers.add(aLayer);
        }
        this.jComboBox_MapLayer.removeAllItems();
        if (this._mapLayers.size() > 0) {
            for (i = 0; i < this._mapLayers.size(); ++i) {
                this.jComboBox_MapLayer.addItem(this._mapLayers.get(i).getLayerName());
            }
            this.jComboBox_MapLayer.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox_MapLayer = new JComboBox();
        this.jComboBox_OutputFormat = new JComboBox();
        this.jButton_Output = new JButton();
        this.jButton_Close = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setTitle("Output Map Data");
        this.jLabel1.setText("Map Layer:");
        this.jLabel2.setText("Output Format:");
        this.jComboBox_MapLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_MapLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOutputMapData.this.jComboBox_MapLayerActionPerformed(evt);
            }
        });
        this.jComboBox_OutputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButton_Output.setText("Output");
        this.jButton_Output.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOutputMapData.this.jButton_OutputActionPerformed(evt);
            }
        });
        this.jButton_Close.setText("Close");
        this.jButton_Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOutputMapData.this.jButton_CloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_MapLayer, -2, 245, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_OutputFormat, 0, -1, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(55, 55, 55).addComponent(this.jButton_Output).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_Close).addGap(49, 49, 49)).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_MapLayer, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jComboBox_OutputFormat, -2, -1, -2)).addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Output).addComponent(this.jButton_Close)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addComponent(this.jProgressBar1, -2, 22, -2)));
        this.pack();
    }

    private void jComboBox_MapLayerActionPerformed(ActionEvent evt) {
        if (this.jComboBox_MapLayer.getItemCount() > 0) {
            this._currentLayer = this._mapLayers.get(this.jComboBox_MapLayer.getSelectedIndex());
            String str = this.jComboBox_OutputFormat.getSelectedItem().toString();
            this.jComboBox_OutputFormat.removeAllItems();
            this.jComboBox_OutputFormat.addItem("ASCII wmp File");
            this.jComboBox_OutputFormat.addItem("Shape File");
            this.jComboBox_OutputFormat.addItem("KML File");
            switch (this._currentLayer.getShapeType()) {
                case POLYGON: 
                case POLYGON_M: 
                case POLYGON_Z: {
                    this.jComboBox_OutputFormat.addItem("GrADS Maskout File");
                }
            }
            ArrayList<String> items = new ArrayList<String>();
            for (int i = 0; i < this.jComboBox_OutputFormat.getItemCount(); ++i) {
                items.add(this.jComboBox_OutputFormat.getItemAt(i).toString());
            }
            int idx = items.indexOf(str);
            if (idx >= 0) {
                this.jComboBox_OutputFormat.setSelectedIndex(idx);
            } else {
                this.jComboBox_OutputFormat.setSelectedIndex(0);
            }
        }
    }

    private void jButton_CloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton_OutputActionPerformed(ActionEvent evt) {
        String format = this.jComboBox_OutputFormat.getSelectedItem().toString();
        if (format.equals("ASCII wmp File")) {
            try {
                this.saveWMPFile();
            }
            catch (IOException ex) {
                Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (format.equals("GrADS Map File")) {
            this.saveGrADSMapFile();
        } else if (format.equals("GrADS Maskout File")) {
            try {
                this.saveGrADSMaskoutFile();
            }
            catch (IOException ex) {
                Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (format.equals("Shape File")) {
            this.saveShapeFile();
        } else if (format.equals("Surfer BLN File")) {
            this.saveBLNMapFile();
        } else if (format.equals("KML File")) {
            this.saveKMLFile();
        }
    }

    private void saveWMPFile() throws IOException {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"wmp"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "wmp File (*.wmp)");
        aDlg.setFileFilter(mapFileFilter);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        aDlg.setAcceptAllFileFilterUsed(false);
        if (aDlg.showSaveDialog(this) == 0) {
            this.jProgressBar1.setVisible(true);
            this.jProgressBar1.setValue(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
                file = new File(fileName);
            }
            BufferedWriter sw = new BufferedWriter(new FileWriter(file));
            List selIndexes = this._currentLayer.getSelectedShapeIndexes();
            boolean hasSelShape = this._currentLayer.hasSelectedShapes();
            int shpNum = this._currentLayer.getShapeNum();
            if (hasSelShape) {
                shpNum = selIndexes.size();
            }
            switch (this._currentLayer.getShapeType()) {
                case POINT: {
                    sw.write("Point");
                    sw.newLine();
                    sw.write(String.valueOf(shpNum));
                    sw.newLine();
                    if (hasSelShape) {
                        for (int i = 0; i < this._currentLayer.getShapeNum(); ++i) {
                            PointShape aPS = (PointShape)this._currentLayer.getShapes().get(i);
                            if (aPS.isSelected()) {
                                sw.write(String.valueOf(aPS.getPoint().X) + "," + String.valueOf(aPS.getPoint().Y));
                                sw.newLine();
                            }
                            this.jProgressBar1.setValue((i + 1) * 100 / this._currentLayer.getShapeNum());
                        }
                    } else {
                        for (int i = 0; i < this._currentLayer.getShapeNum(); ++i) {
                            PointShape aPS = (PointShape)this._currentLayer.getShapes().get(i);
                            sw.write(String.valueOf(aPS.getPoint().X) + "," + String.valueOf(aPS.getPoint().Y));
                            sw.newLine();
                            this.jProgressBar1.setValue((i + 1) * 100 / this._currentLayer.getShapeNum());
                        }
                    }
                    break;
                }
                case POLYLINE: 
                case POLYLINE_Z: {
                    PolylineShape aPLS;
                    int i;
                    sw.write("Polyline");
                    sw.newLine();
                    int shapeNum = 0;
                    for (i = 0; i < this._currentLayer.getShapeNum(); ++i) {
                        aPLS = (PolylineShape)this._currentLayer.getShapes().get(i);
                        if (hasSelShape && !aPLS.isSelected()) continue;
                        shapeNum += aPLS.getPartNum();
                    }
                    sw.write(String.valueOf(shpNum));
                    sw.newLine();
                    for (i = 0; i < this._currentLayer.getShapeNum(); ++i) {
                        aPLS = (PolylineShape)this._currentLayer.getShapes().get(i);
                        if (hasSelShape && !aPLS.isSelected()) continue;
                        for (int p = 0; p < aPLS.getPartNum(); ++p) {
                            int pp;
                            PointD[] Pointps;
                            if (p == aPLS.getPartNum() - 1) {
                                Pointps = new PointD[aPLS.getPointNum() - aPLS.parts[p]];
                                for (pp = aPLS.parts[p]; pp < aPLS.getPointNum(); ++pp) {
                                    Pointps[pp - aPLS.parts[p]] = (PointD)aPLS.getPoints().get(pp);
                                }
                            } else {
                                Pointps = new PointD[aPLS.parts[p + 1] - aPLS.parts[p]];
                                for (pp = aPLS.parts[p]; pp < aPLS.parts[p + 1]; ++pp) {
                                    Pointps[pp - aPLS.parts[p]] = (PointD)aPLS.getPoints().get(pp);
                                }
                            }
                            sw.write(String.valueOf(Pointps.length));
                            sw.newLine();
                            for (PointD aPoint : Pointps) {
                                sw.write(String.valueOf(aPoint.X) + "," + String.valueOf(aPoint.Y));
                                sw.newLine();
                            }
                            ++shapeNum;
                        }
                        this.jProgressBar1.setValue((i + 1) * 100 / this._currentLayer.getShapeNum());
                    }
                    break;
                }
                case POLYGON: {
                    PolygonShape aPGS;
                    int i;
                    sw.write("Polygon");
                    sw.newLine();
                    int shapeNum = 0;
                    for (i = 0; i < this._currentLayer.getShapeNum(); ++i) {
                        aPGS = (PolygonShape)this._currentLayer.getShapes().get(i);
                        if (hasSelShape && !aPGS.isSelected()) continue;
                        shapeNum += aPGS.getPartNum();
                    }
                    sw.write(String.valueOf(shapeNum));
                    sw.newLine();
                    for (i = 0; i < this._currentLayer.getShapeNum(); ++i) {
                        aPGS = (PolygonShape)this._currentLayer.getShapes().get(i);
                        if (hasSelShape && !aPGS.isSelected()) continue;
                        for (int p = 0; p < aPGS.getPartNum(); ++p) {
                            int pp;
                            PointD[] Pointps;
                            if (p == aPGS.getPartNum() - 1) {
                                Pointps = new PointD[aPGS.getPointNum() - aPGS.parts[p]];
                                for (pp = aPGS.parts[p]; pp < aPGS.getPointNum(); ++pp) {
                                    Pointps[pp - aPGS.parts[p]] = (PointD)aPGS.getPoints().get(pp);
                                }
                            } else {
                                Pointps = new PointD[aPGS.parts[p + 1] - aPGS.parts[p]];
                                for (pp = aPGS.parts[p]; pp < aPGS.parts[p + 1]; ++pp) {
                                    Pointps[pp - aPGS.parts[p]] = (PointD)aPGS.getPoints().get(pp);
                                }
                            }
                            sw.write(String.valueOf(Pointps.length));
                            sw.newLine();
                            for (PointD aPoint : Pointps) {
                                sw.write(String.valueOf(aPoint.X) + "," + String.valueOf(aPoint.Y));
                                sw.newLine();
                            }
                            ++shapeNum;
                        }
                        this.jProgressBar1.setValue((i + 1) * 100 / this._currentLayer.getShapeNum());
                    }
                    break;
                }
            }
            sw.close();
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setVisible(false);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void saveGrADSMapFile() {
    }

    private void saveGrADSMaskoutFile() throws IOException {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"ctl"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "GrADS File (*.ctl)");
        aDlg.setFileFilter(mapFileFilter);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        aDlg.setAcceptAllFileFilterUsed(false);
        if (aDlg.showSaveDialog(this) == 0) {
            PolygonShape aPGS;
            int i;
            this.setCursor(Cursor.getPredefinedCursor(3));
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            boolean hasSelShape = this._currentLayer.hasSelectedShapes();
            Extent aExtent = new Extent();
            int n = 0;
            for (i = 0; i < this._currentLayer.getShapeNum(); ++i) {
                aPGS = (PolygonShape)this._currentLayer.getShapes().get(i);
                if (hasSelShape && !aPGS.isSelected()) continue;
                aExtent = n == 0 ? aPGS.getExtent() : MIMath.getLagerExtent((Extent)aExtent, (Extent)aPGS.getExtent());
                ++n;
            }
            GridDataSetting aGDP = new GridDataSetting();
            aGDP.dataExtent.minX = Math.floor(aExtent.minX);
            aGDP.dataExtent.maxX = Math.ceil(aExtent.maxX);
            aGDP.dataExtent.minY = Math.floor(aExtent.minY);
            aGDP.dataExtent.maxY = Math.ceil(aExtent.maxY);
            aGDP.xNum = 20;
            aGDP.yNum = 20;
            FrmGridSet aFrmGS = new FrmGridSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), true);
            aFrmGS.setParameters(aGDP);
            aFrmGS.setLocationRelativeTo(this);
            aFrmGS.setVisible(true);
            if (aFrmGS.isOK()) {
                aGDP = aFrmGS.getParameters();
                this.jProgressBar1.setVisible(true);
                this.jProgressBar1.setValue(0);
                this.setCursor(Cursor.getPredefinedCursor(3));
                double[][] gridData = new double[aGDP.yNum][aGDP.xNum];
                PointD aPoint = new PointD();
                double xSize = (aGDP.dataExtent.maxX - aGDP.dataExtent.minX) / (double)(aGDP.xNum - 1);
                double ySize = (aGDP.dataExtent.maxY - aGDP.dataExtent.minY) / (double)(aGDP.yNum - 1);
                for (i = 0; i < aGDP.yNum; ++i) {
                    aPoint.Y = aGDP.dataExtent.minY + (double)i * ySize;
                    for (int j = 0; j < aGDP.xNum; ++j) {
                        aPoint.X = aGDP.dataExtent.minX + (double)j * xSize;
                        boolean isIn = false;
                        for (int p = 0; p < this._currentLayer.getShapeNum(); ++p) {
                            aPGS = (PolygonShape)this._currentLayer.getShapes().get(p);
                            if (hasSelShape && !aPGS.isSelected() || !GeoComputation.pointInPolygon((PolygonShape)aPGS, (PointD)aPoint)) continue;
                            isIn = true;
                            break;
                        }
                        gridData[i][j] = isIn ? 1.0 : -1.0;
                    }
                    this.jProgressBar1.setValue((i + 1) * 100 / aGDP.yNum);
                }
                String dFile = fileName.replace(".ctl", ".dat");
                GrADSDataInfo aDataInfo = new GrADSDataInfo();
                aDataInfo.setFileName(fileName);
                aDataInfo.TITLE = "Mask data";
                aDataInfo.DSET = dFile;
                aDataInfo.DTYPE = "GRIDDED";
                aDataInfo.XDEF.Type = "LINEAR";
                aDataInfo.XDEF.XNum = aGDP.xNum;
                aDataInfo.XDEF.XMin = (float)aGDP.dataExtent.minX;
                aDataInfo.XDEF.XDelt = (float)xSize;
                aDataInfo.YDEF.Type = "LINEAR";
                aDataInfo.YDEF.YNum = aGDP.yNum;
                aDataInfo.YDEF.YMin = (float)aGDP.dataExtent.minY;
                aDataInfo.YDEF.YDelt = (float)ySize;
                aDataInfo.ZDEF.Type = "LINEAR";
                aDataInfo.ZDEF.ZNum = 1;
                aDataInfo.ZDEF.SLevel = 1.0f;
                aDataInfo.ZDEF.ZDelt = 1.0f;
                aDataInfo.TDEF.Type = "LINEAR";
                aDataInfo.TDEF.STime = LocalDateTime.now();
                aDataInfo.TDEF.TDelt = "1mo";
                Variable aVar = new Variable();
                aVar.setName("mask");
                aVar.setUnits("99");
                aVar.setDescription("background mask data");
                aDataInfo.VARDEF.addVar(aVar);
                aDataInfo.writeGrADSCTLFile();
                aDataInfo.createDataFile(dFile);
                aDataInfo.writeGridData(gridData);
                aDataInfo.closeDataFile();
                this.jProgressBar1.setValue(0);
                this.jProgressBar1.setVisible(false);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void saveShapeFile() {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"shp"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
        aDlg.setFileFilter(mapFileFilter);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        aDlg.setAcceptAllFileFilterUsed(false);
        if (aDlg.showSaveDialog(this) == 0) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            this.saveShapeFile(fileName);
        }
    }

    private void saveShapeFile_bak(final String fileName) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                int i;
                FrmOutputMapData.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmOutputMapData.this.jProgressBar1.setVisible(true);
                FrmOutputMapData.this.jProgressBar1.setValue(0);
                VectorLayer aLayer = new VectorLayer(FrmOutputMapData.this._currentLayer.getShapeType());
                for (i = 0; i < FrmOutputMapData.this._currentLayer.getFieldNumber(); ++i) {
                    aLayer.editAddField(FrmOutputMapData.this._currentLayer.getField(i).getColumnName(), FrmOutputMapData.this._currentLayer.getField(i).getDataType());
                }
                boolean hasSelShape = FrmOutputMapData.this._currentLayer.hasSelectedShapes();
                for (i = 0; i < FrmOutputMapData.this._currentLayer.getShapeNum(); ++i) {
                    Shape aPS = (Shape)FrmOutputMapData.this._currentLayer.getShapes().get(i);
                    if (hasSelShape && !aPS.isSelected()) continue;
                    int sNum = aLayer.getShapeNum();
                    try {
                        if (aLayer.editInsertShape(aPS, sNum)) {
                            for (int j = 0; j < aLayer.getFieldNumber(); ++j) {
                                aLayer.editCellValue(j, sNum, FrmOutputMapData.this._currentLayer.getCellValue(j, i));
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    FrmOutputMapData.this.jProgressBar1.setValue((int)((double)i / (double)FrmOutputMapData.this._currentLayer.getShapeNum() * 100.0));
                }
                aLayer.setProjInfo(FrmOutputMapData.this._currentLayer.getProjInfo());
                aLayer.saveFile(fileName);
                return "";
            }

            @Override
            protected void done() {
                FrmOutputMapData.this.setCursor(Cursor.getDefaultCursor());
                FrmOutputMapData.this.jProgressBar1.setVisible(false);
            }
        };
        worker.execute();
    }

    private void saveShapeFile(String fileName) {
        int i;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jProgressBar1.setVisible(true);
        this.jProgressBar1.setValue(0);
        VectorLayer aLayer = new VectorLayer(this._currentLayer.getShapeType());
        for (i = 0; i < this._currentLayer.getFieldNumber(); ++i) {
            aLayer.editAddField(this._currentLayer.getField(i).getColumnName(), this._currentLayer.getField(i).getDataType());
        }
        boolean hasSelShape = this._currentLayer.hasSelectedShapes();
        for (i = 0; i < this._currentLayer.getShapeNum(); ++i) {
            Shape aPS = (Shape)this._currentLayer.getShapes().get(i);
            if (hasSelShape && !aPS.isSelected()) continue;
            int sNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape(aPS, sNum)) {
                    for (int j = 0; j < aLayer.getFieldNumber(); ++j) {
                        aLayer.editCellValue(j, sNum, this._currentLayer.getCellValue(j, i));
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.jProgressBar1.setValue((int)((double)i / (double)this._currentLayer.getShapeNum() * 100.0));
        }
        aLayer.setProjInfo(this._currentLayer.getProjInfo());
        aLayer.saveFile(fileName);
        this.setCursor(Cursor.getDefaultCursor());
        this.jProgressBar1.setVisible(false);
    }

    private void saveBLNMapFile() {
    }

    private void saveKMLFile() {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"kml"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "KML File (*.kml)");
        aDlg.setFileFilter(mapFileFilter);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        aDlg.setAcceptAllFileFilterUsed(false);
        if (aDlg.showSaveDialog(this) == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            this._currentLayer.saveAsKMLFile(fileName);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmOutputMapData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmOutputMapData dialog = new FrmOutputMapData(new FrmMain(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

