/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.concurrent.Immutable;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;

@Immutable
public final class Range {
    public static final Range EMPTY = new Range();
    public static final Range ONE = new Range(1);
    public static final Range VLEN = new Range(-1);
    private final int n;
    private final int first;
    private final int stride;
    private final String name;

    private Range() {
        this.n = 0;
        this.first = 0;
        this.stride = 1;
        this.name = null;
    }

    public Range(int first, int last) throws InvalidRangeException {
        this(null, first, last, 1);
    }

    public Range(int length) {
        this.name = null;
        this.first = 0;
        this.stride = 1;
        this.n = length;
        assert (this.n != 0);
    }

    public Range(String name, int first, int last) throws InvalidRangeException {
        this(name, first, last, 1);
    }

    public Range(int first, int last, int stride) throws InvalidRangeException {
        this(null, first, last, stride);
    }

    public Range(String name, int first, int last, int stride) throws InvalidRangeException {
        if (first < 0) {
            throw new InvalidRangeException("first (" + first + ") must be >= 0");
        }
        if (last < first) {
            throw new InvalidRangeException("last (" + last + ") must be >= first (" + first + ")");
        }
        if (stride < 1) {
            throw new InvalidRangeException("stride (" + stride + ") must be > 0");
        }
        this.name = name;
        this.first = first;
        this.stride = stride;
        this.n = Math.max(1 + (last - first) / stride, 1);
        assert (this.n != 0);
    }

    public Range(Range r) {
        this.first = r.first();
        this.n = r.length();
        this.stride = r.stride();
        this.name = r.getName();
        assert (this.n != 0);
    }

    public Range(String name, Range r) {
        this.name = name;
        this.first = r.first();
        this.n = r.length();
        this.stride = r.stride();
        assert (this.n != 0);
    }

    public Range compose(Range r) throws InvalidRangeException {
        if (this.length() == 0 || r.length() == 0) {
            return EMPTY;
        }
        if (this == VLEN || r == VLEN) {
            return VLEN;
        }
        int sr_stride = this.stride() * r.stride();
        int sr_first = this.element(r.first());
        int lastx = this.element(r.last());
        int sr_last = this.last() < lastx ? this.last() : lastx;
        return new Range(this.name, sr_first, sr_last, sr_stride);
    }

    public Range compact() throws InvalidRangeException {
        if (this.stride() == 1) {
            return this;
        }
        int first = this.first() / this.stride();
        int last = first + this.length() - 1;
        return new Range(this.name, first, last, 1);
    }

    public Range shiftOrigin(int origin) throws InvalidRangeException {
        if (this == VLEN) {
            return VLEN;
        }
        int first = this.first() - origin;
        int stride = this.stride();
        int last = this.last() - origin;
        return new Range(this.name, first, last, stride);
    }

    public Range intersect(Range r) throws InvalidRangeException {
        int useFirst;
        if (this.length() == 0 || r.length() == 0) {
            return EMPTY;
        }
        if (this == VLEN || r == VLEN) {
            return VLEN;
        }
        int last = Math.min(this.last(), r.last());
        int stride = this.stride() * r.stride();
        if (stride == 1) {
            useFirst = Math.max(this.first(), r.first());
        } else if (this.stride() == 1) {
            if (r.first() >= this.first()) {
                useFirst = r.first();
            } else {
                int incr = (this.first() - r.first()) / stride;
                useFirst = r.first() + incr * stride;
                if (useFirst < this.first()) {
                    useFirst += stride;
                }
            }
        } else if (r.stride() == 1) {
            if (this.first() >= r.first()) {
                useFirst = this.first();
            } else {
                int incr = (r.first() - this.first()) / stride;
                useFirst = this.first() + incr * stride;
                if (useFirst < r.first()) {
                    useFirst += stride;
                }
            }
        } else {
            throw new UnsupportedOperationException("Intersection when both ranges have a stride");
        }
        if (useFirst > last) {
            return EMPTY;
        }
        return new Range(this.name, useFirst, last, stride);
    }

    public boolean intersects(Range r) {
        int useFirst;
        if (this.length() == 0 || r.length() == 0) {
            return false;
        }
        if (this == VLEN || r == VLEN) {
            return true;
        }
        int last = Math.min(this.last(), r.last());
        int stride = this.stride() * r.stride();
        if (stride == 1) {
            useFirst = Math.max(this.first(), r.first());
        } else if (this.stride() == 1) {
            if (r.first() >= this.first()) {
                useFirst = r.first();
            } else {
                int incr = (this.first() - r.first()) / stride;
                useFirst = r.first() + incr * stride;
                if (useFirst < this.first()) {
                    useFirst += stride;
                }
            }
        } else if (r.stride() == 1) {
            if (this.first() >= r.first()) {
                useFirst = this.first();
            } else {
                int incr = (r.first() - this.first()) / stride;
                useFirst = this.first() + incr * stride;
                if (useFirst < r.first()) {
                    useFirst += stride;
                }
            }
        } else {
            throw new UnsupportedOperationException("Intersection when both ranges have a stride");
        }
        return useFirst <= last;
    }

    public boolean past(Range want) {
        return this.first() > want.last();
    }

    public Range union(Range r) throws InvalidRangeException {
        if (this.length() == 0) {
            return r;
        }
        if (this == VLEN || r == VLEN) {
            return VLEN;
        }
        if (r.length() == 0) {
            return this;
        }
        int first = Math.min(this.first(), r.first());
        int last = Math.max(this.last(), r.last());
        return new Range(this.name, first, last);
    }

    public int length() {
        return this.n;
    }

    public int element(int i) throws InvalidRangeException {
        if (i < 0) {
            throw new InvalidRangeException("i must be >= 0");
        }
        if (i >= this.n) {
            throw new InvalidRangeException("i must be < length");
        }
        return this.first + i * this.stride;
    }

    public int index(int elem) throws InvalidRangeException {
        if (elem < this.first) {
            throw new InvalidRangeException("elem must be >= first");
        }
        int result = (elem - this.first) / this.stride;
        if (result > this.n) {
            throw new InvalidRangeException("elem must be <= first = n * stride");
        }
        return result;
    }

    public boolean contains(int i) {
        if (i < this.first()) {
            return false;
        }
        if (i > this.last()) {
            return false;
        }
        if (this.stride == 1) {
            return true;
        }
        return (i - this.first) % this.stride == 0;
    }

    public int elementNC(int i) {
        return this.first + i * this.stride;
    }

    public int first() {
        return this.first;
    }

    public int last() {
        return this.first + (this.n - 1) * this.stride;
    }

    public int stride() {
        return this.stride;
    }

    public String getName() {
        return this.name;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    public int getFirstInInterval(int start) {
        if (start > this.last()) {
            return -1;
        }
        if (start <= this.first) {
            return this.first;
        }
        if (this.stride == 1) {
            return start;
        }
        int offset = start - this.first;
        int i = offset / this.stride;
        i = offset % this.stride == 0 ? i : i + 1;
        return this.first + i * this.stride;
    }

    public String toString() {
        if (this.n == 0) {
            return "EMPTY";
        }
        if (this.n < 0) {
            return "VLEN";
        }
        return this.first + ":" + this.last() + (this.stride > 1 ? ":" + this.stride : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range or = (Range)o;
        if (this.n == 0 && or.n == 0) {
            return true;
        }
        return or.first == this.first && or.n == this.n && or.stride == this.stride;
    }

    public int hashCode() {
        int result = this.first();
        result = 37 * result + this.last();
        result = 37 * result + this.stride();
        return result;
    }

    public int min() {
        if (this.n > 0) {
            if (this.stride > 0) {
                return this.first;
            }
            return this.first + (this.n - 1) * this.stride;
        }
        return this.first;
    }

    public int max() {
        if (this.n > 0) {
            if (this.stride > 0) {
                return this.first + (this.n - 1) * this.stride;
            }
            return this.first;
        }
        if (this.stride > 0) {
            return this.first - 1;
        }
        return this.first + 1;
    }

    public static List factory(int[] shape) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (int i = 0; i < shape.length; ++i) {
            try {
                result.add(new Range(0, Math.max(shape[i] - 1, -1)));
                continue;
            }
            catch (InvalidRangeException e) {
                return null;
            }
        }
        return result;
    }

    public static List setDefaults(List rangeList, int[] shape) {
        try {
            if (rangeList == null) {
                rangeList = new ArrayList<Range>();
                for (int i = 0; i < shape.length; ++i) {
                    rangeList.add(new Range(0, shape[i]));
                }
                return rangeList;
            }
            for (int i = 0; i < shape.length; ++i) {
                Range r = (Range)rangeList.get(i);
                if (r != null) continue;
                rangeList.set(i, new Range(0, shape[i] - 1));
            }
            return rangeList;
        }
        catch (InvalidRangeException ex) {
            return null;
        }
    }

    public static List factory(int[] origin, int[] shape) throws InvalidRangeException {
        ArrayList<Range> result = new ArrayList<Range>();
        for (int i = 0; i < shape.length; ++i) {
            try {
                result.add(new Range(origin[i], origin[i] + shape[i] - 1));
                continue;
            }
            catch (Exception e) {
                throw new InvalidRangeException(e.getMessage());
            }
        }
        return result;
    }

    public static int[] getShape(List ranges) {
        if (ranges == null) {
            return null;
        }
        int[] result = new int[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            result[i] = ((Range)ranges.get(i)).length();
        }
        return result;
    }

    public static String toString(List ranges) {
        if (ranges == null) {
            return "";
        }
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < ranges.size(); ++i) {
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(((Range)ranges.get(i)).length());
        }
        return sbuff.toString();
    }

    public static long computeSize(List section) {
        int[] shape = Range.getShape(section);
        return Index.computeSize(shape);
    }

    public static List appendShape(List ranges, int size) throws InvalidRangeException {
        ranges.add(new Range(0, size - 1));
        return ranges;
    }

    public static int[] getOrigin(List ranges) {
        if (ranges == null) {
            return null;
        }
        int[] result = new int[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            result[i] = ((Range)ranges.get(i)).first();
        }
        return result;
    }

    public static Range[] toArray(List ranges) {
        if (ranges == null) {
            return null;
        }
        return ranges.toArray(new Range[ranges.size()]);
    }

    public static List toList(Range[] ranges) {
        if (ranges == null) {
            return null;
        }
        return Arrays.asList(ranges);
    }

    public static String makeSectionSpec(List ranges) {
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < ranges.size(); ++i) {
            Range r = (Range)ranges.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(r.toString());
        }
        return sbuff.toString();
    }

    public static List parseSpec(String sectionSpec) throws InvalidRangeException {
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer stoke = new StringTokenizer(sectionSpec, "(),");
        while (stoke.hasMoreTokens()) {
            Range section;
            String s = stoke.nextToken().trim();
            if (s.equals(":")) {
                section = null;
            } else {
                if (s.indexOf(58) < 0) {
                    try {
                        int index = Integer.parseInt(s);
                        section = new Range(index, index);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + sectionSpec + ">");
                    }
                }
                StringTokenizer stoke2 = new StringTokenizer(s, ":");
                String s1 = stoke2.nextToken();
                String s2 = stoke2.nextToken();
                String s3 = stoke2.hasMoreTokens() ? stoke2.nextToken() : null;
                try {
                    int index1 = Integer.parseInt(s1);
                    int index2 = Integer.parseInt(s2);
                    int stride = s3 != null ? Integer.parseInt(s3) : 1;
                    section = new Range(index1, index2, stride);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + sectionSpec + ">");
                }
            }
            result.add(section);
        }
        return result;
    }

    public static String checkInRange(List section, int[] shape) {
        if (section.size() != shape.length) {
            return "Number of ranges in section must be =" + shape.length;
        }
        for (int i = 0; i < section.size(); ++i) {
            Range r = (Range)section.get(i);
            if (r == null || r.last() < shape[i]) continue;
            return "Illegal range for dimension " + i + ": requested " + r.last() + " >= max " + shape[i];
        }
        return null;
    }

    public class Iterator {
        private int current = 0;

        public boolean hasNext() {
            return this.current < Range.this.n;
        }

        public int next() {
            return Range.this.elementNC(this.current++);
        }
    }
}

