/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArraySequence;
import org.meteoinfo.ndarray.ArrayStructureBak;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureDataW;
import org.meteoinfo.ndarray.StructureMembers;

public class ArrayStructureW
extends ArrayStructureBak {
    public ArrayStructureW(StructureMembers members, int[] shape) {
        super(members, shape);
        this.sdata = new StructureData[this.nelems];
    }

    public ArrayStructureW(StructureData sdata) {
        super(sdata.getStructureMembers(), new int[]{1});
        this.sdata = new StructureData[1];
        this.sdata[0] = sdata;
    }

    public ArrayStructureW(StructureMembers members, int[] shape, StructureData[] sdata) {
        super(members, shape);
        if (this.nelems != sdata.length) {
            throw new IllegalArgumentException("StructureData length= " + sdata.length + "!= shape.length=" + this.nelems);
        }
        this.sdata = sdata;
    }

    public void setStructureData(StructureData sd, int index) {
        this.sdata[index] = sd;
    }

    @Override
    protected StructureData makeStructureData(ArrayStructureBak as, int index) {
        return new StructureDataW(as.getStructureMembers());
    }

    @Override
    public Array getArray(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getArray(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getArray(m.getName());
    }

    @Override
    public double getScalarDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarDouble(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarDouble(m.getName());
    }

    @Override
    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayDouble(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayDouble(m.getName());
    }

    @Override
    public float getScalarFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarFloat(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarFloat(m.getName());
    }

    @Override
    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayFloat(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayFloat(m.getName());
    }

    @Override
    public byte getScalarByte(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarByte(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarByte(m.getName());
    }

    @Override
    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayByte(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayByte(m.getName());
    }

    @Override
    public short getScalarShort(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarShort(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarShort(m.getName());
    }

    @Override
    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayShort(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayShort(m.getName());
    }

    @Override
    public int getScalarInt(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarInt(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarInt(m.getName());
    }

    @Override
    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayInt(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayInt(m.getName());
    }

    @Override
    public long getScalarLong(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarLong(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarLong(m.getName());
    }

    @Override
    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayLong(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayLong(m.getName());
    }

    @Override
    public char getScalarChar(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarChar(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarChar(m.getName());
    }

    @Override
    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayChar(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayChar(m.getName());
    }

    @Override
    public String getScalarString(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarString(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarString(m.getName());
    }

    @Override
    public String[] getJavaArrayString(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getJavaArrayString(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getJavaArrayString(m.getName());
    }

    @Override
    public StructureData getScalarStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getScalarStructure(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getScalarStructure(m.getName());
    }

    @Override
    public ArrayStructureBak getArrayStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getArrayStructure(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getArrayStructure(m.getName());
    }

    @Override
    public ArraySequence getArraySequence(int recnum, StructureMembers.Member m) {
        if (m.getDataArray() != null) {
            return super.getArraySequence(recnum, m);
        }
        StructureData sd = this.getStructureData(recnum);
        return sd.getArraySequence(m.getName());
    }
}

