/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.util.BigDecimalUtil;

public class Dimension {
    private String name;
    private DimensionType _dimType;
    private List<Double> _dimValue = new ArrayList<Double>();
    private int _dimId;
    private int length = 1;
    private boolean unlimited = false;
    private boolean variableLength = false;
    private boolean shared = true;
    private boolean reverse = false;

    public Dimension() {
        this("null", 1);
    }

    public Dimension(String name, int len) {
        this.name = name;
        this.length = len;
        this._dimType = DimensionType.OTHER;
        this._dimValue = new ArrayList<Double>();
    }

    public Dimension(DimensionType dimType) {
        this(dimType.toString(), 1, dimType);
    }

    public Dimension(String name, int len, DimensionType dimType) {
        this(name, len);
        this._dimType = dimType;
        this._dimValue = new ArrayList<Double>();
    }

    public Dimension(String name, int len, DimensionType dimType, double min, double delta, int num) {
        this(name, len);
        this._dimType = dimType;
        this._dimValue = new ArrayList<Double>();
        for (int i = 0; i < num; ++i) {
            this._dimValue.add(min + delta * (double)i);
        }
    }

    public String getShortName() {
        return this.name;
    }

    public void setShortName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int value) {
        if (value <= 0) {
            return;
        }
        this.length = value;
        if (this._dimValue == null) {
            this._dimValue = new ArrayList<Double>();
        }
        if (this._dimValue.size() != value) {
            this._dimValue.clear();
            for (int i = 0; i < value; ++i) {
                this._dimValue.add(Double.valueOf(i));
            }
        }
    }

    public DimensionType getDimType() {
        return this._dimType;
    }

    public void setDimType(DimensionType value) {
        this._dimType = value;
    }

    public List<Double> getDimValue() {
        return this._dimValue;
    }

    public Array getDimArray() {
        int n = this.getLength();
        Array r = Array.factory(DataType.DOUBLE, new int[]{n});
        for (int i = 0; i < n; ++i) {
            r.setDouble(i, (double)this._dimValue.get(i));
        }
        return r;
    }

    public double getDimValue(int idx) {
        return this._dimValue.get(idx);
    }

    public int getDimId() {
        return this._dimId;
    }

    public void setDimId(int value) {
        this._dimId = value;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean value) {
        this.reverse = value;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean value) {
        this.unlimited = value;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean value) {
        this.shared = value;
    }

    public boolean isVariableLength() {
        return this.variableLength;
    }

    public void setVariableLength(boolean value) {
        this.variableLength = value;
    }

    public boolean equals(Dimension aDim) {
        if (!this.getShortName().equals(aDim.getShortName())) {
            return false;
        }
        if (this._dimType != aDim.getDimType()) {
            return false;
        }
        return this.getLength() == aDim.getLength();
    }

    public double[] getValues() {
        int len = this.getLength();
        double[] values = new double[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this._dimValue.get(i);
        }
        return values;
    }

    public void setValues(List<Double> values) {
        this._dimValue = values;
        this.setLength(this._dimValue.size());
    }

    public void setDimValues(List<Number> values) {
        this._dimValue = new ArrayList<Double>();
        for (Number v : values) {
            this._dimValue.add(v.doubleValue());
        }
        this.setLength(this._dimValue.size());
    }

    public void setValues(double[] values) {
        this._dimValue = new ArrayList<Double>();
        for (double v : values) {
            this._dimValue.add(v);
        }
        this.setLength(this._dimValue.size());
    }

    public void setValues(float[] values) {
        this._dimValue = new ArrayList<Double>();
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double v = fArray[i];
            this._dimValue.add(v);
        }
        this.setLength(this._dimValue.size());
    }

    public void addValue(double value) {
        this._dimValue.add(value);
        this.setLength(this._dimValue.size());
    }

    public double getMinValue() {
        return this._dimValue.get(0);
    }

    public double getMaxValue() {
        return this._dimValue.get(this._dimValue.size() - 1);
    }

    public double getDeltaValue() {
        if (this._dimValue.size() <= 1) {
            return 1.0;
        }
        return BigDecimalUtil.sub(this._dimValue.get(1), this._dimValue.get(0));
    }

    public Dimension extract(Range range) {
        return this.extract(range.first(), range.last(), range.stride());
    }

    public Dimension extract(int first, int last, int stride) {
        int n = (last - first) / stride + 1;
        Dimension dim = new Dimension(this.getShortName(), n, this._dimType);
        dim.setDimId(this._dimId);
        if (this._dimValue.size() > last) {
            ArrayList<Double> values = new ArrayList<Double>();
            if (first <= last) {
                if (stride > 0) {
                    for (int i = first; i <= last; i += stride) {
                        values.add(this._dimValue.get(i));
                    }
                } else {
                    for (int i = last; i >= first; i += stride) {
                        values.add(this._dimValue.get(i));
                    }
                }
            } else if (stride > 0) {
                for (int i = last; i <= first; i += stride) {
                    values.add(this._dimValue.get(i));
                }
            } else {
                for (int i = first; i >= last; i += stride) {
                    values.add(this._dimValue.get(i));
                }
            }
            dim.setValues(values);
        }
        return dim;
    }

    public Dimension extract(double first, double last, double stride) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this._dimType);
        dim.setDimId(this._dimId);
        ArrayList<Double> values = new ArrayList<Double>();
        for (double v = first; v <= last; v += stride) {
            int idx = this.getValueIndex(v);
            values.add(this._dimValue.get(idx));
        }
        dim.setValues(values);
        return dim;
    }

    public Dimension extract(List<Integer> index) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this._dimType);
        dim.setDimId(this._dimId);
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < index.size(); ++i) {
            values.add(this._dimValue.get(index.get(i)));
        }
        dim.setValues(values);
        return dim;
    }

    public Dimension extract(Array index) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this._dimType);
        dim.setDimId(this._dimId);
        ArrayList<Double> values = new ArrayList<Double>();
        IndexIterator iter = index.getIndexIterator();
        while (iter.hasNext()) {
            values.add(this._dimValue.get(iter.getIntNext()));
        }
        dim.setValues(values);
        return dim;
    }

    public int getValueIndex(double v) {
        int idx;
        block4: {
            idx = this._dimValue.indexOf(v);
            if (idx >= 0) break block4;
            idx = this.getLength() - 1;
            if (this.getDeltaValue() > 0.0) {
                for (int i = 0; i < this.getLength(); ++i) {
                    if (!(v <= this._dimValue.get(i))) continue;
                    idx = i == 0 ? 0 : (this._dimValue.get(i) - v > v - this._dimValue.get(i - 1) ? i - 1 : i);
                    break;
                }
            } else {
                for (int i = 0; i < this.getLength(); ++i) {
                    if (!(v >= this._dimValue.get(i))) continue;
                    idx = i == 0 ? 0 : (this._dimValue.get(i - 1) - v > v - this._dimValue.get(i) ? i : i - 1);
                    break;
                }
            }
        }
        return idx;
    }

    public void reverse() {
        Collections.reverse(this._dimValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getShortName());
        sb.append("\n");
        sb.append("Min value: ").append(String.valueOf(this.getMinValue()));
        sb.append("\n");
        sb.append("Max value: ").append(String.valueOf(this.getMaxValue()));
        sb.append("\n");
        sb.append("Size: ").append(String.valueOf(this.getLength()));
        sb.append("\n");
        sb.append("Delta: ").append(String.valueOf(this.getDeltaValue()));
        return sb.toString();
    }
}

