/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.io.IOException;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayStructureBak;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureDataA;
import org.meteoinfo.ndarray.StructureMembers;

public class ArrayStructureMA
extends ArrayStructureBak {
    public ArrayStructureMA(StructureMembers members, int[] shape) {
        super(members, shape);
    }

    public ArrayStructureMA(StructureMembers members, int[] shape, StructureData[] sdata) {
        super(members, shape);
        if (this.nelems != sdata.length) {
            throw new IllegalArgumentException("StructureData length= " + sdata.length + "!= shape.length=" + this.nelems);
        }
        this.sdata = sdata;
    }

    public static ArrayStructureMA factoryMA(ArrayStructureBak from) throws IOException {
        if (from instanceof ArrayStructureMA) {
            return (ArrayStructureMA)from;
        }
        StructureMembers tosm = new StructureMembers(new StructureMembers(from.getStructureMembers()));
        ArrayStructureMA to = new ArrayStructureMA(tosm, from.getShape());
        for (StructureMembers.Member m : from.getMembers()) {
            to.setMemberArray(m.getName(), from.extractMemberArray(m));
        }
        return to;
    }

    @Override
    protected StructureData makeStructureData(ArrayStructureBak as, int index) {
        return new StructureDataA(as, index);
    }

    public void setMemberArray(String memberName, Array data) {
        StructureMembers.Member m = this.members.findMember(memberName);
        m.setDataArray(data);
    }

    private static int[] combine(int[] shape1, int[] shape2) {
        int[] result = new int[shape1.length + shape2.length];
        System.arraycopy(shape1, 0, result, 0, shape1.length);
        System.arraycopy(shape2, 0, result, shape1.length, shape2.length);
        return result;
    }
}

