/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;

public class FlatIndex {
    private Array array;
    private Index index;

    public FlatIndex(Array array) {
        this.array = array;
        this.index = this.array.getIndex();
    }

    public Object getObject(int idx) {
        this.index.setCurrentIndex(idx);
        return this.array.getObject(this.index);
    }

    public void setObject(int idx, Object value) {
        this.index.setCurrentIndex(idx);
        this.array.setObject(this.index, value);
    }

    public Array section(int first, int last, int stride) {
        int n = 1 + Math.abs(last - first) / Math.abs(stride);
        Array r = Array.factory(this.array.dataType, new int[]{n});
        int ii = 0;
        if (last >= first) {
            for (int i = first; i <= last; i += stride) {
                this.index.setCurrentIndex(i);
                r.setObject(ii, this.array.getObject(this.index));
                ++ii;
            }
        } else {
            for (int i = first; i >= last; i += stride) {
                this.index.setCurrentIndex(i);
                r.setObject(ii, this.array.getObject(this.index));
                ++ii;
            }
        }
        return r;
    }

    public Array section(List<Integer> idx) {
        Array r = Array.factory(this.array.dataType, new int[]{idx.size()});
        int ii = 0;
        for (int i : idx) {
            this.index.setCurrentIndex(i);
            r.setObject(ii, this.array.getObject(this.index));
            ++ii;
        }
        return r;
    }

    public void setSection(int first, int last, int stride, Object value) {
        if (last >= first) {
            for (int i = first; i <= last; i += stride) {
                this.index.setCurrentIndex(i);
                this.array.setObject(this.index, value);
            }
        } else {
            for (int i = first; i >= last; i += stride) {
                this.index.setCurrentIndex(i);
                this.array.setObject(this.index, value);
            }
        }
    }

    public void setSection(int first, int last, int stride, Array value) {
        IndexIterator iterator = value.getIndexIterator();
        if (last >= first) {
            for (int i = first; i <= last; i += stride) {
                this.index.setCurrentIndex(i);
                this.array.setObject(this.index, iterator.getObjectNext());
            }
        } else {
            for (int i = first; i >= last; i += stride) {
                this.index.setCurrentIndex(i);
                this.array.setObject(this.index, iterator.getObjectNext());
            }
        }
    }

    public void setSection(List<Integer> idx, Object value) {
        for (int i : idx) {
            this.index.setCurrentIndex(i);
            this.array.setObject(this.index, value);
        }
    }

    public void setSection(List<Integer> idx, Array value) {
        IndexIterator iterator = value.getIndexIterator();
        for (int i : idx) {
            this.index.setCurrentIndex(i);
            this.array.setObject(this.index, iterator.getObjectNext());
        }
    }
}

