/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureDataIterator;

public enum DataType {
    BOOLEAN("boolean", 1, Boolean.TYPE, false, 0),
    BYTE("byte", 1, Byte.TYPE, false, 1),
    CHAR("char", 1, Character.TYPE, false, 18),
    SHORT("short", 2, Short.TYPE, false, 3),
    INT("int", 4, Integer.TYPE, false, 7),
    LONG("long", 8, Long.TYPE, false, 9),
    FLOAT("float", 4, Float.TYPE, false, 11),
    DOUBLE("double", 8, Double.TYPE, false, 12),
    COMPLEX("complex", 1, Complex.class, false, 15),
    DATE("date", 1, LocalDateTime.class, false, 21),
    SEQUENCE("Sequence", 4, StructureDataIterator.class, false, 22),
    STRING("String", 4, String.class, false, 19),
    STRUCTURE("Structure", 1, StructureData.class, false, 23),
    ENUM1("enum1", 1, Byte.TYPE, false, 24),
    ENUM2("enum2", 2, Short.TYPE, false, 25),
    ENUM4("enum4", 4, Integer.TYPE, false, 26),
    OPAQUE("opaque", 1, ByteBuffer.class, false, 27),
    OBJECT("object", 1, Object.class, false, 30),
    UBYTE("ubyte", 1, Byte.TYPE, true, 2),
    USHORT("ushort", 2, Short.TYPE, true, 4),
    UINT("uint", 4, Integer.TYPE, true, 8),
    ULONG("ulong", 8, Long.TYPE, true, 10);

    private final String niceName;
    private final int size;
    private final Class primitiveClass;
    private final Signedness signedness;
    private final int number;

    private DataType(String s, int size, Class primitiveClass, boolean isUnsigned, int number) {
        this(s, size, primitiveClass, isUnsigned ? Signedness.UNSIGNED : Signedness.SIGNED, number);
    }

    private DataType(String s, int size, Class primitiveClass, Signedness signedness, int number) {
        this.niceName = s;
        this.size = size;
        this.primitiveClass = primitiveClass;
        this.signedness = signedness;
        this.number = number;
    }

    public String toString() {
        return this.niceName;
    }

    public int getSize() {
        return this.size;
    }

    public Class getClassType() {
        return this.getPrimitiveClassType();
    }

    public Class getPrimitiveClassType() {
        return this.primitiveClass;
    }

    public Signedness getSignedness() {
        return this.signedness;
    }

    public boolean isUnsigned() {
        return this.signedness == Signedness.UNSIGNED;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isString() {
        return this == STRING || this == CHAR;
    }

    public boolean isBoolean() {
        return this == BOOLEAN;
    }

    public boolean isNumeric() {
        return this == BYTE || this == FLOAT || this == DOUBLE || this == INT || this == SHORT || this == LONG || this == COMPLEX;
    }

    public boolean isIntegral() {
        return this == BYTE || this == INT || this == SHORT || this == LONG;
    }

    public boolean isFloatingPoint() {
        return this == FLOAT || this == DOUBLE;
    }

    public boolean isEnum() {
        return this == ENUM1 || this == ENUM2 || this == ENUM4;
    }

    public static DataType getType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return DataType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static DataType getType(Class c) {
        if (c == Float.TYPE || c == Float.class) {
            return FLOAT;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DOUBLE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return SHORT;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return INT;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return BYTE;
        }
        if (c == Character.TYPE || c == Character.class) {
            return CHAR;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == Long.TYPE || c == Long.class) {
            return LONG;
        }
        if (c == String.class) {
            return STRING;
        }
        if (c == Complex.class) {
            return COMPLEX;
        }
        if (c == LocalDateTime.class) {
            return DATE;
        }
        if (c == StructureData.class) {
            return STRUCTURE;
        }
        if (c == StructureDataIterator.class) {
            return SEQUENCE;
        }
        if (c == ByteBuffer.class) {
            return OPAQUE;
        }
        return null;
    }

    public static DataType getType(Class c, boolean isUnsigned) {
        if (c == Float.TYPE || c == Float.class) {
            return FLOAT;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DOUBLE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return isUnsigned ? USHORT : SHORT;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return isUnsigned ? UINT : INT;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return isUnsigned ? UBYTE : BYTE;
        }
        if (c == Character.TYPE || c == Character.class) {
            return CHAR;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == Long.TYPE || c == Long.class) {
            return isUnsigned ? ULONG : LONG;
        }
        if (c == String.class) {
            return STRING;
        }
        if (c == StructureData.class) {
            return STRUCTURE;
        }
        if (c == StructureDataIterator.class) {
            return SEQUENCE;
        }
        if (c == ByteBuffer.class) {
            return OPAQUE;
        }
        return OBJECT;
    }

    public static String unsignedLongToString(long li) {
        if (li >= 0L) {
            return Long.toString(li);
        }
        byte[] val = new byte[8];
        for (int i = 0; i < 8; ++i) {
            val[7 - i] = (byte)(li & 0xFFL);
            li >>>= 8;
        }
        BigInteger biggy = new BigInteger(1, val);
        return biggy.toString();
    }

    public static long unsignedIntToLong(int i) {
        return i < 0 ? (long)i + 0x100000000L : (long)i;
    }

    public static int unsignedShortToInt(short s) {
        return s & 0xFFFF;
    }

    public static short unsignedByteToShort(byte b) {
        return (short)(b & 0xFF);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 260; ++i) {
            byte b = (byte)i;
            System.out.printf("%4d = %4d%n", b, DataType.unsignedByteToShort(b));
        }
    }

    public static enum Signedness {
        SIGNED,
        UNSIGNED;

    }
}

