/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.io.npy.NpyDataType;
import org.meteoinfo.ndarray.io.npy.NpyFormatException;

public class NpyUtil {
    private NpyUtil() {
    }

    static short u1ToShort(byte b) {
        return (short)(b & 0xFF);
    }

    static short u1ToShort(ByteBuffer buffer) {
        return (short)(buffer.get() & 0xFF);
    }

    static int u2ToInt(byte[] bytes, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes, 0, 2).order(order);
        return NpyUtil.u2ToInt(buffer);
    }

    static int u2ToInt(ByteBuffer buffer) {
        short s = buffer.getShort();
        return s & 0xFFFF;
    }

    static long u4ToLong(byte[] bytes, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes, 0, 4).order(order);
        return NpyUtil.u4ToLong(buffer);
    }

    static long u4ToLong(ByteBuffer buffer) {
        int i = buffer.getInt();
        return (long)i & 0xFFFFFFFFL;
    }

    static BigInteger u8ToBigInteger(ByteBuffer buffer) {
        long i = buffer.getLong();
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        BigInteger upper = BigInteger.valueOf(Integer.toUnsignedLong((int)(i >>> 32)));
        BigInteger lower = BigInteger.valueOf(Integer.toUnsignedLong((int)i));
        return upper.shiftLeft(32).add(lower);
    }

    static float f2ToFloat(ByteBuffer buffer) {
        return NpyUtil.toFloat(buffer.getShort() & 0xFFFF);
    }

    private static float toFloat(int hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((hbits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static DataType toMIDataType(NpyDataType npyDataType) {
        switch (npyDataType) {
            case i1: {
                return DataType.BYTE;
            }
            case i2: {
                return DataType.SHORT;
            }
            case i4: {
                return DataType.INT;
            }
            case i8: {
                return DataType.LONG;
            }
            case f2: 
            case f4: {
                return DataType.FLOAT;
            }
            case f8: {
                return DataType.DOUBLE;
            }
            case u1: {
                return DataType.UBYTE;
            }
            case u2: {
                return DataType.USHORT;
            }
            case u4: {
                return DataType.UINT;
            }
            case u8: {
                return DataType.ULONG;
            }
            case bool: {
                return DataType.BOOLEAN;
            }
            case S: 
            case U: {
                return DataType.STRING;
            }
        }
        return DataType.OBJECT;
    }

    public static NpyDataType toNpyDataType(DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return NpyDataType.i1;
            }
            case SHORT: {
                return NpyDataType.i2;
            }
            case INT: {
                return NpyDataType.i4;
            }
            case LONG: {
                return NpyDataType.i8;
            }
            case FLOAT: {
                return NpyDataType.f4;
            }
            case DOUBLE: {
                return NpyDataType.f8;
            }
            case UBYTE: {
                return NpyDataType.u1;
            }
            case USHORT: {
                return NpyDataType.u2;
            }
            case UINT: {
                return NpyDataType.u4;
            }
            case ULONG: {
                return NpyDataType.u8;
            }
            case BOOLEAN: {
                return NpyDataType.bool;
            }
            case STRING: {
                return NpyDataType.S;
            }
        }
        throw new NpyFormatException("Unsupported data type: " + (Object)((Object)dataType));
    }
}

