/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.shape.CircleShape;
import org.meteoinfo.geometry.shape.CurveLineShape;
import org.meteoinfo.geometry.shape.CurvePolygonShape;
import org.meteoinfo.geometry.shape.EllipseShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.Polygon;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.StationModelShape;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.geometry.shape.WindBarb;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.Reproject;

public class ProjectionUtil {
    public static Extent getProjectionGlobalExtent(ProjectionInfo toProj) {
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        int si = -90;
        int ei = 90;
        switch (toProj.getProjectionName()) {
            case Lambert_Conformal_Conic: {
                si = -80;
                break;
            }
            case North_Polar_Stereographic_Azimuthal: {
                si = 0;
                break;
            }
            case South_Polar_Stereographic_Azimuthal: {
                ei = 0;
            }
        }
        for (int i = si; i <= ei; ++i) {
            double y = i;
            for (int j = -180; j <= 180; ++j) {
                double x = i;
                double[][] points = new double[][]{{x, y}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minX)) {
                        minX = x;
                        minY = y;
                    } else {
                        if (x < minX) {
                            minX = x;
                        }
                        if (y < minY) {
                            minY = y;
                        }
                    }
                    if (Double.isNaN(maxX)) {
                        maxX = x;
                        maxY = y;
                        continue;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (!(y > maxY)) continue;
                    maxY = y;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Extent aExtent = new Extent();
        aExtent.minX = minX;
        aExtent.maxX = maxX;
        aExtent.minY = minY;
        aExtent.maxY = maxY;
        return aExtent;
    }

    public static Extent getProjectionExtent(ProjectionInfo fromProj, ProjectionInfo toProj, List<Number> x, List<Number> y) {
        int i;
        double[] X = new double[x.size()];
        double[] Y = new double[y.size()];
        for (i = 0; i < X.length; ++i) {
            X[i] = x.get(i).doubleValue();
        }
        for (i = 0; i < Y.length; ++i) {
            Y[i] = y.get(i).doubleValue();
        }
        return ProjectionUtil.getProjectionExtent(fromProj, toProj, X, Y);
    }

    public static Extent getProjectionExtent(ProjectionInfo fromProj, ProjectionInfo toProj, Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        double[] X = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] Y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        return ProjectionUtil.getProjectionExtent(fromProj, toProj, X, Y);
    }

    public static Extent getProjectionExtent(ProjectionInfo fromProj, ProjectionInfo toProj, double[] X, double[] Y) {
        double y;
        double x;
        double[][] points;
        int j;
        int i;
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        int minXI = X.length;
        int minYI = Y.length;
        int maxXI = -1;
        int maxYI = -1;
        block8: for (i = 0; i < Y.length; ++i) {
            for (j = 0; j < X.length; ++j) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minY)) {
                        minY = y;
                        minYI = i;
                    }
                    if (i == minYI) {
                        if (!(y < minY)) continue;
                        minY = y;
                        continue;
                    }
                    if (i <= minYI) continue;
                    continue block8;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        block10: for (i = Y.length - 1; i >= 0; --i) {
            for (j = 0; j < X.length; ++j) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(maxY)) {
                        maxY = y;
                        maxYI = i;
                    }
                    if (i == maxYI) {
                        if (!(y > maxY)) continue;
                        maxY = y;
                        continue;
                    }
                    if (i >= maxYI) continue;
                    continue block10;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        block12: for (j = 0; j < X.length; ++j) {
            for (i = 0; i < Y.length; ++i) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minX)) {
                        minX = x;
                        minXI = j;
                    }
                    if (j == minXI) {
                        if (!(x < minX)) continue;
                        minX = x;
                        continue;
                    }
                    if (j <= minXI) continue;
                    continue block12;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        block14: for (j = X.length - 1; j >= 0; --j) {
            for (i = 0; i < Y.length; ++i) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(maxX)) {
                        maxX = x;
                        maxXI = j;
                    }
                    if (j == maxXI) {
                        if (!(x > maxX)) continue;
                        maxX = x;
                        continue;
                    }
                    if (j >= maxXI) continue;
                    continue block14;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (Double.isNaN(minX)) {
            return null;
        }
        if (Double.isNaN(minY)) {
            return null;
        }
        if (Double.isNaN(maxX)) {
            return null;
        }
        if (Double.isNaN(maxY)) {
            return null;
        }
        if (toProj.isLonLat() && maxX < minX && maxX < 0.0) {
            maxX += 360.0;
        }
        Extent aExtent = new Extent();
        aExtent.minX = minX;
        aExtent.maxX = maxX;
        aExtent.minY = minY;
        aExtent.maxY = maxY;
        return aExtent;
    }

    public static PointShape projectPointShape(PointShape aPS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        PointShape newPS = (PointShape)aPS.clone();
        double[][] points = new double[1][];
        PointD oP = newPS.getPoint();
        points[0] = new double[]{oP.X, oP.Y};
        double[] fromP = new double[]{oP.X, oP.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (!Double.isNaN(points[0][0]) && !Double.isNaN(points[0][1])) {
                double[] toP = points[0];
                PointD rp = (PointD)oP.clone();
                rp.X = points[0][0];
                rp.Y = points[0][1];
                newPS.setPoint(rp);
                switch (aPS.getShapeType()) {
                    case WIND_BARB: {
                        ((WindBarb)newPS).angle = ProjectionUtil.projectAngle(((WindBarb)newPS).angle, fromP, toP, fromProj, toProj);
                        break;
                    }
                    case WIND_ARROW: {
                        ((WindArrow)newPS).angle = ProjectionUtil.projectAngle(((WindArrow)newPS).angle, fromP, toP, fromProj, toProj);
                        break;
                    }
                    case STATION_MODEL: {
                        ((StationModelShape)newPS).windBarb.angle = ProjectionUtil.projectAngle(((StationModelShape)newPS).windBarb.angle, fromP, toP, fromProj, toProj);
                    }
                }
                return newPS;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PolylineShape projectPolylineShape(PolylineShape aPLS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polyline> polyLines = new ArrayList<Polyline>();
        for (int i = 0; i < aPLS.getPolylines().size(); ++i) {
            ArrayList<PointD> newPoints = new ArrayList<PointD>();
            Polyline aPL = (Polyline)aPLS.getPolylines().get(i);
            for (int j = 0; j < aPL.getPointList().size(); ++j) {
                double[][] points = new double[1][];
                PointD wPoint = (PointD)aPL.getPointList().get(j);
                double x = wPoint.X;
                if (fromProj.isLonLat()) {
                    if (x > 180.0) {
                        x -= 360.0;
                    } else if (x < -180.0) {
                        x += 360.0;
                    }
                }
                points[0] = new double[]{x, wPoint.Y};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                    if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                    wPoint.X = points[0][0];
                    wPoint.Y = points[0][1];
                    newPoints.add(wPoint);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (newPoints.size() <= 1) continue;
            Polyline bPL = new Polyline();
            bPL.setPointList(newPoints);
            polyLines.add(bPL);
        }
        if (polyLines.size() > 0) {
            aPLS.setPolylines(polyLines);
            return aPLS;
        }
        return null;
    }

    public static double projectAngle(double oAngle, double[] fromP1, double[] toP1, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double pAngle = oAngle;
        double[][] points = new double[1][];
        if (fromP1[1] == 90.0) {
            double[] fromP2 = new double[]{fromP1[0], fromP1[1] - 10.0};
            points[0] = (double[])fromP2.clone();
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                double[] toP2 = points[0];
                double x = toP2[0] - toP1[0];
                double y = toP2[1] - toP1[1];
                double aLen = Math.sqrt(x * x + y * y);
                double angle = Math.asin(x / aLen) * 180.0 / Math.PI;
                if (x < 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x > 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x < 0.0 && y > 0.0) {
                    angle = 360.0 + angle;
                }
                if (aLen == 0.0) {
                    System.out.print("Error");
                }
                if ((pAngle = oAngle + (angle - 180.0)) > 360.0) {
                    pAngle -= 360.0;
                } else if (pAngle < 0.0) {
                    pAngle += 360.0;
                }
            }
            catch (Exception x) {}
        } else {
            double[] fromP2 = new double[]{fromP1[0] + 10.0, fromP1[1]};
            points[0] = (double[])fromP2.clone();
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                double[] toP2 = points[0];
                double x = toP2[0] - toP1[0];
                double y = toP2[1] - toP1[1];
                double aLen = Math.sqrt(x * x + y * y);
                if (aLen == 0.0) {
                    return pAngle;
                }
                double angle = Math.asin(x / aLen) * 180.0 / Math.PI;
                if (Double.isNaN(angle)) {
                    return pAngle;
                }
                if (x < 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x > 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x < 0.0 && y > 0.0) {
                    angle = 360.0 + angle;
                }
                pAngle = oAngle + (angle - 90.0);
                if (pAngle > 360.0) {
                    pAngle -= 360.0;
                } else if (pAngle < 0.0) {
                    pAngle += 360.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pAngle;
    }

    public static PolygonShape projectPolygonShape(PolygonShape aPGS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < aPGS.getPolygons().size(); ++i) {
            Polygon aPG = (Polygon)aPGS.getPolygons().get(i);
            Polygon bPG = null;
            for (int r = 0; r < aPG.getRingNumber(); ++r) {
                List pList = (List)aPG.getRings().get(r);
                ArrayList<PointD> newPoints = new ArrayList<PointD>();
                for (int j = 0; j < pList.size(); ++j) {
                    double[][] points = new double[1][];
                    PointD wPoint = (PointD)pList.get(j);
                    points[0] = new double[]{wPoint.X, wPoint.Y};
                    try {
                        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                        if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                        wPoint = new PointD();
                        wPoint.X = points[0][0];
                        wPoint.Y = points[0][1];
                        newPoints.add(wPoint);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (r == 0) {
                    if (newPoints.size() <= 2) break;
                    bPG = new Polygon();
                    bPG.setOutLine(newPoints);
                    continue;
                }
                if (newPoints.size() <= 2) continue;
                bPG.addHole(newPoints);
            }
            if (bPG == null) continue;
            polygons.add(bPG);
        }
        if (polygons.size() > 0) {
            aPGS.setPolygons(polygons);
            return aPGS;
        }
        return null;
    }

    public static Graphic projectGraphic(Graphic graphic, ProjectionInfo fromProj, ProjectionInfo toProj) {
        Shape shape = ProjectionUtil.projectShape(graphic.getShape(), fromProj, toProj);
        return new Graphic(shape, graphic.getLegend());
    }

    public static GraphicCollection projectGraphics(GraphicCollection aGCollection, ProjectionInfo fromProj, ProjectionInfo toProj) {
        GraphicCollection newGCollection = new GraphicCollection();
        for (Graphic aGraphic : aGCollection.getGraphics()) {
            aGraphic.setShape(ProjectionUtil.projectShape(aGraphic.getShape(), fromProj, toProj));
            if (aGraphic.getShape() == null) continue;
            newGCollection.add(aGraphic);
        }
        return newGCollection;
    }

    public static List<Graphic> projectGraphics(List<Graphic> graphics, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Graphic> newGraphics = new ArrayList<Graphic>();
        for (Graphic aGraphic : graphics) {
            Shape aShape = ProjectionUtil.projectShape(aGraphic.getShape(), fromProj, toProj);
            if (aShape == null) continue;
            newGraphics.add(new Graphic(aShape, aGraphic.getLegend()));
        }
        return newGraphics;
    }

    private static Shape projectShape(Shape aShape, ProjectionInfo fromProj, ProjectionInfo toProj) {
        PointShape newShape;
        switch (aShape.getShapeType()) {
            case POINT: 
            case POINT_M: {
                newShape = ProjectionUtil.projectPointShape((PointShape)aShape, fromProj, toProj);
                break;
            }
            case POLYLINE: 
            case POLYLINE_M: {
                newShape = ProjectionUtil.projectPolylineShape((PolylineShape)aShape, fromProj, toProj);
                break;
            }
            case CURVE_LINE: {
                newShape = ProjectionUtil.projectCurvelineShape((CurveLineShape)aShape, fromProj, toProj);
                break;
            }
            case POLYGON: 
            case POLYGON_M: 
            case RECTANGLE: {
                newShape = ProjectionUtil.projectPolygonShape((PolygonShape)aShape, fromProj, toProj);
                break;
            }
            case CURVE_POLYGON: {
                newShape = ProjectionUtil.projectCurvePolygonShape((CurvePolygonShape)aShape, fromProj, toProj);
                break;
            }
            case CIRCLE: {
                newShape = ProjectionUtil.projectCircleShape((CircleShape)aShape, fromProj, toProj);
                break;
            }
            case ELLIPSE: {
                newShape = ProjectionUtil.projectEllipseShape((EllipseShape)aShape, fromProj, toProj);
                break;
            }
            default: {
                newShape = null;
            }
        }
        return newShape;
    }

    private static CurveLineShape projectCurvelineShape(CurveLineShape aPLS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polyline> polyLines = new ArrayList<Polyline>();
        for (int i = 0; i < aPLS.getPolylines().size(); ++i) {
            ArrayList<PointD> newPoints = new ArrayList<PointD>();
            Polyline aPL = (Polyline)aPLS.getPolylines().get(i);
            for (int j = 0; j < aPL.getPointList().size(); ++j) {
                double[][] points = new double[1][];
                PointD wPoint = (PointD)aPL.getPointList().get(j);
                points[0] = new double[]{wPoint.X, wPoint.Y};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                    if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                    wPoint = new PointD();
                    wPoint.X = points[0][0];
                    wPoint.Y = points[0][1];
                    newPoints.add(wPoint);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (newPoints.size() <= 1) continue;
            Polyline bPL = new Polyline();
            bPL.setPointList(newPoints);
            polyLines.add(bPL);
        }
        if (polyLines.size() > 0) {
            aPLS.setPolylines(polyLines);
            return aPLS;
        }
        return null;
    }

    private static CurvePolygonShape projectCurvePolygonShape(CurvePolygonShape aPGS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < aPGS.getPolygons().size(); ++i) {
            Polygon aPG = (Polygon)aPGS.getPolygons().get(i);
            Polygon bPG = null;
            for (int r = 0; r < aPG.getRingNumber(); ++r) {
                List pList = (List)aPG.getRings().get(r);
                ArrayList<PointD> newPoints = new ArrayList<PointD>();
                for (int j = 0; j < pList.size(); ++j) {
                    double[][] points = new double[1][];
                    PointD wPoint = (PointD)pList.get(j);
                    points[0] = new double[]{wPoint.X, wPoint.Y};
                    try {
                        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                        if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                        wPoint = new PointD();
                        wPoint.X = points[0][0];
                        wPoint.Y = points[0][1];
                        newPoints.add(wPoint);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (r == 0) {
                    if (newPoints.size() <= 2) break;
                    bPG = new Polygon();
                    bPG.setOutLine(newPoints);
                    continue;
                }
                if (newPoints.size() <= 2) continue;
                bPG.addHole(newPoints);
            }
            if (bPG == null) continue;
            polygons.add(bPG);
        }
        if (polygons.size() > 0) {
            aPGS.setPolygons(polygons);
            return aPGS;
        }
        return null;
    }

    private static CircleShape projectCircleShape(CircleShape aCS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double radius = Math.abs(((PointD)aCS.getPoints().get((int)1)).X - ((PointD)aCS.getPoints().get((int)0)).X);
        double[][] points = new double[1][];
        PointD centerPoint = new PointD(((PointD)aCS.getPoints().get((int)0)).X + radius, ((PointD)aCS.getPoints().get((int)0)).Y);
        points[0] = new double[]{centerPoint.X, centerPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            centerPoint.X = points[0][0];
            centerPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        points = new double[1][];
        PointD leftPoint = (PointD)aCS.getPoints().get(0);
        points[0] = new double[]{leftPoint.X, leftPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            leftPoint.X = points[0][0];
            leftPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        radius = Math.abs(centerPoint.X - leftPoint.X);
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        newPoints.add(new PointD(centerPoint.X - radius, centerPoint.Y));
        newPoints.add(new PointD(centerPoint.X, centerPoint.Y - radius));
        newPoints.add(new PointD(centerPoint.X + radius, centerPoint.Y));
        newPoints.add(new PointD(centerPoint.X, centerPoint.Y + radius));
        CircleShape newCS = new CircleShape();
        newCS.setPoints(newPoints);
        return newCS;
    }

    private static EllipseShape projectEllipseShape(EllipseShape aES, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double xRadius = Math.abs(((PointD)aES.getPoints().get((int)2)).X - ((PointD)aES.getPoints().get((int)0)).X) / 2.0;
        double yRadius = Math.abs(((PointD)aES.getPoints().get((int)2)).Y - ((PointD)aES.getPoints().get((int)0)).Y) / 2.0;
        double[][] points = new double[1][];
        PointD centerPoint = new PointD(aES.getExtent().minX + xRadius, aES.getExtent().minY + yRadius);
        points[0] = new double[]{centerPoint.X, centerPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            centerPoint.X = points[0][0];
            centerPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        points = new double[1][];
        PointD lbPoint = new PointD(aES.getExtent().minX, aES.getExtent().minY);
        points[0] = new double[]{lbPoint.X, lbPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            lbPoint.X = points[0][0];
            lbPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        xRadius = Math.abs(centerPoint.X - lbPoint.X);
        yRadius = Math.abs(centerPoint.Y - lbPoint.Y);
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        newPoints.add(new PointD(centerPoint.X - xRadius, centerPoint.Y - yRadius));
        newPoints.add(new PointD(centerPoint.X - xRadius, centerPoint.Y + yRadius));
        newPoints.add(new PointD(centerPoint.X + xRadius, centerPoint.Y + yRadius));
        newPoints.add(new PointD(centerPoint.X + xRadius, centerPoint.Y - yRadius));
        EllipseShape newES = new EllipseShape();
        newES.setPoints(newPoints);
        return newES;
    }
}

