/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.List;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.common.Direction;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;

public class GeostationarySatellite
extends ProjectionInfo {
    public GeostationarySatellite(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Geostationary_Satellite;
    }

    @Override
    public void updateBoundary() {
        double epsilon = 1.0E-10;
        double a = this.crs.getDatum().getEllipsoid().getA();
        double b = this.crs.getDatum().getEllipsoid().getB();
        double h = this.crs.getProjection().getHeightOfOrbit();
        double max_x = h * Math.asin(a / (a + h));
        double max_y = h * Math.asin(b / (a + h));
        double easting = this.crs.getProjection().getFalseEasting();
        double northing = this.crs.getProjection().getFalseNorthing();
        List<PointD> points = this.ellipse_boundary(max_x, max_y, easting, northing, 201);
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ps;
    }

    @Override
    public Object[] checkGridLabel(GridLabel gl, float shift) {
        float angle = gl.getAngle();
        double v = gl.getValue();
        float xShift = 0.0f;
        float yShift = 0.0f;
        XAlign xAlign = XAlign.CENTER;
        YAlign yAlign = YAlign.CENTER;
        if (v == 0.0) {
            if (angle == 90.0f) {
                xShift = shift;
                xAlign = XAlign.LEFT;
            } else if (angle == 270.0f) {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
            } else if (angle < 90.0f) {
                xShift = shift;
                xAlign = XAlign.LEFT;
                yAlign = YAlign.BOTTOM;
            } else if (angle > 90.0f && angle <= 180.0f) {
                xShift = shift;
                xAlign = XAlign.LEFT;
                yAlign = YAlign.TOP;
            } else if (angle > 180.0f && angle < 270.0f) {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
                yAlign = YAlign.TOP;
            } else if (angle > 270.0f && angle <= 360.0f) {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
                yAlign = YAlign.BOTTOM;
            }
        } else if (v > 0.0) {
            if (gl.getLabDirection() == Direction.East) {
                xShift = shift;
                xAlign = XAlign.LEFT;
                yAlign = YAlign.BOTTOM;
            } else {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
                yAlign = YAlign.BOTTOM;
            }
        } else if (gl.getLabDirection() == Direction.East) {
            xShift = shift;
            xAlign = XAlign.LEFT;
            yAlign = YAlign.TOP;
        } else {
            xShift = -shift;
            xAlign = XAlign.RIGHT;
            yAlign = YAlign.TOP;
        }
        return new Object[]{Float.valueOf(xShift), Float.valueOf(yShift), xAlign, yAlign};
    }
}

