/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection;

public enum ProjectionNames {
    LongLat("longlat"),
    Lambert_Conformal_Conic("lcc"),
    Lambert_Equal_Area_Conic("leac"),
    Lambert_Azimuthal_Equal_Area("laea"),
    Albers_Equal_Area("aea"),
    Stereographic_Azimuthal("stere"),
    North_Polar_Stereographic_Azimuthal("stere"),
    South_Polar_Stereographic_Azimuthal("stere"),
    Mercator("merc"),
    Robinson("robin"),
    Molleweide("moll"),
    Orthographic_Azimuthal("ortho"),
    Geostationary_Satellite("geos"),
    Oblique_Stereographic_Alternative("sterea"),
    Transverse_Mercator("tmerc"),
    Sinusoidal("sinu"),
    Cylindrical_Equal_Area("cea"),
    Hammer_Eckert("hammer"),
    Wagner3("wag3"),
    Undefine(null);

    private final String proj4Name;

    private ProjectionNames(String proj4Name) {
        this.proj4Name = proj4Name;
    }

    public String getProj4Name() {
        return this.proj4Name;
    }

    public static ProjectionNames getName(String proj4Name) {
        for (ProjectionNames name : ProjectionNames.values()) {
            if (!name.proj4Name.equals(proj4Name)) continue;
            return name;
        }
        return null;
    }
}

