/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.List;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.Reproject;

public class LambertAzimuthalEqualArea
extends ProjectionInfo {
    public LambertAzimuthalEqualArea(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Lambert_Azimuthal_Equal_Area;
    }

    @Override
    public void updateBoundary() {
        double epsilon = 1.0E-10;
        double a = this.crs.getDatum().getEllipsoid().getA();
        double cenLat = this.getCenterLat();
        double cenLon = this.getCenterLon();
        double lon = cenLon + 180.0 - epsilon;
        double sign = Math.signum(cenLat);
        if (sign == 0.0) {
            sign = 1.0;
        }
        double lat = -cenLat + sign * 0.01;
        PointD p = Reproject.reprojectPoint(lon, lat, KnownCoordinateSystems.geographic.world.WGS1984, this);
        double x = p.X;
        double max_y = p.Y;
        double easting = this.crs.getProjection().getFalseEasting();
        double northing = this.crs.getProjection().getFalseNorthing();
        List<PointD> points = this.ellipse_boundary(a * 1.9999, max_y - northing, easting, northing, 61);
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ps;
    }
}

