/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.meteoinfo.common.colors.ColorMap;

public class ColorListCellRender
extends JPanel
implements ListCellRenderer {
    private ColorMap colorTable;
    private boolean isSelected = false;

    public ColorListCellRender() {
        this.setOpaque(true);
    }

    public ColorListCellRender(boolean isSelected) {
        this.setOpaque(true);
        this.isSelected = isSelected;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.colorTable = value instanceof Object[] ? (ColorMap)((Object[])value)[0] : (ColorMap)value;
        this.isSelected = isSelected;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.colorTable != null) {
            Graphics2D g2 = (Graphics2D)g;
            int n = this.colorTable.getColorCount();
            int xshift = 2;
            int yshift = 2;
            int width = this.getWidth() - xshift;
            double w = width / n;
            if (w <= 0.0) {
                w = 1.0;
            }
            int h = this.getHeight() - yshift;
            double x = xshift / 2;
            double y = yshift / 2;
            for (int i = 0; i < n; ++i) {
                Color c = this.colorTable.getColor(i);
                g2.setColor(c);
                if (x + w > (double)width) {
                    g2.fill(new Rectangle2D.Double(x, y, (double)width - x, h));
                    break;
                }
                if (i == n - 1) {
                    g2.fill(new Rectangle2D.Double(x, y, (double)width - x, h));
                } else {
                    g2.fill(new Rectangle2D.Double(x, y, w, h));
                }
                x += w;
            }
            if (this.isSelected) {
                FontMetrics metrics = g2.getFontMetrics(this.getFont());
                String name = this.colorTable.getName();
                x = this.getWidth() / 2 - metrics.stringWidth(name) / 2;
                y = this.getHeight() / 2 + metrics.getHeight() / 3;
                g2.setColor(Color.black);
                g2.drawString(name, (int)x, (int)y);
            }
        }
    }
}

