/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ui.util;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.util.GlobalUtil;

public class FontUtil {
    public static List<Font> getAllFonts() {
        Font[] fonts;
        ArrayList<Font> fontList = new ArrayList<Font>();
        Font weatherFont = FontUtil.getWeatherFont();
        if (weatherFont != null) {
            fontList.add(weatherFont);
        }
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : fonts = gEnv.getAllFonts()) {
            fontList.add(font);
        }
        String fn = GlobalUtil.getAppPath(FontUtil.class);
        String path = (fn = fn.substring(0, fn.lastIndexOf("/"))) + File.separator + "font";
        File pathDir = new File(path);
        if (pathDir.isDirectory()) {
            // empty if block
        }
        return fontList;
    }

    public static void registerFont(Font font) {
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
    }

    public static void registerFont(String fileName) {
        Font font = FontUtil.getFont(fileName);
        if (font != null) {
            FontUtil.registerFont(font);
        }
    }

    public static void registerWeatherFont() {
        Font weatherFont = FontUtil.getWeatherFont();
        if (weatherFont != null) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(weatherFont);
        }
    }

    public static Font getFont(String fileName) {
        Font font = null;
        try {
            font = Font.createFont(0, new File(fileName));
        }
        catch (FontFormatException | IOException ex) {
            Logger.getLogger(FontUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return font;
    }

    public static Font getWeatherFont() {
        Font font = null;
        InputStream is = FontUtil.class.getResourceAsStream("/fonts/WeatherSymbol.ttf");
        try {
            font = Font.createFont(0, is);
        }
        catch (FontFormatException | IOException ex) {
            Logger.getLogger(FontUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return font;
    }
}

