/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j;

import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.Proj4jException;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.datum.GeocentricConverter;

public class BasicCoordinateTransform
implements CoordinateTransform {
    private CoordinateReferenceSystem srcCRS;
    private CoordinateReferenceSystem tgtCRS;
    private ProjCoordinate geoCoord = new ProjCoordinate(0.0, 0.0);
    private boolean doInverseProjection = true;
    private boolean doForwardProjection = true;
    private boolean doDatumTransform = false;
    private boolean transformViaGeocentric = false;
    private GeocentricConverter srcGeoConv;
    private GeocentricConverter tgtGeoConv;

    public BasicCoordinateTransform(CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem tgtCRS) {
        this.srcCRS = srcCRS;
        this.tgtCRS = tgtCRS;
        this.doInverseProjection = srcCRS != null && srcCRS != CoordinateReferenceSystem.CS_GEO;
        this.doForwardProjection = tgtCRS != null && tgtCRS != CoordinateReferenceSystem.CS_GEO;
        boolean bl = this.doDatumTransform = this.doInverseProjection && this.doForwardProjection && srcCRS.getDatum() != tgtCRS.getDatum();
        if (this.doDatumTransform) {
            boolean isEllipsoidEqual = srcCRS.getDatum().getEllipsoid().isEqual(tgtCRS.getDatum().getEllipsoid());
            if (!isEllipsoidEqual) {
                this.transformViaGeocentric = true;
            }
            if (srcCRS.getDatum().hasTransformToWGS84() || tgtCRS.getDatum().hasTransformToWGS84()) {
                this.transformViaGeocentric = true;
            }
            if (this.transformViaGeocentric) {
                this.srcGeoConv = new GeocentricConverter(srcCRS.getDatum().getEllipsoid());
                this.tgtGeoConv = new GeocentricConverter(tgtCRS.getDatum().getEllipsoid());
                if (srcCRS.getDatum().getTransformType() == 4) {
                    this.srcGeoConv.overrideWithWGS84Params();
                }
                if (tgtCRS.getDatum().getTransformType() == 4) {
                    this.tgtGeoConv.overrideWithWGS84Params();
                }
            }
        }
    }

    @Override
    public CoordinateReferenceSystem getSourceCRS() {
        return this.srcCRS;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS() {
        return this.tgtCRS;
    }

    @Override
    public ProjCoordinate transform(ProjCoordinate src, ProjCoordinate tgt) throws Proj4jException {
        this.geoCoord.setValue(src);
        this.srcCRS.getProjection().getAxisOrder().toENU(this.geoCoord);
        if (this.doInverseProjection) {
            ProjCoordinate coord = new ProjCoordinate();
            coord.setValue(this.geoCoord);
            this.srcCRS.getProjection().inverseProjectRadians(coord, this.geoCoord);
        }
        this.srcCRS.getProjection().getPrimeMeridian().toGreenwich(this.geoCoord);
        this.geoCoord.clearZ();
        if (this.doDatumTransform) {
            this.datumTransform(this.geoCoord);
        }
        this.tgtCRS.getProjection().getPrimeMeridian().fromGreenwich(this.geoCoord);
        if (this.doForwardProjection) {
            this.tgtCRS.getProjection().projectRadians(this.geoCoord, tgt);
        } else {
            tgt.setValue(this.geoCoord);
        }
        this.tgtCRS.getProjection().getAxisOrder().fromENU(tgt);
        return tgt;
    }

    private void datumTransform(ProjCoordinate pt) {
        if (this.srcCRS.getDatum().isEqual(this.tgtCRS.getDatum()) || this.srcCRS.getDatum().getTransformType() == 0 || this.tgtCRS.getDatum().getTransformType() == 0) {
            return;
        }
        if (this.srcCRS.getDatum().getTransformType() == 4) {
            this.srcCRS.getDatum().shift(pt);
        }
        if (this.transformViaGeocentric) {
            this.srcGeoConv.convertGeodeticToGeocentric(pt);
            if (this.srcCRS.getDatum().hasTransformToWGS84()) {
                this.srcCRS.getDatum().transformFromGeocentricToWgs84(pt);
            }
            if (this.tgtCRS.getDatum().hasTransformToWGS84()) {
                this.tgtCRS.getDatum().transformToGeocentricFromWgs84(pt);
            }
            this.tgtGeoConv.convertGeocentricToGeodetic(pt);
        }
        if (this.tgtCRS.getDatum().getTransformType() == 4) {
            this.tgtCRS.getDatum().inverseShift(pt);
        }
    }
}

