/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.locationtech.proj4j.proj.CylindricalProjection;
import org.locationtech.proj4j.util.ProjectionMath;

public class ObliqueMercatorProjection
extends CylindricalProjection {
    private static final double TOL = 1.0E-7;
    private double lamc;
    private double lam1;
    private double phi1;
    private double lam2;
    private double phi2;
    private double Gamma;
    private double al;
    private double bl;
    private double el;
    private double singam;
    private double cosgam;
    private double sinrot;
    private double cosrot;
    private double u_0;
    private boolean ellips;
    private boolean rot;

    public ObliqueMercatorProjection() {
        this.ellipsoid = Ellipsoid.WGS84;
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.minLongitude = Math.toRadians(-60.0);
        this.maxLongitude = Math.toRadians(60.0);
        this.minLatitude = Math.toRadians(-80.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.alpha = Math.toRadians(-45.0);
        this.initialize();
    }

    public ObliqueMercatorProjection(Ellipsoid ellipsoid, double lon_0, double lat_0, double alpha, double k, double x_0, double y_0) {
        this.setEllipsoid(ellipsoid);
        this.lamc = lon_0;
        this.projectionLatitude = lat_0;
        this.alpha = alpha;
        this.scaleFactor = k;
        this.falseEasting = x_0;
        this.falseNorthing = y_0;
        this.initialize();
    }

    @Override
    public void initialize() {
        double f;
        double d;
        double com;
        double con;
        boolean azi;
        super.initialize();
        this.rot = true;
        this.lamc = this.lonc;
        boolean bl = azi = !Double.isNaN(this.alpha);
        if (azi) {
            if (Math.abs(this.alpha) <= 1.0E-7 || Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) <= 1.0E-7 || Math.abs(Math.abs(this.alpha) - 1.5707963267948966) <= 1.0E-7) {
                throw new ProjectionException("Obl 1");
            }
        } else if (Math.abs(this.phi1 - this.phi2) <= 1.0E-7 || (con = Math.abs(this.phi1)) <= 1.0E-7 || Math.abs(con - 1.5707963267948966) <= 1.0E-7 || Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) <= 1.0E-7 || Math.abs(Math.abs(this.phi2) - 1.5707963267948966) <= 1.0E-7) {
            throw new ProjectionException("Obl 2");
        }
        this.spherical = this.es == 0.0;
        double d2 = com = this.spherical ? 1.0 : Math.sqrt(this.one_es);
        if (Math.abs(this.projectionLatitude) > 1.0E-10) {
            double d3;
            double sinphi0 = Math.sin(this.projectionLatitude);
            double cosphi0 = Math.cos(this.projectionLatitude);
            if (!this.spherical) {
                con = 1.0 - this.es * sinphi0 * sinphi0;
                this.bl = cosphi0 * cosphi0;
                this.bl = Math.sqrt(1.0 + this.es * this.bl * this.bl / this.one_es);
                this.al = this.bl * this.scaleFactor * com / con;
                d = this.bl * com / (cosphi0 * Math.sqrt(con));
            } else {
                this.bl = 1.0;
                this.al = this.scaleFactor;
                d = 1.0 / cosphi0;
            }
            f = d * d - 1.0;
            if (d3 <= 0.0) {
                f = 0.0;
            } else {
                f = Math.sqrt(f);
                if (this.projectionLatitude < 0.0) {
                    f = -f;
                }
            }
            this.el = f += d;
            this.el = !this.spherical ? (this.el *= Math.pow(ProjectionMath.tsfn(this.projectionLatitude, sinphi0, this.e), this.bl)) : (this.el *= Math.tan(0.5 * (1.5707963267948966 - this.projectionLatitude)));
        } else {
            this.bl = 1.0 / com;
            this.al = this.scaleFactor;
            f = 1.0;
            d = 1.0;
            this.el = 1.0;
        }
        if (azi) {
            this.Gamma = Math.asin(Math.sin(this.alpha) / d);
            this.projectionLongitude = this.lamc - Math.asin(0.5 * (f - 1.0 / f) * Math.tan(this.Gamma)) / this.bl;
        } else {
            double d4;
            double l;
            double h;
            if (!this.spherical) {
                h = Math.pow(ProjectionMath.tsfn(this.phi1, Math.sin(this.phi1), this.e), this.bl);
                l = Math.pow(ProjectionMath.tsfn(this.phi2, Math.sin(this.phi2), this.e), this.bl);
            } else {
                h = Math.tan(0.5 * (1.5707963267948966 - this.phi1));
                l = Math.tan(0.5 * (1.5707963267948966 - this.phi2));
            }
            f = this.el / h;
            double p = (l - h) / (l + h);
            double j = this.el * this.el;
            j = (j - l * h) / (j + l * h);
            con = this.lam1 - this.lam2;
            if (d4 < -Math.PI) {
                this.lam2 -= Math.PI * 2;
            } else if (con > Math.PI) {
                this.lam2 += Math.PI * 2;
            }
            this.projectionLongitude = ProjectionMath.normalizeLongitude(0.5 * (this.lam1 + this.lam2) - Math.atan(j * Math.tan(0.5 * this.bl * (this.lam1 - this.lam2)) / p) / this.bl);
            this.Gamma = Math.atan(2.0 * Math.sin(this.bl * ProjectionMath.normalizeLongitude(this.lam1 - this.projectionLongitude)) / (f - 1.0 / f));
            this.alpha = Math.asin(d * Math.sin(this.Gamma));
        }
        this.singam = Math.sin(this.Gamma);
        this.cosgam = Math.cos(this.Gamma);
        f = this.alpha;
        this.sinrot = Math.sin(f);
        this.cosrot = Math.cos(f);
        this.u_0 = Math.abs(this.al * Math.atan(Math.sqrt(d * d - 1.0) / this.cosrot) / this.bl);
        if (this.projectionLatitude < 0.0) {
            this.u_0 = -this.u_0;
        }
    }

    @Override
    public void setGamma(double gamma) {
        this.Gamma = gamma;
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        double us;
        double ul;
        double vl = Math.sin(this.bl * lam);
        if (Math.abs(Math.abs(phi) - 1.5707963267948966) <= 1.0E-10) {
            ul = phi < 0.0 ? -this.singam : this.singam;
            us = this.al * phi / this.bl;
        } else {
            double q = this.el / (!this.spherical ? Math.pow(ProjectionMath.tsfn(phi, Math.sin(phi), this.e), this.bl) : Math.tan(0.5 * (1.5707963267948966 - phi)));
            double s = 0.5 * (q - 1.0 / q);
            ul = 2.0 * (s * this.singam - vl * this.cosgam) / (q + 1.0 / q);
            double con = Math.cos(this.bl * lam);
            if (Math.abs(con) >= 1.0E-7) {
                us = this.al * Math.atan((s * this.cosgam + vl * this.singam) / con) / this.bl;
                if (con < 0.0) {
                    us += Math.PI * this.al / this.bl;
                }
            } else {
                us = this.al * this.bl * lam;
            }
        }
        if (Math.abs(Math.abs(ul) - 1.0) <= 1.0E-10) {
            throw new ProjectionException("Obl 3");
        }
        double vs = 0.5 * this.al * Math.log((1.0 - ul) / (1.0 + ul)) / this.bl;
        us -= this.u_0;
        if (!this.rot) {
            xy.x = us;
            xy.y = vs;
        } else {
            xy.x = vs * this.cosrot + us * this.sinrot;
            xy.y = us * this.cosrot - vs * this.sinrot;
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        double vs;
        double us;
        if (!this.rot) {
            us = x;
            vs = y;
        } else {
            vs = x * this.cosrot - y * this.sinrot;
            us = y * this.cosrot + x * this.sinrot;
        }
        double q = Math.exp(-this.bl * vs / this.al);
        double s = 0.5 * (q - 1.0 / q);
        double vl = Math.sin(this.bl * (us += this.u_0) / this.al);
        double ul = 2.0 * (vl * this.cosgam + s * this.singam) / (q + 1.0 / q);
        if (Math.abs(Math.abs(ul) - 1.0) < 1.0E-10) {
            lp.x = 0.0;
            lp.y = ul < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            lp.y = this.el / Math.sqrt((1.0 + ul) / (1.0 - ul));
            lp.y = !this.spherical ? ProjectionMath.phi2(Math.pow(lp.y, 1.0 / this.bl), this.e) : 1.5707963267948966 - 2.0 * Math.atan(lp.y);
            lp.x = -Math.atan2(s * this.cosgam - vl * this.singam, Math.cos(this.bl * us / this.al)) / this.bl;
        }
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Oblique Mercator";
    }
}

