/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.builtin;

import java.util.HashMap;
import java.util.Map;

import org.miaixz.bus.image.galaxy.data.Code;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class AnatomicRegion {

    public static final Code Abdomen = new Code("818981001", "SCT", null, "Abdomen");
    public static final Code AbdomenPelvis = new Code("818982008", "SCT", null, "Abdomen and Pelvis");
    public static final Code AbdominalAorta = new Code("7832008", "SCT", null, "Abdomen aorta");
    public static final Code AcromioclavicularJoint = new Code("85856004", "SCT", null, "Acromioclavicular joint");
    public static final Code AdrenalGland = new Code("23451007", "SCT", null, "Adrenal gland");
    public static final Code AmnioticFluid = new Code("77012006", "SCT", null, "Amniotic fluid");
    public static final Code AnkleJoint = new Code("70258002", "SCT", null, "Ankle joint");
    public static final Code AntecubitalVein = new Code("128553008", "SCT", null, "Antecubital vein");
    public static final Code AnteriorCardiacVein = new Code("194996006", "SCT", null, "Anterior cardiac vein");
    public static final Code AnteriorCerebralArtery = new Code("60176003", "SCT", null, "Anterior cerebral artery");
    public static final Code AnteriorCommunicatingArtery = new Code("8012006", "SCT", null,
            "Anterior communicating artery");
    public static final Code AnteriorSpinalArtery = new Code("17388009", "SCT", null, "Anterior spinal artery");
    public static final Code AnteriorTibialArtery = new Code("68053000", "SCT", null, "Anterior tibial artery");
    public static final Code AnusRectumSigmoidColon = new Code("110612005", "SCT", null,
            "Anus, rectum and sigmoid colon");
    public static final Code Aorta = new Code("15825003", "SCT", null, "Aorta");
    public static final Code AorticArch = new Code("57034009", "SCT", null, "Aortic arch");
    public static final Code Appendix = new Code("66754008", "SCT", null, "Appendix");
    public static final Code Artery = new Code("51114001", "SCT", null, "Artery");
    public static final Code AscendingAorta = new Code("54247002", "SCT", null, "Ascending aorta");
    public static final Code AscendingColon = new Code("9040008", "SCT", null, "Ascending colon");
    public static final Code Axilla = new Code("91470000", "SCT", null, "Axilla");
    public static final Code AxillaryArtery = new Code("67937003", "SCT", null, "Axillary Artery");
    public static final Code AxillaryVein = new Code("68705008", "SCT", null, "Axillary vein");
    public static final Code AzygosVein = new Code("72107004", "SCT", null, "Azygos vein");
    public static final Code Back = new Code("77568009", "SCT", null, "Back");
    public static final Code BasilarArtery = new Code("59011009", "SCT", null, "Basilar artery");
    public static final Code BileDuct = new Code("28273000", "SCT", null, "Bile Duct");
    public static final Code BiliaryTract = new Code("34707002", "SCT", null, "Biliary tract");
    public static final Code Bladder = new Code("89837001", "SCT", null, "Bladder");
    public static final Code BladderUrethra = new Code("110837003", "SCT", null, "Bladder and urethra");
    public static final Code BrachialArtery = new Code("17137000", "SCT", null, "Brachial artery");
    public static final Code BrachialVein = new Code("20115005", "SCT", null, "Brachial vein");
    public static final Code Brain = new Code("12738006", "SCT", null, "Brain");
    public static final Code Breast = new Code("76752008", "SCT", null, "Breast");
    public static final Code Bronchus = new Code("955009", "SCT", null, "Bronchus");
    public static final Code Buttock = new Code("46862004", "SCT", null, "Buttock");
    public static final Code Calcaneus = new Code("80144004", "SCT", null, "Calcaneus");
    public static final Code CalfOfLeg = new Code("53840002", "SCT", null, "Calf of leg");
    public static final Code CarotidArtery = new Code("69105007", "SCT", null, "Carotid Artery");
    public static final Code CarotidBulb = new Code("21479005", "SCT", null, "Carotid Bulb");
    public static final Code CeliacArtery = new Code("57850000", "SCT", null, "Celiac artery");
    public static final Code CephalicVein = new Code("20699002", "SCT", null, "Cephalic vein");
    public static final Code Cerebellum = new Code("113305005", "SCT", null, "Cerebellum");
    public static final Code CerebralArtery = new Code("88556005", "SCT", null, "Cerebral artery");
    public static final Code CerebralHemisphere = new Code("372073000", "SCT", null, "Cerebral hemisphere");
    public static final Code CervicalSpine = new Code("122494005", "SCT", null, "Cervical spine");
    public static final Code CervicoThoracicSpine = new Code("1217257000", "SCT", null, "Cervico-thoracic spine");
    public static final Code Cervix = new Code("71252005", "SCT", null, "Cervix");
    public static final Code Cheek = new Code("60819002", "SCT", null, "Cheek");
    public static final Code Chest = new Code("43799004", "SCT", null, "Chest");
    public static final Code ChestAbdomen = new Code("416550000", "SCT", null, "Chest and Abdomen");
    public static final Code ChestAbdomenPelvis = new Code("416775004", "SCT", null, "Chest, Abdomen and Pelvis");
    public static final Code ChoroidPlexus = new Code("80621003", "SCT", null, "Choroid plexus");
    public static final Code CircleOfWillis = new Code("11279006", "SCT", null, "Circle of Willis");
    public static final Code Clavicle = new Code("51299004", "SCT", null, "Clavicle");
    public static final Code Coccyx = new Code("64688005", "SCT", null, "Coccyx");
    public static final Code Colon = new Code("71854001", "SCT", null, "Colon");
    public static final Code CommonBileDuct = new Code("79741001", "SCT", null, "Common bile duct");
    public static final Code CommonCarotidArtery = new Code("32062004", "SCT", null, "Common carotid artery");
    public static final Code CommonFemoralArtery = new Code("181347005", "SCT", null, "Common femoral artery");
    public static final Code CommonFemoralVein = new Code("397363009", "SCT", null, "Common femoral vein");
    public static final Code CommonIliacArtery = new Code("73634005", "SCT", null, "Common iliac artery");
    public static final Code CommonIliacVein = new Code("46027005", "SCT", null, "Common iliac vein");
    public static final Code Cornea = new Code("28726007", "SCT", null, "Cornea");
    public static final Code CoronaryArtery = new Code("41801008", "SCT", null, "Coronary artery");
    public static final Code CoronarySinus = new Code("90219004", "SCT", null, "Coronary sinus");
    public static final Code DescendingAorta = new Code("32672002", "SCT", null, "Descending aorta");
    public static final Code DescendingColon = new Code("32622004", "SCT", null, "Descending colon");
    public static final Code Duodenum = new Code("38848004", "SCT", null, "Duodenum");
    public static final Code Ear = new Code("117590005", "SCT", null, "Ear");
    public static final Code ElbowJoint = new Code("16953009", "SCT", null, "Elbow joint");
    public static final Code EndoArterial = new Code("51114001", "SCT", null, "Endo-arterial");
    public static final Code EndoCardiac = new Code("80891009", "SCT", null, "Endo-cardiac");
    public static final Code EndoEsophageal = new Code("32849002", "SCT", null, "Endo-esophageal");
    public static final Code Endometrium = new Code("2739003", "SCT", null, "Endometrium");
    public static final Code EndoNasal = new Code("53342003", "SCT", null, "Endo-nasal");
    public static final Code EndoNasopharyngeal = new Code("18962004", "SCT", null, "Endo-nasopharyngeal");
    public static final Code EndoRectal = new Code("34402009", "SCT", null, "Endo-rectal");
    public static final Code EndoRenal = new Code("64033007", "SCT", null, "Endo-renal");
    public static final Code EndoUreteric = new Code("87953007", "SCT", null, "Endo-ureteric");
    public static final Code EndoUrethral = new Code("13648007", "SCT", null, "Endo-urethral");
    public static final Code EndoVaginal = new Code("76784001", "SCT", null, "Endo-vaginal");
    public static final Code EndoVascular = new Code("59820001", "SCT", null, "Endo-vascular");
    public static final Code EndoVenous = new Code("29092000", "SCT", null, "Endo-venous");
    public static final Code EndoVesical = new Code("48367006", "SCT", null, "Endo-vesical");
    public static final Code EntireBody = new Code("38266002", "SCT", null, "Entire body");
    public static final Code Epididymis = new Code("87644002", "SCT", null, "Epididymis");
    public static final Code EpigastricRegion = new Code("27947004", "SCT", null, "Epigastric region");
    public static final Code Esophagus = new Code("32849002", "SCT", null, "Esophagus");
    public static final Code ExternalAuditoryCanal = new Code("84301002", "SCT", null, "External auditory canal");
    public static final Code ExternalCarotidArtery = new Code("22286001", "SCT", null, "External carotid artery");
    public static final Code ExternalIliacArtery = new Code("113269004", "SCT", null, "External iliac artery");
    public static final Code ExternalIliacVein = new Code("63507001", "SCT", null, "External iliac vein");
    public static final Code ExternalJugularVein = new Code("71585003", "SCT", null, "External jugular vein");
    public static final Code Extremity = new Code("66019005", "SCT", null, "Extremity");
    public static final Code Eye = new Code("81745001", "SCT", null, "Eye");
    public static final Code Eyelid = new Code("80243003", "SCT", null, "Eyelid");
    public static final Code Face = new Code("89545001", "SCT", null, "Face");
    public static final Code FacialArtery = new Code("23074001", "SCT", null, "Facial artery");
    public static final Code FemoralArtery = new Code("7657000", "SCT", null, "Femoral artery");
    public static final Code FemoralVein = new Code("83419000", "SCT", null, "Femoral vein");
    public static final Code Femur = new Code("71341001", "SCT", null, "Femur");
    public static final Code Fibula = new Code("87342007", "SCT", null, "Fibula");
    public static final Code Finger = new Code("7569003", "SCT", null, "Finger");
    public static final Code Flank = new Code("58602004", "SCT", null, "Flank");
    public static final Code FontanelSkull = new Code("79361005", "SCT", null, "Fontanel of skull");
    public static final Code Foot = new Code("56459004", "SCT", null, "Foot");
    public static final Code Forearm = new Code("14975008", "SCT", null, "Forearm");
    public static final Code FourthVentricle = new Code("35918002", "SCT", null, "Fourth Ventricle");
    public static final Code Gallbladder = new Code("28231008", "SCT", null, "Gallbladder");
    public static final Code GastricVein = new Code("110568007", "SCT", null, "Gastric vein");
    public static final Code GenicularArtery = new Code("128559007", "SCT", null, "Genicular artery");
    public static final Code GestationalSac = new Code("300571009", "SCT", null, "Gestational sac");
    public static final Code GlutealRegion = new Code("46862004", "SCT", null, "Gluteal region");
    public static final Code GreatSaphenousVein = new Code("60734001", "SCT", null, "Great saphenous vein");
    public static final Code Hand = new Code("85562004", "SCT", null, "Hand");
    public static final Code Head = new Code("69536005", "SCT", null, "Head");
    public static final Code HeadNeck = new Code("774007", "SCT", null, "Head and Neck");
    public static final Code Heart = new Code("80891009", "SCT", null, "Heart");
    public static final Code HepaticArtery = new Code("76015000", "SCT", null, "Hepatic artery");
    public static final Code HepaticVein = new Code("8993003", "SCT", null, "Hepatic vein");
    public static final Code HipJoint = new Code("24136001", "SCT", null, "Hip joint");
    public static final Code Humerus = new Code("85050009", "SCT", null, "Humerus");
    public static final Code HypogastricRegion = new Code("11708003", "SCT", null, "Hypogastric region");
    public static final Code Hypopharynx = new Code("81502006", "SCT", null, "Hypopharynx");
    public static final Code Ileum = new Code("34516001", "SCT", null, "Ileum");
    public static final Code IliacArtery = new Code("10293006", "SCT", null, "Iliac artery");
    public static final Code IliacVein = new Code("244411005", "SCT", null, "Iliac vein");
    public static final Code Ilium = new Code("22356005", "SCT", null, "Ilium");
    public static final Code InferiorMesentricArtery = new Code("33795007", "SCT", null, "Inferior mesenteric artery");
    public static final Code InferiorVenaCava = new Code("64131007", "SCT", null, "Inferior vena cava");
    public static final Code InguinalRegion = new Code("26893007", "SCT", null, "Inguinal region");
    public static final Code InnominateArtery = new Code("12691009", "SCT", null, "Innominate artery");
    public static final Code InnominateVein = new Code("8887007", "SCT", null, "Innominate vein");
    public static final Code InternalAuditoryCanal = new Code("361078006", "SCT", null, "Internal Auditory Canal");
    public static final Code InternalCarotidArtery = new Code("86117002", "SCT", null, "Internal carotid artery");
    public static final Code InternalIliacArtery = new Code("90024005", "SCT", null, "Internal iliac artery");
    public static final Code InternalJugularVein = new Code("12123001", "SCT", null, "Internal jugular vein");
    public static final Code InternalMammaryArtery = new Code("86117002", "SCT", null, "Internal mammary artery");
    public static final Code Intracranial = new Code("1101003", "SCT", null, "Intracranial");
    public static final Code JawRegion = new Code("661005", "SCT", null, "Jaw region");
    public static final Code Jejunum = new Code("21306003", "SCT", null, "Jejunum");
    public static final Code Joint = new Code("39352004", "SCT", null, "Joint");
    public static final Code Kidney = new Code("64033007", "SCT", null, "Kidney");
    public static final Code Knee = new Code("72696002", "SCT", null, "Knee");
    public static final Code LacrimalArtery = new Code("59749000", "SCT", null, "Lacrimal artery");
    public static final Code LargeIntestine = new Code("14742008", "SCT", null, "Large intestine");
    public static final Code Larynx = new Code("4596009", "SCT", null, "Larynx");
    public static final Code LateralVentricle = new Code("66720007", "SCT", null, "Lateral Ventricle");
    public static final Code LeftAtrium = new Code("82471001", "SCT", null, "Left atrium");
    public static final Code LeftFemoralArtery = new Code("113270003", "SCT", null, "Left femoral artery");
    public static final Code LeftHepaticVein = new Code("273202007", "SCT", null, "Left hepatic vein");
    public static final Code LeftHypochondriacRegion = new Code("133945003", "SCT", null, "Left hypochondriac region");
    public static final Code LeftInguinalRegion = new Code("85119005", "SCT", null, "Left inguinal region");
    public static final Code LeftLowerQuadrantAbdomen = new Code("68505006", "SCT", null,
            "Left lower quadrant of abdomen");
    public static final Code LeftLumbarRegion = new Code("1017210004", "SCT", null, "Left lumbar region");
    public static final Code LeftPortalVein = new Code("70253006", "SCT", null, "Left portal vein");
    public static final Code LeftPulmonaryArtery = new Code("50408007", "SCT", null, "Left pulmonary artery");
    public static final Code LeftUpperQuadrantAbdomen = new Code("86367003", "SCT", null,
            "Left upper quadrant of abdomen");
    public static final Code LeftVentricle = new Code("87878005", "SCT", null, "Left ventricle");
    public static final Code LingualArtery = new Code("113264009", "SCT", null, "Lingual artery");
    public static final Code Liver = new Code("10200004", "SCT", null, "Liver");
    public static final Code LowerLeg = new Code("30021000", "SCT", null, "Lower leg");
    public static final Code LowerLimb = new Code("61685007", "SCT", null, "Lower limb");
    public static final Code LumbarArtery = new Code("34635009", "SCT", null, "Lumbar artery");
    public static final Code LumbarRegion = new Code("52612000", "SCT", null, "Lumbar region");
    public static final Code LumbarSpine = new Code("122496007", "SCT", null, "Lumbar spine");
    public static final Code LumboSacralSpine = new Code("1217253001", "SCT", null, "Lumbo-sacral spine");
    public static final Code LumenBloodVessel = new Code("91747007", "SCT", null, "Lumen of blood vessel");
    public static final Code Lung = new Code("39607008", "SCT", null, "Lung");
    public static final Code Mandible = new Code("91609006", "SCT", null, "Mandible");
    public static final Code MastoidBone = new Code("59066005", "SCT", null, "Mastoid Bone");
    public static final Code Maxilla = new Code("70925003", "SCT", null, "Maxilla");
    public static final Code Mediastinum = new Code("72410000", "SCT", null, "Mediastinum");
    public static final Code MesentericArtery = new Code("86570000", "SCT", null, "Mesenteric artery");
    public static final Code MesentericVein = new Code("128583004", "SCT", null, "Mesenteric vein");
    public static final Code MiddleCerebralArtery = new Code("17232002", "SCT", null, "Middle cerebral artery");
    public static final Code MiddleHepaticVein = new Code("273099000", "SCT", null, "Middle hepatic vein");
    public static final Code MorisonsPouch = new Code("243977002", "SCT", null, "Morisons Pouch");
    public static final Code Mouth = new Code("123851003", "SCT", null, "Mouth");
    public static final Code Nasopharynx = new Code("360955006", "SCT", null, "Nasopharynx");
    public static final Code Neck = new Code("45048000", "SCT", null, "Neck");
    public static final Code NeckChest = new Code("417437006", "SCT", null, "Neck and Chest");
    public static final Code NeckChestAbdomen = new Code("416152001", "SCT", null, "Neck, Chest and Abdomen");
    public static final Code NeckChestAbdomenPelvis = new Code("416319003", "SCT", null,
            "Neck, Chest, Abdomen and Pelvis");
    public static final Code Nose = new Code("45206002", "SCT", null, "Nose");
    public static final Code OccipitalArtery = new Code("31145008", "SCT", null, "Occipital artery");
    public static final Code OccipitalVein = new Code("32114007", "SCT", null, "Occipital vein");
    public static final Code OphthalmicArtery = new Code("53549008", "SCT", null, "Ophthalmic artery");
    public static final Code OpticCanal = new Code("55024004", "SCT", null, "Optic canal");
    public static final Code OrbitalStructure = new Code("363654007", "SCT", null, "Orbital structure");
    public static final Code Ovary = new Code("15497006", "SCT", null, "Ovary");
    public static final Code Pancreas = new Code("15776009", "SCT", null, "Pancreas");
    public static final Code PancreaticDuct = new Code("69930009", "SCT", null, "Pancreatic duct");
    public static final Code PancreaticDuctBileDuctSystems = new Code("110621006", "SCT", null,
            "Pancreatic duct and bile duct systems");
    public static final Code Parasternal = new Code("91691001", "SCT", null, "Parasternal");
    public static final Code Parathyroid = new Code("111002", "SCT", null, "Parathyroid");
    public static final Code ParotidGland = new Code("45289007", "SCT", null, "Parotid gland");
    public static final Code Patella = new Code("64234005", "SCT", null, "Patella");
    public static final Code Pelvis = new Code("816092008", "SCT", null, "Pelvis");
    public static final Code PelvisLowerExtremities = new Code("1231522001", "SCT", null,
            "Pelvis and lower extremities");
    public static final Code PenileArtery = new Code("282044005", "SCT", null, "Penile artery");
    public static final Code Penis = new Code("18911002", "SCT", null, "Penis");
    public static final Code Perineum = new Code("38864007", "SCT", null, "Perineum");
    public static final Code PeronealArtery = new Code("8821006", "SCT", null, "Peroneal artery");
    public static final Code Phantom = new Code("706342009", "SCT", null, "Phantom");
    public static final Code Pharynx = new Code("54066008", "SCT", null, "Pharynx");
    public static final Code PharynxLarynx = new Code("312535008", "SCT", null, "Pharynx and Larynx");
    public static final Code Placenta = new Code("78067005", "SCT", null, "Placenta");
    public static final Code PoplitealArtery = new Code("43899006", "SCT", null, "Popliteal artery");
    public static final Code PoplitealFossa = new Code("32361000", "SCT", null, "Popliteal fossa");
    public static final Code PoplitealVein = new Code("56849005", "SCT", null, "Popliteal vein");
    public static final Code PortalVein = new Code("32764006", "SCT", null, "Portal vein");
    public static final Code PosteriorCerebralArtery = new Code("70382005", "SCT", null, "Posterior cerebral artery");
    public static final Code PosteriorCommunicatingArtery = new Code("43119007", "SCT", null,
            "Posterior communicating artery");
    public static final Code PosteriorTibialArtery = new Code("13363002", "SCT", null, "Posterior tibial artery");
    public static final Code ProfundaFemorisArtery = new Code("31677005", "SCT", null, "Profunda femoris artery");
    public static final Code ProfundaFemorisVein = new Code("23438002", "SCT", null, "Profunda femoris vein");
    public static final Code Prostate = new Code("41216001", "SCT", null, "Prostate");
    public static final Code PulmonaryArtery = new Code("81040000", "SCT", null, "Pulmonary artery");
    public static final Code PulmonaryVein = new Code("122972007", "SCT", null, "Pulmonary vein");
    public static final Code RadialArtery = new Code("45631007", "SCT", null, "Radial artery");
    public static final Code Radius = new Code("62413002", "SCT", null, "Radius");
    public static final Code RadiusUlna = new Code("110535000", "SCT", null, "Radius and ulna");
    public static final Code RectouterinePouch = new Code("53843000", "SCT", null, "Rectouterine pouch");
    public static final Code Rectum = new Code("34402009", "SCT", null, "Rectum");
    public static final Code RenalArtery = new Code("2841007", "SCT", null, "Renal artery");
    public static final Code RenalVein = new Code("56400007", "SCT", null, "Renal vein");
    public static final Code Retroperitoneum = new Code("82849001", "SCT", null, "Retroperitoneum");
    public static final Code Rib = new Code("113197003", "SCT", null, "Rib");
    public static final Code RightAtrium = new Code("73829009", "SCT", null, "Right atrium");
    public static final Code RightFemoralArtery = new Code("69833005", "SCT", null, "Right femoral artery");
    public static final Code RightHepaticVein = new Code("272998002", "SCT", null, "Right hepatic vein");
    public static final Code RightHypochondriacRegion = new Code("133946002", "SCT", null,
            "Right hypochondriac region");
    public static final Code RightInguinalRegion = new Code("37117007", "SCT", null, "Right inguinal region");
    public static final Code RightLowerQuadrantAbdomen = new Code("48544008", "SCT", null,
            "Right lower quadrant of abdomen");
    public static final Code RightLumbarRegion = new Code("1017211000", "SCT", null, "Right lumbar region");
    public static final Code RightPortalVein = new Code("73931004", "SCT", null, "Right portal vein");
    public static final Code RightPulmonaryArtery = new Code("78480002", "SCT", null, "Right pulmonary artery");
    public static final Code RightUpperQuadrantAbdomen = new Code("50519007", "SCT", null,
            "Right upper quadrant of abdomen");
    public static final Code RightVentricle = new Code("53085002", "SCT", null, "Right ventricle");
    public static final Code SacroiliacJoint = new Code("39723000", "SCT", null, "Sacroiliac joint");
    public static final Code Sacrum = new Code("54735007", "SCT", null, "Sacrum");
    public static final Code SaphenofemoralJunction = new Code("128587003", "SCT", null, "Saphenofemoral junction");
    public static final Code SaphenousVein = new Code("362072009", "SCT", null, "Saphenous vein");
    public static final Code Scalp = new Code("41695006", "SCT", null, "Scalp");
    public static final Code Scapula = new Code("79601000", "SCT", null, "Scapula");
    public static final Code Sclera = new Code("18619003", "SCT", null, "Sclera");
    public static final Code Scrotum = new Code("20233005", "SCT", null, "Scrotum");
    public static final Code SellaTurcica = new Code("42575006", "SCT", null, "Sella turcica");
    public static final Code SeminalVesicle = new Code("64739004", "SCT", null, "Seminal vesicle");
    public static final Code SesamoidBonesFoot = new Code("58742003", "SCT", null, "Sesamoid bones of foot");
    public static final Code Shoulder = new Code("16982005", "SCT", null, "Shoulder");
    public static final Code SigmoidColon = new Code("60184004", "SCT", null, "Sigmoid Colon");
    public static final Code Skull = new Code("89546000", "SCT", null, "Skull");
    public static final Code SmallIntestine = new Code("30315005", "SCT", null, "Small Intestine");
    public static final Code SpinalCord = new Code("2748008", "SCT", null, "Spinal Cord");
    public static final Code Spine = new Code("421060004", "SCT", null, "Spine");
    public static final Code Spleen = new Code("78961009", "SCT", null, "Spleen");
    public static final Code SplenicArtery = new Code("22083002", "SCT", null, "Splenic artery");
    public static final Code SplenicVein = new Code("35819009", "SCT", null, "Splenic vein");
    public static final Code SternoclavicularJoint = new Code("7844006", "SCT", null, "Sternoclavicular joint");
    public static final Code Sternum = new Code("56873002", "SCT", null, "Sternum");
    public static final Code Stomach = new Code("69695003", "SCT", null, "Stomach");
    public static final Code SubclavianArtery = new Code("36765005", "SCT", null, "Subclavian artery");
    public static final Code SubclavianVein = new Code("9454009", "SCT", null, "Subclavian vein");
    public static final Code Subcostal = new Code("19695001", "SCT", null, "Subcostal");
    public static final Code SubmandibularGland = new Code("54019009", "SCT", null, "Submandibular gland");
    public static final Code SuperficialFemoralArtery = new Code("181349008", "SCT", null,
            "Superficial femoral artery");
    public static final Code SuperficialFemoralVein = new Code("397364003", "SCT", null, "Superficial femoral vein");
    public static final Code SuperiorLeftPulmonaryVein = new Code("43863001", "SCT", null,
            "Superior left pulmonary vein");
    public static final Code SuperiorMesentericArtery = new Code("42258001", "SCT", null, "Superior mesenteric artery");
    public static final Code SuperiorRightPulmonaryVein = new Code("8629005", "SCT", null,
            "Superior right pulmonary vein");
    public static final Code SuperiorThyroidArtery = new Code("72021004", "SCT", null, "Superior thyroid artery");
    public static final Code SuperiorVenaCava = new Code("48345005", "SCT", null, "Superior vena cava");
    public static final Code SupraclavicularRegionNeck = new Code("77621008", "SCT", null,
            "Supraclavicular region of neck");
    public static final Code SuprapubicRegion = new Code("11708003", "SCT", null, "Suprapubic region");
    public static final Code TemporomandibularJoint = new Code("53620006", "SCT", null, "Temporomandibular joint");
    public static final Code Testis = new Code("40689003", "SCT", null, "Testis");
    public static final Code Thalamus = new Code("42695009", "SCT", null, "Thalamus");
    public static final Code Thigh = new Code("68367000", "SCT", null, "Thigh");
    public static final Code ThirdVentricle = new Code("49841001", "SCT", null, "Third ventricle");
    public static final Code ThoracicAorta = new Code("113262008", "SCT", null, "Thoracic aorta");
    public static final Code ThoracicSpine = new Code("122495006", "SCT", null, "Thoracic spine");
    public static final Code ThoracoLumbarSpine = new Code("1217256009", "SCT", null, "Thoraco-lumbar spine");
    public static final Code Thorax = new Code("43799004", "SCT", null, "Thorax");
    public static final Code Thumb = new Code("76505004", "SCT", null, "Thumb");
    public static final Code Thymus = new Code("9875009", "SCT", null, "Thymus");
    public static final Code Thyroid = new Code("69748006", "SCT", null, "Thyroid");
    public static final Code Tibia = new Code("12611008", "SCT", null, "Tibia");
    public static final Code TibiaFibula = new Code("110536004", "SCT", null, "Tibia and fibula");
    public static final Code Toe = new Code("29707007", "SCT", null, "Toe");
    public static final Code Tongue = new Code("21974007", "SCT", null, "Tongue");
    public static final Code Trachea = new Code("44567001", "SCT", null, "Trachea");
    public static final Code TracheaBronchus = new Code("110726009", "SCT", null, "Trachea and bronchus");
    public static final Code TransverseColon = new Code("485005", "SCT", null, "Transverse colon");
    public static final Code Ulna = new Code("23416004", "SCT", null, "Ulna");
    public static final Code UlnarArtery = new Code("44984001", "SCT", null, "Ulnar artery");
    public static final Code UmbilicalArtery = new Code("50536004", "SCT", null, "Umbilical artery");
    public static final Code UmbilicalRegion = new Code("90290004", "SCT", null, "Umbilical region");
    public static final Code UmbilicalVein = new Code("284639000", "SCT", null, "Umbilical vein");
    public static final Code UpperArm = new Code("40983000", "SCT", null, "Upper arm");
    public static final Code UpperLimb = new Code("53120007", "SCT", null, "Upper limb");
    public static final Code UpperUrinaryTract = new Code("431491007", "SCT", null, "Upper urinary tract");
    public static final Code Ureter = new Code("87953007", "SCT", null, "Ureter");
    public static final Code Urethra = new Code("13648007", "SCT", null, "Urethra");
    public static final Code Uterus = new Code("35039007", "SCT", null, "Uterus");
    public static final Code Vagina = new Code("76784001", "SCT", null, "Vagina");
    public static final Code Vein = new Code("29092000", "SCT", null, "Vein");
    public static final Code VertebralArtery = new Code("85234005", "SCT", null, "Vertebral Artery");
    public static final Code Vulva = new Code("45292006", "SCT", null, "Vulva");
    public static final Code WristJoint = new Code("74670003", "SCT", null, "Wrist joint");
    public static final Code Zygoma = new Code("13881006", "SCT", null, "Zygoma");

    private static final Map<String, Code> BODY_PART_EXAMINED = new HashMap<>();

    static {
        BODY_PART_EXAMINED.put("ABDOMEN", Abdomen);
        BODY_PART_EXAMINED.put("ABDOMENPELVIS", AbdomenPelvis);
        BODY_PART_EXAMINED.put("ABDOMINALAORTA", AbdominalAorta);
        BODY_PART_EXAMINED.put("ACJOINT", AcromioclavicularJoint);
        BODY_PART_EXAMINED.put("ADRENAL", AdrenalGland);
        BODY_PART_EXAMINED.put("AMNIOTICFLUID", AmnioticFluid);
        BODY_PART_EXAMINED.put("ANKLE", AnkleJoint);
        BODY_PART_EXAMINED.put("ANTECUBITALV", AntecubitalVein);
        BODY_PART_EXAMINED.put("ANTCARDIACV", AnteriorCardiacVein);
        BODY_PART_EXAMINED.put("ACA", AnteriorCerebralArtery);
        BODY_PART_EXAMINED.put("ANTCOMMA", AnteriorCommunicatingArtery);
        BODY_PART_EXAMINED.put("ANTSPINALA", AnteriorSpinalArtery);
        BODY_PART_EXAMINED.put("ANTTIBIALA", AnteriorTibialArtery);
        BODY_PART_EXAMINED.put("ANUSRECTUMSIGMD", AnusRectumSigmoidColon);
        BODY_PART_EXAMINED.put("AORTA", Aorta);
        BODY_PART_EXAMINED.put("AORTICARCH", AorticArch);
        BODY_PART_EXAMINED.put("APPENDIX", Appendix);
        BODY_PART_EXAMINED.put("ARTERY", Artery);
        BODY_PART_EXAMINED.put("ASCAORTA", AscendingAorta);
        BODY_PART_EXAMINED.put("ASCENDINGCOLON", AscendingColon);
        BODY_PART_EXAMINED.put("AXILLA", Axilla);
        BODY_PART_EXAMINED.put("AXILLARYA", AxillaryArtery);
        BODY_PART_EXAMINED.put("AXILLARYV", AxillaryVein);
        BODY_PART_EXAMINED.put("AZYGOSVEIN", AzygosVein);
        BODY_PART_EXAMINED.put("BACK", Back);
        BODY_PART_EXAMINED.put("BASILARA", BasilarArtery);
        BODY_PART_EXAMINED.put("BILEDUCT", BileDuct);
        BODY_PART_EXAMINED.put("BILIARYTRACT", BiliaryTract);
        BODY_PART_EXAMINED.put("BLADDER", Bladder);
        BODY_PART_EXAMINED.put("BLADDERURETHRA", BladderUrethra);
        BODY_PART_EXAMINED.put("BRACHIALA", BrachialArtery);
        BODY_PART_EXAMINED.put("BRACHIALV", BrachialVein);
        BODY_PART_EXAMINED.put("BRAIN", Brain);
        BODY_PART_EXAMINED.put("BREAST", Breast);
        BODY_PART_EXAMINED.put("BRONCHUS", Bronchus);
        BODY_PART_EXAMINED.put("BUTTOCK", Buttock);
        BODY_PART_EXAMINED.put("CALCANEUS", Calcaneus);
        BODY_PART_EXAMINED.put("CALF", CalfOfLeg);
        BODY_PART_EXAMINED.put("CAROTID", CarotidArtery);
        BODY_PART_EXAMINED.put("BULB", CarotidBulb);
        BODY_PART_EXAMINED.put("CELIACA", CeliacArtery);
        BODY_PART_EXAMINED.put("CEPHALICV", CephalicVein);
        BODY_PART_EXAMINED.put("CEREBELLUM", Cerebellum);
        BODY_PART_EXAMINED.put("CEREBRALA", CerebralArtery);
        BODY_PART_EXAMINED.put("CEREBHEMISPHERE", CerebralHemisphere);
        BODY_PART_EXAMINED.put("CSPINE", CervicalSpine);
        BODY_PART_EXAMINED.put("CTSPINE", CervicoThoracicSpine);
        BODY_PART_EXAMINED.put("CERVIX", Cervix);
        BODY_PART_EXAMINED.put("CHEEK", Cheek);
        BODY_PART_EXAMINED.put("CHEST", Chest);
        BODY_PART_EXAMINED.put("CHESTABDOMEN", ChestAbdomen);
        BODY_PART_EXAMINED.put("CHESTABDPELVIS", ChestAbdomenPelvis);
        BODY_PART_EXAMINED.put("CHOROIDPLEXUS", ChoroidPlexus);
        BODY_PART_EXAMINED.put("CIRCLEOFWILLIS", CircleOfWillis);
        BODY_PART_EXAMINED.put("CLAVICLE", Clavicle);
        BODY_PART_EXAMINED.put("COCCYX", Coccyx);
        BODY_PART_EXAMINED.put("COLON", Colon);
        BODY_PART_EXAMINED.put("COMMONBILEDUCT", CommonBileDuct);
        BODY_PART_EXAMINED.put("CCA", CommonCarotidArtery);
        BODY_PART_EXAMINED.put("CFA", CommonFemoralArtery);
        BODY_PART_EXAMINED.put("CFV", CommonFemoralVein);
        BODY_PART_EXAMINED.put("COMILIACA", CommonIliacArtery);
        BODY_PART_EXAMINED.put("COMILIACV", CommonIliacVein);
        BODY_PART_EXAMINED.put("CORNEA", Cornea);
        BODY_PART_EXAMINED.put("CORONARYARTERY", CoronaryArtery);
        BODY_PART_EXAMINED.put("CORONARYSINUS", CoronarySinus);
        BODY_PART_EXAMINED.put("DESCAORTA", DescendingAorta);
        BODY_PART_EXAMINED.put("DESCENDINGCOLON", DescendingColon);
        BODY_PART_EXAMINED.put("DUODENUM", Duodenum);
        BODY_PART_EXAMINED.put("EAR", Ear);
        BODY_PART_EXAMINED.put("ELBOW", ElbowJoint);
        BODY_PART_EXAMINED.put("ENDOARTERIAL", EndoArterial);
        BODY_PART_EXAMINED.put("ENDOCARDIAC", EndoCardiac);
        BODY_PART_EXAMINED.put("ENDOESOPHAGEAL", EndoEsophageal);
        BODY_PART_EXAMINED.put("ENDOMETRIUM", Endometrium);
        BODY_PART_EXAMINED.put("ENDONASAL", EndoNasal);
        BODY_PART_EXAMINED.put("ENDONASOPHARYNYX", EndoNasopharyngeal);
        BODY_PART_EXAMINED.put("ENDORECTAL", EndoRectal);
        BODY_PART_EXAMINED.put("ENDORENAL", EndoRenal);
        BODY_PART_EXAMINED.put("ENDOURETERIC", EndoUreteric);
        BODY_PART_EXAMINED.put("ENDOURETHRAL", EndoUrethral);
        BODY_PART_EXAMINED.put("ENDOVAGINAL", EndoVaginal);
        BODY_PART_EXAMINED.put("ENDOVASCULAR", EndoVascular);
        BODY_PART_EXAMINED.put("ENDOVENOUS", EndoVenous);
        BODY_PART_EXAMINED.put("ENDOVESICAL", EndoVesical);
        BODY_PART_EXAMINED.put("WHOLEBODY", EntireBody);
        BODY_PART_EXAMINED.put("EPIDIDYMIS", Epididymis);
        BODY_PART_EXAMINED.put("EPIGASTRIC", EpigastricRegion);
        BODY_PART_EXAMINED.put("ESOPHAGUS", Esophagus);
        BODY_PART_EXAMINED.put("EAC", ExternalAuditoryCanal);
        BODY_PART_EXAMINED.put("ECA", ExternalCarotidArtery);
        BODY_PART_EXAMINED.put("EXTILIACA", ExternalIliacArtery);
        BODY_PART_EXAMINED.put("EXTILIACV", ExternalIliacVein);
        BODY_PART_EXAMINED.put("EXTJUGV", ExternalJugularVein);
        BODY_PART_EXAMINED.put("EXTREMITY", Extremity);
        BODY_PART_EXAMINED.put("EYE", Eye);
        BODY_PART_EXAMINED.put("EYELID", Eyelid);
        BODY_PART_EXAMINED.put("FACE", Face);
        BODY_PART_EXAMINED.put("FACIALA", FacialArtery);
        BODY_PART_EXAMINED.put("FEMORALA", FemoralArtery);
        BODY_PART_EXAMINED.put("FEMORALV", FemoralVein);
        BODY_PART_EXAMINED.put("FEMUR", Femur);
        BODY_PART_EXAMINED.put("FIBULA", Fibula);
        BODY_PART_EXAMINED.put("FINGER", Finger);
        BODY_PART_EXAMINED.put("FLANK", Flank);
        BODY_PART_EXAMINED.put("FONTANEL", FontanelSkull);
        BODY_PART_EXAMINED.put("FOOT", Foot);
        BODY_PART_EXAMINED.put("FOREARM", Forearm);
        BODY_PART_EXAMINED.put("4THVENTRICLE", FourthVentricle);
        BODY_PART_EXAMINED.put("GALLBLADDER", Gallbladder);
        BODY_PART_EXAMINED.put("GASTRICV", GastricVein);
        BODY_PART_EXAMINED.put("GENICULARA", GenicularArtery);
        BODY_PART_EXAMINED.put("GESTSAC", GestationalSac);
        BODY_PART_EXAMINED.put("GLUTEAL", GlutealRegion);
        BODY_PART_EXAMINED.put("GSV", GreatSaphenousVein);
        BODY_PART_EXAMINED.put("HAND", Hand);
        BODY_PART_EXAMINED.put("HEAD", Head);
        BODY_PART_EXAMINED.put("HEADNECK", HeadNeck);
        BODY_PART_EXAMINED.put("HEART", Heart);
        BODY_PART_EXAMINED.put("HEPATICA", HepaticArtery);
        BODY_PART_EXAMINED.put("HEPATICV", HepaticVein);
        BODY_PART_EXAMINED.put("HIP", HipJoint);
        BODY_PART_EXAMINED.put("HUMERUS", Humerus);
        BODY_PART_EXAMINED.put("HYPOGASTRIC", HypogastricRegion);
        BODY_PART_EXAMINED.put("HYPOPHARYNX", Hypopharynx);
        BODY_PART_EXAMINED.put("ILEUM", Ileum);
        BODY_PART_EXAMINED.put("ILIACA", IliacArtery);
        BODY_PART_EXAMINED.put("ILIACV", IliacVein);
        BODY_PART_EXAMINED.put("ILIUM", Ilium);
        BODY_PART_EXAMINED.put("INFMESA", InferiorMesentricArtery);
        BODY_PART_EXAMINED.put("INFVENACAVA", InferiorVenaCava);
        BODY_PART_EXAMINED.put("INGUINAL", InguinalRegion);
        BODY_PART_EXAMINED.put("INNOMINATEA", InnominateArtery);
        BODY_PART_EXAMINED.put("INNOMINATEV", InnominateVein);
        BODY_PART_EXAMINED.put("IAC", InternalAuditoryCanal);
        BODY_PART_EXAMINED.put("ICA", InternalCarotidArtery);
        BODY_PART_EXAMINED.put("INTILIACA", InternalIliacArtery);
        BODY_PART_EXAMINED.put("INTJUGULARV", InternalJugularVein);
        BODY_PART_EXAMINED.put("INTMAMMARYA", InternalMammaryArtery);
        BODY_PART_EXAMINED.put("INTRACRANIAL", Intracranial);
        BODY_PART_EXAMINED.put("JAW", JawRegion);
        BODY_PART_EXAMINED.put("JEJUNUM", Jejunum);
        BODY_PART_EXAMINED.put("JOINT", Joint);
        BODY_PART_EXAMINED.put("KIDNEY", Kidney);
        BODY_PART_EXAMINED.put("KNEE", Knee);
        BODY_PART_EXAMINED.put("LACRIMALA", LacrimalArtery);
        BODY_PART_EXAMINED.put("LARGEINTESTINE", LargeIntestine);
        BODY_PART_EXAMINED.put("LARYNX", Larynx);
        BODY_PART_EXAMINED.put("LATVENTRICLE", LateralVentricle);
        BODY_PART_EXAMINED.put("LATRIUM", LeftAtrium);
        BODY_PART_EXAMINED.put("LFEMORALA", LeftFemoralArtery);
        BODY_PART_EXAMINED.put("LHEPATICV", LeftHepaticVein);
        BODY_PART_EXAMINED.put("LHYPOCHONDRIAC", LeftHypochondriacRegion);
        BODY_PART_EXAMINED.put("LINGUINAL", LeftInguinalRegion);
        BODY_PART_EXAMINED.put("LLQ", LeftLowerQuadrantAbdomen);
        BODY_PART_EXAMINED.put("LLUMBAR", LeftLumbarRegion);
        BODY_PART_EXAMINED.put("LPORTALV", LeftPortalVein);
        BODY_PART_EXAMINED.put("LPULMONARYA", LeftPulmonaryArtery);
        BODY_PART_EXAMINED.put("LUQ", LeftUpperQuadrantAbdomen);
        BODY_PART_EXAMINED.put("LVENTRICLE", LeftVentricle);
        BODY_PART_EXAMINED.put("LINGUALA", LingualArtery);
        BODY_PART_EXAMINED.put("LIVER", Liver);
        BODY_PART_EXAMINED.put("LEG", LowerLeg);
        BODY_PART_EXAMINED.put("LOWERLIMB", LowerLimb);
        BODY_PART_EXAMINED.put("LUMBARA", LumbarArtery);
        BODY_PART_EXAMINED.put("LUMBAR", LumbarRegion);
        BODY_PART_EXAMINED.put("LSPINE", LumbarSpine);
        BODY_PART_EXAMINED.put("LSSPINE", LumboSacralSpine);
        BODY_PART_EXAMINED.put("LUMEN", LumenBloodVessel);
        BODY_PART_EXAMINED.put("LUNG", Lung);
        BODY_PART_EXAMINED.put("MANDIBLE", Mandible);
        BODY_PART_EXAMINED.put("MASTOID", MastoidBone);
        BODY_PART_EXAMINED.put("MAXILLA", Maxilla);
        BODY_PART_EXAMINED.put("MEDIASTINUM", Mediastinum);
        BODY_PART_EXAMINED.put("MESENTRICA", MesentericArtery);
        BODY_PART_EXAMINED.put("MESENTRICV", MesentericVein);
        BODY_PART_EXAMINED.put("MCA", MiddleCerebralArtery);
        BODY_PART_EXAMINED.put("MIDHEPATICV", MiddleHepaticVein);
        BODY_PART_EXAMINED.put("MORISONSPOUCH", MorisonsPouch);
        BODY_PART_EXAMINED.put("MOUTH", Mouth);
        BODY_PART_EXAMINED.put("NASOPHARYNX", Nasopharynx);
        BODY_PART_EXAMINED.put("NECK", Neck);
        BODY_PART_EXAMINED.put("NECKCHEST", NeckChest);
        BODY_PART_EXAMINED.put("NECKCHESTABDOMEN", NeckChestAbdomen);
        BODY_PART_EXAMINED.put("NECKCHESTABDPELV", NeckChestAbdomenPelvis);
        BODY_PART_EXAMINED.put("NOSE", Nose);
        BODY_PART_EXAMINED.put("OCCPITALA", OccipitalArtery);
        BODY_PART_EXAMINED.put("OCCPITALV", OccipitalVein);
        BODY_PART_EXAMINED.put("OPHTHALMICA", OphthalmicArtery);
        BODY_PART_EXAMINED.put("OPTICCANAL", OpticCanal);
        BODY_PART_EXAMINED.put("ORBIT", OrbitalStructure);
        BODY_PART_EXAMINED.put("OVARY", Ovary);
        BODY_PART_EXAMINED.put("PANCREAS", Pancreas);
        BODY_PART_EXAMINED.put("PANCREATICDUCT", PancreaticDuct);
        BODY_PART_EXAMINED.put("PANCBILEDUCT", PancreaticDuctBileDuctSystems);
        BODY_PART_EXAMINED.put("PARASTERNAL", Parasternal);
        BODY_PART_EXAMINED.put("PARATHYROID", Parathyroid);
        BODY_PART_EXAMINED.put("PAROTID", ParotidGland);
        BODY_PART_EXAMINED.put("PATELLA", Patella);
        BODY_PART_EXAMINED.put("PELVIS", Pelvis);
        BODY_PART_EXAMINED.put("PELVISLOWEXTREMT", PelvisLowerExtremities);
        BODY_PART_EXAMINED.put("PENILEA", PenileArtery);
        BODY_PART_EXAMINED.put("PENIS", Penis);
        BODY_PART_EXAMINED.put("PERINEUM", Perineum);
        BODY_PART_EXAMINED.put("PERONEALA", PeronealArtery);
        BODY_PART_EXAMINED.put("PHANTOM", Phantom);
        BODY_PART_EXAMINED.put("PHARYNX", Pharynx);
        BODY_PART_EXAMINED.put("PHARYNXLARYNX", PharynxLarynx);
        BODY_PART_EXAMINED.put("PLACENTA", Placenta);
        BODY_PART_EXAMINED.put("POPLITEALA", PoplitealArtery);
        BODY_PART_EXAMINED.put("POPLITEALFOSSA", PoplitealFossa);
        BODY_PART_EXAMINED.put("POPLITEALV", PoplitealVein);
        BODY_PART_EXAMINED.put("PORTALV", PortalVein);
        BODY_PART_EXAMINED.put("PCA", PosteriorCerebralArtery);
        BODY_PART_EXAMINED.put("POSCOMMA", PosteriorCommunicatingArtery);
        BODY_PART_EXAMINED.put("POSTIBIALA", PosteriorTibialArtery);
        BODY_PART_EXAMINED.put("PROFFEMA", ProfundaFemorisArtery);
        BODY_PART_EXAMINED.put("PROFFEMV", ProfundaFemorisVein);
        BODY_PART_EXAMINED.put("PROSTATE", Prostate);
        BODY_PART_EXAMINED.put("PULMONARYA", PulmonaryArtery);
        BODY_PART_EXAMINED.put("PULMONARYV", PulmonaryVein);
        BODY_PART_EXAMINED.put("RADIALA", RadialArtery);
        BODY_PART_EXAMINED.put("RADIUS", Radius);
        BODY_PART_EXAMINED.put("RADIUSULNA", RadiusUlna);
        BODY_PART_EXAMINED.put("CULDESAC", RectouterinePouch);
        BODY_PART_EXAMINED.put("RECTUM", Rectum);
        BODY_PART_EXAMINED.put("RENALA", RenalArtery);
        BODY_PART_EXAMINED.put("RENALV", RenalVein);
        BODY_PART_EXAMINED.put("RETROPERITONEUM", Retroperitoneum);
        BODY_PART_EXAMINED.put("RIB", Rib);
        BODY_PART_EXAMINED.put("RATRIUM", RightAtrium);
        BODY_PART_EXAMINED.put("RFEMORALA", RightFemoralArtery);
        BODY_PART_EXAMINED.put("RHEPATICV", RightHepaticVein);
        BODY_PART_EXAMINED.put("RHYPOCHONDRIAC", RightHypochondriacRegion);
        BODY_PART_EXAMINED.put("RINGUINAL", RightInguinalRegion);
        BODY_PART_EXAMINED.put("RLQ", RightLowerQuadrantAbdomen);
        BODY_PART_EXAMINED.put("RLUMBAR", RightLumbarRegion);
        BODY_PART_EXAMINED.put("RPORTALV", RightPortalVein);
        BODY_PART_EXAMINED.put("RPULMONARYA", RightPulmonaryArtery);
        BODY_PART_EXAMINED.put("RUQ", RightUpperQuadrantAbdomen);
        BODY_PART_EXAMINED.put("RVENTRICLE", RightVentricle);
        BODY_PART_EXAMINED.put("SIJOINT", SacroiliacJoint);
        BODY_PART_EXAMINED.put("SSPINE", Sacrum);
        BODY_PART_EXAMINED.put("SFJ", SaphenofemoralJunction);
        BODY_PART_EXAMINED.put("SAPHENOUSV", SaphenousVein);
        BODY_PART_EXAMINED.put("SCALP", Scalp);
        BODY_PART_EXAMINED.put("SCAPULA", Scapula);
        BODY_PART_EXAMINED.put("SCLERA", Sclera);
        BODY_PART_EXAMINED.put("SCROTUM", Scrotum);
        BODY_PART_EXAMINED.put("SELLA", SellaTurcica);
        BODY_PART_EXAMINED.put("SEMVESICLE", SeminalVesicle);
        BODY_PART_EXAMINED.put("SESAMOID", SesamoidBonesFoot);
        BODY_PART_EXAMINED.put("SHOULDER", Shoulder);
        BODY_PART_EXAMINED.put("SIGMOID", SigmoidColon);
        BODY_PART_EXAMINED.put("SKULL", Skull);
        BODY_PART_EXAMINED.put("SMALLINTESTINE", SmallIntestine);
        BODY_PART_EXAMINED.put("SPINALCORD", SpinalCord);
        BODY_PART_EXAMINED.put("SPINE", Spine);
        BODY_PART_EXAMINED.put("SPLEEN", Spleen);
        BODY_PART_EXAMINED.put("SPLENICA", SplenicArtery);
        BODY_PART_EXAMINED.put("SPLENICV", SplenicVein);
        BODY_PART_EXAMINED.put("SCJOINT", SternoclavicularJoint);
        BODY_PART_EXAMINED.put("STERNUM", Sternum);
        BODY_PART_EXAMINED.put("STOMACH", Stomach);
        BODY_PART_EXAMINED.put("SUBCLAVIANA", SubclavianArtery);
        BODY_PART_EXAMINED.put("SUBCLAVIANV", SubclavianVein);
        BODY_PART_EXAMINED.put("SUBCOSTAL", Subcostal);
        BODY_PART_EXAMINED.put("SUBMANDIBULAR", SubmandibularGland);
        BODY_PART_EXAMINED.put("SFA", SuperficialFemoralArtery);
        BODY_PART_EXAMINED.put("SFV", SuperficialFemoralVein);
        BODY_PART_EXAMINED.put("LSUPPULMONARYV", SuperiorLeftPulmonaryVein);
        BODY_PART_EXAMINED.put("SMA", SuperiorMesentericArtery);
        BODY_PART_EXAMINED.put("RSUPPULMONARYV", SuperiorRightPulmonaryVein);
        BODY_PART_EXAMINED.put("SUPTHYROIDA", SuperiorThyroidArtery);
        BODY_PART_EXAMINED.put("SVC", SuperiorVenaCava);
        BODY_PART_EXAMINED.put("SUPRACLAVICULAR", SupraclavicularRegionNeck);
        BODY_PART_EXAMINED.put("SUPRAPUBIC", SuprapubicRegion);
        BODY_PART_EXAMINED.put("TMJ", TemporomandibularJoint);
        BODY_PART_EXAMINED.put("TESTIS", Testis);
        BODY_PART_EXAMINED.put("THALAMUS", Thalamus);
        BODY_PART_EXAMINED.put("THIGH", Thigh);
        BODY_PART_EXAMINED.put("3RDVENTRICLE", ThirdVentricle);
        BODY_PART_EXAMINED.put("THORACICAORTA", ThoracicAorta);
        BODY_PART_EXAMINED.put("TSPINE", ThoracicSpine);
        BODY_PART_EXAMINED.put("TLSPINE", ThoracoLumbarSpine);
        BODY_PART_EXAMINED.put("THORAX", Thorax);
        BODY_PART_EXAMINED.put("THUMB", Thumb);
        BODY_PART_EXAMINED.put("THYMUS", Thymus);
        BODY_PART_EXAMINED.put("THYROID", Thyroid);
        BODY_PART_EXAMINED.put("TIBIA", Tibia);
        BODY_PART_EXAMINED.put("TIBIAFIBULA", TibiaFibula);
        BODY_PART_EXAMINED.put("TOE", Toe);
        BODY_PART_EXAMINED.put("TONGUE", Tongue);
        BODY_PART_EXAMINED.put("TRACHEA", Trachea);
        BODY_PART_EXAMINED.put("TRACHEABRONCHUS", TracheaBronchus);
        BODY_PART_EXAMINED.put("TRANSVERSECOLON", TransverseColon);
        BODY_PART_EXAMINED.put("ULNA", Ulna);
        BODY_PART_EXAMINED.put("ULNARA", UlnarArtery);
        BODY_PART_EXAMINED.put("UMBILICALA", UmbilicalArtery);
        BODY_PART_EXAMINED.put("UMBILICAL", UmbilicalRegion);
        BODY_PART_EXAMINED.put("UMBILICALV", UmbilicalVein);
        BODY_PART_EXAMINED.put("UPPERARM", UpperArm);
        BODY_PART_EXAMINED.put("UPPERLIMB", UpperLimb);
        BODY_PART_EXAMINED.put("UPRURINARYTRACT", UpperUrinaryTract);
        BODY_PART_EXAMINED.put("URETER", Ureter);
        BODY_PART_EXAMINED.put("URETHRA", Urethra);
        BODY_PART_EXAMINED.put("UTERUS", Uterus);
        BODY_PART_EXAMINED.put("VAGINA", Vagina);
        BODY_PART_EXAMINED.put("VEIN", Vein);
        BODY_PART_EXAMINED.put("VERTEBRALA", VertebralArtery);
        BODY_PART_EXAMINED.put("VULVA", Vulva);
        BODY_PART_EXAMINED.put("WRIST", WristJoint);
        BODY_PART_EXAMINED.put("ZYGOMA", Zygoma);
    }

    public static Code codeOf(String bodyPartExamined) {
        return BODY_PART_EXAMINED.get(bodyPartExamined);
    }

    public static Code addCode(Code code, String bodyPartExamined) {
        return BODY_PART_EXAMINED.put(bodyPartExamined, code);
    }

    public static Code removeCode(String bodyPartExamined) {
        return BODY_PART_EXAMINED.remove(bodyPartExamined);
    }

}
