/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.BioPri3D;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "BioPri3D";

    /** (0011,xx20) VR=UL VM=1 ? */
    public static final int _0011_xx20_ = 0x00110020;

    /** (0011,xx24) VR=DS VM=1-n ? */
    public static final int _0011_xx24_ = 0x00110024;

    /** (0011,xx30) VR=LO VM=1 ? */
    public static final int _0011_xx30_ = 0x00110030;

    /** (0011,xx31) VR=UL VM=1 ? */
    public static final int _0011_xx31_ = 0x00110031;

    /** (0011,xx32) VR=SL VM=1 ? */
    public static final int _0011_xx32_ = 0x00110032;

    /** (0011,xx39) VR=CS VM=1 ? */
    public static final int _0011_xx39_ = 0x00110039;

    /** (0011,xx3A) VR=UL VM=1 ? */
    public static final int _0011_xx3A_ = 0x0011003A;

    /** (0011,xxD0) VR=OB VM=1 ? */
    public static final int _0011_xxD0_ = 0x001100D0;

    /** (0011,xxE0) VR=UL VM=1 ? */
    public static final int _0011_xxE0_ = 0x001100E0;

    /** (0011,xxE1) VR=UL VM=1 ? */
    public static final int _0011_xxE1_ = 0x001100E1;

    /** (0011,xxE2) VR=UL VM=1 ? */
    public static final int _0011_xxE2_ = 0x001100E2;

    /** (0011,xxE3) VR=US VM=1 ? */
    public static final int _0011_xxE3_ = 0x001100E3;

    /** (0011,xxE4) VR=US VM=1 ? */
    public static final int _0011_xxE4_ = 0x001100E4;

    /** (0011,xxE5) VR=CS VM=1 ? */
    public static final int _0011_xxE5_ = 0x001100E5;

    /** (0063,xx0C) VR=DS VM=1-n ? */
    public static final int _0063_xx0C_ = 0x0063000C;

    /** (0063,xx35) VR=SQ VM=1 ? */
    public static final int _0063_xx35_ = 0x00630035;

    /** (0063,xx20) VR=US VM=1 ? */
    public static final int _0063_xx20_ = 0x00630020;

    /** (0063,xx21) VR=UL VM=1 ? */
    public static final int _0063_xx21_ = 0x00630021;

}
