/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.GEHC_CT_ADVAPP_001;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "GEHC_CT_ADVAPP_001";

    /** (0053,xx20) VR=IS VM=1 Shuttle Flag */
    public static final int ShuttleFlag = 0x00530020;

    /** (0053,xx40) VR=SH VM=1 Iterative Recon Annotation */
    public static final int IterativeReconAnnotation = 0x00530040;

    /** (0053,xx41) VR=SH VM=1 Iterative Recon Mode */
    public static final int IterativeReconMode = 0x00530041;

    /** (0053,xx42) VR=LO VM=1 Iterative Recon Configuration */
    public static final int IterativeReconConfiguration = 0x00530042;

    /** (0053,xx43) VR=SH VM=1 Iterative Recon Level */
    public static final int IterativeReconLevel = 0x00530043;

    /** (0053,xx60) VR=SH VM=1 Recon Flip Rotate Anno */
    public static final int ReconFlipRotateAnno = 0x00530060;

    /** (0053,xx61) VR=SH VM=1 High Resolution Flag */
    public static final int HighResolutionFlag = 0x00530061;

    /** (0053,xx62) VR=SH VM=1 Respiratory Flag */
    public static final int RespiratoryFlag = 0x00530062;

    /** (0053,xx64) VR=IS VM=1 Shutter Mode */
    public static final int ShutterMode = 0x00530064;

    /** (0053,xx65) VR=IS VM=1 Shutter Mode Percent */
    public static final int ShutterModePercent = 0x00530065;

    /** (0053,xx66) VR=LO VM=1 Image Browser Annotation */
    public static final int ImageBrowserAnnotation = 0x00530066;

    /** (0053,xx67) VR=IS VM=1 Overlapped Recon Flag */
    public static final int OverlappedReconFlag = 0x00530067;

    /** (0053,xx68) VR=IS VM=1 Row Number Anotation Flag */
    public static final int RowNumberAnotationFlag = 0x00530068;

    /** (0053,xx6A) VR=IS VM=1 ODM Flag */
    public static final int ODMFlag = 0x0053006A;

    /** (0053,xx6B) VR=IS VM=1 ODM Reduction Percent */
    public static final int ODMReductionPercent = 0x0053006B;

    /** (0053,xx7D) VR=LO VM=1 SubOptimal IQ String */
    public static final int SubOptimalIQString = 0x0053007D;

    /** (0053,xx9D) VR=LO VM=1 MARs Annotation */
    public static final int MARsAnnotation = 0x0053009D;

}
