/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SMS_USG_S2000;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "SIEMENS MED SMS USG S2000";

    /** (0019,xx00) VR=SH VM=1 Private Creator Version */
    public static final int PrivateCreatorVersion = 0x00190000;

    /** (0019,xx03) VR=FD VM=1 Frame Rate */
    public static final int FrameRate = 0x00190003;

    /** (0019,xx0C) VR=US VM=1 Burned in Graphics */
    public static final int BurnedInGraphics = 0x0019000C;

    /** (0019,xx0D) VR=SH VM=1 SieClear Index */
    public static final int SieClearIndex = 0x0019000D;

    /** (0019,xx0E) VR=US VM=1 ? */
    public static final int _0019_xx0E_ = 0x0019000E;

    /** (0019,xx20) VR=SH VM=1 B-Mode Submode */
    public static final int BModeSubmode = 0x00190020;

    /** (0019,xx21) VR=FD VM=1 B-Mode Dynamic Range */
    public static final int BModeDynamicRange = 0x00190021;

    /** (0019,xx22) VR=FD VM=1 B-Mode Overall Gain */
    public static final int BModeOverallGain = 0x00190022;

    /** (0019,xx23) VR=US VM=1 B-Mode Resolution/Speed Index */
    public static final int BModeResolutionSpeedIndex = 0x00190023;

    /** (0019,xx24) VR=US VM=1 B-Mode Edge Enhance Index */
    public static final int BModeEdgeEnhanceIndex = 0x00190024;

    /** (0019,xx25) VR=US VM=1 B-Mode Persistence Index */
    public static final int BModePersistenceIndex = 0x00190025;

    /** (0019,xx26) VR=US VM=1 B-Mode Map Index */
    public static final int BModeMapIndex = 0x00190026;

    /** (0019,xx27) VR=US VM=1 ? */
    public static final int _0019_xx27_ = 0x00190027;

    /** (0019,xx28) VR=US VM=1 ? */
    public static final int _0019_xx28_ = 0x00190028;

    /** (0019,xx29) VR=US VM=1 ? */
    public static final int _0019_xx29_ = 0x00190029;

    /** (0019,xx2A) VR=US VM=1 B-Mode Tint Type */
    public static final int BModeTintType = 0x0019002A;

    /** (0019,xx2D) VR=US VM=1 B-Mode Tint Index */
    public static final int BModeTintIndex = 0x0019002D;

    /** (0019,xx2E) VR=SH VM=1 ClarifyVE Index */
    public static final int ClarifyVEIndex = 0x0019002E;

    /** (0019,xx30) VR=DS VM=1 ? */
    public static final int _0019_xx30_ = 0x00190030;

    /** (0019,xx31) VR=US VM=1 ? */
    public static final int _0019_xx31_ = 0x00190031;

    /** (0019,xx3A) VR=US VM=1 Image Flag */
    public static final int ImageFlag = 0x0019003A;

    /** (0019,xx3B) VR=LT VM=1 ? */
    public static final int _0019_xx3B_ = 0x0019003B;

    /** (0019,xx40) VR=SH VM=1 Color Flow State */
    public static final int ColorFlowState = 0x00190040;

    /** (0019,xx41) VR=US VM=1 Color Flow Wall Filter Index */
    public static final int ColorFlowWallFilterIndex = 0x00190041;

    /** (0019,xx42) VR=SH VM=1 Color Flow Submode */
    public static final int ColorFlowSubmode = 0x00190042;

    /** (0019,xx43) VR=FD VM=1 Color Flow Overall Gain */
    public static final int ColorFlowOverallGain = 0x00190043;

    /** (0019,xx44) VR=US VM=1 Color Flow Resolution/Speed Index */
    public static final int ColorFlowResolutionSpeedIndex = 0x00190044;

    /** (0019,xx46) VR=US VM=1 Color Flow Smooth Index */
    public static final int ColorFlowSmoothIndex = 0x00190046;

    /** (0019,xx47) VR=US VM=1 Color Flow Persistence Index */
    public static final int ColorFlowPersistenceIndex = 0x00190047;

    /** (0019,xx48) VR=US VM=1 Color Flow Map Index */
    public static final int ColorFlowMapIndex = 0x00190048;

    /** (0019,xx49) VR=US VM=1 Color Flow Priority Index */
    public static final int ColorFlowPriorityIndex = 0x00190049;

    /** (0019,xx54) VR=FD VM=1 Color Flow Maximum Velocity */
    public static final int ColorFlowMaximumVelocity = 0x00190054;

    /** (0019,xx60) VR=FD VM=1 Doppler Dynamic Range */
    public static final int DopplerDynamicRange = 0x00190060;

    /** (0019,xx61) VR=FD VM=1 Doppler Overall Gain */
    public static final int DopplerOverallGain = 0x00190061;

    /** (0019,xx62) VR=FD VM=1 Doppler Wall Filter */
    public static final int DopplerWallFilter = 0x00190062;

    /** (0019,xx63) VR=FD VM=1 Doppler Gate Size */
    public static final int DopplerGateSize = 0x00190063;

    /** (0019,xx65) VR=US VM=1 Doppler Map Index */
    public static final int DopplerMapIndex = 0x00190065;

    /** (0019,xx66) VR=SH VM=1 Doppler Submode */
    public static final int DopplerSubmode = 0x00190066;

    /** (0019,xx67) VR=US VM=1 ? */
    public static final int _0019_xx67_ = 0x00190067;

    /** (0019,xx69) VR=US VM=1 Doppler Time/Freq Res Index */
    public static final int DopplerTimeFreqResIndex = 0x00190069;

    /** (0019,xx6A) VR=US VM=1 Doppler Trace Inverted */
    public static final int DopplerTraceInverted = 0x0019006A;

    /** (0019,xx6C) VR=US VM=1 Doppler Tint Type */
    public static final int DopplerTintType = 0x0019006C;

    /** (0019,xx72) VR=US VM=1 Doppler Tint Index */
    public static final int DopplerTintIndex = 0x00190072;

    /** (0019,xx80) VR=US VM=1 M-Mode Dynamic Range */
    public static final int MModeDynamicRange = 0x00190080;

    /** (0019,xx81) VR=US VM=1 M-Mode Overall Gain */
    public static final int MModeOverallGain = 0x00190081;

    /** (0019,xx82) VR=US VM=1 M-Mode Edge Enhance Index */
    public static final int MModeEdgeEnhanceIndex = 0x00190082;

    /** (0019,xx83) VR=US VM=1 M-Mode Map Index */
    public static final int MModeMapIndex = 0x00190083;

    /** (0019,xx86) VR=US VM=1 M-Mode Tint Type */
    public static final int MModeTintType = 0x00190086;

    /** (0019,xx87) VR=SH VM=1 M-Mode Submode */
    public static final int MModeSubmode = 0x00190087;

    /** (0019,xx88) VR=US VM=1 M-Mode Tint Index */
    public static final int MModeTintIndex = 0x00190088;

    /** (0019,xx95) VR=US VM=1 ? */
    public static final int _0019_xx95_ = 0x00190095;

}
