/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.Siemens__Thorax_Multix_FD_Raw_Image_Settings;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "Siemens: Thorax/Multix FD Raw Image Settings";

    /** (0025,xx00) VR=SS VM=1 Raw Image Amplification */
    public static final int RawImageAmplification = 0x00250000;

    /** (0025,xx01) VR=SS VM=1 Gamma LUT */
    public static final int GammaLUT = 0x00250001;

    /** (0025,xx02) VR=US VM=1 ? */
    public static final int _0025_xx02_ = 0x00250002;

    /** (0025,xx03) VR=FL VM=1 ? */
    public static final int _0025_xx03_ = 0x00250003;

    /** (0025,xx04) VR=FL VM=1 ? */
    public static final int _0025_xx04_ = 0x00250004;

    /** (0025,xx05) VR=FL VM=1 ? */
    public static final int _0025_xx05_ = 0x00250005;

    /** (0025,xx06) VR=FL VM=1 ? */
    public static final int _0025_xx06_ = 0x00250006;

    /** (0025,xx07) VR=FL VM=1 ? */
    public static final int _0025_xx07_ = 0x00250007;

    /** (0025,xx08) VR=FL VM=1 ? */
    public static final int _0025_xx08_ = 0x00250008;

    /** (0025,xx09) VR=FL VM=1 ? */
    public static final int _0025_xx09_ = 0x00250009;

    /** (0025,xx0A) VR=FL VM=1 ? */
    public static final int _0025_xx0A_ = 0x0025000A;

    /** (0025,xx0B) VR=US VM=1 ? */
    public static final int _0025_xx0B_ = 0x0025000B;

    /** (0025,xx0C) VR=SS VM=1 Harmonization Kernel */
    public static final int HarmonizationKernel = 0x0025000C;

    /** (0025,xx0D) VR=FL VM=1 Harmonization Gain */
    public static final int HarmonizationGain = 0x0025000D;

    /** (0025,xx0E) VR=SS VM=1 Edge Enhancement Kernel */
    public static final int EdgeEnhancementKernel = 0x0025000E;

    /** (0025,xx0F) VR=FL VM=1 Edge Enhancement Gain */
    public static final int EdgeEnhancementGain = 0x0025000F;

    /** (0025,xx10) VR=LT VM=1 Internal Value */
    public static final int InternalValue = 0x00250010;

    /** (0025,xx11) VR=SS VM=1 ? */
    public static final int _0025_xx11_ = 0x00250011;

    /** (0025,xx12) VR=SS VM=1 ? */
    public static final int _0025_xx12_ = 0x00250012;

    /** (0025,xx13) VR=SS VM=1 ? */
    public static final int _0025_xx13_ = 0x00250013;

    /** (0025,xx14) VR=SS VM=1 ? */
    public static final int _0025_xx14_ = 0x00250014;

    /** (0025,xx15) VR=SS VM=1 ? */
    public static final int _0025_xx15_ = 0x00250015;

    /** (0025,xx16) VR=SS VM=1 ? */
    public static final int _0025_xx16_ = 0x00250016;

    /** (0025,xx17) VR=LO VM=1 ? */
    public static final int _0025_xx17_ = 0x00250017;

    /** (0025,xx18) VR=US VM=1 Auto Gain */
    public static final int AutoGain = 0x00250018;

    /** (0025,xx19) VR=US VM=1 Ortho Subsampling */
    public static final int OrthoSubsampling = 0x00250019;

    /** (0025,xx1A) VR=US VM=2 Image Crop Upper Left */
    public static final int ImageCropUpperLeft = 0x0025001A;

    /** (0025,xx1B) VR=US VM=2 Image Crop Upper Right */
    public static final int ImageCropUpperRight = 0x0025001B;

    /** (0025,xx1C) VR=US VM=2 Image Crop Lower Left */
    public static final int ImageCropLowerLeft = 0x0025001C;

    /** (0025,xx1D) VR=US VM=2 Image Crop Lower Right */
    public static final int ImageCropLowerRight = 0x0025001D;

    /** (0025,xx30) VR=US VM=1 Manual Cropping */
    public static final int ManualCropping = 0x00250030;

    /** (0025,xx31) VR=SS VM=1 Gamma LUT Parameter 1 */
    public static final int GammaLUTParameter1 = 0x00250031;

    /** (0025,xx32) VR=DS VM=1 Gamma LUT Parameter 2 */
    public static final int GammaLUTParameter2 = 0x00250032;

    /** (0025,xx33) VR=SS VM=1 Gamma LUT Parameter 3 */
    public static final int GammaLUTParameter3 = 0x00250033;

    /** (0025,xx34) VR=SS VM=1 Gamma LUT Parameter 4 */
    public static final int GammaLUTParameter4 = 0x00250034;

    /** (0025,xx35) VR=LO VM=1 Gamma LUT Name */
    public static final int GammaLUTName = 0x00250035;

    /** (0025,xx36) VR=DS VM=1 ? */
    public static final int _0025_xx36_ = 0x00250036;

    /** (0025,xx37) VR=DS VM=1 ? */
    public static final int _0025_xx37_ = 0x00250037;

}
