/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.acuson;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "ACUSON";

    /** (0009,xx00) VR=IS VM=1 ? */
    public static final int _0009_xx00_ = 0x00090000;

    /** (0009,xx01) VR=IS VM=1 ? */
    public static final int _0009_xx01_ = 0x00090001;

    /** (0009,xx02) VR=UN VM=1 ? */
    public static final int _0009_xx02_ = 0x00090002;

    /** (0009,xx03) VR=UN VM=1 ? */
    public static final int _0009_xx03_ = 0x00090003;

    /** (0009,xx04) VR=UN VM=1 ? */
    public static final int _0009_xx04_ = 0x00090004;

    /** (0009,xx05) VR=UN VM=1 ? */
    public static final int _0009_xx05_ = 0x00090005;

    /** (0009,xx06) VR=UN VM=1 ? */
    public static final int _0009_xx06_ = 0x00090006;

    /** (0009,xx07) VR=UN VM=1 ? */
    public static final int _0009_xx07_ = 0x00090007;

    /** (0009,xx08) VR=LT VM=1 ? */
    public static final int _0009_xx08_ = 0x00090008;

    /** (0009,xx09) VR=LT VM=1 ? */
    public static final int _0009_xx09_ = 0x00090009;

    /** (0009,xx0a) VR=IS VM=1 ? */
    public static final int _0009_xx0a_ = 0x0009000a;

    /** (0009,xx0b) VR=IS VM=1 ? */
    public static final int _0009_xx0b_ = 0x0009000b;

    /** (0009,xx0c) VR=IS VM=1 ? */
    public static final int _0009_xx0c_ = 0x0009000c;

    /** (0009,xx0d) VR=IS VM=1 ? */
    public static final int _0009_xx0d_ = 0x0009000d;

    /** (0009,xx0e) VR=IS VM=1 ? */
    public static final int _0009_xx0e_ = 0x0009000e;

    /** (0009,xx0f) VR=UN VM=1 ? */
    public static final int _0009_xx0f_ = 0x0009000f;

    /** (0009,xx10) VR=IS VM=1 ? */
    public static final int _0009_xx10_ = 0x00090010;

    /** (0009,xx11) VR=UN VM=1 ? */
    public static final int _0009_xx11_ = 0x00090011;

    /** (0009,xx12) VR=IS VM=1 ? */
    public static final int _0009_xx12_ = 0x00090012;

    /** (0009,xx13) VR=IS VM=1 ? */
    public static final int _0009_xx13_ = 0x00090013;

    /** (0009,xx14) VR=LT VM=1 ? */
    public static final int _0009_xx14_ = 0x00090014;

    /** (0009,xx15) VR=UN VM=1 ? */
    public static final int _0009_xx15_ = 0x00090015;

}
