/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.agfa_ag_hpstate;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "AGFA-AG_HPState";

    /** (0011,xx11) VR=SH VM=1 ? */
    public static final int _0011_xx11_ = 0x00110011;

    /** (0019,xxA0) VR=SQ VM=1 ? */
    public static final int _0019_xxA0_ = 0x001900A0;

    /** (0019,xxA1) VR=FL VM=1 ? */
    public static final int _0019_xxA1_ = 0x001900A1;

    /** (0019,xxA2) VR=FL VM=1 ? */
    public static final int _0019_xxA2_ = 0x001900A2;

    /** (0019,xxA3) VR=FL VM=1 ? */
    public static final int _0019_xxA3_ = 0x001900A3;

    /** (0019,xxA4) VR=FL VM=1 ? */
    public static final int _0019_xxA4_ = 0x001900A4;

    /** (0071,xx18) VR=SQ VM=1 ? */
    public static final int _0071_xx18_ = 0x00710018;

    /** (0071,xx19) VR=SQ VM=1 ? */
    public static final int _0071_xx19_ = 0x00710019;

    /** (0071,xx1A) VR=SQ VM=1 ? */
    public static final int _0071_xx1A_ = 0x0071001A;

    /** (0071,xx1C) VR=SQ VM=1 ? */
    public static final int _0071_xx1C_ = 0x0071001C;

    /** (0071,xx1E) VR=SQ VM=1 ? */
    public static final int _0071_xx1E_ = 0x0071001E;

    /** (0071,xx20) VR=FL VM=1-n ? */
    public static final int _0071_xx20_ = 0x00710020;

    /** (0071,xx21) VR=FD VM=1-n ? */
    public static final int _0071_xx21_ = 0x00710021;

    /** (0071,xx22) VR=FD VM=1-n ? */
    public static final int _0071_xx22_ = 0x00710022;

    /** (0071,xx23) VR=FD VM=1-n ? */
    public static final int _0071_xx23_ = 0x00710023;

    /** (0071,xx24) VR=FD VM=1 ? */
    public static final int _0071_xx24_ = 0x00710024;

    /** (0071,xx2B) VR=FD VM=1-n ? */
    public static final int _0071_xx2B_ = 0x0071002B;

    /** (0071,xx2C) VR=FD VM=3 ? */
    public static final int _0071_xx2C_ = 0x0071002C;

    /** (0071,xx2D) VR=FD VM=1 ? */
    public static final int _0071_xx2D_ = 0x0071002D;

    /** (0073,xx23) VR=SH VM=1 ? */
    public static final int _0073_xx23_ = 0x00730023;

    /** (0073,xx24) VR=SQ VM=1 ? */
    public static final int _0073_xx24_ = 0x00730024;

    /** (0073,xx28) VR=SQ VM=1 ? */
    public static final int _0073_xx28_ = 0x00730028;

    /** (0073,xx80) VR=FL VM=1 ? */
    public static final int _0073_xx80_ = 0x00730080;

    /** (0075,xx10) VR=LO VM=1 ? */
    public static final int _0075_xx10_ = 0x00750010;

    /** (0087,xx01) VR=LO VM=1 ? */
    public static final int _0087_xx01_ = 0x00870001;

    /** (0087,xx02) VR=LO VM=1 ? */
    public static final int _0087_xx02_ = 0x00870002;

    /** (0087,xx03) VR=SL VM=2 ? */
    public static final int _0087_xx03_ = 0x00870003;

    /** (0087,xx04) VR=SL VM=2 ? */
    public static final int _0087_xx04_ = 0x00870004;

    /** (0087,xx05) VR=FD VM=2 ? */
    public static final int _0087_xx05_ = 0x00870005;

    /** (0087,xx06) VR=FD VM=2 ? */
    public static final int _0087_xx06_ = 0x00870006;

    /** (0087,xx07) VR=FD VM=2 ? */
    public static final int _0087_xx07_ = 0x00870007;

    /** (0087,xx08) VR=FD VM=2 ? */
    public static final int _0087_xx08_ = 0x00870008;

}
