/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.GEMS_RELA_01;

import org.miaixz.bus.image.galaxy.data.ElementDictionary;
import org.miaixz.bus.image.galaxy.data.VR;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateElementDictionary extends ElementDictionary {

    public static final String PrivateCreator = "";

    public PrivateElementDictionary() {
        super("", PrivateTag.class);
    }

    @Override
    public String keywordOf(int tag) {
        return PrivateKeyword.valueOf(tag);
    }

    @Override
    public VR vrOf(int tag) {

        switch (tag & 0xFFFF00FF) {

        case PrivateTag.TableStartLocation:
        case PrivateTag.RotationFromSourceXRot:
        case PrivateTag.RotationFromSourceYRot:
        case PrivateTag.RotationFromSourceZRot:
        case PrivateTag.TaggingFlipAngle:
        case PrivateTag.TaggingOrientation:
        case PrivateTag.TagSpacing:
        case PrivateTag.RTIATimer:
        case PrivateTag.Fps:
        case PrivateTag.AutoWindowLevelAlpha:
        case PrivateTag.AutoWindowLevelBeta:
        case PrivateTag.AutoWindowLevelWindow:
        case PrivateTag.AutoWindowLevelLevel:
            return VR.DS;
        case PrivateTag.BiopsyTLocation:
        case PrivateTag.BiopsyRefLocation:
            return VR.FL;
        case PrivateTag.AnatomicalReferenceForScout:
            return VR.LO;
        case PrivateTag._0021_xx70_:
        case PrivateTag._0021_xx71_:
            return VR.LT;
        case PrivateTag.GenesisVersionNow:
        case PrivateTag.ImagePosition:
        case PrivateTag.ImageOrientation:
            return VR.SH;
        case PrivateTag.Num3DSlabs:
        case PrivateTag.LocsPer3DSlab:
        case PrivateTag.Overlaps:
        case PrivateTag.ImageFiltering:
        case PrivateTag.DiffusionDirection:
            return VR.SL;
        case PrivateTag.SeriesFromWhichPrescribed:
        case PrivateTag._0021_xx16_:
        case PrivateTag.ImageFromWhichPrescribed:
        case PrivateTag.ScreenFormat:
        case PrivateTag.LocationsInAcquisition:
        case PrivateTag.GraphicallyPrescribed:
        case PrivateTag.TubeFocalSpotPosition:
        case PrivateTag.BiopsyPosition:
            return VR.SS;
        case PrivateTag.SeriesRecordChecksum:
        case PrivateTag.AcqReconRecordChecksum:
            return VR.UL;
        case PrivateTag._0021_xx15_:
        case PrivateTag._0021_xx4E_:
            return VR.US;
        }
        return VR.UN;
    }
}
