/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SMIL_PB79;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "SMIL_PB79";

    /** (0079,xx00) VR=LO VM=1 Analgesia */
    public static final int Analgesia = 0x00790000;

    /** (0079,xx01) VR=LO VM=1 Anesthesia */
    public static final int Anesthesia = 0x00790001;

    /** (0079,xx02) VR=IS VM=1 Bed Motion */
    public static final int BedMotion = 0x00790002;

    /** (0079,xx03) VR=LO VM=1 Food Access */
    public static final int FoodAccess = 0x00790003;

    /** (0079,xx04) VR=DS VM=1 Histogram Version */
    public static final int HistogramVersion = 0x00790004;

    /** (0079,xx06) VR=DS VM=1 Injection Decay Correction */
    public static final int InjectionDecayCorrection = 0x00790006;

    /** (0079,xx07) VR=LO VM=1 Isotope */
    public static final int Isotope = 0x00790007;

    /** (0079,xx08) VR=LO VM=1 Other Drugs */
    public static final int OtherDrugs = 0x00790008;

    /** (0079,xx09) VR=IS VM=1 RebinningType */
    public static final int RebinningType = 0x00790009;

    /** (0079,xx0A) VR=DS VM=1 Rebinning Version */
    public static final int RebinningVersion = 0x0079000A;

    /** (0079,xx0B) VR=IS VM=1 Reconstruction */
    public static final int Reconstruction = 0x0079000B;

    /** (0079,xx0C) VR=DS VM=1 ReconstructionVersion */
    public static final int ReconstructionVersion = 0x0079000C;

    /** (0079,xx0D) VR=LO VM=1 Injected Compounds */
    public static final int InjectedCompound = 0x0079000D;

    /** (0079,xx0E) VR=LO VM=1 Study Model */
    public static final int StudyModel = 0x0079000E;

    /** (0079,xx0F) VR=LO VM=1 Subject Genus */
    public static final int SubjectGenus = 0x0079000F;

    /** (0079,xx10) VR=LO VM=1 Subject Phenotype */
    public static final int SubjectPhenotype = 0x00790010;

    /** (0079,xx11) VR=DS VM=1 Version */
    public static final int Version = 0x00790011;

    /** (0079,xx12) VR=LO VM=1 Water Access */
    public static final int WaterAccess = 0x00790012;

    /** (0079,xx13) VR=DS VM=1 X Offset */
    public static final int XOffset = 0x00790013;

    /** (0079,xx14) VR=DS VM=1 Y Offset */
    public static final int YOffset = 0x00790014;

    /** (0079,xx15) VR=DS VM=1 Zoom */
    public static final int Zoom = 0x00790015;

    /** (0079,xx17) VR=IS VM=1 Subject Orientation */
    public static final int SubjectOrientation = 0x00790017;

}
