/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.GEMS_PETD_01;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "GEMS_PETD_01";

    /** (0009,xx01) VR=LO VM=2 Implementation Version Name */
    public static final int ImplementationVersionName = 0x00090001;

    /** (0009,xx02) VR=LO VM=1 Patient ID */
    public static final int PatientID = 0x00090002;

    /** (0009,xx03) VR=SH VM=1 Patient Compatible Version */
    public static final int PatientCompatibleVersion = 0x00090003;

    /** (0009,xx04) VR=SH VM=1 Patient Software Version */
    public static final int PatientSoftwareVersion = 0x00090004;

    /** (0009,xx05) VR=DT VM=1 Patient DateTime */
    public static final int PatientDateTime = 0x00090005;

    /** (0009,xx06) VR=SL VM=1 Patient Type */
    public static final int PatientType = 0x00090006;

    /** (0009,xx07) VR=UI VM=1 Exam ID */
    public static final int ExamID = 0x00090007;

    /** (0009,xx08) VR=SH VM=1 Exam Compatible Version */
    public static final int ExamCompatibleVersion = 0x00090008;

    /** (0009,xx09) VR=SH VM=1 Exam Software Version */
    public static final int ExamSoftwareVersion = 0x00090009;

    /** (0009,xx0A) VR=UI VM=1 Scan ID */
    public static final int ScanID = 0x0009000A;

    /** (0009,xx0B) VR=SH VM=1 Scan Compatible Version */
    public static final int ScanCompatibleVersion = 0x0009000B;

    /** (0009,xx0C) VR=SH VM=1 Scan Software Version */
    public static final int ScanSoftwareVersion = 0x0009000C;

    /** (0009,xx0D) VR=DT VM=1 Scan Date Time */
    public static final int ScanDateTime = 0x0009000D;

    /** (0009,xx0E) VR=DT VM=1 Scan Ready */
    public static final int ScanReady = 0x0009000E;

    /** (0009,xx0F) VR=ST VM=1 Scan Description */
    public static final int ScanDescription = 0x0009000F;

    /** (0009,xx10) VR=LO VM=1 Hospital Name */
    public static final int HospitalName = 0x00090010;

    /** (0009,xx11) VR=LO VM=1 Scanner Description */
    public static final int ScannerDescription = 0x00090011;

    /** (0009,xx12) VR=LO VM=1 Manufacturer */
    public static final int Manufacturer = 0x00090012;

    /** (0009,xx13) VR=UI VM=1 FOR Identifier */
    public static final int FORIdentifier = 0x00090013;

    /** (0009,xx14) VR=LO VM=1 Landmark Name */
    public static final int LandmarkName = 0x00090014;

    /** (0009,xx15) VR=SH VM=1 Landmark Abbrev */
    public static final int LandmarkAbbrev = 0x00090015;

    /** (0009,xx16) VR=SL VM=1 Patient Position */
    public static final int PatientPosition = 0x00090016;

    /** (0009,xx17) VR=SL VM=1 Scan Perspective */
    public static final int ScanPerspective = 0x00090017;

    /** (0009,xx18) VR=SL VM=1 Scan Type */
    public static final int ScanType = 0x00090018;

    /** (0009,xx19) VR=SL VM=1 Scan Mode */
    public static final int ScanMode = 0x00090019;

    /** (0009,xx1A) VR=SL VM=1 Start Condition */
    public static final int StartCondition = 0x0009001A;

    /** (0009,xx1B) VR=SL VM=1 Start Condition Data */
    public static final int StartConditionData = 0x0009001B;

    /** (0009,xx1C) VR=SL VM=1 Sel Stop Condition */
    public static final int SelStopCondition = 0x0009001C;

    /** (0009,xx1D) VR=SL VM=1 Sel Stop Condition Data */
    public static final int SelStopConditionData = 0x0009001D;

    /** (0009,xx1E) VR=SL VM=1 Collect Deadtime */
    public static final int CollectDeadtime = 0x0009001E;

    /** (0009,xx1F) VR=SL VM=1 Collect Singles */
    public static final int CollectSingles = 0x0009001F;

    /** (0009,xx20) VR=SL VM=1 Collect Count Rate */
    public static final int CollectCountRate = 0x00090020;

    /** (0009,xx21) VR=SL VM=1 Count Rate Period */
    public static final int CountRatePeriod = 0x00090021;

    /** (0009,xx22) VR=SL VM=1 Delayed Events */
    public static final int DelayedEvents = 0x00090022;

    /** (0009,xx23) VR=SL VM=1 Delayed Bias */
    public static final int DelayedBias = 0x00090023;

    /** (0009,xx24) VR=SL VM=1 Word Size */
    public static final int WordSize = 0x00090024;

    /** (0009,xx25) VR=SL VM=1 Axial Acceptance */
    public static final int AxialAcceptance = 0x00090025;

    /** (0009,xx26) VR=SL VM=1 Axial Angle 3D */
    public static final int AxialAngle3D = 0x00090026;

    /** (0009,xx27) VR=SL VM=1 Theta Compression */
    public static final int ThetaCompression = 0x00090027;

    /** (0009,xx28) VR=SL VM=1 Axial Compression */
    public static final int AxialCompression = 0x00090028;

    /** (0009,xx29) VR=FL VM=1 Gantry Tilt Angle */
    public static final int GantryTiltAngle = 0x00090029;

    /** (0009,xx2A) VR=SL VM=1 Collimation */
    public static final int Collimation = 0x0009002A;

    /** (0009,xx2B) VR=SL VM=1 Scan FOV */
    public static final int ScanFOV = 0x0009002B;

    /** (0009,xx2C) VR=SL VM=1 Axial FOV */
    public static final int AxialFOV = 0x0009002C;

    /** (0009,xx2D) VR=SL VM=1 Event Separation */
    public static final int EventSeparation = 0x0009002D;

    /** (0009,xx2E) VR=SL VM=1 Mask Width */
    public static final int MaskWidth = 0x0009002E;

    /** (0009,xx2F) VR=SL VM=1 Binning Mode */
    public static final int BinningMode = 0x0009002F;

    /** (0009,xx30) VR=SL VM=1 Trig Rej Method */
    public static final int TrigRejMethod = 0x00090030;

    /** (0009,xx31) VR=SL VM=1 Number For Reject */
    public static final int NumberForReject = 0x00090031;

    /** (0009,xx32) VR=SL VM=1 Lower Reject Limit */
    public static final int LowerRejectLimit = 0x00090032;

    /** (0009,xx33) VR=SL VM=1 Upper Reject Limit */
    public static final int UpperRejectLimit = 0x00090033;

    /** (0009,xx34) VR=SL VM=1 Triggers Acquired */
    public static final int TriggersAcquired = 0x00090034;

    /** (0009,xx35) VR=SL VM=1 Triggers Rejected */
    public static final int TriggersRejected = 0x00090035;

    /** (0009,xx36) VR=LO VM=1 Tracer Name */
    public static final int TracerName = 0x00090036;

    /** (0009,xx37) VR=LO VM=1 Batch Description */
    public static final int BatchDescription = 0x00090037;

    /** (0009,xx38) VR=FL VM=1 Tracer Activity */
    public static final int TracerActivity = 0x00090038;

    /** (0009,xx39) VR=DT VM=1 Measured Date Time */
    public static final int MeasuredDateTime = 0x00090039;

    /** (0009,xx3A) VR=FL VM=1 Pre Inj Volume */
    public static final int PreInjVolume = 0x0009003A;

    /** (0009,xx3B) VR=DT VM=1 Administered Date Time */
    public static final int AdministeredDateTime = 0x0009003B;

    /** (0009,xx3C) VR=FL VM=1 Post Injected Activity */
    public static final int PostInjectedActivity = 0x0009003C;

    /** (0009,xx3D) VR=DT VM=1 Post Injected Date Time */
    public static final int PostInjectedDateTime = 0x0009003D;

    /** (0009,xx3E) VR=SH VM=1 Radio Nuclide Name */
    public static final int RadioNuclideName = 0x0009003E;

    /** (0009,xx3F) VR=FL VM=1 Half Life */
    public static final int HalfLife = 0x0009003F;

    /** (0009,xx40) VR=FL VM=1 Positron Fraction */
    public static final int PositronFraction = 0x00090040;

    /** (0009,xx41) VR=SL VM=1 Source 1 Holder */
    public static final int Source1Holder = 0x00090041;

    /** (0009,xx42) VR=FL VM=1 Source 1 Activity */
    public static final int Source1Activity = 0x00090042;

    /** (0009,xx43) VR=DT VM=1 Source 1 Meas DT */
    public static final int Source1MeasDT = 0x00090043;

    /** (0009,xx44) VR=SH VM=1 Source 1 Radio Nuclide */
    public static final int Source1RadioNuclide = 0x00090044;

    /** (0009,xx45) VR=FL VM=1 Source 1 Half Life */
    public static final int Source1HalfLife = 0x00090045;

    /** (0009,xx46) VR=SL VM=1 Source 2 Holder */
    public static final int Source2Holder = 0x00090046;

    /** (0009,xx47) VR=FL VM=1 Source 2 Activity */
    public static final int Source2Activity = 0x00090047;

    /** (0009,xx48) VR=DT VM=1 Source 2 Meas DT */
    public static final int Source2MeasDT = 0x00090048;

    /** (0009,xx49) VR=SH VM=1 Source 2 Radio Nuclide */
    public static final int Source2RadioNuclide = 0x00090049;

    /** (0009,xx4A) VR=FL VM=1 Source 2 Half Life */
    public static final int Source2HalfLife = 0x0009004A;

    /** (0009,xx4B) VR=SL VM=1 Source Speed */
    public static final int SourceSpeed = 0x0009004B;

    /** (0009,xx4C) VR=FL VM=1 Source Location */
    public static final int SourceLocation = 0x0009004C;

    /** (0009,xx4D) VR=SL VM=1 Emission Present */
    public static final int EmissionPresent = 0x0009004D;

    /** (0009,xx4E) VR=SL VM=1 Lower Axial Acc */
    public static final int LowerAxialAcc = 0x0009004E;

    /** (0009,xx4F) VR=SL VM=1 Upper Axial Acc */
    public static final int UpperAxialAcc = 0x0009004F;

    /** (0009,xx50) VR=SL VM=1 Lower Coinc Limit */
    public static final int LowerCoincLimit = 0x00090050;

    /** (0009,xx51) VR=SL VM=1 Upper Coinc Limit */
    public static final int UpperCoincLimit = 0x00090051;

    /** (0009,xx52) VR=SL VM=1 Coinc Delay Offset */
    public static final int CoincDelayOffset = 0x00090052;

    /** (0009,xx53) VR=SL VM=1 Coinc Output Mode */
    public static final int CoincOutputMode = 0x00090053;

    /** (0009,xx54) VR=SL VM=1 Upper Energy Limit */
    public static final int UpperEnergyLimit = 0x00090054;

    /** (0009,xx55) VR=SL VM=1 Lower Energy Limit */
    public static final int LowerEnergyLimit = 0x00090055;

    /** (0009,xx56) VR=UI VM=1 Normal Cal ID */
    public static final int NormalCalID = 0x00090056;

    /** (0009,xx57) VR=UI VM=1 Normal 2D Cal ID */
    public static final int Normal2DCalID = 0x00090057;

    /** (0009,xx58) VR=UI VM=1 Blank Cal ID */
    public static final int BlankCalID = 0x00090058;

    /** (0009,xx59) VR=UI VM=1 WC Cal ID */
    public static final int WCCalID = 0x00090059;

    /** (0009,xx5A) VR=SL VM=1 Derived */
    public static final int Derived = 0x0009005A;

    /** (0009,xx5B) VR=LO VM=1 Contrast Agent */
    public static final int ContrastAgent = 0x0009005B;

    /** (0009,xx5C) VR=UI VM=1 frame_id */
    public static final int frameid = 0x0009005C;

    /** (0009,xx5D) VR=UI VM=1 scan_id */
    public static final int scanid = 0x0009005D;

    /** (0009,xx5E) VR=UI VM=1 exam_id */
    public static final int examid = 0x0009005E;

    /** (0009,xx5F) VR=LO VM=1 patient_id */
    public static final int patientid = 0x0009005F;

    /** (0009,xx60) VR=SH VM=1 compatible_version */
    public static final int compatibleversion = 0x00090060;

    /** (0009,xx61) VR=SH VM=1 software_version */
    public static final int softwareversion = 0x00090061;

    /** (0009,xx62) VR=ST VM=1 where_is_frame */
    public static final int whereisframe = 0x00090062;

    /** (0009,xx63) VR=SL VM=1 frame_size */
    public static final int framesize = 0x00090063;

    /** (0009,xx64) VR=SL VM=1 file_exists */
    public static final int fileexists = 0x00090064;

    /** (0009,xx65) VR=SL VM=1 patient_entry */
    public static final int patiententry = 0x00090065;

    /** (0009,xx66) VR=FL VM=1 table_height */
    public static final int tableheight = 0x00090066;

    /** (0009,xx67) VR=FL VM=1 table_z_position */
    public static final int tablezposition = 0x00090067;

    /** (0009,xx68) VR=DT VM=1 landmark_datetime */
    public static final int landmarkdatetime = 0x00090068;

    /** (0009,xx69) VR=SL VM=1 slice_count */
    public static final int slicecount = 0x00090069;

    /** (0009,xx6A) VR=FL VM=1 start_location */
    public static final int startlocation = 0x0009006A;

    /** (0009,xx6B) VR=SL VM=1 acq_delay */
    public static final int acqdelay = 0x0009006B;

    /** (0009,xx6C) VR=DT VM=1 acq_start */
    public static final int acqstart = 0x0009006C;

    /** (0009,xx6D) VR=SL VM=1 acq_duration */
    public static final int acqduration = 0x0009006D;

    /** (0009,xx6E) VR=SL VM=1 acq_bin_dur */
    public static final int acqbindur = 0x0009006E;

    /** (0009,xx6F) VR=SL VM=1 acq_bin_start */
    public static final int acqbinstart = 0x0009006F;

    /** (0009,xx70) VR=SL VM=1 actual_stop_cond */
    public static final int actualstopcond = 0x00090070;

    /** (0009,xx71) VR=FD VM=1 total_prompts */
    public static final int totalprompts = 0x00090071;

    /** (0009,xx72) VR=FD VM=1 total_delays */
    public static final int totaldelays = 0x00090072;

    /** (0009,xx73) VR=SL VM=1 frame_valid */
    public static final int framevalid = 0x00090073;

    /** (0009,xx74) VR=SL VM=1 validity_info */
    public static final int validityinfo = 0x00090074;

    /** (0009,xx75) VR=SL VM=1 archived */
    public static final int archived = 0x00090075;

    /** (0009,xx76) VR=SL VM=1 compression */
    public static final int compression = 0x00090076;

    /** (0009,xx77) VR=SL VM=1 uncompressed_size */
    public static final int uncompressedsize = 0x00090077;

    /** (0009,xx78) VR=SL VM=1 accum_bin_dur */
    public static final int accumbindur = 0x00090078;

    /** (0009,xx79) VR=SH VM=1 Image Set Compatible Version */
    public static final int ImageSetCompatibleVersion = 0x00090079;

    /** (0009,xx7A) VR=SH VM=1 Image Set Software Version */
    public static final int ImageSetSoftwareVersion = 0x0009007A;

    /** (0009,xx7B) VR=DT VM=1 Image Set Date Time */
    public static final int ImageSetDateTime = 0x0009007B;

    /** (0009,xx7C) VR=SL VM=1 Image Set Source */
    public static final int ImageSetSource = 0x0009007C;

    /** (0009,xx7D) VR=SL VM=1 Image Set Contents */
    public static final int ImageSetContents = 0x0009007D;

    /** (0009,xx7E) VR=SL VM=1 Image Set Type */
    public static final int ImageSetType = 0x0009007E;

    /** (0009,xx7F) VR=DS VM=1 Image Set Reference */
    public static final int ImageSetReference = 0x0009007F;

    /** (0009,xx80) VR=SL VM=1 Multi Patient */
    public static final int MultiPatient = 0x00090080;

    /** (0009,xx81) VR=SL VM=1 Number of Normals */
    public static final int NumberOfNormals = 0x00090081;

    /** (0009,xx82) VR=UI VM=1 Color Map ID */
    public static final int ColorMapID = 0x00090082;

    /** (0009,xx83) VR=SL VM=1 Window Level Type */
    public static final int WindowLevelType = 0x00090083;

    /** (0009,xx84) VR=FL VM=1 Rotate */
    public static final int Rotate = 0x00090084;

    /** (0009,xx85) VR=SL VM=1 Flip */
    public static final int Flip = 0x00090085;

    /** (0009,xx86) VR=FL VM=1 Zoom */
    public static final int Zoom = 0x00090086;

    /** (0009,xx87) VR=SL VM=1 PanX */
    public static final int PanX = 0x00090087;

    /** (0009,xx88) VR=SL VM=1 PanY */
    public static final int PanY = 0x00090088;

    /** (0009,xx89) VR=FL VM=1 Window Level Min */
    public static final int WindowLevelMin = 0x00090089;

    /** (0009,xx8A) VR=FL VM=1 Window Level Max */
    public static final int WindowLevelMax = 0x0009008A;

    /** (0009,xx8B) VR=SL VM=1 ReconMethod */
    public static final int ReconMethod = 0x0009008B;

    /** (0009,xx8C) VR=SL VM=1 Attenuation */
    public static final int Attenuation = 0x0009008C;

    /** (0009,xx8D) VR=FL VM=1 Attenuation Coefficient */
    public static final int AttenuationCoefficient = 0x0009008D;

    /** (0009,xx8E) VR=SL VM=1 BP Filter */
    public static final int BPFilter = 0x0009008E;

    /** (0009,xx8F) VR=FL VM=1 BP Filter Cutoff */
    public static final int BPFilterCutoff = 0x0009008F;

    /** (0009,xx90) VR=SL VM=1 BP Filter Order */
    public static final int BPFilterOrder = 0x00090090;

    /** (0009,xx91) VR=FL VM=1 BP Filter Center I */
    public static final int BPFilterCenterI = 0x00090091;

    /** (0009,xx92) VR=FL VM=1 BP Filter Center P */
    public static final int BPFilterCenterP = 0x00090092;

    /** (0009,xx93) VR=SL VM=1 Atten Smooth */
    public static final int AttenSmooth = 0x00090093;

    /** (0009,xx94) VR=SL VM=1 Atten Smooth Param */
    public static final int AttenSmoothParam = 0x00090094;

    /** (0009,xx95) VR=SL VM=1 Angle Smooth Param */
    public static final int AngleSmoothParam = 0x00090095;

    /** (0009,xx96) VR=UI VM=1 Well CounterCal ID */
    public static final int WellCounterCalID = 0x00090096;

    /** (0009,xx97) VR=UI VM=1 Trans Scan ID */
    public static final int TransScanID = 0x00090097;

    /** (0009,xx98) VR=UI VM=1 Norm Cal ID */
    public static final int NormCalID = 0x00090098;

    /** (0009,xx99) VR=UI VM=1 Blnk Cal ID */
    public static final int BlnkCalID = 0x00090099;

    /** (0009,xx9A) VR=FL VM=1 CAC Edge Threshold */
    public static final int CACEdgeThreshold = 0x0009009A;

    /** (0009,xx9B) VR=FL VM=1 CAC Skull Offset */
    public static final int CACSkullOffset = 0x0009009B;

    /** (0009,xx9C) VR=UI VM=1 Emiss Sub ID */
    public static final int EmissSubID = 0x0009009C;

    /** (0009,xx9D) VR=SS VM=1 Radial Filter 3D */
    public static final int RadialFilter3D = 0x0009009D;

    /** (0009,xx9E) VR=FL VM=1 Radial Cutoff 3D */
    public static final int RadialCutoff3D = 0x0009009E;

    /** (0009,xx9F) VR=SL VM=1 Axial Filter 3D */
    public static final int AxialFilter3D = 0x0009009F;

    /** (0009,xxA0) VR=FL VM=1 Axial Cutoff 3D */
    public static final int AxialCutoff3D = 0x000900A0;

    /** (0009,xxA1) VR=FL VM=1 Axial Start */
    public static final int AxialStart = 0x000900A1;

    /** (0009,xxA2) VR=FL VM=1 Axial Spacing */
    public static final int AxialSpacing = 0x000900A2;

    /** (0009,xxA3) VR=SL VM=1 Axial Angles Used */
    public static final int AxialAnglesUsed = 0x000900A3;

    /** (0009,xxA6) VR=SL VM=1 slice_number */
    public static final int slicenumber = 0x000900A6;

    /** (0009,xxA7) VR=FL VM=1 total_counts */
    public static final int totalcounts = 0x000900A7;

    /** (0009,xxA8) VR=OB VM=1 other_atts */
    public static final int otheratts = 0x000900A8;

    /** (0009,xxA9) VR=SL VM=1 other_atts_size */
    public static final int otherattssize = 0x000900A9;

    /** (0009,xxAB) VR=FL VM=1 bp_center_x */
    public static final int bpcenterx = 0x000900AB;

    /** (0009,xxAC) VR=FL VM=1 bp_center_y */
    public static final int bpcentery = 0x000900AC;

    /** (0009,xxAD) VR=UI VM=1 trans_frame_id */
    public static final int transframeid = 0x000900AD;

    /** (0009,xxAE) VR=UI VM=1 tpluse_frame_id */
    public static final int tpluseframeid = 0x000900AE;

    /** (0009,xxB1) VR=FL VM=1 profile_spacing */
    public static final int profilespacing = 0x000900B1;

    /** (0009,xxB2) VR=SS VM=1 IR Num Iterations */
    public static final int IRNumIterations = 0x000900B2;

    /** (0009,xxB3) VR=SS VM=1 IR Num Subsets */
    public static final int IRNumSubsets = 0x000900B3;

    /** (0009,xxB4) VR=FL VM=1 IR Recon FOV */
    public static final int IRReconFOV = 0x000900B4;

    /** (0009,xxB5) VR=SS VM=1 IR Corr Model */
    public static final int IRCorrModel = 0x000900B5;

    /** (0009,xxB6) VR=SS VM=1 IR Loop Filter */
    public static final int IRLoopFilter = 0x000900B6;

    /** (0009,xxB7) VR=FL VM=1 IR Pre Filt Param */
    public static final int IRPreFiltParam = 0x000900B7;

    /** (0009,xxB8) VR=FL VM=1 IR Loop Filt Param */
    public static final int IRLoopFiltParam = 0x000900B8;

    /** (0009,xxB9) VR=FL VM=1 Response Filt Param */
    public static final int ResponseFiltParam = 0x000900B9;

    /** (0009,xxBA) VR=SS VM=1 Post Filter */
    public static final int PostFilter = 0x000900BA;

    /** (0009,xxBB) VR=FL VM=1 Post Filter Param */
    public static final int PostFilterParam = 0x000900BB;

    /** (0009,xxBC) VR=SS VM=1 IR Regularize */
    public static final int IRRegularize = 0x000900BC;

    /** (0009,xxBD) VR=FL VM=1 IR Regularize Param */
    public static final int IRRegularizeParam = 0x000900BD;

    /** (0009,xxBE) VR=SS VM=1 AC BP Filter */
    public static final int ACBPFilter = 0x000900BE;

    /** (0009,xxBF) VR=FL VM=1 AC BP Filt Cutoff */
    public static final int ACBPFiltCutoff = 0x000900BF;

    /** (0009,xxC0) VR=SL VM=1 AC BP Filt Order */
    public static final int ACBPFiltOrder = 0x000900C0;

    /** (0009,xxC1) VR=SS VM=1 AC Img Smooth */
    public static final int ACImgSmooth = 0x000900C1;

    /** (0009,xxC2) VR=FL VM=1 AC Img Smooth Parm */
    public static final int ACImgSmoothParm = 0x000900C2;

    /** (0009,xxC3) VR=SL VM=1 Scatter Method */
    public static final int ScatterMethod = 0x000900C3;

    /** (0009,xxC4) VR=SS VM=1 Scatter Num Iter */
    public static final int ScatterNumIter = 0x000900C4;

    /** (0009,xxC5) VR=FL VM=1 Scatter Parm */
    public static final int ScatterParm = 0x000900C5;

    /** (0009,xxC6) VR=FL VM=1 seg_qc_parm */
    public static final int segqcparm = 0x000900C6;

    /** (0009,xxC7) VR=SL VM=1 overlap */
    public static final int overlap = 0x000900C7;

    /** (0009,xxC8) VR=UI VM=1 ovlp_frm_id */
    public static final int ovlpfrmid = 0x000900C8;

    /** (0009,xxC9) VR=UI VM=1 ovlp_trans_frm_id */
    public static final int ovlptransfrmid = 0x000900C9;

    /** (0009,xxCA) VR=UI VM=1 ovlp_tpulse_frm_id */
    public static final int ovlptpulsefrmid = 0x000900CA;

    /** (0009,xxCB) VR=FL VM=1 vqc_x_axis_trans */
    public static final int vqcxaxistrans = 0x000900CB;

    /** (0009,xxCC) VR=FL VM=1 vqc_x_axis_tilt */
    public static final int vqcxaxistilt = 0x000900CC;

    /** (0009,xxCD) VR=FL VM=1 vqc_y_axis_trans */
    public static final int vqcyaxistrans = 0x000900CD;

    /** (0009,xxCE) VR=FL VM=1 vqc_y_axis_swivel */
    public static final int vqcyaxisswivel = 0x000900CE;

    /** (0009,xxCF) VR=FL VM=1 vqc_z_axis_trans */
    public static final int vqczaxistrans = 0x000900CF;

    /** (0009,xxD0) VR=FL VM=1 vqc_z_axis_roll */
    public static final int vqczaxisroll = 0x000900D0;

    /** (0009,xxD1) VR=LO VM=1 ctac_conv_scale */
    public static final int ctacconvscale = 0x000900D1;

    /** (0009,xxD2) VR=UI VM=1 image_set_id */
    public static final int imagesetid = 0x000900D2;

    /** (0009,xxD3) VR=SL VM=1 contrast_route */
    public static final int contrastroute = 0x000900D3;

    /** (0009,xxD5) VR=FL VM=1 loop_filter_parm */
    public static final int loopfilterparm = 0x000900D5;

    /** (0009,xxD6) VR=FL VM=1 image_one_loc */
    public static final int imageoneloc = 0x000900D6;

    /** (0009,xxD7) VR=FL VM=1 image_index_loc */
    public static final int imageindexloc = 0x000900D7;

    /** (0009,xxD8) VR=SL VM=1 frame_number */
    public static final int framenumber = 0x000900D8;

    /** (0009,xxD9) VR=SL VM=1 list_file_exists */
    public static final int listfileexists = 0x000900D9;

    /** (0009,xxDA) VR=ST VM=1 where_is_list_frame */
    public static final int whereislistframe = 0x000900DA;

    /** (0009,xxDB) VR=SL VM=1 ir_z_filter_flag */
    public static final int irzfilterflag = 0x000900DB;

    /** (0009,xxDC) VR=FL VM=1 ir_z_filter_ratio */
    public static final int irzfilterratio = 0x000900DC;

    /** (0009,xxDD) VR=US VM=1 num_of_rr_interval */
    public static final int numofrrinterval = 0x000900DD;

    /** (0009,xxDE) VR=US VM=1 num_of_time_slots */
    public static final int numoftimeslots = 0x000900DE;

    /** (0009,xxDF) VR=US VM=1 num_of_slices */
    public static final int numofslices = 0x000900DF;

    /** (0009,xxE0) VR=US VM=1 num_of_time_slices */
    public static final int numoftimeslices = 0x000900E0;

    /** (0009,xxE1) VR=SL VM=1 unlisted_scan */
    public static final int unlistedscan = 0x000900E1;

    /** (0009,xxE2) VR=SL VM=1 rest_stress */
    public static final int reststress = 0x000900E2;

    /** (0009,xxE3) VR=FL VM=1 phase percentage */
    public static final int phasepercentage = 0x000900E3;

    /** (0009,xxE4) VR=ST VM=1 ? */
    public static final int _0009_xxE4_ = 0x000900E4;

    /** (0009,xxE5) VR=FL VM=1 left shift */
    public static final int leftshift = 0x000900E5;

    /** (0009,xxE6) VR=FL VM=1 posterior shift */
    public static final int posteriorshift = 0x000900E6;

    /** (0009,xxE7) VR=FL VM=1 superior shift */
    public static final int superiorshift = 0x000900E7;

    /** (0009,xxE8) VR=SL VM=1 acq_bin_num */
    public static final int acqbinnum = 0x000900E8;

    /** (0009,xxE9) VR=FL VM=1 acq_bin_dur_percent */
    public static final int acqbindurpercent = 0x000900E9;

    /** (0009,xxEA) VR=SL VM=1 ? */
    public static final int _0009_xxEA_ = 0x000900EA;

    /** (0009,xxEB) VR=FL VM=1 ? */
    public static final int _0009_xxEB_ = 0x000900EB;

    /** (0009,xxEC) VR=SL VM=1 ? */
    public static final int _0009_xxEC_ = 0x000900EC;

    /** (0011,xx01) VR=SQ VM=1 ? */
    public static final int _0011_xx01_ = 0x00110001;

    /** (0011,xx18) VR=OB VM=1 ? */
    public static final int _0011_xx18_ = 0x00110018;

    /** (0013,xx01) VR=SQ VM=1 ? */
    public static final int _0013_xx01_ = 0x00130001;

    /** (0017,xx01) VR=UI VM=1 correction_cal_id */
    public static final int correctioncalid = 0x00170001;

    /** (0017,xx04) VR=DT VM=1 cal_datetime */
    public static final int caldatetime = 0x00170004;

    /** (0017,xx05) VR=LO VM=1 cal_datetime */
    public static final int caldescription = 0x00170005;

    /** (0017,xx06) VR=SL VM=1 cal_type */
    public static final int caltype = 0x00170006;

    /** (0017,xx07) VR=ST VM=1 where_is_corr */
    public static final int whereiscorr = 0x00170007;

    /** (0017,xx08) VR=SL VM=1 corr_file_size */
    public static final int corrfilesize = 0x00170008;

    /** (0017,xx0A) VR=DT VM=1 scan_datetime */
    public static final int scandatetime = 0x0017000A;

    /** (0017,xx0B) VR=LO VM=1 norm_2d_cal_id */
    public static final int norm2dcalid = 0x0017000B;

    /** (0017,xx0C) VR=SH VM=1 hosp_identifier */
    public static final int hospidentifier = 0x0017000C;

    /** (0019,xx01) VR=UI VM=1 wc_cal_id */
    public static final int wccalid = 0x00190001;

    /** (0019,xx07) VR=LO VM=1 cal_hardware */
    public static final int calhardware = 0x00190007;

    /** (0019,xx08) VR=OB VM=1 coefficients */
    public static final int coefficients = 0x00190008;

    /** (0019,xx09) VR=FL VM=1 activity_factor_hr */
    public static final int activityfactorhr = 0x00190009;

    /** (0019,xx0A) VR=FL VM=1 activity_factor_hs */
    public static final int activityfactorhs = 0x0019000A;

    /** (0019,xx0B) VR=FL VM=1 activity_factor_3d */
    public static final int activityfactor3d = 0x0019000B;

    /** (0019,xx0F) VR=FL VM=1 meas_activity */
    public static final int measactivity = 0x0019000F;

    /** (0019,xx10) VR=DT VM=1 meas_datetime */
    public static final int measdatetime = 0x00190010;

    /** (0019,xx11) VR=SL VM=1 axial_filter_3d */
    public static final int axialfilter3d = 0x00190011;

    /** (0019,xx12) VR=FL VM=1 axial_cutoff_3d */
    public static final int axialcutoff3d = 0x00190012;

    /** (0019,xx13) VR=SL VM=1 default_flag */
    public static final int defaultflag = 0x00190013;

    /** (0019,xx15) VR=SL VM=1 wc_cal_rec_method */
    public static final int wccalrecmethod = 0x00190015;

    /** (0019,xx16) VR=SL VM=1 activity_factor_2d */
    public static final int activityfactor2d = 0x00190016;

    /** (0019,xx17) VR=SL VM=1 isotope */
    public static final int isotope = 0x00190017;

    /** (0021,xx01) VR=US VM=1 raw_data_type */
    public static final int rawdatatype = 0x00210001;

    /** (0021,xx02) VR=UL VM=1 raw_data_size */
    public static final int rawdatasize = 0x00210002;

    /** (0023,xx01) VR=OB VM=1 raw_data_blob */
    public static final int rawdatablob = 0x00230001;

    /** (5001,xx01) VR=UI VM=1 Curve ID */
    public static final int CurveID = 0x50010001;

    /** (5001,xx02) VR=SH VM=1 Curve Compatible Version */
    public static final int CurveCompatibleVersion = 0x50010002;

    /** (5001,xx03) VR=SH VM=1 Curve Software Version */
    public static final int CurveSoftwareVersion = 0x50010003;

    /** (5001,xx04) VR=SL VM=1 Statistics Type */
    public static final int StatisticsType = 0x50010004;

    /** (5001,xx05) VR=LT VM=1 How Derived */
    public static final int HowDerived = 0x50010005;

    /** (5001,xx06) VR=SL VM=1 How Derived Size */
    public static final int HowDerivedSize = 0x50010006;

    /** (5001,xx08) VR=SL VM=1 Deadtime */
    public static final int Deadtime = 0x50010008;

    /** (5003,xx01) VR=SQ VM=1 Graph Sequence */
    public static final int GraphSequence = 0x50030001;

    /** (5003,xx02) VR=UI VM=1 Graph ID */
    public static final int GraphID = 0x50030002;

    /** (5003,xx03) VR=SH VM=1 Graph Compatible Version */
    public static final int GraphCompatibleVersion = 0x50030003;

    /** (5003,xx04) VR=SH VM=1 Graph Software Version */
    public static final int GraphSoftwareVersion = 0x50030004;

    /** (5003,xx05) VR=LO VM=1 Title */
    public static final int Title = 0x50030005;

    /** (5003,xx06) VR=DT VM=1 Graph Date Time */
    public static final int GraphDateTime = 0x50030006;

    /** (5003,xx07) VR=ST VM=1 Graph Description */
    public static final int GraphDescription = 0x50030007;

    /** (5003,xx08) VR=LO VM=1 Title Font Name */
    public static final int TitleFontName = 0x50030008;

    /** (5003,xx09) VR=SH VM=1 Title Font Size */
    public static final int TitleFontSize = 0x50030009;

    /** (5003,xx0A) VR=LO VM=1 Footer */
    public static final int Footer = 0x5003000A;

    /** (5003,xx0B) VR=SH VM=1 Footer Font Size */
    public static final int FooterFontSize = 0x5003000B;

    /** (5003,xx0C) VR=LO VM=1 Foreground Color */
    public static final int ForegroundColor = 0x5003000C;

    /** (5003,xx0D) VR=LO VM=1 Background Color */
    public static final int BackgroundColor = 0x5003000D;

    /** (5003,xx0E) VR=SL VM=1 Graph Border */
    public static final int GraphBorder = 0x5003000E;

    /** (5003,xx0F) VR=SL VM=1 Graph Width */
    public static final int GraphWidth = 0x5003000F;

    /** (5003,xx10) VR=SL VM=1 Graph Height */
    public static final int GraphHeight = 0x50030010;

    /** (5003,xx11) VR=SL VM=1 Grid */
    public static final int Grid = 0x50030011;

    /** (5003,xx12) VR=LO VM=1 Label Font Name */
    public static final int LabelFontName = 0x50030012;

    /** (5003,xx13) VR=SH VM=1 Label Font Size */
    public static final int LabelFontSize = 0x50030013;

    /** (5003,xx14) VR=LO VM=1 Axes Color */
    public static final int AxesColor = 0x50030014;

    /** (5003,xx15) VR=LO VM=1 X Axis Label */
    public static final int XAxisLabel = 0x50030015;

    /** (5003,xx16) VR=SL VM=1 X Axis Units */
    public static final int XAxisUnits = 0x50030016;

    /** (5003,xx17) VR=FL VM=1 X Major Tics */
    public static final int XMajorTics = 0x50030017;

    /** (5003,xx18) VR=FL VM=1 X Axis Min */
    public static final int XAxisMin = 0x50030018;

    /** (5003,xx19) VR=FL VM=1 X Axis Max */
    public static final int XAxisMax = 0x50030019;

    /** (5003,xx1A) VR=LO VM=1 Y Axis Label */
    public static final int YAxisLabel = 0x5003001A;

    /** (5003,xx1B) VR=SL VM=1 Y Axis Units */
    public static final int YAxisUnits = 0x5003001B;

    /** (5003,xx1C) VR=FL VM=1 Y Major Tics */
    public static final int YMajorTics = 0x5003001C;

    /** (5003,xx1D) VR=FL VM=1 Y Axis Min */
    public static final int YAxisMin = 0x5003001D;

    /** (5003,xx1E) VR=FL VM=1 Y Axis Max */
    public static final int YAxisMax = 0x5003001E;

    /** (5003,xx1F) VR=LO VM=1 Legend Font Name */
    public static final int LegendFontName = 0x5003001F;

    /** (5003,xx20) VR=SH VM=1 Legend Font Size */
    public static final int LegendFontSize = 0x50030020;

    /** (5003,xx21) VR=SL VM=1 Legend Location X */
    public static final int LegendLocationX = 0x50030021;

    /** (5003,xx22) VR=SL VM=1 Legend Location Y */
    public static final int LegendLocationY = 0x50030022;

    /** (5003,xx23) VR=SL VM=1 Legend Width */
    public static final int LegendWidth = 0x50030023;

    /** (5003,xx24) VR=SL VM=1 Legend Height */
    public static final int LegendHeight = 0x50030024;

    /** (5003,xx25) VR=SL VM=1 Legend Border */
    public static final int LegendBorder = 0x50030025;

    /** (5005,xx01) VR=SQ VM=1 Curve Presentation Sequence */
    public static final int CurvePresentationSequence = 0x50050001;

    /** (5005,xx02) VR=UI VM=1 Curve Presentation ID */
    public static final int CurvePresentationID = 0x50050002;

    /**
     * (5005,xx05) VR=SH VM=1 Curve Presentation Compatible Version
     */
    public static final int CurvePresentationCompatibleVersion = 0x50050005;

    /**
     * (5005,xx06) VR=SH VM=1 Curve Presentation Software Version
     */
    public static final int CurvePresentationSoftwareVersion = 0x50050006;

    /** (5005,xx07) VR=LO VM=1 Curve Label */
    public static final int CurveLabel = 0x50050007;

    /** (5005,xx08) VR=LO VM=1 Color */
    public static final int Color = 0x50050008;

    /** (5005,xx09) VR=SL VM=1 Line Type */
    public static final int LineType = 0x50050009;

    /** (5005,xx0A) VR=SL VM=1 Line Width */
    public static final int LineWidth = 0x5005000A;

    /** (5005,xx0B) VR=SL VM=1 Point Symbol */
    public static final int PointSymbol = 0x5005000B;

    /** (5005,xx0C) VR=SL VM=1 Point Symbol Dim */
    public static final int PointSymbolDim = 0x5005000C;

    /** (5005,xx0D) VR=LO VM=1 Point Color */
    public static final int PointColor = 0x5005000D;

}
