/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.GEMS_RELA_01;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "GEMS_RELA_01";

    /** (0021,xx03) VR=SS VM=1 Series From Which Prescribed */
    public static final int SeriesFromWhichPrescribed = 0x00210003;

    /** (0021,xx05) VR=SH VM=1 Genesis Version Now */
    public static final int GenesisVersionNow = 0x00210005;

    /** (0021,xx07) VR=UL VM=1 Series Record Checksum */
    public static final int SeriesRecordChecksum = 0x00210007;

    /** (0021,xx15) VR=US VM=1 ? */
    public static final int _0021_xx15_ = 0x00210015;

    /** (0021,xx16) VR=SS VM=1 ? */
    public static final int _0021_xx16_ = 0x00210016;

    /** (0021,xx19) VR=UL VM=1 Acq Recon Record Checksum */
    public static final int AcqReconRecordChecksum = 0x00210019;

    /** (0021,xx20) VR=DS VM=1 Table Start Location */
    public static final int TableStartLocation = 0x00210020;

    /** (0021,xx36) VR=SS VM=1 Image From Which Prescribed */
    public static final int ImageFromWhichPrescribed = 0x00210036;

    /** (0021,xx37) VR=SS VM=1 Screen Format */
    public static final int ScreenFormat = 0x00210037;

    /** (0021,xx4A) VR=LO VM=1 Anatomical Reference For Scout */
    public static final int AnatomicalReferenceForScout = 0x0021004A;

    /** (0021,xx4E) VR=US VM=1 ? */
    public static final int _0021_xx4E_ = 0x0021004E;

    /** (0021,xx4F) VR=SS VM=1 Locations In Acquisition */
    public static final int LocationsInAcquisition = 0x0021004F;

    /** (0021,xx50) VR=SS VM=1 Graphically Prescribed */
    public static final int GraphicallyPrescribed = 0x00210050;

    /** (0021,xx51) VR=DS VM=1 Rotation From Source X Rot */
    public static final int RotationFromSourceXRot = 0x00210051;

    /** (0021,xx52) VR=DS VM=1 Rotation From Source Y Rot */
    public static final int RotationFromSourceYRot = 0x00210052;

    /** (0021,xx53) VR=DS VM=1 Rotation From Source Z Rot */
    public static final int RotationFromSourceZRot = 0x00210053;

    /** (0021,xx54) VR=SH VM=3 Image Position */
    public static final int ImagePosition = 0x00210054;

    /** (0021,xx55) VR=SH VM=6 Image Orientation */
    public static final int ImageOrientation = 0x00210055;

    /** (0021,xx56) VR=SL VM=1 Num 3D slabs */
    public static final int Num3DSlabs = 0x00210056;

    /** (0021,xx57) VR=SL VM=1 Locs per 3D slab */
    public static final int LocsPer3DSlab = 0x00210057;

    /** (0021,xx58) VR=SL VM=1 Overlaps */
    public static final int Overlaps = 0x00210058;

    /** (0021,xx59) VR=SL VM=1 Image Filtering 0.5/0.2T */
    public static final int ImageFiltering = 0x00210059;

    /** (0021,xx5A) VR=SL VM=1 Diffusion direction */
    public static final int DiffusionDirection = 0x0021005A;

    /** (0021,xx5B) VR=DS VM=1 Tagging Flip Angle */
    public static final int TaggingFlipAngle = 0x0021005B;

    /** (0021,xx5C) VR=DS VM=1 Tagging Orientation */
    public static final int TaggingOrientation = 0x0021005C;

    /** (0021,xx5D) VR=DS VM=1 Tag Spacing */
    public static final int TagSpacing = 0x0021005D;

    /** (0021,xx5E) VR=DS VM=1 RTIA_timer */
    public static final int RTIATimer = 0x0021005E;

    /** (0021,xx5F) VR=DS VM=1 Fps */
    public static final int Fps = 0x0021005F;

    /** (0021,xx70) VR=LT VM=1 ? */
    public static final int _0021_xx70_ = 0x00210070;

    /** (0021,xx71) VR=LT VM=1 ? */
    public static final int _0021_xx71_ = 0x00210071;

    /** (0021,xx81) VR=DS VM=1 Auto Window Level Alpha */
    public static final int AutoWindowLevelAlpha = 0x00210081;

    /** (0021,xx82) VR=DS VM=1 Auto Window Level Beta */
    public static final int AutoWindowLevelBeta = 0x00210082;

    /** (0021,xx83) VR=DS VM=1 Auto Window Level Window */
    public static final int AutoWindowLevelWindow = 0x00210083;

    /** (0021,xx84) VR=DS VM=1 Auto Window Level Level */
    public static final int AutoWindowLevelLevel = 0x00210084;

    /** (0021,xx90) VR=SS VM=1 Tube Focal Spot Position */
    public static final int TubeFocalSpotPosition = 0x00210090;

    /** (0021,xx91) VR=SS VM=1 Biopsy Position */
    public static final int BiopsyPosition = 0x00210091;

    /** (0021,xx92) VR=FL VM=1 Biopsy T Location */
    public static final int BiopsyTLocation = 0x00210092;

    /** (0021,xx93) VR=FL VM=1 Biopsy Ref Location */
    public static final int BiopsyRefLocation = 0x00210093;

}
