/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.Siemens__Thorax_Multix_FD_Post_Processing;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "Siemens: Thorax/Multix FD Post Processing";

    /** (0021,xx00) VR=US VM=1 ? */
    public static final int _0021_xx00_ = 0x00210000;

    /** (0021,xx01) VR=SS VM=1 ? */
    public static final int _0021_xx01_ = 0x00210001;

    /** (0021,xx02) VR=FL VM=1 ? */
    public static final int _0021_xx02_ = 0x00210002;

    /** (0021,xx03) VR=FL VM=1 ? */
    public static final int _0021_xx03_ = 0x00210003;

    /** (0021,xx04) VR=US VM=1 ? */
    public static final int _0021_xx04_ = 0x00210004;

    /** (0021,xx05) VR=SS VM=1 ? */
    public static final int _0021_xx05_ = 0x00210005;

    /** (0021,xx06) VR=FL VM=1 ? */
    public static final int _0021_xx06_ = 0x00210006;

    /** (0021,xx07) VR=FL VM=1 ? */
    public static final int _0021_xx07_ = 0x00210007;

    /** (0021,xx08) VR=US VM=1 Auto Window Flag */
    public static final int AutoWindowFlag = 0x00210008;

    /** (0021,xx09) VR=SL VM=1 Auto Window Center */
    public static final int AutoWindowCenter = 0x00210009;

    /** (0021,xx0A) VR=SL VM=1 Auto Window Width */
    public static final int AutoWindowWidth = 0x0021000A;

    /** (0021,xx0B) VR=SS VM=1 Filter ID */
    public static final int FilterID = 0x0021000B;

    /** (0021,xx0C) VR=FL VM=1 ? */
    public static final int _0021_xx0C_ = 0x0021000C;

    /** (0021,xx0D) VR=SS VM=1 ? */
    public static final int _0021_xx0D_ = 0x0021000D;

    /** (0021,xx0E) VR=US VM=1 Dose Control Value */
    public static final int DoseControlValue = 0x0021000E;

    /** (0021,xx0F) VR=US VM=1 ? */
    public static final int _0021_xx0F_ = 0x0021000F;

    /** (0021,xx10) VR=US VM=1 ? */
    public static final int _0021_xx10_ = 0x00210010;

    /** (0021,xx11) VR=SS VM=1 ? */
    public static final int _0021_xx11_ = 0x00210011;

    /** (0021,xx12) VR=SS VM=1 ? */
    public static final int _0021_xx12_ = 0x00210012;

    /** (0021,xx13) VR=SS VM=1 ? */
    public static final int _0021_xx13_ = 0x00210013;

    /** (0021,xx14) VR=US VM=1 Anatomic Correct View */
    public static final int AnatomicCorrectView = 0x00210014;

    /** (0021,xx15) VR=SS VM=1 Auto Window Shift */
    public static final int AutoWindowShift = 0x00210015;

    /** (0021,xx16) VR=DS VM=1 Auto Window Expansion */
    public static final int AutoWindowExpansion = 0x00210016;

    /** (0021,xx17) VR=LO VM=1 System Type */
    public static final int SystemType = 0x00210017;

    /** (0021,xx18) VR=LO VM=1 Detector Type */
    public static final int DetectorType = 0x00210018;

    /** (0021,xx30) VR=US VM=1 Anatomic Sort Number */
    public static final int AnatomicSortNumber = 0x00210030;

    /** (0021,xx31) VR=US VM=1 Acquisition Sort Number */
    public static final int AcquisitionSortNumber = 0x00210031;

}
