/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth;

import java.util.Arrays;
import java.util.function.Function;
import org.miaixz.bus.auth.Complex;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Provider;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;

public class Authorizer {
    private String source;
    private Context context;
    private CacheX cache;
    private Complex[] complex;

    private Authorizer() {
    }

    public static Authorizer builder() {
        return new Authorizer();
    }

    public Authorizer source(String source) {
        this.source = source;
        return this;
    }

    public Authorizer context(Context context) {
        this.context = context;
        return this;
    }

    public Authorizer context(Function<String, Context> context) {
        this.context = context.apply(this.source);
        return this;
    }

    public Authorizer cache(CacheX cache) {
        this.cache = cache;
        return this;
    }

    public Authorizer complex(Complex ... complex) {
        this.complex = complex;
        return this;
    }

    public Provider build() {
        if (StringKit.isEmpty((CharSequence)this.source) || null == this.context) {
            throw new AuthorizedException(ErrorCode._NOT_IMPLEMENTED.getKey());
        }
        Complex[] complexes = this.concat(Registry.values(), this.complex);
        Complex complex = Arrays.stream(complexes).distinct().filter(authSource -> authSource.getName().equalsIgnoreCase(this.source)).findAny().orElseThrow(() -> new AuthorizedException(ErrorCode._NOT_IMPLEMENTED.getKey()));
        Class<? extends AbstractProvider> targetClass = complex.getTargetClass();
        if (null == targetClass) {
            throw new AuthorizedException(ErrorCode._NOT_IMPLEMENTED.getKey());
        }
        try {
            if (this.cache == null) {
                return targetClass.getDeclaredConstructor(Context.class).newInstance(this.context);
            }
            return targetClass.getDeclaredConstructor(Context.class, CacheX.class).newInstance(this.context, this.cache);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthorizedException(ErrorCode._NOT_IMPLEMENTED.getKey());
        }
    }

    private Complex[] concat(Complex[] first, Complex[] second) {
        if (null == second || second.length == 0) {
            return first;
        }
        Complex[] result = new Complex[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

