/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Builder {
    private final Map<String, String> params = new LinkedHashMap<String, String>(7);
    private String baseUrl;

    private Builder() {
    }

    public static Builder fromUrl(String baseUrl) {
        Builder builder = new Builder();
        builder.setBaseUrl(baseUrl);
        return builder;
    }

    public static Map<String, String> parseStringToMap(String text) {
        HashMap<String, String> res;
        if (text.contains("&")) {
            String[] fields = text.split("&");
            res = new HashMap((int)((double)fields.length / 0.75 + 1.0));
            for (String field : fields) {
                if (!field.contains("=")) continue;
                String[] keyValue = field.split("=");
                res.put(UrlDecoder.decode((String)keyValue[0]), keyValue.length == 2 ? UrlDecoder.decode((String)keyValue[1]) : null);
            }
        } else {
            res = new HashMap<String, String>(0);
        }
        return res;
    }

    public static String parseMapToString(Map<String, String> map, boolean encode) {
        if (null == map || map.isEmpty()) {
            return "";
        }
        ArrayList paramList = new ArrayList();
        map.forEach((k, v) -> {
            if (null == v) {
                paramList.add(k + "=");
            } else {
                paramList.add(k + "=" + (encode ? UrlEncoder.encodeAll((String)v) : v));
            }
        });
        return String.join((CharSequence)"&", paramList);
    }

    public static byte[] sign(byte[] key, byte[] data, String algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthorizedException("Unsupported algorithm: " + algorithm, (Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthorizedException("Invalid key: " + ArrayKit.toString((Object)key), (Throwable)ex);
        }
    }

    public static String codeVerifier() {
        return Base64.encodeUrlSafe((CharSequence)RandomKit.randomString((int)50));
    }

    public static String codeChallenge(String codeChallengeMethod, String codeVerifier) {
        if (Algorithm.SHA256.getValue().equalsIgnoreCase(codeChallengeMethod)) {
            return new String(Base64.encode((byte[])Builder.digest(codeVerifier), (boolean)true), Charset.US_ASCII);
        }
        return codeVerifier;
    }

    public static byte[] digest(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SHA256.getValue());
            messageDigest.update(str.getBytes(Charset.UTF_8));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String build() {
        return this.build(false);
    }

    public String build(boolean encode) {
        if (MapKit.isEmpty(this.params)) {
            return this.baseUrl;
        }
        String baseUrl = StringKit.appendIfMissing((CharSequence)this.baseUrl, (CharSequence)"?", (CharSequence[])new CharSequence[]{"&"});
        String paramString = Builder.parseMapToString(this.params, encode);
        return baseUrl + paramString;
    }

    public Map<String, Object> getReadOnlyParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public Builder queryParam(String key, Object value) {
        if (StringKit.isEmpty((CharSequence)key)) {
            throw new RuntimeException("Parameter name cannot be empty");
        }
        String valueAsString = value != null ? value.toString() : null;
        this.params.put(key, valueAsString);
        return this;
    }

    @Generated
    public Map<String, String> getParams() {
        return this.params;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

