/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth;

import org.miaixz.bus.auth.Complex;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.xyz.StringKit;

public class Checker {
    public static boolean isSupportedAuth(Context context, Complex complex) {
        boolean isSupported;
        boolean bl = isSupported = StringKit.isNotEmpty((CharSequence)context.getAppKey()) && StringKit.isNotEmpty((CharSequence)context.getAppSecret());
        if (isSupported && Registry.STACK_OVERFLOW == complex) {
            isSupported = StringKit.isNotEmpty((CharSequence)context.getUnionId());
        }
        if (isSupported && Registry.WECHAT_EE == complex) {
            isSupported = StringKit.isNotEmpty((CharSequence)context.getUnionId());
        }
        if (isSupported && (Registry.CODING == complex || Registry.OKTA == complex)) {
            isSupported = StringKit.isNotEmpty((CharSequence)context.getPrefix());
        }
        if (isSupported && Registry.XIMALAYA == complex) {
            boolean bl2 = isSupported = StringKit.isNotEmpty((CharSequence)context.getDeviceId()) && null != context.getType();
            if (isSupported) {
                isSupported = "3".equals(context.getType()) || StringKit.isNotEmpty((CharSequence)context.getUnionId());
            }
        }
        return isSupported;
    }

    public static void check(Context context, Complex complex) {
        String redirectUri = context.getRedirectUri();
        if (context.isIgnoreRedirectUri()) {
            return;
        }
        if (StringKit.isEmpty((CharSequence)redirectUri)) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_REDIRECT_URI.getKey(), new Object[]{complex});
        }
        if (!Protocol.isHttp((String)redirectUri) && !Protocol.isHttps((String)redirectUri)) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_REDIRECT_URI.getKey(), new Object[]{complex});
        }
    }

    public static void check(Complex complex, Callback callback) {
        if (complex == Registry.TWITTER) {
            return;
        }
        String code = callback.getCode();
        if (StringKit.isEmpty((CharSequence)code) && complex == Registry.HUAWEI) {
            code = callback.getAuthorization_code();
        }
        if (StringKit.isEmpty((CharSequence)code)) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_CODE.getKey(), new Object[]{complex});
        }
    }

    public static void check(String state, Complex complex, CacheX cache) {
        if (complex == Registry.TWITTER) {
            return;
        }
        if (StringKit.isEmpty((CharSequence)state) || !cache.containsKey((Object)state)) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_STATUS.getKey(), new Object[]{complex});
        }
    }
}

