/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.metric;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.auth.metric.jwt.JWTHeader;
import org.miaixz.bus.auth.metric.jwt.JWTPayload;
import org.miaixz.bus.auth.metric.jwt.JWTRegister;
import org.miaixz.bus.auth.metric.jwt.JWTVerifier;
import org.miaixz.bus.auth.metric.jwt.signature.JWTSigner;
import org.miaixz.bus.auth.metric.jwt.signature.JWTSignerBuilder;
import org.miaixz.bus.auth.metric.jwt.signature.NoneJWTSigner;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.JWTException;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;

public class JWT
implements JWTRegister<JWT> {
    private final JWTHeader header = new JWTHeader();
    private final JWTPayload payload = new JWTPayload();
    private Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;
    private JWTSigner signer;
    private List<String> tokens;

    public static JWT of() {
        return new JWT();
    }

    public static JWT of(String token) {
        return new JWT(token);
    }

    public JWT() {
    }

    public JWT(String token) {
        this();
        this.parse(token);
    }

    public JWT parse(String token) throws IllegalArgumentException {
        Assert.notBlank((CharSequence)token, (String)"Token String must be not blank!", (Object[])new Object[0]);
        List<String> tokens = JWT.splitToken(token);
        this.tokens = tokens;
        this.header.parse(tokens.get(0), this.charset);
        this.payload.parse(tokens.get(1), this.charset);
        return this;
    }

    public JWT setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JWT setKey(byte[] key) {
        String algorithmId = (String)this.header.getClaim(JWTHeader.ALGORITHM);
        if (StringKit.isNotBlank((CharSequence)algorithmId)) {
            return this.setSigner(algorithmId, key);
        }
        return this.setSigner(JWTSignerBuilder.hs256(key));
    }

    public JWT setSigner(String algorithmId, byte[] key) {
        return this.setSigner(JWTSignerBuilder.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, Key key) {
        return this.setSigner(JWTSignerBuilder.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, KeyPair keyPair) {
        return this.setSigner(JWTSignerBuilder.createSigner(algorithmId, keyPair));
    }

    public JWT setSigner(JWTSigner signer) {
        this.signer = signer;
        return this;
    }

    public JWTSigner getSigner() {
        return this.signer;
    }

    public Map<String, Object> getHeaders() {
        return this.header.getClaimsJson();
    }

    public JWTHeader getHeader() {
        return this.header;
    }

    public Object getHeader(String name) {
        return this.header.getClaim(name);
    }

    public String getAlgorithm() {
        return (String)this.header.getClaim(JWTHeader.ALGORITHM);
    }

    public JWT setHeader(String name, Object value) {
        this.header.setClaim(name, value);
        return this;
    }

    public JWT addHeaders(Map<String, ?> headers) {
        this.header.putAll(headers);
        return this;
    }

    public Map<String, Object> getPayloads() {
        return this.payload.getClaimsJson();
    }

    public JWTPayload getPayload() {
        return this.payload;
    }

    public Object getPayload(String name) {
        return this.getPayload().getClaim(name);
    }

    public <T> T getPayload(String propertyName, Type propertyType) {
        Object value = this.getPayload().getClaim(propertyName);
        if (value != null && propertyType instanceof Class) {
            return ((Class)propertyType).cast(value);
        }
        return null;
    }

    @Override
    public JWT setPayload(String name, Object value) {
        this.payload.setClaim(name, value);
        return this;
    }

    public JWT addPayloads(Map<String, ?> payloads) {
        this.payload.putAll(payloads);
        return this;
    }

    public String sign() {
        return this.sign(this.signer);
    }

    public String sign(JWTSigner signer) {
        Assert.notNull((Object)signer, () -> new JWTException("No Signer provided!"));
        String algorithm = (String)this.header.getClaim(JWTHeader.ALGORITHM);
        if (StringKit.isBlank((CharSequence)algorithm)) {
            this.header.setClaim(JWTHeader.ALGORITHM, JWTSignerBuilder.getId(signer.getAlgorithm()));
        }
        String headerBase64 = Base64.encodeUrlSafe((CharSequence)this.header.toString(), (Charset)this.charset);
        String payloadBase64 = Base64.encodeUrlSafe((CharSequence)this.payload.toString(), (Charset)this.charset);
        String sign = signer.sign(headerBase64, payloadBase64);
        return StringKit.format((CharSequence)"{}.{}.{}", (Object[])new Object[]{headerBase64, payloadBase64, sign});
    }

    public boolean verify() {
        return this.verify(this.signer);
    }

    public boolean validate(long leeway) {
        if (!this.verify()) {
            return false;
        }
        try {
            JWTVerifier.of(this).validateDate((Date)DateKit.now(), leeway);
        }
        catch (ValidateException e) {
            return false;
        }
        return true;
    }

    public boolean verify(JWTSigner signer) {
        List<String> tokens;
        if (null == signer) {
            signer = NoneJWTSigner.NONE;
        }
        if (CollKit.isEmpty(tokens = this.tokens)) {
            throw new JWTException("No token to verify!");
        }
        return signer.verify(tokens.get(0), tokens.get(1), tokens.get(2));
    }

    public static List<String> splitToken(String token) {
        List tokens = StringKit.split((CharSequence)token, (CharSequence)".");
        if (3 != tokens.size()) {
            throw new JWTException("The token was expected 3 parts, but got {}.", new Object[]{tokens.size()});
        }
        return tokens;
    }
}

