/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.metric.jwt;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Assert;

public class Claims
implements Serializable {
    private static final long serialVersionUID = 2852289137231L;
    private Map<String, Object> claims;

    public void setClaim(String name, Object value) {
        Assert.notNull((Object)name, (String)"Name must be not null!", (Object[])new Object[0]);
        this.init();
        if (value == null) {
            this.claims.remove(name);
            return;
        }
        this.claims.put(name, value);
    }

    public void putAll(Map<String, ?> headerClaims) {
        if (headerClaims != null && !headerClaims.isEmpty()) {
            for (Map.Entry<String, ?> entry : headerClaims.entrySet()) {
                this.setClaim(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object getClaim(String name) {
        this.init();
        return this.claims.get(name);
    }

    public Map<String, Object> getClaimsJson() {
        this.init();
        return this.claims;
    }

    public void parse(String tokenPart, Charset charset) {
        String decoded = Base64.decodeString((CharSequence)tokenPart, (Charset)charset);
        this.claims = this.parseJsonString(decoded);
    }

    public String toString() {
        this.init();
        return this.toJsonString(this.claims);
    }

    private void init() {
        if (this.claims == null) {
            this.claims = new HashMap<String, Object>();
        }
    }

    private Map<String, Object> parseJsonString(String json) {
        String[] pairs;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (json == null || json.trim().isEmpty()) {
            return result;
        }
        if (!(json = json.trim()).startsWith("{") || !json.endsWith("}")) {
            throw new IllegalArgumentException("Invalid JSON format");
        }
        if ((json = json.substring(1, json.length() - 1).trim()).isEmpty()) {
            return result;
        }
        for (String pair : pairs = json.split(",")) {
            String[] keyValue = pair.split(":", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim().replaceAll("^\"|\"$", "");
            String value = keyValue[1].trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                result.put(key, value.substring(1, value.length() - 1));
                continue;
            }
            if (value.matches("-?\\d+")) {
                result.put(key, Long.parseLong(value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private String toJsonString(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"").append(entry.getKey()).append("\":");
            Object value = entry.getValue();
            if (value instanceof String) {
                sb.append("\"").append(value).append("\"");
            } else if (value instanceof Number) {
                sb.append(value);
            } else {
                sb.append("\"").append(value).append("\"");
            }
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }
}

