/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.metric.jwt;

import java.util.Date;
import java.util.Map;
import org.miaixz.bus.auth.metric.JWT;
import org.miaixz.bus.auth.metric.jwt.JWTPayload;
import org.miaixz.bus.auth.metric.jwt.signature.JWTSigner;
import org.miaixz.bus.auth.metric.jwt.signature.NoneJWTSigner;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;

public class JWTVerifier {
    private final JWT jwt;

    public JWTVerifier(JWT jwt) {
        this.jwt = jwt;
    }

    public static JWTVerifier of(String token) {
        return new JWTVerifier(JWT.of(token));
    }

    public static JWTVerifier of(JWT jwt) {
        return new JWTVerifier(jwt);
    }

    public static boolean verify(String token, byte[] key) {
        return JWT.of(token).setKey(key).verify();
    }

    public static boolean verify(String token, JWTSigner signer) {
        return JWT.of(token).verify(signer);
    }

    private static void validateAlgorithm(JWT jwt, JWTSigner signer) throws ValidateException {
        String algorithmId = jwt.getAlgorithm();
        if (null == signer) {
            signer = jwt.getSigner();
        }
        if (StringKit.isEmpty((CharSequence)algorithmId)) {
            if (null == signer || signer instanceof NoneJWTSigner) {
                return;
            }
            throw new ValidateException("No algorithm defined in header!");
        }
        if (null == signer) {
            throw new IllegalArgumentException("No Signer for validate algorithm!");
        }
        String algorithmIdInSigner = signer.getAlgorithmId();
        if (!StringKit.equals((CharSequence)algorithmId, (CharSequence)algorithmIdInSigner)) {
            throw new ValidateException("Algorithm [{}] defined in header doesn't match to [{}]!", new Object[]{algorithmId, algorithmIdInSigner});
        }
        if (!jwt.verify(signer)) {
            throw new ValidateException("Signature verification failed!");
        }
    }

    private static void validateDate(JWTPayload payload, Date now, long leeway) throws ValidateException {
        Map<String, Object> claims;
        if (null == now) {
            now = DateKit.now();
            now.setTime(now.getTime() / 1000L * 1000L);
        }
        Long notBefore = (claims = payload.getClaimsJson()).get("nbf") instanceof Long ? (Long)claims.get("nbf") : null;
        Long expiresAt = claims.get("exp") instanceof Long ? (Long)claims.get("exp") : null;
        Long issueAt = claims.get("iat") instanceof Long ? (Long)claims.get("iat") : null;
        JWTVerifier.validateNotAfter("nbf", notBefore, now, leeway);
        JWTVerifier.validateNotBefore("exp", expiresAt, now, leeway);
        JWTVerifier.validateNotAfter("iat", issueAt, now, leeway);
    }

    private static void validateNotAfter(String fieldName, Long dateToCheck, Date now, long leeway) throws ValidateException {
        if (dateToCheck == null) {
            return;
        }
        Date checkDate = new Date(dateToCheck * 1000L);
        if (leeway > 0L) {
            now = new Date(now.getTime() + leeway * 1000L);
        }
        if (checkDate.after(now)) {
            throw new ValidateException("'{}':[{}]] is after now:[{}]", new Object[]{fieldName, DateKit.date((Date)checkDate), DateKit.date((Date)now)});
        }
    }

    private static void validateNotBefore(String fieldName, Long dateToCheck, Date now, long leeway) throws ValidateException {
        if (dateToCheck == null) {
            return;
        }
        Date checkDate = new Date(dateToCheck * 1000L);
        if (leeway > 0L) {
            now = new Date(now.getTime() - leeway * 1000L);
        }
        if (checkDate.before(now)) {
            throw new ValidateException("'{}':[{}]] is before now:[{}]", new Object[]{fieldName, DateKit.date((Date)checkDate), DateKit.date((Date)now)});
        }
    }

    public JWTVerifier validateAlgorithm() throws ValidateException {
        return this.validateAlgorithm(null);
    }

    public JWTVerifier validateAlgorithm(JWTSigner signer) throws ValidateException {
        JWTVerifier.validateAlgorithm(this.jwt, signer);
        return this;
    }

    public JWTVerifier validateDate() throws ValidateException {
        return this.validateDate((Date)DateKit.beginOfSecond((Date)DateKit.now()));
    }

    public JWTVerifier validateDate(Date dateToCheck) throws ValidateException {
        JWTVerifier.validateDate(this.jwt.getPayload(), dateToCheck, 0L);
        return this;
    }

    public JWTVerifier validateDate(Date dateToCheck, long leeway) throws ValidateException {
        JWTVerifier.validateDate(this.jwt.getPayload(), dateToCheck, leeway);
        return this;
    }
}

